/* application.c generated by valac 0.56.4, the Vala compiler
 * generated from application.vala, do not modify */

/*
 *  Notes - panel plugin for Xfce Desktop Environment
 *  Copyright (c) 2009-2010  Mike Massonnet <mmassonnet@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include "libnotes.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <xfconf/xfconf.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <errno.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <config.h>
#include <libxfce4util/libxfce4util.h>
#include <signal.h>

enum  {
	XNP_APPLICATION_0_PROPERTY,
	XNP_APPLICATION_NOTES_PATH_PROPERTY,
	XNP_APPLICATION_CONFIG_FILE_PROPERTY,
	XNP_APPLICATION_NUM_PROPERTIES
};
static GParamSpec* xnp_application_properties[XNP_APPLICATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

struct _XnpApplicationPrivate {
	GSList* window_monitor_list;
	GSList* window_list;
	gchar* _notes_path;
	gchar* _config_file;
	XfconfChannel* xfconf_channel;
};

struct _Block1Data {
	int _ref_count_;
	XnpApplication* self;
	GtkMenu* menu;
};

static gint XnpApplication_private_offset;
static gpointer xnp_application_parent_class = NULL;

static void _g_object_unref0_ (gpointer var);
static inline void _g_slist_free__g_object_unref0_ (GSList* self);
static void xnp_application_update_notes_path (XnpApplication* self);
static void xnp_application_update_color (XnpApplication* self);
static void xnp_application_quit (XnpApplication* self);
static gboolean xnp_application_window_name_exists (XnpApplication* self,
                                             const gchar* name);
static void xnp_application_load_window_data (XnpApplication* self,
                                       XnpWindow* window);
static void xnp_application_window_monitor_list_add (XnpApplication* self,
                                              XnpWindow* window);
static void __lambda25_ (XnpApplication* self,
                  XnpWindow* win,
                  const gchar* action);
static void xnp_application_rename_window (XnpApplication* self,
                                    XnpWindow* window);
static void xnp_application_set_data_value (XnpApplication* self,
                                     GObject* object,
                                     const gchar* data,
                                     gboolean val);
static void xnp_application_delete_window (XnpApplication* self,
                                    XnpWindow* window);
static void xnp_application_refresh_notes (XnpApplication* self,
                                    XnpWindow* window);
static void ___lambda25__xnp_window_action (XnpWindow* _sender,
                                     const gchar* action,
                                     gpointer self);
static void __lambda26_ (XnpApplication* self,
                  XnpWindow* win,
                  XnpNote* note);
static gboolean xnp_application_get_data_value (XnpApplication* self,
                                         GObject* object,
                                         const gchar* data);
static void xnp_application_save_note (XnpApplication* self,
                                XnpWindow* window,
                                XnpNote* note);
static void ___lambda26__xnp_window_save_data (XnpWindow* _sender,
                                        XnpNote* note,
                                        gpointer self);
static void __lambda27_ (XnpApplication* self,
                  XnpWindow* win,
                  XnpNote* note);
static void ___lambda27__xnp_window_note_inserted (XnpWindow* _sender,
                                            XnpNote* note,
                                            gpointer self);
static void __lambda28_ (XnpApplication* self,
                  XnpWindow* win,
                  XnpNote* note);
static void ___lambda28__xnp_window_note_deleted (XnpWindow* _sender,
                                           XnpNote* note,
                                           gpointer self);
static void __lambda29_ (XnpApplication* self,
                  XnpWindow* win,
                  XnpNote* note,
                  const gchar* old_name);
static gboolean xnp_application_name_is_valid (XnpApplication* self,
                                        const gchar* name);
static void ___lambda29__xnp_window_note_renamed (XnpWindow* _sender,
                                           XnpNote* note,
                                           const gchar* old_name,
                                           gpointer self);
static void xnp_application_window_monitor_list_remove (XnpApplication* self,
                                                 XnpWindow* window);
static void __lambda24_ (XnpApplication* self,
                  XnpWindow* window);
static void ___lambda24__xnp_window_monitor_window_updated (XnpWindowMonitor* _sender,
                                                     XnpWindow* window,
                                                     gpointer self);
static XnpWindowMonitor* xnp_application_window_monitor_list_lookup (XnpApplication* self,
                                                              XnpWindow* window);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda30_ (Block1Data* _data1_);
static void __lambda31_ (XnpApplication* self,
                  GtkWidget* w);
static void ___lambda31__gtk_callback (GtkWidget* widget,
                                gpointer self);
static void ____lambda32_ (XnpApplication* self,
                    GtkMenuItem* i);
static void _____lambda32__gtk_menu_item_activate (GtkMenuItem* _sender,
                                            gpointer self);
static void __lambda33_ (XnpApplication* self);
static void ___lambda33__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void ___lambda30__gtk_widget_show (GtkWidget* _sender,
                                   gpointer self);
static GObject * xnp_application_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void _xnp_application_quit_xfce_posix_signal_handler (gint signal,
                                                      gpointer self);
static void _xnp_application___lambda34_ (XnpApplication* self);
static void __xnp_application___lambda34__xfconf_g__channel_property_changed (XfconfChannel* _sender,
                                                                       const gchar* property,
                                                                       GValue* value,
                                                                       gpointer self);
static void _xnp_application___lambda35_ (XnpApplication* self);
static void __xnp_application___lambda35__g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self);
static void _xnp_application___lambda36_ (XnpApplication* self);
static void __xnp_application___lambda36__xfconf_g__channel_property_changed (XfconfChannel* _sender,
                                                                       const gchar* property,
                                                                       GValue* value,
                                                                       gpointer self);
static void xnp_application_finalize (GObject * obj);
static GType xnp_application_get_type_once (void);
static void _vala_xnp_application_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_xnp_application_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
xnp_application_get_instance_private (XnpApplication* self)
{
	return G_STRUCT_MEMBER_P (self, XnpApplication_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_slist_free__g_object_unref0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

XnpApplication*
xnp_application_construct (GType object_type,
                           const gchar* config_file)
{
	XnpApplication * self = NULL;
	g_return_val_if_fail (config_file != NULL, NULL);
	self = (XnpApplication*) g_object_new (object_type, "config-file", config_file, NULL);
	return self;
}

XnpApplication*
xnp_application_new (const gchar* config_file)
{
	return xnp_application_construct (XNP_TYPE_APPLICATION, config_file);
}

XnpApplication*
xnp_application_construct_with_notes_path (GType object_type,
                                           const gchar* config_file,
                                           const gchar* notes_path)
{
	XnpApplication * self = NULL;
	g_return_val_if_fail (config_file != NULL, NULL);
	g_return_val_if_fail (notes_path != NULL, NULL);
	self = (XnpApplication*) g_object_new (object_type, "config-file", config_file, "notes-path", notes_path, NULL);
	return self;
}

XnpApplication*
xnp_application_new_with_notes_path (const gchar* config_file,
                                     const gchar* notes_path)
{
	return xnp_application_construct_with_notes_path (XNP_TYPE_APPLICATION, config_file, notes_path);
}

static void
xnp_application_update_notes_path (XnpApplication* self)
{
	gchar* new_notes_path = NULL;
	XfconfChannel* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* dirname = NULL;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp19_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->xfconf_channel;
	_tmp1_ = self->priv->_notes_path;
	_tmp2_ = xfconf_channel_get_string (_tmp0_, "/global/notes-path", _tmp1_);
	new_notes_path = _tmp2_;
	_tmp3_ = self->priv->_notes_path;
	_tmp4_ = new_notes_path;
	if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
		_g_free0 (new_notes_path);
		return;
	}
	{
		GDir* dir = NULL;
		const gchar* _tmp5_;
		GDir* _tmp6_;
		GDir* _tmp7_;
		const gchar* _tmp8_;
		_tmp5_ = new_notes_path;
		_tmp6_ = g_dir_open (_tmp5_, (guint) 0, &_inner_error0_);
		dir = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = dir;
		_tmp8_ = g_dir_read_name (_tmp7_);
		if (_tmp8_ != NULL) {
			GtkMessageDialog* error_dialog = NULL;
			GtkMessageDialog* _tmp9_;
			GtkMessageDialog* _tmp10_;
			const gchar* _tmp11_;
			GtkMessageDialog* _tmp12_;
			GtkMessageDialog* _tmp13_;
			XfconfChannel* _tmp14_;
			const gchar* _tmp15_;
			_tmp9_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, 0, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", _ ("Select notes path"));
			g_object_ref_sink (_tmp9_);
			error_dialog = _tmp9_;
			_tmp10_ = error_dialog;
			_tmp11_ = new_notes_path;
			gtk_message_dialog_format_secondary_text (_tmp10_, _ ("The selected directory (%s) for the new notes path already contains fi" \
"les. You must select or create an empty directory."), _tmp11_);
			_tmp12_ = error_dialog;
			gtk_dialog_run ((GtkDialog*) _tmp12_);
			_tmp13_ = error_dialog;
			gtk_widget_destroy ((GtkWidget*) _tmp13_);
			_tmp14_ = self->priv->xfconf_channel;
			_tmp15_ = self->priv->_notes_path;
			xfconf_channel_set_string (_tmp14_, "/global/notes-path", _tmp15_);
			_g_object_unref0 (error_dialog);
			_g_dir_close0 (dir);
			_g_free0 (new_notes_path);
			return;
		}
		_g_dir_close0 (dir);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (new_notes_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp16_ = new_notes_path;
	_tmp17_ = g_path_get_dirname (_tmp16_);
	dirname = _tmp17_;
	_tmp19_ = dirname;
	if (g_mkdir_with_parents (_tmp19_, 0700) != 0) {
		_tmp18_ = TRUE;
	} else {
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		_tmp20_ = self->priv->_notes_path;
		_tmp21_ = new_notes_path;
		_tmp18_ = g_rename (_tmp20_, _tmp21_) != 0;
	}
	if (_tmp18_) {
		GtkMessageDialog* error_dialog = NULL;
		GtkMessageDialog* _tmp22_;
		GtkMessageDialog* _tmp23_;
		const gchar* _tmp24_;
		GtkMessageDialog* _tmp25_;
		GtkMessageDialog* _tmp26_;
		XfconfChannel* _tmp27_;
		const gchar* _tmp28_;
		_tmp22_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, 0, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", _ ("Select notes path"));
		g_object_ref_sink (_tmp22_);
		error_dialog = _tmp22_;
		_tmp23_ = error_dialog;
		_tmp24_ = g_strerror (errno);
		gtk_message_dialog_format_secondary_text (_tmp23_, _ ("Unable to select directory for new notes path: %s"), _tmp24_);
		_tmp25_ = error_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp25_);
		_tmp26_ = error_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp26_);
		_tmp27_ = self->priv->xfconf_channel;
		_tmp28_ = self->priv->_notes_path;
		xfconf_channel_set_string (_tmp27_, "/global/notes-path", _tmp28_);
		_g_object_unref0 (error_dialog);
		_g_free0 (dirname);
		_g_free0 (new_notes_path);
		return;
	}
	_g_free0 (dirname);
	_g_free0 (new_notes_path);
}

static void
xnp_application_update_color (XnpApplication* self)
{
	gchar* color = NULL;
	XfconfChannel* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->xfconf_channel;
	_tmp1_ = xfconf_channel_get_string (_tmp0_, "/global/background-color", "#F7EB96");
	color = _tmp1_;
	_tmp2_ = color;
	if (g_strcmp0 (_tmp2_, "GTK+") == 0) {
		_g_free0 (color);
		return;
	}
	_tmp3_ = color;
	xnp_theme_set_background_color (_tmp3_);
	_g_free0 (color);
}

static void
xnp_application_quit (XnpApplication* self)
{
	g_return_if_fail (self != NULL);
	xnp_application_save_notes (self);
	gtk_main_quit ();
}

/**
 * create_window:
 *
 * Creates a new Xnp.Window and stores it inside window_list.
 * If a name is given, it assumes it can load existing notes.
 */
static void
__lambda25_ (XnpApplication* self,
             XnpWindow* win,
             const gchar* action)
{
	g_return_if_fail (win != NULL);
	g_return_if_fail (action != NULL);
	if (g_strcmp0 (action, "rename") == 0) {
		xnp_application_rename_window (self, win);
		xnp_application_set_data_value (self, (GObject*) win, "internal-change", TRUE);
	} else {
		if (g_strcmp0 (action, "delete") == 0) {
			xnp_application_delete_window (self, win);
			xnp_application_set_data_value (self, (GObject*) win, "internal-change", TRUE);
		} else {
			if (g_strcmp0 (action, "create-new-window") == 0) {
				XnpWindow* new_win = NULL;
				XnpWindow* _tmp0_;
				XnpWindow* _tmp1_;
				_tmp0_ = xnp_application_create_window (self, NULL);
				new_win = _tmp0_;
				_tmp1_ = new_win;
				gtk_widget_show ((GtkWidget*) _tmp1_);
				xnp_application_set_data_value (self, (GObject*) win, "internal-change", TRUE);
				_g_object_unref0 (new_win);
			} else {
				if (g_strcmp0 (action, "refresh-notes") == 0) {
					xnp_application_refresh_notes (self, win);
				} else {
					if (g_strcmp0 (action, "properties") == 0) {
						xnp_application_open_settings_dialog (self);
					} else {
						if (g_strcmp0 (action, "about") == 0) {
							xnp_application_open_about_dialog (self);
						}
					}
				}
			}
		}
	}
}

static void
___lambda25__xnp_window_action (XnpWindow* _sender,
                                const gchar* action,
                                gpointer self)
{
	__lambda25_ ((XnpApplication*) self, _sender, action);
}

static void
__lambda26_ (XnpApplication* self,
             XnpWindow* win,
             XnpNote* note)
{
	g_return_if_fail (win != NULL);
	g_return_if_fail (note != NULL);
	if (!xnp_application_get_data_value (self, (GObject*) win, "external-change")) {
		xnp_application_set_data_value (self, (GObject*) win, "internal-change", TRUE);
		xnp_application_save_note (self, win, note);
	}
}

static void
___lambda26__xnp_window_save_data (XnpWindow* _sender,
                                   XnpNote* note,
                                   gpointer self)
{
	__lambda26_ ((XnpApplication*) self, _sender, note);
}

static void
__lambda27_ (XnpApplication* self,
             XnpWindow* win,
             XnpNote* note)
{
	XfconfChannel* _tmp0_;
	XnpHypertextView* _tmp1_;
	gchar* path = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (win != NULL);
	g_return_if_fail (note != NULL);
	_tmp0_ = self->priv->xfconf_channel;
	_tmp1_ = note->text_view;
	xfconf_g_property_bind (_tmp0_, "/global/font-description", G_TYPE_STRING, _tmp1_, "font");
	_tmp2_ = self->priv->_notes_path;
	_tmp3_ = xnp_window_get_name (win);
	_tmp4_ = _tmp3_;
	_tmp5_ = xnp_note_get_name (note);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("%s/%s/%s", _tmp2_, _tmp4_, _tmp6_);
	path = _tmp7_;
	{
		g_file_set_contents (path, "", (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		xnp_application_set_data_value (self, (GObject*) win, "internal-change", TRUE);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (path);
}

static void
___lambda27__xnp_window_note_inserted (XnpWindow* _sender,
                                       XnpNote* note,
                                       gpointer self)
{
	__lambda27_ ((XnpApplication*) self, _sender, note);
}

static void
__lambda28_ (XnpApplication* self,
             XnpWindow* win,
             XnpNote* note)
{
	gchar* path = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (win != NULL);
	g_return_if_fail (note != NULL);
	_tmp0_ = self->priv->_notes_path;
	_tmp1_ = xnp_window_get_name (win);
	_tmp2_ = _tmp1_;
	_tmp3_ = xnp_note_get_name (note);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s/%s/%s", _tmp0_, _tmp2_, _tmp4_);
	path = _tmp5_;
	g_unlink (path);
	xnp_application_set_data_value (self, (GObject*) win, "internal-change", TRUE);
	_g_free0 (path);
}

static void
___lambda28__xnp_window_note_deleted (XnpWindow* _sender,
                                      XnpNote* note,
                                      gpointer self)
{
	__lambda28_ ((XnpApplication*) self, _sender, note);
}

static void
__lambda29_ (XnpApplication* self,
             XnpWindow* win,
             XnpNote* note,
             const gchar* old_name)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* old_path = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* new_path = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	g_return_if_fail (win != NULL);
	g_return_if_fail (note != NULL);
	g_return_if_fail (old_name != NULL);
	_tmp0_ = xnp_note_get_name (note);
	_tmp1_ = _tmp0_;
	if (!xnp_application_name_is_valid (self, _tmp1_)) {
		xnp_note_set_name (note, old_name);
		return;
	}
	_tmp2_ = self->priv->_notes_path;
	_tmp3_ = xnp_window_get_name (win);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s/%s/%s", _tmp2_, _tmp4_, old_name);
	old_path = _tmp5_;
	_tmp6_ = self->priv->_notes_path;
	_tmp7_ = xnp_window_get_name (win);
	_tmp8_ = _tmp7_;
	_tmp9_ = xnp_note_get_name (note);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strdup_printf ("%s/%s/%s", _tmp6_, _tmp8_, _tmp10_);
	new_path = _tmp11_;
	_tmp12_ = old_path;
	_tmp13_ = new_path;
	g_rename (_tmp12_, _tmp13_);
	xnp_application_set_data_value (self, (GObject*) win, "internal-change", TRUE);
	_g_free0 (new_path);
	_g_free0 (old_path);
}

static void
___lambda29__xnp_window_note_renamed (XnpWindow* _sender,
                                      XnpNote* note,
                                      const gchar* old_name,
                                      gpointer self)
{
	__lambda29_ ((XnpApplication*) self, _sender, note, old_name);
}

XnpWindow*
xnp_application_create_window (XnpApplication* self,
                               const gchar* name)
{
	XnpWindow* window = NULL;
	XnpWindow* _tmp0_;
	XnpWindow* _tmp18_;
	XnpWindow* _tmp19_;
	XnpWindow* _tmp20_;
	GSList* _tmp21_;
	gchar* window_path = NULL;
	const gchar* _tmp25_;
	XnpWindow* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gboolean _tmp30_ = FALSE;
	XnpWindow* _tmp40_;
	XfconfChannel* _tmp41_;
	XnpWindow* _tmp42_;
	XfconfChannel* _tmp43_;
	XnpWindow* _tmp44_;
	XnpWindow* _tmp45_;
	XnpWindow* _tmp46_;
	XnpWindow* _tmp47_;
	XnpWindow* _tmp48_;
	XnpWindow* _tmp49_;
	GError* _inner_error0_ = NULL;
	XnpWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = xnp_window_new ();
	g_object_ref_sink (_tmp0_);
	window = _tmp0_;
	if (name == NULL) {
		XnpWindow* _tmp1_;
		XfconfChannel* _tmp2_;
		XnpWindow* _tmp3_;
		XfconfChannel* _tmp4_;
		gint width = 0;
		XfconfChannel* _tmp5_;
		gint height = 0;
		XfconfChannel* _tmp6_;
		gboolean _tmp7_ = FALSE;
		_tmp1_ = window;
		_tmp2_ = self->priv->xfconf_channel;
		xnp_window_set_above (_tmp1_, xfconf_channel_get_bool (_tmp2_, "/new-window/always-on-top", FALSE));
		_tmp3_ = window;
		_tmp4_ = self->priv->xfconf_channel;
		xnp_window_set_sticky (_tmp3_, xfconf_channel_get_bool (_tmp4_, "/new-window/sticky", TRUE));
		_tmp5_ = self->priv->xfconf_channel;
		width = (gint) xfconf_channel_get_int (_tmp5_, "/new-window/width", (gint32) 0);
		_tmp6_ = self->priv->xfconf_channel;
		height = (gint) xfconf_channel_get_int (_tmp6_, "/new-window/height", (gint32) 0);
		if (width > 0) {
			_tmp7_ = height > 0;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			XnpWindow* _tmp8_;
			_tmp8_ = window;
			gtk_window_resize ((GtkWindow*) _tmp8_, width, height);
		}
	}
	if (name == NULL) {
		gchar* window_name = NULL;
		gchar* _tmp9_;
		gint len = 0;
		GSList* _tmp10_;
		XnpWindow* _tmp15_;
		const gchar* _tmp16_;
		_tmp9_ = g_strdup (_ ("Notes"));
		window_name = _tmp9_;
		_tmp10_ = self->priv->window_list;
		len = (gint) g_slist_length (_tmp10_);
		{
			gint id = 0;
			id = 1;
			{
				gboolean _tmp11_ = FALSE;
				_tmp11_ = TRUE;
				while (TRUE) {
					const gchar* _tmp14_;
					if (!_tmp11_) {
						gint _tmp12_;
						_tmp12_ = id;
						id = _tmp12_ + 1;
					}
					_tmp11_ = FALSE;
					if (!(id <= (len + 1))) {
						break;
					}
					if (id > 1) {
						gchar* _tmp13_;
						_tmp13_ = g_strdup_printf (_ ("Notes %d"), id);
						_g_free0 (window_name);
						window_name = _tmp13_;
					}
					_tmp14_ = window_name;
					if (!xnp_application_window_name_exists (self, _tmp14_)) {
						break;
					}
				}
			}
		}
		_tmp15_ = window;
		_tmp16_ = window_name;
		xnp_window_set_name (_tmp15_, _tmp16_);
		_g_free0 (window_name);
	} else {
		XnpWindow* _tmp17_;
		_tmp17_ = window;
		xnp_window_set_name (_tmp17_, name);
	}
	_tmp18_ = window;
	_tmp19_ = _g_object_ref0 (_tmp18_);
	_tmp20_ = window;
	self->priv->window_list = g_slist_insert_sorted (self->priv->window_list, _tmp19_, (GCompareFunc) xnp_window_compare_func);
	_tmp21_ = self->priv->window_list;
	{
		GSList* win_collection = NULL;
		GSList* win_it = NULL;
		win_collection = _tmp21_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XnpWindow* _tmp22_;
			XnpWindow* win = NULL;
			_tmp22_ = _g_object_ref0 ((XnpWindow*) win_it->data);
			win = _tmp22_;
			{
				XnpWindow* _tmp23_;
				GSList* _tmp24_;
				_tmp23_ = win;
				_tmp24_ = self->priv->window_list;
				xnp_window_set_window_list (_tmp23_, _tmp24_);
				_g_object_unref0 (win);
			}
		}
	}
	_tmp25_ = self->priv->_notes_path;
	_tmp26_ = window;
	_tmp27_ = xnp_window_get_name (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_strdup_printf ("%s/%s", _tmp25_, _tmp28_);
	window_path = _tmp29_;
	if (name == NULL) {
		_tmp30_ = TRUE;
	} else {
		const gchar* _tmp31_;
		_tmp31_ = window_path;
		_tmp30_ = !g_file_test (_tmp31_, G_FILE_TEST_IS_DIR | G_FILE_TEST_EXISTS);
	}
	if (_tmp30_) {
		{
			const gchar* _tmp32_;
			gchar* note_path = NULL;
			const gchar* _tmp33_;
			gchar* _tmp34_;
			const gchar* _tmp35_;
			XnpWindow* _tmp36_;
			_tmp32_ = window_path;
			g_mkdir_with_parents (_tmp32_, 0700);
			_tmp33_ = window_path;
			_tmp34_ = g_strdup_printf ("%s/%s", _tmp33_, _ ("Notes"));
			note_path = _tmp34_;
			_tmp35_ = note_path;
			g_file_set_contents (_tmp35_, "", (gssize) -1, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (note_path);
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				_g_free0 (window_path);
				_g_object_unref0 (window);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp36_ = window;
			xnp_application_load_window_data (self, _tmp36_);
			_g_free0 (note_path);
		}
		goto __finally0;
		__catch0_g_file_error:
		{
			GError* e = NULL;
			GError* _tmp37_;
			const gchar* _tmp38_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp37_ = e;
			_tmp38_ = _tmp37_->message;
			g_critical ("application.vala:213: Unable to initialize a notes group: %s", _tmp38_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (window_path);
			_g_object_unref0 (window);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	} else {
		XnpWindow* _tmp39_;
		_tmp39_ = window;
		xnp_application_load_window_data (self, _tmp39_);
	}
	_tmp40_ = window;
	xnp_application_window_monitor_list_add (self, _tmp40_);
	_tmp41_ = self->priv->xfconf_channel;
	_tmp42_ = window;
	xfconf_g_property_bind (_tmp41_, "/global/skip-taskbar-hint", G_TYPE_BOOLEAN, _tmp42_, "skip-taskbar-hint");
	_tmp43_ = self->priv->xfconf_channel;
	_tmp44_ = window;
	xfconf_g_property_bind (_tmp43_, "/global/tabs-position", G_TYPE_INT, _tmp44_, "tabs-position");
	_tmp45_ = window;
	g_signal_connect_object (_tmp45_, "action", (GCallback) ___lambda25__xnp_window_action, self, 0);
	_tmp46_ = window;
	g_signal_connect_object (_tmp46_, "save-data", (GCallback) ___lambda26__xnp_window_save_data, self, 0);
	_tmp47_ = window;
	g_signal_connect_object (_tmp47_, "note-inserted", (GCallback) ___lambda27__xnp_window_note_inserted, self, 0);
	_tmp48_ = window;
	g_signal_connect_object (_tmp48_, "note-deleted", (GCallback) ___lambda28__xnp_window_note_deleted, self, 0);
	_tmp49_ = window;
	g_signal_connect_object (_tmp49_, "note-renamed", (GCallback) ___lambda29__xnp_window_note_renamed, self, 0);
	result = window;
	_g_free0 (window_path);
	return result;
}

/**
 * load_window_data:
 *
 * Load existing notes and configuration inside the window.
 */
static void
xnp_application_load_window_data (XnpApplication* self,
                                  XnpWindow* window)
{
	gchar* name = NULL;
	gchar* path = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GKeyFile* keyfile = NULL;
	GKeyFile* _tmp34_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->_notes_path;
	_tmp1_ = xnp_window_get_name (window);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("%s/%s", _tmp0_, _tmp2_);
	path = _tmp3_;
	{
		GDir* dir = NULL;
		const gchar* _tmp4_;
		GDir* _tmp5_;
		_tmp4_ = path;
		_tmp5_ = g_dir_open (_tmp4_, (guint) 0, &_inner_error0_);
		dir = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (path);
			_g_free0 (name);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		while (TRUE) {
			GDir* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			const gchar* _tmp9_;
			_tmp6_ = dir;
			_tmp7_ = g_dir_read_name (_tmp6_);
			_tmp8_ = g_strdup (_tmp7_);
			_g_free0 (name);
			name = _tmp8_;
			_tmp9_ = name;
			if (!(_tmp9_ != NULL)) {
				break;
			}
			{
				gchar* contents = NULL;
				GFile* file = NULL;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				GFile* _tmp14_;
				GFile* _tmp15_;
				GFile* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_ = NULL;
				XnpNote* note = NULL;
				XnpNote* _tmp20_;
				XnpNote* _tmp21_;
				const gchar* _tmp22_;
				GtkTextBuffer* buffer = NULL;
				XnpNote* _tmp23_;
				XnpHypertextView* _tmp24_;
				GtkTextBuffer* _tmp25_;
				GtkTextBuffer* _tmp26_;
				GtkTextBuffer* _tmp27_;
				const gchar* _tmp28_;
				XfconfChannel* _tmp29_;
				XnpNote* _tmp30_;
				XnpHypertextView* _tmp31_;
				_tmp10_ = path;
				_tmp11_ = name;
				_tmp12_ = g_strdup_printf ("%s/%s", _tmp10_, _tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = g_file_new_for_path (_tmp13_);
				_tmp15_ = _tmp14_;
				_g_free0 (_tmp13_);
				file = _tmp15_;
				_tmp16_ = file;
				_tmp17_ = g_file_get_path (_tmp16_);
				_tmp18_ = _tmp17_;
				g_file_get_contents (_tmp18_, &_tmp19_, NULL, &_inner_error0_);
				_g_free0 (contents);
				contents = _tmp19_;
				_g_free0 (_tmp18_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (file);
					_g_free0 (contents);
					if (_inner_error0_->domain == G_FILE_ERROR) {
						goto __catch1_g_file_error;
					}
					_g_dir_close0 (dir);
					_g_free0 (path);
					_g_free0 (name);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_tmp20_ = xnp_window_insert_note (window);
				note = _tmp20_;
				_tmp21_ = note;
				_tmp22_ = name;
				xnp_note_set_name (_tmp21_, _tmp22_);
				_tmp23_ = note;
				_tmp24_ = _tmp23_->text_view;
				_tmp25_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp24_);
				_tmp26_ = _g_object_ref0 (_tmp25_);
				buffer = _tmp26_;
				_tmp27_ = buffer;
				_tmp28_ = contents;
				gtk_text_buffer_set_text (_tmp27_, _tmp28_, -1);
				_tmp29_ = self->priv->xfconf_channel;
				_tmp30_ = note;
				_tmp31_ = _tmp30_->text_view;
				xfconf_g_property_bind (_tmp29_, "/global/font-description", G_TYPE_STRING, _tmp31_, "font");
				_g_object_unref0 (buffer);
				_g_object_unref0 (note);
				_g_object_unref0 (file);
				_g_free0 (contents);
			}
			goto __finally1;
			__catch1_g_file_error:
			{
				GError* e = NULL;
				GError* _tmp32_;
				const gchar* _tmp33_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp32_ = e;
				_tmp33_ = _tmp32_->message;
				g_warning ("application.vala:315: %s", _tmp33_);
				_g_error_free0 (e);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_dir_close0 (dir);
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				_g_free0 (path);
				_g_free0 (name);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_g_dir_close0 (dir);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (path);
		_g_free0 (name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp34_ = g_key_file_new ();
	keyfile = _tmp34_;
	{
		GKeyFile* _tmp35_;
		const gchar* _tmp36_;
		gint winx = 0;
		GKeyFile* _tmp37_;
		const gchar* _tmp38_;
		const gchar* _tmp39_;
		gint winy = 0;
		GKeyFile* _tmp40_;
		const gchar* _tmp41_;
		const gchar* _tmp42_;
		gint width = 0;
		GKeyFile* _tmp43_;
		const gchar* _tmp44_;
		const gchar* _tmp45_;
		gint height = 0;
		GKeyFile* _tmp46_;
		const gchar* _tmp47_;
		const gchar* _tmp48_;
		gchar** tabs_order = NULL;
		GKeyFile* _tmp49_;
		const gchar* _tmp50_;
		const gchar* _tmp51_;
		gsize _tmp52_ = 0;
		gchar** _tmp53_;
		gint tabs_order_length1;
		gint _tabs_order_size_;
		gint last_page = 0;
		GKeyFile* _tmp54_;
		const gchar* _tmp55_;
		const gchar* _tmp56_;
		gboolean above = FALSE;
		GKeyFile* _tmp57_;
		const gchar* _tmp58_;
		const gchar* _tmp59_;
		gboolean sticky = FALSE;
		GKeyFile* _tmp60_;
		const gchar* _tmp61_;
		const gchar* _tmp62_;
		gint _tmp63_ = 0;
		GKeyFile* _tmp64_;
		const gchar* _tmp65_;
		const gchar* _tmp66_;
		gdouble opacity = 0.0;
		gboolean visible = FALSE;
		GKeyFile* _tmp67_;
		const gchar* _tmp68_;
		const gchar* _tmp69_;
		_tmp35_ = keyfile;
		_tmp36_ = self->priv->_config_file;
		g_key_file_load_from_file (_tmp35_, _tmp36_, G_KEY_FILE_NONE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp37_ = keyfile;
		_tmp38_ = xnp_window_get_name (window);
		_tmp39_ = _tmp38_;
		winx = g_key_file_get_integer (_tmp37_, _tmp39_, "PosX", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp40_ = keyfile;
		_tmp41_ = xnp_window_get_name (window);
		_tmp42_ = _tmp41_;
		winy = g_key_file_get_integer (_tmp40_, _tmp42_, "PosY", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp43_ = keyfile;
		_tmp44_ = xnp_window_get_name (window);
		_tmp45_ = _tmp44_;
		width = g_key_file_get_integer (_tmp43_, _tmp45_, "Width", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp46_ = keyfile;
		_tmp47_ = xnp_window_get_name (window);
		_tmp48_ = _tmp47_;
		height = g_key_file_get_integer (_tmp46_, _tmp48_, "Height", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp49_ = keyfile;
		_tmp50_ = xnp_window_get_name (window);
		_tmp51_ = _tmp50_;
		_tmp53_ = g_key_file_get_string_list (_tmp49_, _tmp51_, "TabsOrder", &_tmp52_, &_inner_error0_);
		tabs_order = _tmp53_;
		tabs_order_length1 = _tmp52_;
		_tabs_order_size_ = tabs_order_length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp54_ = keyfile;
		_tmp55_ = xnp_window_get_name (window);
		_tmp56_ = _tmp55_;
		last_page = g_key_file_get_integer (_tmp54_, _tmp56_, "LastTab", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			tabs_order = (_vala_array_free (tabs_order, tabs_order_length1, (GDestroyNotify) g_free), NULL);
			goto __catch2_g_error;
		}
		_tmp57_ = keyfile;
		_tmp58_ = xnp_window_get_name (window);
		_tmp59_ = _tmp58_;
		above = g_key_file_get_boolean (_tmp57_, _tmp59_, "Above", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			tabs_order = (_vala_array_free (tabs_order, tabs_order_length1, (GDestroyNotify) g_free), NULL);
			goto __catch2_g_error;
		}
		_tmp60_ = keyfile;
		_tmp61_ = xnp_window_get_name (window);
		_tmp62_ = _tmp61_;
		sticky = g_key_file_get_boolean (_tmp60_, _tmp62_, "Sticky", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			tabs_order = (_vala_array_free (tabs_order, tabs_order_length1, (GDestroyNotify) g_free), NULL);
			goto __catch2_g_error;
		}
		_tmp64_ = keyfile;
		_tmp65_ = xnp_window_get_name (window);
		_tmp66_ = _tmp65_;
		_tmp63_ = g_key_file_get_integer (_tmp64_, _tmp66_, "Transparency", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			tabs_order = (_vala_array_free (tabs_order, tabs_order_length1, (GDestroyNotify) g_free), NULL);
			goto __catch2_g_error;
		}
		opacity = 1 - (((gdouble) _tmp63_) / 100);
		_tmp67_ = keyfile;
		_tmp68_ = xnp_window_get_name (window);
		_tmp69_ = _tmp68_;
		visible = g_key_file_get_boolean (_tmp67_, _tmp69_, "Visible", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			tabs_order = (_vala_array_free (tabs_order, tabs_order_length1, (GDestroyNotify) g_free), NULL);
			goto __catch2_g_error;
		}
		gtk_window_move ((GtkWindow*) window, winx, winy);
		gtk_window_resize ((GtkWindow*) window, width, height);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp70_ = FALSE;
				_tmp70_ = TRUE;
				while (TRUE) {
					gchar** _tmp72_;
					gint _tmp72__length1;
					gchar** _tmp73_;
					gint _tmp73__length1;
					const gchar* _tmp74_;
					if (!_tmp70_) {
						gint _tmp71_;
						_tmp71_ = i;
						i = _tmp71_ + 1;
					}
					_tmp70_ = FALSE;
					_tmp72_ = tabs_order;
					_tmp72__length1 = tabs_order_length1;
					if (!(i < _tmp72__length1)) {
						break;
					}
					_tmp73_ = tabs_order;
					_tmp73__length1 = tabs_order_length1;
					_tmp74_ = _tmp73_[i];
					xnp_window_move_note (window, _tmp74_, i);
				}
			}
		}
		xnp_window_set_current_page (window, last_page);
		xnp_window_set_above (window, above);
		xnp_window_set_sticky (window, sticky);
		gtk_widget_set_opacity ((GtkWidget*) window, opacity);
		if (visible) {
			gtk_widget_show ((GtkWidget*) window);
		}
		tabs_order = (_vala_array_free (tabs_order, tabs_order_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally2;
	__catch2_g_error:
	{
		g_clear_error (&_inner_error0_);
		gtk_widget_show ((GtkWidget*) window);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_key_file_unref0 (keyfile);
		_g_free0 (path);
		_g_free0 (name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_key_file_unref0 (keyfile);
	_g_free0 (path);
	_g_free0 (name);
}

/**
 * save_windows_configuration:
 *
 * Save window configuration inside rc file.
 */
void
xnp_application_save_windows_configuration (XnpApplication* self)
{
	GKeyFile* keyfile = NULL;
	GKeyFile* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_key_file_new ();
	keyfile = _tmp0_;
	{
		GSList* _tmp1_;
		gchar* contents = NULL;
		GKeyFile* _tmp63_;
		gchar* _tmp64_;
		const gchar* _tmp65_;
		_tmp1_ = self->priv->window_list;
		{
			GSList* win_collection = NULL;
			GSList* win_it = NULL;
			win_collection = _tmp1_;
			for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
				XnpWindow* _tmp2_;
				XnpWindow* win = NULL;
				_tmp2_ = _g_object_ref0 ((XnpWindow*) win_it->data);
				win = _tmp2_;
				{
					gint winx = 0;
					gint winy = 0;
					gint width = 0;
					gint height = 0;
					XnpWindow* _tmp3_;
					gint _tmp4_ = 0;
					gint _tmp5_ = 0;
					gint _tmp6_ = 0;
					gint _tmp7_ = 0;
					gchar** tabs_order = NULL;
					XnpWindow* _tmp8_;
					gint _tmp9_ = 0;
					gchar** _tmp10_;
					gint tabs_order_length1;
					gint _tabs_order_size_;
					gint last_page = 0;
					XnpWindow* _tmp11_;
					gint transparency = 0;
					XnpWindow* _tmp12_;
					gdouble _tmp13_;
					gdouble _tmp14_;
					gboolean visible = FALSE;
					XnpWindow* _tmp15_;
					GKeyFile* _tmp16_;
					XnpWindow* _tmp17_;
					const gchar* _tmp18_;
					const gchar* _tmp19_;
					GKeyFile* _tmp20_;
					XnpWindow* _tmp21_;
					const gchar* _tmp22_;
					const gchar* _tmp23_;
					GKeyFile* _tmp24_;
					XnpWindow* _tmp25_;
					const gchar* _tmp26_;
					const gchar* _tmp27_;
					GKeyFile* _tmp28_;
					XnpWindow* _tmp29_;
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					GKeyFile* _tmp32_;
					XnpWindow* _tmp33_;
					const gchar* _tmp34_;
					const gchar* _tmp35_;
					gchar** _tmp36_;
					gint _tmp36__length1;
					GKeyFile* _tmp37_;
					XnpWindow* _tmp38_;
					const gchar* _tmp39_;
					const gchar* _tmp40_;
					GKeyFile* _tmp41_;
					XnpWindow* _tmp42_;
					const gchar* _tmp43_;
					const gchar* _tmp44_;
					XnpWindow* _tmp45_;
					gboolean _tmp46_;
					gboolean _tmp47_;
					GKeyFile* _tmp48_;
					XnpWindow* _tmp49_;
					const gchar* _tmp50_;
					const gchar* _tmp51_;
					XnpWindow* _tmp52_;
					gboolean _tmp53_;
					gboolean _tmp54_;
					GKeyFile* _tmp55_;
					XnpWindow* _tmp56_;
					const gchar* _tmp57_;
					const gchar* _tmp58_;
					GKeyFile* _tmp59_;
					XnpWindow* _tmp60_;
					const gchar* _tmp61_;
					const gchar* _tmp62_;
					_tmp3_ = win;
					xnp_window_get_geometry (_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_, &_tmp7_);
					winx = _tmp4_;
					winy = _tmp5_;
					width = _tmp6_;
					height = _tmp7_;
					_tmp8_ = win;
					_tmp10_ = xnp_window_get_note_names (_tmp8_, &_tmp9_);
					tabs_order = _tmp10_;
					tabs_order_length1 = _tmp9_;
					_tabs_order_size_ = tabs_order_length1;
					_tmp11_ = win;
					last_page = xnp_window_get_current_page (_tmp11_);
					_tmp12_ = win;
					_tmp13_ = gtk_widget_get_opacity ((GtkWidget*) _tmp12_);
					_tmp14_ = _tmp13_;
					transparency = (gint) ((1 - _tmp14_) * 100);
					_tmp15_ = win;
					visible = gtk_widget_get_visible ((GtkWidget*) _tmp15_);
					_tmp16_ = keyfile;
					_tmp17_ = win;
					_tmp18_ = xnp_window_get_name (_tmp17_);
					_tmp19_ = _tmp18_;
					g_key_file_set_integer (_tmp16_, _tmp19_, "PosX", winx);
					_tmp20_ = keyfile;
					_tmp21_ = win;
					_tmp22_ = xnp_window_get_name (_tmp21_);
					_tmp23_ = _tmp22_;
					g_key_file_set_integer (_tmp20_, _tmp23_, "PosY", winy);
					_tmp24_ = keyfile;
					_tmp25_ = win;
					_tmp26_ = xnp_window_get_name (_tmp25_);
					_tmp27_ = _tmp26_;
					g_key_file_set_integer (_tmp24_, _tmp27_, "Width", width);
					_tmp28_ = keyfile;
					_tmp29_ = win;
					_tmp30_ = xnp_window_get_name (_tmp29_);
					_tmp31_ = _tmp30_;
					g_key_file_set_integer (_tmp28_, _tmp31_, "Height", height);
					_tmp32_ = keyfile;
					_tmp33_ = win;
					_tmp34_ = xnp_window_get_name (_tmp33_);
					_tmp35_ = _tmp34_;
					_tmp36_ = tabs_order;
					_tmp36__length1 = tabs_order_length1;
					g_key_file_set_string_list (_tmp32_, _tmp35_, "TabsOrder", (const gchar* const*) _tmp36_, (gint) _tmp36__length1);
					_tmp37_ = keyfile;
					_tmp38_ = win;
					_tmp39_ = xnp_window_get_name (_tmp38_);
					_tmp40_ = _tmp39_;
					g_key_file_set_integer (_tmp37_, _tmp40_, "LastTab", last_page);
					_tmp41_ = keyfile;
					_tmp42_ = win;
					_tmp43_ = xnp_window_get_name (_tmp42_);
					_tmp44_ = _tmp43_;
					_tmp45_ = win;
					_tmp46_ = xnp_window_get_above (_tmp45_);
					_tmp47_ = _tmp46_;
					g_key_file_set_boolean (_tmp41_, _tmp44_, "Above", _tmp47_);
					_tmp48_ = keyfile;
					_tmp49_ = win;
					_tmp50_ = xnp_window_get_name (_tmp49_);
					_tmp51_ = _tmp50_;
					_tmp52_ = win;
					_tmp53_ = xnp_window_get_sticky (_tmp52_);
					_tmp54_ = _tmp53_;
					g_key_file_set_boolean (_tmp48_, _tmp51_, "Sticky", _tmp54_);
					_tmp55_ = keyfile;
					_tmp56_ = win;
					_tmp57_ = xnp_window_get_name (_tmp56_);
					_tmp58_ = _tmp57_;
					g_key_file_set_double (_tmp55_, _tmp58_, "Transparency", (gdouble) transparency);
					_tmp59_ = keyfile;
					_tmp60_ = win;
					_tmp61_ = xnp_window_get_name (_tmp60_);
					_tmp62_ = _tmp61_;
					g_key_file_set_boolean (_tmp59_, _tmp62_, "Visible", visible);
					tabs_order = (_vala_array_free (tabs_order, tabs_order_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (win);
				}
			}
		}
		_tmp63_ = keyfile;
		_tmp64_ = g_key_file_to_data (_tmp63_, NULL, NULL);
		contents = _tmp64_;
		_tmp65_ = self->priv->_config_file;
		g_file_set_contents (_tmp65_, contents, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (contents);
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_key_file_unref0 (keyfile);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_free0 (contents);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		const gchar* _tmp66_;
		GError* _tmp67_;
		const gchar* _tmp68_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp66_ = self->priv->_config_file;
		_tmp67_ = e;
		_tmp68_ = _tmp67_->message;
		g_message ("application.vala:384: Unable to save window configuration from %s: %s", _tmp66_, _tmp68_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_key_file_unref0 (keyfile);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_key_file_unref0 (keyfile);
}

/**
 * save_notes:
 *
 * Save the contents of every existing notes.
 */
void
xnp_application_save_notes (XnpApplication* self)
{
	GSList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window_list;
	{
		GSList* win_collection = NULL;
		GSList* win_it = NULL;
		win_collection = _tmp0_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XnpWindow* _tmp1_;
			XnpWindow* win = NULL;
			_tmp1_ = _g_object_ref0 ((XnpWindow*) win_it->data);
			win = _tmp1_;
			{
				XnpWindow* _tmp2_;
				XnpWindow* _tmp3_;
				_tmp2_ = win;
				xnp_application_set_data_value (self, (GObject*) _tmp2_, "external-change", FALSE);
				_tmp3_ = win;
				xnp_window_save_notes (_tmp3_);
				_g_object_unref0 (win);
			}
		}
	}
}

/**
 * save_note:
 *
 * Save the contents of the given note.
 */
static void
xnp_application_save_note (XnpApplication* self,
                           XnpWindow* window,
                           XnpNote* note)
{
	gchar* path = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	g_return_if_fail (note != NULL);
	_tmp0_ = self->priv->_notes_path;
	_tmp1_ = xnp_window_get_name (window);
	_tmp2_ = _tmp1_;
	_tmp3_ = xnp_note_get_name (note);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s/%s/%s", _tmp0_, _tmp2_, _tmp4_);
	path = _tmp5_;
	{
		GtkTextIter start = {0};
		GtkTextIter end = {0};
		GtkTextBuffer* buffer = NULL;
		XnpHypertextView* _tmp6_;
		GtkTextBuffer* _tmp7_;
		GtkTextBuffer* _tmp8_;
		GtkTextIter _tmp9_ = {0};
		GtkTextIter _tmp10_ = {0};
		gchar* contents = NULL;
		GtkTextIter _tmp11_;
		GtkTextIter _tmp12_;
		gchar* _tmp13_;
		_tmp6_ = note->text_view;
		_tmp7_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp6_);
		_tmp8_ = _g_object_ref0 (_tmp7_);
		buffer = _tmp8_;
		gtk_text_buffer_get_bounds (buffer, &_tmp9_, &_tmp10_);
		start = _tmp9_;
		end = _tmp10_;
		_tmp11_ = start;
		_tmp12_ = end;
		_tmp13_ = gtk_text_buffer_get_text (buffer, &_tmp11_, &_tmp12_, TRUE);
		contents = _tmp13_;
		g_file_set_contents (path, contents, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (contents);
			_g_object_unref0 (buffer);
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_free0 (contents);
		_g_object_unref0 (buffer);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("application.vala:415: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (path);
}

/**
 * rename_window:
 *
 * Renames the window name.
 */
static void
xnp_application_rename_window (XnpApplication* self,
                               XnpWindow* window)
{
	GtkDialog* dialog = NULL;
	GtkDialog* _tmp0_;
	GtkBox* content_area = NULL;
	GtkDialog* _tmp1_;
	GtkBox* _tmp2_;
	GtkBox* _tmp3_;
	GtkDialog* _tmp4_;
	GtkDialog* _tmp5_;
	GtkDialog* _tmp6_;
	GtkDialog* _tmp7_;
	GtkEntry* entry = NULL;
	GtkEntry* _tmp8_;
	GtkEntry* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	GtkEntry* _tmp12_;
	GtkBox* _tmp13_;
	GtkEntry* _tmp14_;
	GtkBox* _tmp15_;
	gint res = 0;
	GtkDialog* _tmp16_;
	GtkDialog* _tmp17_;
	GtkDialog* _tmp37_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = (GtkDialog*) gtk_dialog_new_with_buttons (_ ("Rename group"), (GtkWindow*) window, GTK_DIALOG_DESTROY_WITH_PARENT, "_Cancel", GTK_RESPONSE_CANCEL, "_OK", GTK_RESPONSE_OK, NULL);
	g_object_ref_sink (_tmp0_);
	dialog = _tmp0_;
	_tmp1_ = dialog;
	_tmp2_ = gtk_dialog_get_content_area (_tmp1_);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_box_get_type (), GtkBox));
	content_area = _tmp3_;
	_tmp4_ = dialog;
	gtk_dialog_set_default_response (_tmp4_, (gint) GTK_RESPONSE_OK);
	_tmp5_ = dialog;
	gtk_window_set_resizable ((GtkWindow*) _tmp5_, FALSE);
	_tmp6_ = dialog;
	gtk_window_set_icon_name ((GtkWindow*) _tmp6_, "gtk-edit");
	_tmp7_ = dialog;
	gtk_container_set_border_width ((GtkContainer*) _tmp7_, (guint) 4);
	_tmp8_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp8_);
	entry = _tmp8_;
	_tmp9_ = entry;
	_tmp10_ = xnp_window_get_name (window);
	_tmp11_ = _tmp10_;
	gtk_entry_set_text (_tmp9_, _tmp11_);
	_tmp12_ = entry;
	gtk_entry_set_activates_default (_tmp12_, TRUE);
	_tmp13_ = content_area;
	_tmp14_ = entry;
	gtk_container_add ((GtkContainer*) _tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = content_area;
	gtk_widget_show_all ((GtkWidget*) _tmp15_);
	_tmp16_ = dialog;
	res = gtk_dialog_run (_tmp16_);
	_tmp17_ = dialog;
	gtk_widget_hide ((GtkWidget*) _tmp17_);
	if (res == ((gint) GTK_RESPONSE_OK)) {
		const gchar* name = NULL;
		GtkEntry* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		_tmp18_ = entry;
		_tmp19_ = gtk_entry_get_text (_tmp18_);
		_tmp20_ = _tmp19_;
		name = _tmp20_;
		_tmp21_ = name;
		if (xnp_application_window_name_exists (self, _tmp21_)) {
			GtkMessageDialog* error_dialog = NULL;
			const gchar* _tmp22_;
			GtkMessageDialog* _tmp23_;
			GtkMessageDialog* _tmp24_;
			GtkMessageDialog* _tmp25_;
			_tmp22_ = name;
			_tmp23_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) window, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _ ("The name %s is already in use"), _tmp22_);
			g_object_ref_sink (_tmp23_);
			error_dialog = _tmp23_;
			_tmp24_ = error_dialog;
			gtk_dialog_run ((GtkDialog*) _tmp24_);
			_tmp25_ = error_dialog;
			gtk_widget_destroy ((GtkWidget*) _tmp25_);
			_g_object_unref0 (error_dialog);
		} else {
			const gchar* _tmp26_;
			gchar* old_path = NULL;
			const gchar* _tmp27_;
			const gchar* _tmp28_;
			const gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* new_path = NULL;
			const gchar* _tmp31_;
			const gchar* _tmp32_;
			gchar* _tmp33_;
			const gchar* _tmp34_;
			const gchar* _tmp35_;
			const gchar* _tmp36_;
			_tmp26_ = name;
			if (!xnp_application_name_is_valid (self, _tmp26_)) {
				_g_object_unref0 (entry);
				_g_object_unref0 (content_area);
				_g_object_unref0 (dialog);
				return;
			}
			_tmp27_ = self->priv->_notes_path;
			_tmp28_ = xnp_window_get_name (window);
			_tmp29_ = _tmp28_;
			_tmp30_ = g_strdup_printf ("%s/%s", _tmp27_, _tmp29_);
			old_path = _tmp30_;
			_tmp31_ = self->priv->_notes_path;
			_tmp32_ = name;
			_tmp33_ = g_strdup_printf ("%s/%s", _tmp31_, _tmp32_);
			new_path = _tmp33_;
			_tmp34_ = name;
			xnp_window_set_name (window, _tmp34_);
			_tmp35_ = old_path;
			_tmp36_ = new_path;
			g_rename (_tmp35_, _tmp36_);
			self->priv->window_list = g_slist_sort (self->priv->window_list, (GCompareFunc) xnp_window_compare_func);
			xnp_application_window_monitor_list_remove (self, window);
			xnp_application_window_monitor_list_add (self, window);
			_g_free0 (new_path);
			_g_free0 (old_path);
		}
	}
	_tmp37_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp37_);
	_g_object_unref0 (entry);
	_g_object_unref0 (content_area);
	_g_object_unref0 (dialog);
}

/**
 * delete_window:
 *
 * Delete the window.
 */
static GSList*
vala_g_slist_remove_full (GSList* self,
                          gconstpointer data,
                          GFreeFunc func)
{
	GSList* l = NULL;
	GSList* result;
	l = self;
	while (TRUE) {
		GSList* _tmp0_;
		GSList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GSList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GSList* _tmp3_;
			GSList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GSList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GSList* _tmp5_;
			gconstpointer _tmp6_;
			GSList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GSList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_slist_delete_link (self, (GSList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

static void
xnp_application_delete_window (XnpApplication* self,
                               XnpWindow* window)
{
	gint _tmp0_;
	gint _tmp1_;
	gchar* name = NULL;
	gchar* path = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GSList* _tmp20_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = xnp_window_get_n_pages (window);
	_tmp1_ = _tmp0_;
	if (_tmp1_ >= 1) {
		GtkMessageDialog* dialog = NULL;
		GtkMessageDialog* _tmp2_;
		gint res = 0;
		GtkMessageDialog* _tmp3_;
		GtkMessageDialog* _tmp4_;
		_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) window, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, "%s", _ ("Are you sure you want to delete this group?"));
		g_object_ref_sink (_tmp2_);
		dialog = _tmp2_;
		_tmp3_ = dialog;
		res = gtk_dialog_run ((GtkDialog*) _tmp3_);
		_tmp4_ = dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp4_);
		if (res != ((gint) GTK_RESPONSE_YES)) {
			_g_object_unref0 (dialog);
			return;
		}
		_g_object_unref0 (dialog);
	}
	_tmp5_ = self->priv->_notes_path;
	_tmp6_ = xnp_window_get_name (window);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("%s/%s", _tmp5_, _tmp7_);
	path = _tmp8_;
	{
		GDir* dir = NULL;
		const gchar* _tmp9_;
		GDir* _tmp10_;
		const gchar* _tmp19_;
		_tmp9_ = path;
		_tmp10_ = g_dir_open (_tmp9_, (guint) 0, &_inner_error0_);
		dir = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (path);
			_g_free0 (name);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		while (TRUE) {
			GDir* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			const gchar* _tmp14_;
			gchar* filename = NULL;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			const gchar* _tmp18_;
			_tmp11_ = dir;
			_tmp12_ = g_dir_read_name (_tmp11_);
			_tmp13_ = g_strdup (_tmp12_);
			_g_free0 (name);
			name = _tmp13_;
			_tmp14_ = name;
			if (!(_tmp14_ != NULL)) {
				break;
			}
			_tmp15_ = path;
			_tmp16_ = name;
			_tmp17_ = g_strdup_printf ("%s/%s", _tmp15_, _tmp16_);
			filename = _tmp17_;
			_tmp18_ = filename;
			g_unlink (_tmp18_);
			_g_free0 (filename);
		}
		_tmp19_ = path;
		g_rmdir (_tmp19_);
		_g_dir_close0 (dir);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (path);
		_g_free0 (name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	xnp_application_window_monitor_list_remove (self, window);
	self->priv->window_list = vala_g_slist_remove_full (self->priv->window_list, window, _g_object_unref0_);
	gtk_widget_destroy ((GtkWidget*) window);
	_tmp20_ = self->priv->window_list;
	if (g_slist_length (_tmp20_) >= ((guint) 1)) {
		GSList* _tmp21_;
		_tmp21_ = self->priv->window_list;
		{
			GSList* win_collection = NULL;
			GSList* win_it = NULL;
			win_collection = _tmp21_;
			for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
				XnpWindow* _tmp22_;
				XnpWindow* win = NULL;
				_tmp22_ = _g_object_ref0 ((XnpWindow*) win_it->data);
				win = _tmp22_;
				{
					XnpWindow* _tmp23_;
					GSList* _tmp24_;
					_tmp23_ = win;
					_tmp24_ = self->priv->window_list;
					xnp_window_set_window_list (_tmp23_, _tmp24_);
					_g_object_unref0 (win);
				}
			}
		}
	} else {
		XnpWindow* new_win = NULL;
		XnpWindow* _tmp25_;
		XnpWindow* _tmp26_;
		_tmp25_ = xnp_application_create_window (self, NULL);
		new_win = _tmp25_;
		_tmp26_ = new_win;
		gtk_widget_show ((GtkWidget*) _tmp26_);
		_g_object_unref0 (new_win);
	}
	_g_free0 (path);
	_g_free0 (name);
}

/**
 * refresh_notes:
 *
 * Prompt for reloading notes from disk.
 */
static void
xnp_application_refresh_notes (XnpApplication* self,
                               XnpWindow* window)
{
	GtkMessageDialog* dialog = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GtkMessageDialog* _tmp2_;
	GtkMessageDialog* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GtkMessageDialog* _tmp6_;
	GtkMessageDialog* _tmp7_;
	gint res = 0;
	GtkMessageDialog* _tmp8_;
	GtkMessageDialog* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = xnp_window_get_name (window);
	_tmp1_ = _tmp0_;
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) window, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, _ ("The group \"%s\" has been modified on the disk"), _tmp1_);
	g_object_ref_sink (_tmp2_);
	dialog = _tmp2_;
	_tmp3_ = dialog;
	_tmp4_ = xnp_window_get_name (window);
	_tmp5_ = _tmp4_;
	gtk_window_set_title ((GtkWindow*) _tmp3_, _tmp5_);
	_tmp6_ = dialog;
	gtk_window_set_icon_name ((GtkWindow*) _tmp6_, "xfce4-notes-plugin");
	_tmp7_ = dialog;
	gtk_message_dialog_format_secondary_text (_tmp7_, "%s", _ ("Do you want to reload the group?"));
	_tmp8_ = dialog;
	res = gtk_dialog_run ((GtkDialog*) _tmp8_);
	_tmp9_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp9_);
	if (res == ((gint) GTK_RESPONSE_YES)) {
		gchar* name = NULL;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		XnpWindow* win = NULL;
		const gchar* _tmp13_;
		XnpWindow* _tmp14_;
		XnpWindow* _tmp15_;
		_tmp10_ = xnp_window_get_name (window);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strdup (_tmp11_);
		name = _tmp12_;
		xnp_application_window_monitor_list_remove (self, window);
		self->priv->window_list = vala_g_slist_remove_full (self->priv->window_list, window, _g_object_unref0_);
		gtk_widget_destroy ((GtkWidget*) window);
		_tmp13_ = name;
		_tmp14_ = xnp_application_create_window (self, _tmp13_);
		win = _tmp14_;
		_tmp15_ = win;
		gtk_widget_show ((GtkWidget*) _tmp15_);
		_g_object_unref0 (win);
		_g_free0 (name);
	} else {
		xnp_application_set_data_value (self, (GObject*) window, "external-change", FALSE);
		xnp_window_set_show_refresh_button (window, FALSE);
		xnp_window_save_notes (window);
	}
	_g_object_unref0 (dialog);
}

/**
 * window_monitor_list_add:
 *
 * Creates an Xnp.WindowMonitor object and stores it inside window_monitor_list.
 */
static void
__lambda24_ (XnpApplication* self,
             XnpWindow* window)
{
	g_return_if_fail (window != NULL);
	if (xnp_application_get_data_value (self, (GObject*) window, "internal-change")) {
		xnp_application_set_data_value (self, (GObject*) window, "internal-change", FALSE);
	} else {
		xnp_application_set_data_value (self, (GObject*) window, "external-change", TRUE);
		xnp_window_set_show_refresh_button (window, TRUE);
	}
}

static void
___lambda24__xnp_window_monitor_window_updated (XnpWindowMonitor* _sender,
                                                XnpWindow* window,
                                                gpointer self)
{
	__lambda24_ ((XnpApplication*) self, window);
}

static void
xnp_application_window_monitor_list_add (XnpApplication* self,
                                         XnpWindow* window)
{
	GFile* file = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	XnpWindowMonitor* monitor = NULL;
	XnpWindowMonitor* _tmp7_;
	XnpWindowMonitor* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->_notes_path;
	_tmp1_ = xnp_window_get_name (window);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("%s/%s", _tmp0_, _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_file_new_for_path (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	file = _tmp6_;
	_tmp7_ = xnp_window_monitor_new (window, file);
	monitor = _tmp7_;
	g_signal_connect_object (monitor, "window-updated", (GCallback) ___lambda24__xnp_window_monitor_window_updated, self, 0);
	_tmp8_ = _g_object_ref0 (monitor);
	self->priv->window_monitor_list = g_slist_prepend (self->priv->window_monitor_list, _tmp8_);
	_g_object_unref0 (monitor);
	_g_object_unref0 (file);
}

/**
 * window_monitor_list_remove:
 *
 * Removes a monitor from window_monitor_list matching @window.
 */
static void
xnp_application_window_monitor_list_remove (XnpApplication* self,
                                            XnpWindow* window)
{
	XnpWindowMonitor* monitor = NULL;
	XnpWindowMonitor* _tmp0_;
	XnpWindowMonitor* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = xnp_application_window_monitor_list_lookup (self, window);
	monitor = _tmp0_;
	_tmp1_ = monitor;
	if (_tmp1_ != NULL) {
		XnpWindowMonitor* _tmp2_;
		_tmp2_ = monitor;
		self->priv->window_monitor_list = vala_g_slist_remove_full (self->priv->window_monitor_list, _tmp2_, _g_object_unref0_);
	}
	_g_object_unref0 (monitor);
}

/**
 * window_monitor_list_lookup:
 *
 * Returns the window_monitor object that contains @window from the window_monitor_list.
 */
static XnpWindowMonitor*
xnp_application_window_monitor_list_lookup (XnpApplication* self,
                                            XnpWindow* window)
{
	XnpWindowMonitor* window_monitor = NULL;
	GSList* _tmp0_;
	XnpWindowMonitor* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (window != NULL, NULL);
	window_monitor = NULL;
	_tmp0_ = self->priv->window_monitor_list;
	{
		GSList* monitor_collection = NULL;
		GSList* monitor_it = NULL;
		monitor_collection = _tmp0_;
		for (monitor_it = monitor_collection; monitor_it != NULL; monitor_it = monitor_it->next) {
			XnpWindowMonitor* _tmp1_;
			XnpWindowMonitor* monitor = NULL;
			_tmp1_ = _g_object_ref0 ((XnpWindowMonitor*) monitor_it->data);
			monitor = _tmp1_;
			{
				XnpWindowMonitor* _tmp2_;
				XnpWindow* _tmp3_;
				_tmp2_ = monitor;
				_tmp3_ = _tmp2_->window;
				if (_tmp3_ == window) {
					XnpWindowMonitor* _tmp4_;
					XnpWindowMonitor* _tmp5_;
					_tmp4_ = monitor;
					_tmp5_ = _g_object_ref0 (_tmp4_);
					_g_object_unref0 (window_monitor);
					window_monitor = _tmp5_;
					_g_object_unref0 (monitor);
					break;
				}
				_g_object_unref0 (monitor);
			}
		}
	}
	result = window_monitor;
	return result;
}

/**
 * get_data_value:
 *
 * Convenience function to return a GObject data boolean value.
 */
static gboolean
xnp_application_get_data_value (XnpApplication* self,
                                GObject* object,
                                const gchar* data)
{
	gconstpointer _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (object != NULL, FALSE);
	g_return_val_if_fail (data != NULL, FALSE);
	_tmp0_ = g_object_get_data (object, data);
	result = (gboolean) ((gintptr) _tmp0_);
	return result;
}

/**
 * set_data_value:
 *
 * Convenience function to set a GObject data boolean value.
 */
static void
xnp_application_set_data_value (XnpApplication* self,
                                GObject* object,
                                const gchar* data,
                                gboolean val)
{
	void* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = GINT_TO_POINTER ((gint) val);
	g_object_set_data_full (object, data, _tmp0_, NULL);
}

/**
 * window_name_exists:
 *
 * Verify if the given name already exists in the window list.
 */
static gboolean
xnp_application_window_name_exists (XnpApplication* self,
                                    const gchar* name)
{
	GSList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = self->priv->window_list;
	{
		GSList* win_collection = NULL;
		GSList* win_it = NULL;
		win_collection = _tmp0_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XnpWindow* _tmp1_;
			XnpWindow* win = NULL;
			_tmp1_ = _g_object_ref0 ((XnpWindow*) win_it->data);
			win = _tmp1_;
			{
				XnpWindow* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				_tmp2_ = win;
				_tmp3_ = xnp_window_get_name (_tmp2_);
				_tmp4_ = _tmp3_;
				if (g_strcmp0 (_tmp4_, name) == 0) {
					result = TRUE;
					_g_object_unref0 (win);
					return result;
				}
				_g_object_unref0 (win);
			}
		}
	}
	result = FALSE;
	return result;
}

/**
 * name_is_valid:
 *
 * Verify if the given name is valid for window and notes.
 */
static gboolean
xnp_application_name_is_valid (XnpApplication* self,
                               const gchar* name)
{
	gboolean res = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	res = g_regex_match_simple ("^[^*|/\\:\"<>?]+$", name, 0, 0);
	if (!res) {
		GtkMessageDialog* error_dialog = NULL;
		GtkMessageDialog* _tmp0_;
		GtkMessageDialog* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GtkMessageDialog* _tmp4_;
		GtkMessageDialog* _tmp5_;
		_tmp0_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, 0, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _ ("The name \"%s\" is invalid."), name);
		g_object_ref_sink (_tmp0_);
		error_dialog = _tmp0_;
		_tmp1_ = error_dialog;
		_tmp2_ = g_strdup_printf (_ ("The invalid characters are: %s"), "<tt>*|/\\:\"&lt;&gt;?</tt>");
		_tmp3_ = _tmp2_;
		gtk_message_dialog_format_secondary_markup (_tmp1_, "%s", _tmp3_);
		_g_free0 (_tmp3_);
		_tmp4_ = error_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp4_);
		_tmp5_ = error_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp5_);
		_g_object_unref0 (error_dialog);
	}
	result = res;
	return result;
}

/**
 * show_hide_notes:
 *
 * Show all the notes or hide them if they are all shown.
 */
void
xnp_application_show_hide_notes (XnpApplication* self)
{
	gboolean invisible_found = FALSE;
	gboolean visible_found = FALSE;
	gboolean active_found = FALSE;
	GSList* _tmp0_;
	GSList* _tmp6_;
	g_return_if_fail (self != NULL);
	invisible_found = FALSE;
	visible_found = FALSE;
	active_found = FALSE;
	_tmp0_ = self->priv->window_list;
	{
		GSList* win_collection = NULL;
		GSList* win_it = NULL;
		win_collection = _tmp0_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XnpWindow* _tmp1_;
			XnpWindow* win = NULL;
			_tmp1_ = _g_object_ref0 ((XnpWindow*) win_it->data);
			win = _tmp1_;
			{
				XnpWindow* _tmp2_;
				gboolean _tmp3_;
				gboolean _tmp4_;
				XnpWindow* _tmp5_;
				_tmp2_ = win;
				g_object_get ((GtkWindow*) _tmp2_, "is-active", &_tmp3_, NULL);
				_tmp4_ = _tmp3_;
				if (_tmp4_) {
					active_found = TRUE;
				}
				_tmp5_ = win;
				if (!gtk_widget_get_visible ((GtkWidget*) _tmp5_)) {
					invisible_found = TRUE;
				} else {
					visible_found = TRUE;
				}
				_g_object_unref0 (win);
			}
		}
	}
	_tmp6_ = self->priv->window_list;
	{
		GSList* win_collection = NULL;
		GSList* win_it = NULL;
		win_collection = _tmp6_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XnpWindow* _tmp7_;
			XnpWindow* win = NULL;
			_tmp7_ = _g_object_ref0 ((XnpWindow*) win_it->data);
			win = _tmp7_;
			{
				gboolean _tmp8_ = FALSE;
				if (!active_found) {
					_tmp8_ = visible_found;
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					XnpWindow* _tmp9_;
					_tmp9_ = win;
					if (gtk_widget_get_visible ((GtkWidget*) _tmp9_)) {
						XnpWindow* _tmp10_;
						_tmp10_ = win;
						gtk_window_present ((GtkWindow*) _tmp10_);
					}
				} else {
					if (invisible_found) {
						XnpWindow* _tmp11_;
						_tmp11_ = win;
						gtk_widget_show ((GtkWidget*) _tmp11_);
					} else {
						XnpWindow* _tmp12_;
						_tmp12_ = win;
						xnp_window_hide (_tmp12_);
					}
				}
				_g_object_unref0 (win);
			}
		}
	}
}

/**
 * open_settings_dialog:
 *
 * Open the settings dialog.
 */
void
xnp_application_open_settings_dialog (XnpApplication* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		g_spawn_command_line_async ("xfce4-notes-settings", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GtkMessageDialog* error_dialog = NULL;
		GtkMessageDialog* _tmp0_;
		GtkMessageDialog* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		GtkMessageDialog* _tmp4_;
		GtkMessageDialog* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", _ ("Unable to open the settings dialog"));
		g_object_ref_sink (_tmp0_);
		error_dialog = _tmp0_;
		_tmp1_ = error_dialog;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		gtk_message_dialog_format_secondary_text (_tmp1_, "%s", _tmp3_);
		_tmp4_ = error_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp4_);
		_tmp5_ = error_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp5_);
		_g_object_unref0 (error_dialog);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

/**
 * open_about_dialog:
 *
 * Open the about dialog.
 */
void
xnp_application_open_about_dialog (XnpApplication* self)
{
	gchar** authors = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gint authors_length1;
	gint _authors_size_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("(c) 2023 Arthur Demchenkov");
	_tmp1_ = g_strdup ("(c) 2006-2010 Mike Massonnet");
	_tmp2_ = g_strdup ("(c) 2003 Jakob Henriksson");
	_tmp3_ = g_new0 (gchar*, 4 + 1);
	_tmp3_[0] = _tmp0_;
	_tmp3_[1] = _tmp1_;
	_tmp3_[2] = _tmp2_;
	_tmp3_[3] = NULL;
	authors = _tmp3_;
	authors_length1 = 4;
	_authors_size_ = authors_length1;
	_tmp4_ = xfce_get_license_text (XFCE_LICENSE_TEXT_GPL);
	gtk_show_about_dialog (NULL, "program-name", _ ("Notes"), "logo-icon-name", "xfce4-notes-plugin", "comments", _ ("Ideal for your quick notes"), "version", PACKAGE_VERSION, "copyright", "Copyright © 2003-2023 The Xfce development team", "license", _tmp4_, "website", "https://docs.xfce.org/panel-plugins/xfce4-notes-plugin", "website-label", "docs.xfce.org", "authors", authors, "translator-credits", _ ("translator-credits"), NULL, NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}

/**
 * context_menu:
 *
 * Provides a GtkMenu to be used for right click context menus
 * like in trayicons. Its items are destroyed/refreshed every
 * time the menu is shown.
 */
static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		XnpApplication* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->menu);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda31_ (XnpApplication* self,
             GtkWidget* w)
{
	g_return_if_fail (w != NULL);
	gtk_widget_destroy (w);
}

static void
___lambda31__gtk_callback (GtkWidget* widget,
                           gpointer self)
{
	__lambda31_ ((XnpApplication*) self, widget);
}

static void
____lambda32_ (XnpApplication* self,
               GtkMenuItem* i)
{
	XnpWindow* w = NULL;
	gconstpointer _tmp0_;
	XnpWindow* _tmp1_;
	g_return_if_fail (i != NULL);
	_tmp0_ = g_object_get_data ((GObject*) i, "window");
	_tmp1_ = _g_object_ref0 ((XnpWindow*) _tmp0_);
	w = _tmp1_;
	gtk_window_present ((GtkWindow*) w);
	_g_object_unref0 (w);
}

static void
_____lambda32__gtk_menu_item_activate (GtkMenuItem* _sender,
                                       gpointer self)
{
	____lambda32_ ((XnpApplication*) self, _sender);
}

static void
__lambda33_ (XnpApplication* self)
{
	XnpWindow* new_win = NULL;
	XnpWindow* _tmp0_;
	_tmp0_ = xnp_application_create_window (self, NULL);
	new_win = _tmp0_;
	gtk_widget_show ((GtkWidget*) new_win);
	_g_object_unref0 (new_win);
}

static void
___lambda33__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda33_ ((XnpApplication*) self);
}

static void
__lambda30_ (Block1Data* _data1_)
{
	XnpApplication* self;
	GSList* _tmp0_;
	GtkSeparatorMenuItem* mi_sep = NULL;
	GtkSeparatorMenuItem* _tmp10_;
	GtkMenuItem* mi_add = NULL;
	GtkMenuItem* _tmp11_;
	self = _data1_->self;
	gtk_container_foreach ((GtkContainer*) _data1_->menu, ___lambda31__gtk_callback, self);
	_tmp0_ = self->priv->window_list;
	{
		GSList* win_collection = NULL;
		GSList* win_it = NULL;
		win_collection = _tmp0_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XnpWindow* _tmp1_;
			XnpWindow* win = NULL;
			_tmp1_ = _g_object_ref0 ((XnpWindow*) win_it->data);
			win = _tmp1_;
			{
				GtkMenuItem* mi = NULL;
				XnpWindow* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				GtkMenuItem* _tmp5_;
				GtkMenuItem* _tmp6_;
				XnpWindow* _tmp7_;
				GtkMenuItem* _tmp8_;
				GtkMenuItem* _tmp9_;
				_tmp2_ = win;
				_tmp3_ = xnp_window_get_name (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp4_);
				g_object_ref_sink (_tmp5_);
				mi = _tmp5_;
				_tmp6_ = mi;
				_tmp7_ = win;
				g_object_set_data_full ((GObject*) _tmp6_, "window", (void*) _tmp7_, NULL);
				_tmp8_ = mi;
				g_signal_connect_object (_tmp8_, "activate", (GCallback) _____lambda32__gtk_menu_item_activate, self, 0);
				_tmp9_ = mi;
				gtk_menu_shell_append ((GtkMenuShell*) _data1_->menu, _tmp9_);
				_g_object_unref0 (mi);
				_g_object_unref0 (win);
			}
		}
	}
	_tmp10_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp10_);
	mi_sep = _tmp10_;
	gtk_menu_shell_append ((GtkMenuShell*) _data1_->menu, (GtkMenuItem*) mi_sep);
	_tmp11_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("_Add a new group"));
	g_object_ref_sink (_tmp11_);
	mi_add = _tmp11_;
	g_signal_connect_object (mi_add, "activate", (GCallback) ___lambda33__gtk_menu_item_activate, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) _data1_->menu, mi_add);
	gtk_widget_show_all ((GtkWidget*) _data1_->menu);
	_g_object_unref0 (mi_add);
	_g_object_unref0 (mi_sep);
}

static void
___lambda30__gtk_widget_show (GtkWidget* _sender,
                              gpointer self)
{
	__lambda30_ (self);
}

GtkMenu*
xnp_application_context_menu (XnpApplication* self)
{
	Block1Data* _data1_;
	GtkMenu* _tmp0_;
	GtkMenu* _tmp1_;
	GtkMenu* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp0_);
	_data1_->menu = _tmp0_;
	g_signal_connect_data ((GtkWidget*) _data1_->menu, "show", (GCallback) ___lambda30__gtk_widget_show, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp1_ = _g_object_ref0 (_data1_->menu);
	result = _tmp1_;
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

const gchar*
xnp_application_get_notes_path (XnpApplication* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_notes_path;
	result = _tmp0_;
	return result;
}

void
xnp_application_set_notes_path (XnpApplication* self,
                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = xnp_application_get_notes_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_notes_path);
		self->priv->_notes_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, xnp_application_properties[XNP_APPLICATION_NOTES_PATH_PROPERTY]);
	}
}

const gchar*
xnp_application_get_config_file (XnpApplication* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_config_file;
	result = _tmp0_;
	return result;
}

static void
xnp_application_set_config_file (XnpApplication* self,
                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = xnp_application_get_config_file (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_config_file);
		self->priv->_config_file = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, xnp_application_properties[XNP_APPLICATION_CONFIG_FILE_PROPERTY]);
	}
}

static void
_xnp_application_quit_xfce_posix_signal_handler (gint signal,
                                                 gpointer self)
{
	xnp_application_quit ((XnpApplication*) self);
}

static void
_xnp_application___lambda34_ (XnpApplication* self)
{
	xnp_application_update_color (self);
}

static void
__xnp_application___lambda34__xfconf_g__channel_property_changed (XfconfChannel* _sender,
                                                                  const gchar* property,
                                                                  GValue* value,
                                                                  gpointer self)
{
	_xnp_application___lambda34_ ((XnpApplication*) self);
}

static void
_xnp_application___lambda35_ (XnpApplication* self)
{
	xnp_application_update_color (self);
}

static void
__xnp_application___lambda35__g_object_notify (GObject* _sender,
                                               GParamSpec* pspec,
                                               gpointer self)
{
	_xnp_application___lambda35_ ((XnpApplication*) self);
}

static void
_xnp_application___lambda36_ (XnpApplication* self)
{
	xnp_application_update_notes_path (self);
}

static void
__xnp_application___lambda36__xfconf_g__channel_property_changed (XfconfChannel* _sender,
                                                                  const gchar* property,
                                                                  GValue* value,
                                                                  gpointer self)
{
	_xnp_application___lambda36_ ((XnpApplication*) self);
}

static GObject *
xnp_application_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	XnpApplication * self;
	XfconfChannel* _tmp4_;
	XfconfChannel* _tmp5_;
	GtkSettings* _tmp6_;
	const gchar* _tmp7_;
	XfconfChannel* _tmp14_;
	gchar* name = NULL;
	gboolean found = FALSE;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (xnp_application_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XNP_TYPE_APPLICATION, XnpApplication);
	{
		xfce_posix_signal_handler_init (&_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		xfce_posix_signal_handler_set_handler ((gint) SIGTERM, _xnp_application_quit_xfce_posix_signal_handler, self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		xfce_posix_signal_handler_set_handler ((gint) SIGINT, _xnp_application_quit_xfce_posix_signal_handler, self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_critical ("application.vala:40: Unable to connect to UNIX signals. %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	{
		xfconf_init (&_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_critical ("application.vala:47: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp4_ = xfconf_channel_new_with_property_base ("xfce4-panel", "/plugins/notes");
	_g_object_unref0 (self->priv->xfconf_channel);
	self->priv->xfconf_channel = _tmp4_;
	xnp_application_update_color (self);
	_tmp5_ = self->priv->xfconf_channel;
	g_signal_connect_object (_tmp5_, "property-changed::/global/background-color", (GCallback) __xnp_application___lambda34__xfconf_g__channel_property_changed, self, 0);
	_tmp6_ = gtk_settings_get_default ();
	g_signal_connect_object ((GObject*) _tmp6_, "notify::gtk-theme-name", (GCallback) __xnp_application___lambda35__g_object_notify, self, 0);
	_tmp7_ = self->priv->_notes_path;
	if (_tmp7_ == NULL) {
		gchar* default_path = NULL;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		XfconfChannel* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp8_ = g_get_user_data_dir ();
		_tmp9_ = g_strdup_printf ("%s/notes", _tmp8_);
		default_path = _tmp9_;
		_tmp10_ = self->priv->xfconf_channel;
		_tmp11_ = default_path;
		_tmp12_ = xfconf_channel_get_string (_tmp10_, "/global/notes-path", _tmp11_);
		_tmp13_ = _tmp12_;
		xnp_application_set_notes_path (self, _tmp13_);
		_g_free0 (_tmp13_);
		_g_free0 (default_path);
	}
	_tmp14_ = self->priv->xfconf_channel;
	g_signal_connect_object (_tmp14_, "property-changed::/global/notes-path", (GCallback) __xnp_application___lambda36__xfconf_g__channel_property_changed, self, 0);
	found = FALSE;
	{
		GDir* dir = NULL;
		const gchar* _tmp15_;
		GDir* _tmp16_;
		_tmp15_ = self->priv->_notes_path;
		_tmp16_ = g_dir_open (_tmp15_, (guint) 0, &_inner_error0_);
		dir = _tmp16_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		while (TRUE) {
			GDir* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			XnpWindow* _tmp22_;
			XnpWindow* _tmp23_;
			_tmp17_ = dir;
			_tmp18_ = g_dir_read_name (_tmp17_);
			_tmp19_ = g_strdup (_tmp18_);
			_g_free0 (name);
			name = _tmp19_;
			_tmp20_ = name;
			if (!(_tmp20_ != NULL)) {
				break;
			}
			_tmp21_ = name;
			_tmp22_ = xnp_application_create_window (self, _tmp21_);
			_tmp23_ = _tmp22_;
			_g_object_unref0 (_tmp23_);
			found = TRUE;
		}
		_g_dir_close0 (dir);
	}
	goto __finally2;
	__catch2_g_error:
	{
		const gchar* _tmp24_;
		g_clear_error (&_inner_error0_);
		_tmp24_ = self->priv->_notes_path;
		g_mkdir_with_parents (_tmp24_, 0700);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	if (found == FALSE) {
		XnpWindow* _tmp25_;
		XnpWindow* _tmp26_;
		_tmp25_ = xnp_application_create_window (self, NULL);
		_tmp26_ = _tmp25_;
		_g_object_unref0 (_tmp26_);
	}
	_g_free0 (name);
	return obj;
}

static void
xnp_application_class_init (XnpApplicationClass * klass,
                            gpointer klass_data)
{
	xnp_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &XnpApplication_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_xnp_application_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_xnp_application_set_property;
	G_OBJECT_CLASS (klass)->constructor = xnp_application_constructor;
	G_OBJECT_CLASS (klass)->finalize = xnp_application_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_APPLICATION_NOTES_PATH_PROPERTY, xnp_application_properties[XNP_APPLICATION_NOTES_PATH_PROPERTY] = g_param_spec_string ("notes-path", "notes-path", "notes-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_APPLICATION_CONFIG_FILE_PROPERTY, xnp_application_properties[XNP_APPLICATION_CONFIG_FILE_PROPERTY] = g_param_spec_string ("config-file", "config-file", "config-file", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
xnp_application_instance_init (XnpApplication * self,
                               gpointer klass)
{
	self->priv = xnp_application_get_instance_private (self);
}

static void
xnp_application_finalize (GObject * obj)
{
	XnpApplication * self;
	GSList* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XNP_TYPE_APPLICATION, XnpApplication);
	xnp_application_save_windows_configuration (self);
	_g_object_unref0 (self->priv->xfconf_channel);
	self->priv->xfconf_channel = NULL;
	xfconf_shutdown ();
	_tmp0_ = self->priv->window_list;
	{
		GSList* win_collection = NULL;
		GSList* win_it = NULL;
		win_collection = _tmp0_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XnpWindow* _tmp1_;
			XnpWindow* win = NULL;
			_tmp1_ = _g_object_ref0 ((XnpWindow*) win_it->data);
			win = _tmp1_;
			{
				XnpWindow* _tmp2_;
				_tmp2_ = win;
				gtk_widget_destroy ((GtkWidget*) _tmp2_);
				_g_object_unref0 (win);
				win = NULL;
				_g_object_unref0 (win);
			}
		}
	}
	(self->priv->window_monitor_list == NULL) ? NULL : (self->priv->window_monitor_list = (_g_slist_free__g_object_unref0_ (self->priv->window_monitor_list), NULL));
	(self->priv->window_list == NULL) ? NULL : (self->priv->window_list = (_g_slist_free__g_object_unref0_ (self->priv->window_list), NULL));
	_g_free0 (self->priv->_notes_path);
	_g_free0 (self->priv->_config_file);
	_g_object_unref0 (self->priv->xfconf_channel);
	G_OBJECT_CLASS (xnp_application_parent_class)->finalize (obj);
}

static GType
xnp_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (XnpApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xnp_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XnpApplication), 0, (GInstanceInitFunc) xnp_application_instance_init, NULL };
	GType xnp_application_type_id;
	xnp_application_type_id = g_type_register_static (G_TYPE_OBJECT, "XnpApplication", &g_define_type_info, 0);
	XnpApplication_private_offset = g_type_add_instance_private (xnp_application_type_id, sizeof (XnpApplicationPrivate));
	return xnp_application_type_id;
}

GType
xnp_application_get_type (void)
{
	static volatile gsize xnp_application_type_id__once = 0;
	if (g_once_init_enter (&xnp_application_type_id__once)) {
		GType xnp_application_type_id;
		xnp_application_type_id = xnp_application_get_type_once ();
		g_once_init_leave (&xnp_application_type_id__once, xnp_application_type_id);
	}
	return xnp_application_type_id__once;
}

static void
_vala_xnp_application_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	XnpApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, XNP_TYPE_APPLICATION, XnpApplication);
	switch (property_id) {
		case XNP_APPLICATION_NOTES_PATH_PROPERTY:
		g_value_set_string (value, xnp_application_get_notes_path (self));
		break;
		case XNP_APPLICATION_CONFIG_FILE_PROPERTY:
		g_value_set_string (value, xnp_application_get_config_file (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_xnp_application_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	XnpApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, XNP_TYPE_APPLICATION, XnpApplication);
	switch (property_id) {
		case XNP_APPLICATION_NOTES_PATH_PROPERTY:
		xnp_application_set_notes_path (self, g_value_get_string (value));
		break;
		case XNP_APPLICATION_CONFIG_FILE_PROPERTY:
		xnp_application_set_config_file (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

