/*
 *========================================================================
 * $Id: libwulf_wulfhosts.h 90 2004-09-30 17:38:02Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

#include <wulfware/libwulf_copyright.h>

/* We use these for certain buffer sizes */
#define K 1024
#define K4 4096
#define K64 65536

/* Default xmlsysd port */
#define XMLSYSD_PORT 7887

 /*
  * This flag says "connect to localhost only" and skips parsing
  * of wulfhosts files in any location.
  */
 int localhosts_only;

 /*
  * The following structs exist only to allow <iprange> and <hostrange>
  * blocks of hosts to be read in and saved all at once.
  */
 typedef struct {
    char hostname[K];
    char hostip[K];
    unsigned long inetaddress;
    int port;
 } Hosttag;

 typedef struct {
    char hostfmt[K];
    int imin;
    int imax;
    int port;
 } Hostrange;

 typedef struct {
    int ipmin[4];
    int ipmax[4];
    int port;
 } IPrange;

 /*
  * We keep linked lists of host tags and host ranges and ip ranges
  * for parsing wulfhosts.
  */
 List *hosttaglist;
 List *hostrangelist;
 List *iprangelist;

 /*
  * We'll also want a couple of linked lists for users and tasks to be
  * monitored.
  */
 List *userlist;
 List *tasklist;

 /*
  * Needed by connect_to_hosts() since it is always a threaded routine
  * and hence needs at most one argument
  */
 typedef struct {
   List *hostlist;
   int connect_delay;
 } Connectlist;

 
