/*
 *   This file is part of VBA Express.
 *
 *   Copyright (c) 2005-2006 Achraf cherti <achrafcherti@gmail.com>
 * 
 *   VBA Express is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   VBA Express is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with VBA Express; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

// generated by Fast Light User Interface Designer (fluid) version 1.0107

#ifndef interface_h
#define interface_h
#include <FL/Fl.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Image.H>
#include <FL/Fl_PNG_Image.H>
#include <FL/Fl_Pixmap.H>
#ifdef __linux__
#include <X11/xpm.h>
#endif

class myWindow : public Fl_Double_Window {
public:
  int event_enabled;
  myWindow(int w, int h, const char *str=0) ;
  int handle(int e);
};
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Check_Button.H>
#include <FL/Fl_Button.H>

class InterfaceConfig {
public:
  int ok;
  InterfaceConfig();
  Fl_Double_Window *MainWindow;
  Fl_Box *label_config_interface;
  Fl_Check_Button *check_fenetre_centree;
  Fl_Check_Button *check_sauvegarde_automatique;
  Fl_Check_Button *check_souvenir_onglet;
  Fl_Button *btn_ok;
private:
  void cb_btn_ok_i(Fl_Button*, void*);
  static void cb_btn_ok(Fl_Button*, void*);
public:
  Fl_Button *btn_annuler;
private:
  void cb_btn_annuler_i(Fl_Button*, void*);
  static void cb_btn_annuler(Fl_Button*, void*);
public:
  ~InterfaceConfig();
  int show();
};
#include <FL/Fl_Browser.H>

class TextViewer {
public:
  TextViewer();
  Fl_Double_Window *MainWindow;
  Fl_Button *btn_fermer;
private:
  void cb_btn_fermer_i(Fl_Button*, void*);
  static void cb_btn_fermer(Fl_Button*, void*);
public:
  Fl_Browser *browser;
  ~TextViewer();
  void show();
};

class About {
public:
  About();
  Fl_Double_Window *MainWindow;
  Fl_Button *btn_fermer;
private:
  void cb_btn_fermer1_i(Fl_Button*, void*);
  static void cb_btn_fermer1(Fl_Button*, void*);
public:
  Fl_Box *image_gba;
  Fl_Box *label_auteur;
  Fl_Button *btn_plus_info;
  Fl_Box *label_licence;
  Fl_Box *label_titre_licence;
  Fl_Button *btn_lire_licence;
  Fl_Box *label_site;
  ~About();
  void show();
};
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Tabs.H>
#include <FL/Fl_Group.H>
#include <FL/Fl_Round_Button.H>
#include <FL/Fl_Counter.H>
#include <FL/Fl_Output.H>

class Interface {
  Fl_Image *_actual_skin;
public:
  int changed;
  Pixmap icon_pixmap;
  Pixmap icon_mask;
  Interface();
  myWindow *MainWindow;
  Fl_Box *image_fond;
  static Fl_Menu_Item menu_[];
  static Fl_Menu_Item *mnu_fichier;
  static Fl_Menu_Item *mnu_ouvrir_jeu;
  static Fl_Menu_Item *mnu_enregistrer_config;
  static Fl_Menu_Item *mnu_enregistrer_config_sous;
  static Fl_Menu_Item *mnu_importer_config;
  static Fl_Menu_Item *mnu_quitter;
  static Fl_Menu_Item *mnu_lang;
  static Fl_Menu_Item *mnu_lang_fr;
  static Fl_Menu_Item *mnu_lang_en;
  static Fl_Menu_Item *mnu_config;
  static Fl_Menu_Item *mnu_config_interface;
  static Fl_Menu_Item *mnu_config_skin;
  static Fl_Menu_Item *mnu_aide_menu;
  static Fl_Menu_Item *mnu_a_propos;
  Fl_Tabs *onglets;
  Fl_Group *tab_affichage;
  Fl_Check_Button *check_plein_ecran;
private:
  void cb_check_plein_ecran_i(Fl_Check_Button*, void*);
  static void cb_check_plein_ecran(Fl_Check_Button*, void*);
public:
  Fl_Round_Button *check_interframe_aucune;
private:
  void cb_check_interframe_aucune_i(Fl_Round_Button*, void*);
  static void cb_check_interframe_aucune(Fl_Round_Button*, void*);
public:
  Fl_Round_Button *check_interframe_motion;
private:
  void cb_check_interframe_motion_i(Fl_Round_Button*, void*);
  static void cb_check_interframe_motion(Fl_Round_Button*, void*);
public:
  Fl_Round_Button *check_interframe_smart;
private:
  void cb_check_interframe_smart_i(Fl_Round_Button*, void*);
  static void cb_check_interframe_smart(Fl_Round_Button*, void*);
public:
  Fl_Box *label_interframe;
  Fl_Counter *slide_video;
private:
  void cb_slide_video_i(Fl_Counter*, void*);
  static void cb_slide_video(Fl_Counter*, void*);
public:
  Fl_Check_Button *check_auto_skip;
private:
  void cb_check_auto_skip_i(Fl_Check_Button*, void*);
  static void cb_check_auto_skip(Fl_Check_Button*, void*);
public:
  Fl_Counter *slide_frame_skip;
private:
  void cb_slide_frame_skip_i(Fl_Counter*, void*);
  static void cb_slide_frame_skip(Fl_Counter*, void*);
public:
  Fl_Counter *slide_gb_skip;
private:
  void cb_slide_gb_skip_i(Fl_Counter*, void*);
  static void cb_slide_gb_skip(Fl_Counter*, void*);
public:
  Fl_Browser *browser_filter;
private:
  void cb_browser_filter_i(Fl_Browser*, void*);
  static void cb_browser_filter(Fl_Browser*, void*);
public:
  Fl_Group *tab_son;
  Fl_Check_Button *check_son_active;
private:
  void cb_check_son_active_i(Fl_Check_Button*, void*);
  static void cb_check_son_active(Fl_Check_Button*, void*);
public:
  Fl_Group *group_sound_qualite;
  Fl_Round_Button *radio_44;
private:
  void cb_radio_44_i(Fl_Round_Button*, void*);
  static void cb_radio_44(Fl_Round_Button*, void*);
public:
  Fl_Round_Button *radio_22;
private:
  void cb_radio_22_i(Fl_Round_Button*, void*);
  static void cb_radio_22(Fl_Round_Button*, void*);
public:
  Fl_Round_Button *radio_11;
private:
  void cb_radio_11_i(Fl_Round_Button*, void*);
  static void cb_radio_11(Fl_Round_Button*, void*);
public:
  Fl_Box *label_qualite_son;
  Fl_Group *group_sound_divers;
  Fl_Check_Button *check_reverse_stereo;
private:
  void cb_check_reverse_stereo_i(Fl_Check_Button*, void*);
  static void cb_check_reverse_stereo(Fl_Check_Button*, void*);
public:
  Fl_Check_Button *check_low_pass_filter;
private:
  void cb_check_low_pass_filter_i(Fl_Check_Button*, void*);
  static void cb_check_low_pass_filter(Fl_Check_Button*, void*);
public:
  Fl_Check_Button *check_echo;
private:
  void cb_check_echo_i(Fl_Check_Button*, void*);
  static void cb_check_echo(Fl_Check_Button*, void*);
public:
  Fl_Box *label_divers;
  Fl_Counter *slide_volume;
private:
  void cb_slide_volume_i(Fl_Counter*, void*);
  static void cb_slide_volume(Fl_Counter*, void*);
public:
  Fl_Group *tab_controle;
  Fl_Output *output_key_left;
  Fl_Output *output_key_right;
  Fl_Output *output_key_up;
  Fl_Output *output_key_down;
  Fl_Output *output_key_speed;
  Fl_Output *output_key_capture;
private:
  void cb_Speed_i(Fl_Button*, void*);
  static void cb_Speed(Fl_Button*, void*);
  void cb_Capture_i(Fl_Button*, void*);
  static void cb_Capture(Fl_Button*, void*);
  void cb_L_i(Fl_Button*, void*);
  static void cb_L(Fl_Button*, void*);
  void cb_R_i(Fl_Button*, void*);
  static void cb_R(Fl_Button*, void*);
  void cb_2_i(Fl_Button*, void*);
  static void cb_2(Fl_Button*, void*);
  void cb__i(Fl_Button*, void*);
  static void cb_(Fl_Button*, void*);
  void cb_21_i(Fl_Button*, void*);
  static void cb_21(Fl_Button*, void*);
  void cb_1_i(Fl_Button*, void*);
  static void cb_1(Fl_Button*, void*);
  void cb_A_i(Fl_Button*, void*);
  static void cb_A(Fl_Button*, void*);
  void cb_B_i(Fl_Button*, void*);
  static void cb_B(Fl_Button*, void*);
  void cb_Select_i(Fl_Button*, void*);
  static void cb_Select(Fl_Button*, void*);
  void cb_Start_i(Fl_Button*, void*);
  static void cb_Start(Fl_Button*, void*);
public:
  Fl_Output *output_key_a;
  Fl_Output *output_key_b;
  Fl_Output *output_key_start;
  Fl_Output *output_key_select;
  Fl_Output *output_key_l;
  Fl_Output *output_key_r;
  Fl_Group *tab_autre;
  Fl_Round_Button *radio_capture_bmp;
private:
  void cb_radio_capture_bmp_i(Fl_Round_Button*, void*);
  static void cb_radio_capture_bmp(Fl_Round_Button*, void*);
public:
  Fl_Round_Button *radio_capture_png;
private:
  void cb_radio_capture_png_i(Fl_Round_Button*, void*);
  static void cb_radio_capture_png(Fl_Round_Button*, void*);
public:
  Fl_Box *label_screenshot;
  Fl_Check_Button *check_color_option;
private:
  void cb_check_color_option_i(Fl_Check_Button*, void*);
  static void cb_check_color_option(Fl_Check_Button*, void*);
public:
  Fl_Check_Button *check_pause_si_inactif;
private:
  void cb_check_pause_si_inactif_i(Fl_Check_Button*, void*);
  static void cb_check_pause_si_inactif(Fl_Check_Button*, void*);
public:
  Fl_Check_Button *check_agb_print;
private:
  void cb_check_agb_print_i(Fl_Check_Button*, void*);
  static void cb_check_agb_print(Fl_Check_Button*, void*);
public:
  Fl_Round_Button *radio_speed_none;
private:
  void cb_radio_speed_none_i(Fl_Round_Button*, void*);
  static void cb_radio_speed_none(Fl_Round_Button*, void*);
public:
  Fl_Round_Button *radio_speed_percentage;
private:
  void cb_radio_speed_percentage_i(Fl_Round_Button*, void*);
  static void cb_radio_speed_percentage(Fl_Round_Button*, void*);
public:
  Fl_Round_Button *radio_speed_detailed;
private:
  void cb_radio_speed_detailed_i(Fl_Round_Button*, void*);
  static void cb_radio_speed_detailed(Fl_Round_Button*, void*);
public:
  Fl_Check_Button *check_speed_transparent;
private:
  void cb_check_speed_transparent_i(Fl_Check_Button*, void*);
  static void cb_check_speed_transparent(Fl_Check_Button*, void*);
public:
  Fl_Box *label_afficher_rapidite;
  Fl_Check_Button *check_disable_status;
private:
  void cb_check_disable_status_i(Fl_Check_Button*, void*);
  static void cb_check_disable_status(Fl_Check_Button*, void*);
public:
  Fl_Check_Button *check_enable_mmx;
private:
  void cb_check_enable_mmx_i(Fl_Check_Button*, void*);
  static void cb_check_enable_mmx(Fl_Check_Button*, void*);
public:
  Fl_Check_Button *check_enable_rtc;
private:
  void cb_check_enable_rtc_i(Fl_Check_Button*, void*);
  static void cb_check_enable_rtc(Fl_Check_Button*, void*);
public:
  Fl_Check_Button *check_enhanced_detection;
private:
  void cb_check_enhanced_detection_i(Fl_Check_Button*, void*);
  static void cb_check_enhanced_detection(Fl_Check_Button*, void*);
public:
  Fl_Check_Button *check_bordure_auto;
private:
  void cb_check_bordure_auto_i(Fl_Check_Button*, void*);
  static void cb_check_bordure_auto(Fl_Check_Button*, void*);
public:
  Fl_Group *tab_path;
  Fl_Button *btn_effacer_sauvegardes;
  Fl_Output *output_chemin_sauvegardes;
  Fl_Button *btn_chemin_sauvegardes;
  Fl_Button *btn_effacer_gameboy;
  Fl_Output *output_chemin_gameboy;
  Fl_Button *btn_chemin_gameboy;
  Fl_Button *btn_effacer_captures;
  Fl_Output *output_chemin_captures;
  Fl_Button *btn_chemin_captures;
  Fl_Button *btn_effacer_bios;
  Fl_Output *output_chemin_bios;
  Fl_Button *btn_chemin_bios;
  Fl_Button *btn_quitter;
  Fl_Button *btn_jouer;
  ~Interface();
  void getkey(Fl_Output *output);
  void dommage();
  void show(int argc, char **argv);
  void default_skin();
  void change_skin(const char *filename);
};

class SkinManager {
public:
  const char *msg_skin;
  int ok;
  SkinManager();
  Fl_Double_Window *MainWindow;
  Fl_Box *label_config_skin;
  Fl_Button *btn_ok;
private:
  void cb_btn_ok1_i(Fl_Button*, void*);
  static void cb_btn_ok1(Fl_Button*, void*);
public:
  Fl_Button *btn_annuler;
private:
  void cb_btn_annuler1_i(Fl_Button*, void*);
  static void cb_btn_annuler1(Fl_Button*, void*);
public:
  Fl_Browser *list;
  int show(const char *msg);
};
#endif
