#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 263
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 137
#define ALIAS_COUNT 0
#define TOKEN_COUNT 72
#define EXTERNAL_TOKEN_COUNT 6
#define FIELD_COUNT 21
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 59

enum {
  sym_identifier = 1,
  sym_hash_bang_line = 2,
  anon_sym_return = 3,
  anon_sym_SEMI = 4,
  anon_sym_EQ = 5,
  anon_sym_COMMA = 6,
  anon_sym_COLON_COLON = 7,
  sym_break_statement = 8,
  anon_sym_goto = 9,
  anon_sym_do = 10,
  anon_sym_end = 11,
  anon_sym_while = 12,
  anon_sym_repeat = 13,
  anon_sym_until = 14,
  anon_sym_if = 15,
  anon_sym_then = 16,
  anon_sym_elseif = 17,
  anon_sym_else = 18,
  anon_sym_for = 19,
  anon_sym_in = 20,
  anon_sym_function = 21,
  anon_sym_local = 22,
  anon_sym_DOT = 23,
  anon_sym_COLON = 24,
  anon_sym_LT = 25,
  anon_sym_GT = 26,
  sym_nil = 27,
  sym_false = 28,
  sym_true = 29,
  sym_number = 30,
  anon_sym_DQUOTE = 31,
  anon_sym_SQUOTE = 32,
  aux_sym__doublequote_string_content_token1 = 33,
  aux_sym__singlequote_string_content_token1 = 34,
  sym_escape_sequence = 35,
  sym_vararg_expression = 36,
  anon_sym_LPAREN = 37,
  anon_sym_RPAREN = 38,
  anon_sym_LBRACK = 39,
  anon_sym_RBRACK = 40,
  anon_sym_LBRACE = 41,
  anon_sym_RBRACE = 42,
  anon_sym_or = 43,
  anon_sym_and = 44,
  anon_sym_LT_EQ = 45,
  anon_sym_EQ_EQ = 46,
  anon_sym_TILDE_EQ = 47,
  anon_sym_GT_EQ = 48,
  anon_sym_PIPE = 49,
  anon_sym_TILDE = 50,
  anon_sym_AMP = 51,
  anon_sym_LT_LT = 52,
  anon_sym_GT_GT = 53,
  anon_sym_PLUS = 54,
  anon_sym_DASH = 55,
  anon_sym_STAR = 56,
  anon_sym_SLASH = 57,
  anon_sym_SLASH_SLASH = 58,
  anon_sym_PERCENT = 59,
  anon_sym_DOT_DOT = 60,
  anon_sym_CARET = 61,
  anon_sym_not = 62,
  anon_sym_POUND = 63,
  anon_sym_DASH_DASH = 64,
  aux_sym_comment_token1 = 65,
  sym__block_comment_start = 66,
  sym__block_comment_content = 67,
  sym__block_comment_end = 68,
  sym__block_string_start = 69,
  sym__block_string_content = 70,
  sym__block_string_end = 71,
  sym_chunk = 72,
  sym__block = 73,
  sym_statement = 74,
  sym_return_statement = 75,
  sym_empty_statement = 76,
  sym_assignment_statement = 77,
  sym__variable_assignment_varlist = 78,
  sym__variable_assignment_explist = 79,
  sym_label_statement = 80,
  sym_goto_statement = 81,
  sym_do_statement = 82,
  sym_while_statement = 83,
  sym_repeat_statement = 84,
  sym_if_statement = 85,
  sym_elseif_statement = 86,
  sym_else_statement = 87,
  sym_for_statement = 88,
  sym_for_generic_clause = 89,
  sym_for_numeric_clause = 90,
  sym_declaration = 91,
  sym_function_declaration = 92,
  sym__local_function_declaration = 93,
  sym__function_name = 94,
  sym__function_name_prefix_expression = 95,
  sym__function_name_dot_index_expression = 96,
  sym__function_name_method_index_expression = 97,
  sym_variable_declaration = 98,
  sym__local_variable_assignment = 99,
  sym__name_list = 100,
  sym__att_name_list = 101,
  sym__attrib = 102,
  sym__expression_list = 103,
  sym_expression = 104,
  sym_string = 105,
  sym__quote_string = 106,
  aux_sym__doublequote_string_content = 107,
  aux_sym__singlequote_string_content = 108,
  sym__block_string = 109,
  sym_function_definition = 110,
  sym__function_body = 111,
  sym_parameters = 112,
  sym__parameter_list = 113,
  sym__prefix_expression = 114,
  sym_variable = 115,
  sym_bracket_index_expression = 116,
  sym_dot_index_expression = 117,
  sym_function_call = 118,
  sym_method_index_expression = 119,
  sym_arguments = 120,
  sym_parenthesized_expression = 121,
  sym_table_constructor = 122,
  sym__field_list = 123,
  sym__field_sep = 124,
  sym_field = 125,
  sym_binary_expression = 126,
  sym_unary_expression = 127,
  sym_comment = 128,
  aux_sym_chunk_repeat1 = 129,
  aux_sym__variable_assignment_varlist_repeat1 = 130,
  aux_sym__variable_assignment_explist_repeat1 = 131,
  aux_sym_if_statement_repeat1 = 132,
  aux_sym__name_list_repeat1 = 133,
  aux_sym__att_name_list_repeat1 = 134,
  aux_sym__expression_list_repeat1 = 135,
  aux_sym__field_list_repeat1 = 136,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_hash_bang_line] = "hash_bang_line",
  [anon_sym_return] = "return",
  [anon_sym_SEMI] = ";",
  [anon_sym_EQ] = "=",
  [anon_sym_COMMA] = ",",
  [anon_sym_COLON_COLON] = "::",
  [sym_break_statement] = "break_statement",
  [anon_sym_goto] = "goto",
  [anon_sym_do] = "do",
  [anon_sym_end] = "end",
  [anon_sym_while] = "while",
  [anon_sym_repeat] = "repeat",
  [anon_sym_until] = "until",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_elseif] = "elseif",
  [anon_sym_else] = "else",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_function] = "function",
  [anon_sym_local] = "local",
  [anon_sym_DOT] = ".",
  [anon_sym_COLON] = ":",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [sym_nil] = "nil",
  [sym_false] = "false",
  [sym_true] = "true",
  [sym_number] = "number",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_SQUOTE] = "'",
  [aux_sym__doublequote_string_content_token1] = "_doublequote_string_content_token1",
  [aux_sym__singlequote_string_content_token1] = "_singlequote_string_content_token1",
  [sym_escape_sequence] = "escape_sequence",
  [sym_vararg_expression] = "vararg_expression",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_or] = "or",
  [anon_sym_and] = "and",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_TILDE_EQ] = "~=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_PIPE] = "|",
  [anon_sym_TILDE] = "~",
  [anon_sym_AMP] = "&",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_SLASH_SLASH] = "//",
  [anon_sym_PERCENT] = "%",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_CARET] = "^",
  [anon_sym_not] = "not",
  [anon_sym_POUND] = "#",
  [anon_sym_DASH_DASH] = "comment_start",
  [aux_sym_comment_token1] = "comment_content",
  [sym__block_comment_start] = "comment_start",
  [sym__block_comment_content] = "comment_content",
  [sym__block_comment_end] = "comment_end",
  [sym__block_string_start] = "[[",
  [sym__block_string_content] = "string_content",
  [sym__block_string_end] = "]]",
  [sym_chunk] = "chunk",
  [sym__block] = "block",
  [sym_statement] = "statement",
  [sym_return_statement] = "return_statement",
  [sym_empty_statement] = "empty_statement",
  [sym_assignment_statement] = "assignment_statement",
  [sym__variable_assignment_varlist] = "variable_list",
  [sym__variable_assignment_explist] = "expression_list",
  [sym_label_statement] = "label_statement",
  [sym_goto_statement] = "goto_statement",
  [sym_do_statement] = "do_statement",
  [sym_while_statement] = "while_statement",
  [sym_repeat_statement] = "repeat_statement",
  [sym_if_statement] = "if_statement",
  [sym_elseif_statement] = "elseif_statement",
  [sym_else_statement] = "else_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_generic_clause] = "for_generic_clause",
  [sym_for_numeric_clause] = "for_numeric_clause",
  [sym_declaration] = "declaration",
  [sym_function_declaration] = "function_declaration",
  [sym__local_function_declaration] = "function_declaration",
  [sym__function_name] = "_function_name",
  [sym__function_name_prefix_expression] = "_function_name_prefix_expression",
  [sym__function_name_dot_index_expression] = "dot_index_expression",
  [sym__function_name_method_index_expression] = "method_index_expression",
  [sym_variable_declaration] = "variable_declaration",
  [sym__local_variable_assignment] = "assignment_statement",
  [sym__name_list] = "variable_list",
  [sym__att_name_list] = "variable_list",
  [sym__attrib] = "attribute",
  [sym__expression_list] = "expression_list",
  [sym_expression] = "expression",
  [sym_string] = "string",
  [sym__quote_string] = "_quote_string",
  [aux_sym__doublequote_string_content] = "_doublequote_string_content",
  [aux_sym__singlequote_string_content] = "_singlequote_string_content",
  [sym__block_string] = "_block_string",
  [sym_function_definition] = "function_definition",
  [sym__function_body] = "_function_body",
  [sym_parameters] = "parameters",
  [sym__parameter_list] = "_parameter_list",
  [sym__prefix_expression] = "_prefix_expression",
  [sym_variable] = "variable",
  [sym_bracket_index_expression] = "bracket_index_expression",
  [sym_dot_index_expression] = "dot_index_expression",
  [sym_function_call] = "function_call",
  [sym_method_index_expression] = "method_index_expression",
  [sym_arguments] = "arguments",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_table_constructor] = "table_constructor",
  [sym__field_list] = "_field_list",
  [sym__field_sep] = "_field_sep",
  [sym_field] = "field",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_comment] = "comment",
  [aux_sym_chunk_repeat1] = "chunk_repeat1",
  [aux_sym__variable_assignment_varlist_repeat1] = "_variable_assignment_varlist_repeat1",
  [aux_sym__variable_assignment_explist_repeat1] = "_variable_assignment_explist_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym__name_list_repeat1] = "_name_list_repeat1",
  [aux_sym__att_name_list_repeat1] = "_att_name_list_repeat1",
  [aux_sym__expression_list_repeat1] = "_expression_list_repeat1",
  [aux_sym__field_list_repeat1] = "_field_list_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_hash_bang_line] = sym_hash_bang_line,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [sym_break_statement] = sym_break_statement,
  [anon_sym_goto] = anon_sym_goto,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_end] = anon_sym_end,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_repeat] = anon_sym_repeat,
  [anon_sym_until] = anon_sym_until,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_elseif] = anon_sym_elseif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_local] = anon_sym_local,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [sym_nil] = sym_nil,
  [sym_false] = sym_false,
  [sym_true] = sym_true,
  [sym_number] = sym_number,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym__doublequote_string_content_token1] = aux_sym__doublequote_string_content_token1,
  [aux_sym__singlequote_string_content_token1] = aux_sym__singlequote_string_content_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_vararg_expression] = sym_vararg_expression,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_TILDE_EQ] = anon_sym_TILDE_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_DASH_DASH] = sym__block_comment_start,
  [aux_sym_comment_token1] = sym__block_comment_content,
  [sym__block_comment_start] = sym__block_comment_start,
  [sym__block_comment_content] = sym__block_comment_content,
  [sym__block_comment_end] = sym__block_comment_end,
  [sym__block_string_start] = sym__block_string_start,
  [sym__block_string_content] = sym__block_string_content,
  [sym__block_string_end] = sym__block_string_end,
  [sym_chunk] = sym_chunk,
  [sym__block] = sym__block,
  [sym_statement] = sym_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_empty_statement] = sym_empty_statement,
  [sym_assignment_statement] = sym_assignment_statement,
  [sym__variable_assignment_varlist] = sym__variable_assignment_varlist,
  [sym__variable_assignment_explist] = sym__variable_assignment_explist,
  [sym_label_statement] = sym_label_statement,
  [sym_goto_statement] = sym_goto_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_repeat_statement] = sym_repeat_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_elseif_statement] = sym_elseif_statement,
  [sym_else_statement] = sym_else_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_generic_clause] = sym_for_generic_clause,
  [sym_for_numeric_clause] = sym_for_numeric_clause,
  [sym_declaration] = sym_declaration,
  [sym_function_declaration] = sym_function_declaration,
  [sym__local_function_declaration] = sym_function_declaration,
  [sym__function_name] = sym__function_name,
  [sym__function_name_prefix_expression] = sym__function_name_prefix_expression,
  [sym__function_name_dot_index_expression] = sym_dot_index_expression,
  [sym__function_name_method_index_expression] = sym_method_index_expression,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym__local_variable_assignment] = sym_assignment_statement,
  [sym__name_list] = sym__variable_assignment_varlist,
  [sym__att_name_list] = sym__variable_assignment_varlist,
  [sym__attrib] = sym__attrib,
  [sym__expression_list] = sym__variable_assignment_explist,
  [sym_expression] = sym_expression,
  [sym_string] = sym_string,
  [sym__quote_string] = sym__quote_string,
  [aux_sym__doublequote_string_content] = aux_sym__doublequote_string_content,
  [aux_sym__singlequote_string_content] = aux_sym__singlequote_string_content,
  [sym__block_string] = sym__block_string,
  [sym_function_definition] = sym_function_definition,
  [sym__function_body] = sym__function_body,
  [sym_parameters] = sym_parameters,
  [sym__parameter_list] = sym__parameter_list,
  [sym__prefix_expression] = sym__prefix_expression,
  [sym_variable] = sym_variable,
  [sym_bracket_index_expression] = sym_bracket_index_expression,
  [sym_dot_index_expression] = sym_dot_index_expression,
  [sym_function_call] = sym_function_call,
  [sym_method_index_expression] = sym_method_index_expression,
  [sym_arguments] = sym_arguments,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_table_constructor] = sym_table_constructor,
  [sym__field_list] = sym__field_list,
  [sym__field_sep] = sym__field_sep,
  [sym_field] = sym_field,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_comment] = sym_comment,
  [aux_sym_chunk_repeat1] = aux_sym_chunk_repeat1,
  [aux_sym__variable_assignment_varlist_repeat1] = aux_sym__variable_assignment_varlist_repeat1,
  [aux_sym__variable_assignment_explist_repeat1] = aux_sym__variable_assignment_explist_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym__name_list_repeat1] = aux_sym__name_list_repeat1,
  [aux_sym__att_name_list_repeat1] = aux_sym__att_name_list_repeat1,
  [aux_sym__expression_list_repeat1] = aux_sym__expression_list_repeat1,
  [aux_sym__field_list_repeat1] = aux_sym__field_list_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_hash_bang_line] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_goto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_end] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_repeat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_until] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elseif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_local] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [sym_nil] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__doublequote_string_content_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__singlequote_string_content_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_vararg_expression] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_comment_token1] = {
    .visible = true,
    .named = false,
  },
  [sym__block_comment_start] = {
    .visible = true,
    .named = false,
  },
  [sym__block_comment_content] = {
    .visible = true,
    .named = false,
  },
  [sym__block_comment_end] = {
    .visible = true,
    .named = false,
  },
  [sym__block_string_start] = {
    .visible = true,
    .named = false,
  },
  [sym__block_string_content] = {
    .visible = true,
    .named = true,
  },
  [sym__block_string_end] = {
    .visible = true,
    .named = false,
  },
  [sym_chunk] = {
    .visible = true,
    .named = true,
  },
  [sym__block] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_assignment_varlist] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_assignment_explist] = {
    .visible = true,
    .named = true,
  },
  [sym_label_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_goto_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_repeat_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elseif_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_else_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_generic_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_for_numeric_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__local_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__function_name] = {
    .visible = false,
    .named = true,
  },
  [sym__function_name_prefix_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__function_name_dot_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__function_name_method_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__local_variable_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym__name_list] = {
    .visible = true,
    .named = true,
  },
  [sym__att_name_list] = {
    .visible = true,
    .named = true,
  },
  [sym__attrib] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_list] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym__quote_string] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__doublequote_string_content] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__singlequote_string_content] = {
    .visible = false,
    .named = false,
  },
  [sym__block_string] = {
    .visible = false,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__function_body] = {
    .visible = false,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym__parameter_list] = {
    .visible = false,
    .named = true,
  },
  [sym__prefix_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_variable] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_bracket_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_dot_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym_method_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_table_constructor] = {
    .visible = true,
    .named = true,
  },
  [sym__field_list] = {
    .visible = false,
    .named = true,
  },
  [sym__field_sep] = {
    .visible = false,
    .named = true,
  },
  [sym_field] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_chunk_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__variable_assignment_varlist_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__variable_assignment_explist_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__name_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__att_name_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__expression_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__field_list_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_alternative = 1,
  field_arguments = 2,
  field_attribute = 3,
  field_body = 4,
  field_clause = 5,
  field_condition = 6,
  field_consequence = 7,
  field_content = 8,
  field_end = 9,
  field_field = 10,
  field_left = 11,
  field_local_declaration = 12,
  field_method = 13,
  field_name = 14,
  field_operand = 15,
  field_parameters = 16,
  field_right = 17,
  field_start = 18,
  field_step = 19,
  field_table = 20,
  field_value = 21,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_attribute] = "attribute",
  [field_body] = "body",
  [field_clause] = "clause",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_content] = "content",
  [field_end] = "end",
  [field_field] = "field",
  [field_left] = "left",
  [field_local_declaration] = "local_declaration",
  [field_method] = "method",
  [field_name] = "name",
  [field_operand] = "operand",
  [field_parameters] = "parameters",
  [field_right] = "right",
  [field_start] = "start",
  [field_step] = "step",
  [field_table] = "table",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 4},
  [3] = {.index = 5, .length = 1},
  [4] = {.index = 6, .length = 1},
  [5] = {.index = 7, .length = 2},
  [6] = {.index = 9, .length = 2},
  [7] = {.index = 11, .length = 3},
  [8] = {.index = 14, .length = 2},
  [9] = {.index = 16, .length = 2},
  [10] = {.index = 18, .length = 2},
  [11] = {.index = 20, .length = 2},
  [12] = {.index = 22, .length = 2},
  [13] = {.index = 24, .length = 3},
  [14] = {.index = 27, .length = 2},
  [15] = {.index = 29, .length = 1},
  [16] = {.index = 30, .length = 1},
  [17] = {.index = 31, .length = 1},
  [18] = {.index = 32, .length = 1},
  [19] = {.index = 33, .length = 3},
  [20] = {.index = 36, .length = 2},
  [21] = {.index = 38, .length = 3},
  [22] = {.index = 41, .length = 2},
  [23] = {.index = 43, .length = 2},
  [24] = {.index = 45, .length = 2},
  [25] = {.index = 47, .length = 1},
  [26] = {.index = 48, .length = 2},
  [27] = {.index = 50, .length = 1},
  [28] = {.index = 24, .length = 3},
  [29] = {.index = 51, .length = 2},
  [30] = {.index = 53, .length = 1},
  [31] = {.index = 54, .length = 2},
  [32] = {.index = 56, .length = 1},
  [33] = {.index = 57, .length = 1},
  [34] = {.index = 58, .length = 1},
  [35] = {.index = 59, .length = 3},
  [36] = {.index = 62, .length = 4},
  [37] = {.index = 66, .length = 4},
  [38] = {.index = 70, .length = 3},
  [39] = {.index = 73, .length = 2},
  [40] = {.index = 75, .length = 1},
  [41] = {.index = 76, .length = 2},
  [42] = {.index = 78, .length = 2},
  [43] = {.index = 80, .length = 2},
  [44] = {.index = 82, .length = 2},
  [45] = {.index = 84, .length = 2},
  [46] = {.index = 86, .length = 2},
  [47] = {.index = 88, .length = 2},
  [48] = {.index = 90, .length = 2},
  [49] = {.index = 92, .length = 2},
  [50] = {.index = 94, .length = 1},
  [51] = {.index = 95, .length = 2},
  [52] = {.index = 97, .length = 3},
  [53] = {.index = 100, .length = 3},
  [54] = {.index = 103, .length = 3},
  [55] = {.index = 106, .length = 3},
  [56] = {.index = 109, .length = 2},
  [57] = {.index = 111, .length = 4},
  [58] = {.index = 115, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_local_declaration, 0, .inherited = true},
  [1] =
    {field_body, 0, .inherited = true},
    {field_local_declaration, 0},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
  [5] =
    {field_local_declaration, 0},
  [6] =
    {field_name, 0},
  [7] =
    {field_end, 1},
    {field_start, 0},
  [9] =
    {field_content, 1},
    {field_start, 0},
  [11] =
    {field_content, 0, .inherited = true},
    {field_end, 0, .inherited = true},
    {field_start, 0, .inherited = true},
  [14] =
    {field_field, 0, .inherited = true},
    {field_table, 0, .inherited = true},
  [16] =
    {field_method, 0, .inherited = true},
    {field_table, 0, .inherited = true},
  [18] =
    {field_attribute, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [20] =
    {field_arguments, 1},
    {field_name, 0},
  [22] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
  [24] =
    {field_content, 1},
    {field_end, 2},
    {field_start, 0},
  [27] =
    {field_body, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
  [29] =
    {field_value, 0},
  [30] =
    {field_operand, 1},
  [31] =
    {field_body, 1},
  [32] =
    {field_condition, 2},
  [33] =
    {field_body, 2, .inherited = true},
    {field_name, 1},
    {field_parameters, 2, .inherited = true},
  [36] =
    {field_attribute, 1},
    {field_name, 0},
  [38] =
    {field_attribute, 1, .inherited = true},
    {field_name, 0},
    {field_name, 1, .inherited = true},
  [41] =
    {field_name, 0, .inherited = true},
    {field_value, 2, .inherited = true},
  [43] =
    {field_field, 2},
    {field_table, 0},
  [45] =
    {field_method, 2},
    {field_table, 0},
  [47] =
    {field_name, 1},
  [48] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [50] =
    {field_parameters, 0},
  [51] =
    {field_left, 0},
    {field_right, 2},
  [53] =
    {field_condition, 1},
  [54] =
    {field_body, 1},
    {field_condition, 3},
  [56] =
    {field_alternative, 0},
  [57] =
    {field_clause, 1},
  [58] =
    {field_name, 0, .inherited = true},
  [59] =
    {field_body, 3, .inherited = true},
    {field_name, 2},
    {field_parameters, 3, .inherited = true},
  [62] =
    {field_attribute, 1},
    {field_attribute, 2, .inherited = true},
    {field_name, 0},
    {field_name, 2, .inherited = true},
  [66] =
    {field_attribute, 0, .inherited = true},
    {field_attribute, 1, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [70] =
    {field_attribute, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_value, 2, .inherited = true},
  [73] =
    {field_value, 0},
    {field_value, 1, .inherited = true},
  [75] =
    {field_name, 1, .inherited = true},
  [76] =
    {field_body, 1},
    {field_parameters, 0},
  [78] =
    {field_name, 0},
    {field_value, 2},
  [80] =
    {field_body, 3},
    {field_condition, 1},
  [82] =
    {field_condition, 1},
    {field_consequence, 3},
  [84] =
    {field_alternative, 3},
    {field_condition, 1},
  [86] =
    {field_alternative, 3, .inherited = true},
    {field_condition, 1},
  [88] =
    {field_alternative, 0, .inherited = true},
    {field_alternative, 1, .inherited = true},
  [90] =
    {field_body, 3},
    {field_clause, 1},
  [92] =
    {field_attribute, 2},
    {field_name, 1},
  [94] =
    {field_value, 1},
  [95] =
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [97] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 3},
  [100] =
    {field_alternative, 4, .inherited = true},
    {field_condition, 1},
    {field_consequence, 3},
  [103] =
    {field_alternative, 3, .inherited = true},
    {field_alternative, 4},
    {field_condition, 1},
  [106] =
    {field_end, 4},
    {field_name, 0},
    {field_start, 2},
  [109] =
    {field_name, 1},
    {field_value, 4},
  [111] =
    {field_alternative, 4, .inherited = true},
    {field_alternative, 5},
    {field_condition, 1},
    {field_consequence, 3},
  [115] =
    {field_end, 4},
    {field_name, 0},
    {field_start, 2},
    {field_step, 6},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [28] = {
    [1] = sym__block_string_content,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  aux_sym__doublequote_string_content, 2,
    aux_sym__doublequote_string_content,
    sym__block_string_content,
  aux_sym__singlequote_string_content, 2,
    aux_sym__singlequote_string_content,
    sym__block_string_content,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 17,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 13,
  [28] = 5,
  [29] = 18,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 16,
  [38] = 38,
  [39] = 15,
  [40] = 40,
  [41] = 14,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 60,
  [62] = 62,
  [63] = 59,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 176,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 184,
  [186] = 186,
  [187] = 187,
  [188] = 187,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 183,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 199,
  [200] = 200,
  [201] = 201,
  [202] = 202,
  [203] = 203,
  [204] = 204,
  [205] = 205,
  [206] = 206,
  [207] = 207,
  [208] = 208,
  [209] = 209,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 214,
  [215] = 215,
  [216] = 216,
  [217] = 217,
  [218] = 218,
  [219] = 219,
  [220] = 220,
  [221] = 221,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 230,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 229,
  [250] = 250,
  [251] = 224,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 255,
  [256] = 256,
  [257] = 257,
  [258] = 227,
  [259] = 259,
  [260] = 260,
  [261] = 261,
  [262] = 262,
};

static inline bool sym_escape_sequence_character_set_1(int32_t c) {
  return (c < 'a'
    ? (c < '\''
      ? (c < '"'
        ? c == '\n'
        : c <= '"')
      : (c <= '\'' || c == '\\'))
    : (c <= 'b' || (c < 'r'
      ? (c < 'n'
        ? c == 'f'
        : c <= 'n')
      : (c <= 'r' || (c >= 't' && c <= 'v')))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(20);
      if (lookahead == '"') ADVANCE(39);
      if (lookahead == '#') ADVANCE(76);
      if (lookahead == '%') ADVANCE(73);
      if (lookahead == '&') ADVANCE(65);
      if (lookahead == '\'') ADVANCE(40);
      if (lookahead == '(') ADVANCE(52);
      if (lookahead == ')') ADVANCE(53);
      if (lookahead == '*') ADVANCE(70);
      if (lookahead == '+') ADVANCE(68);
      if (lookahead == ',') ADVANCE(24);
      if (lookahead == '-') ADVANCE(69);
      if (lookahead == '.') ADVANCE(27);
      if (lookahead == '/') ADVANCE(71);
      if (lookahead == '0') ADVANCE(33);
      if (lookahead == ':') ADVANCE(28);
      if (lookahead == ';') ADVANCE(22);
      if (lookahead == '<') ADVANCE(29);
      if (lookahead == '=') ADVANCE(23);
      if (lookahead == '>') ADVANCE(31);
      if (lookahead == '[') ADVANCE(54);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead == ']') ADVANCE(55);
      if (lookahead == '^') ADVANCE(75);
      if (lookahead == '{') ADVANCE(56);
      if (lookahead == '|') ADVANCE(62);
      if (lookahead == '}') ADVANCE(57);
      if (lookahead == '~') ADVANCE(64);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(17)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(34);
      if (lookahead != 0 &&
          lookahead > 31 &&
          (lookahead < 127 || 159 < lookahead)) ADVANCE(77);
      END_STATE();
    case 1:
      if (lookahead == '"') ADVANCE(39);
      if (lookahead == '-') ADVANCE(42);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0) ADVANCE(43);
      END_STATE();
    case 2:
      if (lookahead == '\'') ADVANCE(40);
      if (lookahead == '-') ADVANCE(45);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(44);
      if (lookahead != 0) ADVANCE(46);
      END_STATE();
    case 3:
      if (lookahead == '.') ADVANCE(4);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(36);
      END_STATE();
    case 4:
      if (lookahead == '.') ADVANCE(51);
      END_STATE();
    case 5:
      if (lookahead == '.') ADVANCE(14);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(35);
      END_STATE();
    case 6:
      if (lookahead == 'L') ADVANCE(32);
      END_STATE();
    case 7:
      if (lookahead == 'L') ADVANCE(6);
      END_STATE();
    case 8:
      if (lookahead == 'u') ADVANCE(9);
      if (lookahead == 'x') ADVANCE(16);
      if (lookahead == 'z') ADVANCE(48);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(50);
      if (sym_escape_sequence_character_set_1(lookahead)) ADVANCE(47);
      END_STATE();
    case 9:
      if (lookahead == '{') ADVANCE(15);
      END_STATE();
    case 10:
      if (lookahead == '}') ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(10);
      END_STATE();
    case 11:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(12);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(38);
      END_STATE();
    case 12:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(38);
      END_STATE();
    case 13:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 14:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(37);
      END_STATE();
    case 15:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(10);
      END_STATE();
    case 16:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(13);
      END_STATE();
    case 17:
      if (eof) ADVANCE(20);
      if (lookahead == '"') ADVANCE(39);
      if (lookahead == '#') ADVANCE(76);
      if (lookahead == '%') ADVANCE(73);
      if (lookahead == '&') ADVANCE(65);
      if (lookahead == '\'') ADVANCE(40);
      if (lookahead == '(') ADVANCE(52);
      if (lookahead == ')') ADVANCE(53);
      if (lookahead == '*') ADVANCE(70);
      if (lookahead == '+') ADVANCE(68);
      if (lookahead == ',') ADVANCE(24);
      if (lookahead == '-') ADVANCE(69);
      if (lookahead == '.') ADVANCE(27);
      if (lookahead == '/') ADVANCE(71);
      if (lookahead == '0') ADVANCE(33);
      if (lookahead == ':') ADVANCE(28);
      if (lookahead == ';') ADVANCE(22);
      if (lookahead == '<') ADVANCE(29);
      if (lookahead == '=') ADVANCE(23);
      if (lookahead == '>') ADVANCE(31);
      if (lookahead == '[') ADVANCE(54);
      if (lookahead == ']') ADVANCE(55);
      if (lookahead == '^') ADVANCE(75);
      if (lookahead == '{') ADVANCE(56);
      if (lookahead == '|') ADVANCE(62);
      if (lookahead == '}') ADVANCE(57);
      if (lookahead == '~') ADVANCE(64);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(17)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(34);
      if (lookahead != 0 &&
          lookahead > 31 &&
          lookahead != '\\' &&
          (lookahead < 127 || 159 < lookahead)) ADVANCE(77);
      END_STATE();
    case 18:
      if (eof) ADVANCE(20);
      if (lookahead == '"') ADVANCE(39);
      if (lookahead == '#') ADVANCE(76);
      if (lookahead == '\'') ADVANCE(40);
      if (lookahead == '(') ADVANCE(52);
      if (lookahead == ')') ADVANCE(53);
      if (lookahead == '-') ADVANCE(69);
      if (lookahead == '.') ADVANCE(3);
      if (lookahead == '0') ADVANCE(33);
      if (lookahead == ';') ADVANCE(22);
      if (lookahead == '>') ADVANCE(30);
      if (lookahead == '[') ADVANCE(54);
      if (lookahead == '{') ADVANCE(56);
      if (lookahead == '}') ADVANCE(57);
      if (lookahead == '~') ADVANCE(63);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(18)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(34);
      if (lookahead != 0 &&
          lookahead > 31 &&
          (lookahead < '%' || '=' < lookahead) &&
          (lookahead < '\\' || '^' < lookahead) &&
          (lookahead < '|' || 159 < lookahead)) ADVANCE(77);
      END_STATE();
    case 19:
      if (eof) ADVANCE(20);
      if (lookahead == '"') ADVANCE(39);
      if (lookahead == '#') ADVANCE(21);
      if (lookahead == '%') ADVANCE(73);
      if (lookahead == '&') ADVANCE(65);
      if (lookahead == '\'') ADVANCE(40);
      if (lookahead == '(') ADVANCE(52);
      if (lookahead == ')') ADVANCE(53);
      if (lookahead == '*') ADVANCE(70);
      if (lookahead == '+') ADVANCE(68);
      if (lookahead == ',') ADVANCE(24);
      if (lookahead == '-') ADVANCE(69);
      if (lookahead == '.') ADVANCE(26);
      if (lookahead == '/') ADVANCE(71);
      if (lookahead == ':') ADVANCE(28);
      if (lookahead == ';') ADVANCE(22);
      if (lookahead == '<') ADVANCE(29);
      if (lookahead == '=') ADVANCE(23);
      if (lookahead == '>') ADVANCE(31);
      if (lookahead == '[') ADVANCE(54);
      if (lookahead == ']') ADVANCE(55);
      if (lookahead == '^') ADVANCE(75);
      if (lookahead == '{') ADVANCE(56);
      if (lookahead == '|') ADVANCE(62);
      if (lookahead == '}') ADVANCE(57);
      if (lookahead == '~') ADVANCE(64);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(19)
      if (lookahead != 0 &&
          lookahead > 31 &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != '\\' &&
          (lookahead < 127 || 159 < lookahead)) ADVANCE(77);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(sym_hash_bang_line);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(21);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(59);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(74);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(74);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(36);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(25);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(66);
      if (lookahead == '=') ADVANCE(58);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(61);
      if (lookahead == '>') ADVANCE(67);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(sym_number);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(36);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(11);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(32);
      if (lookahead == 'L') ADVANCE(6);
      if (lookahead == 'U') ADVANCE(7);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(5);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(34);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(36);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(11);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(32);
      if (lookahead == 'L') ADVANCE(6);
      if (lookahead == 'U') ADVANCE(7);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(34);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(37);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(32);
      if (lookahead == 'L') ADVANCE(6);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(11);
      if (lookahead == 'U') ADVANCE(7);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(35);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(11);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(36);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(32);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(11);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(37);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(38);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(aux_sym__doublequote_string_content_token1);
      if (lookahead == '-') ADVANCE(42);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(43);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(aux_sym__doublequote_string_content_token1);
      if (lookahead == '-') ADVANCE(43);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(43);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(aux_sym__doublequote_string_content_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(43);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(aux_sym__singlequote_string_content_token1);
      if (lookahead == '-') ADVANCE(45);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(44);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(46);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(aux_sym__singlequote_string_content_token1);
      if (lookahead == '-') ADVANCE(46);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(46);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(aux_sym__singlequote_string_content_token1);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(46);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(48);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(47);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(49);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(sym_vararg_expression);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_TILDE_EQ);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (lookahead == '=') ADVANCE(60);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(78);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(72);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead != 0 &&
          lookahead > ' ' &&
          lookahead != '"' &&
          lookahead != '#' &&
          (lookahead < '%' || '/' < lookahead) &&
          (lookahead < ':' || '>' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || 159 < lookahead)) ADVANCE(77);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(82);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '-') ADVANCE(81);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(80);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(82);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '-') ADVANCE(79);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(82);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(82);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'd') ADVANCE(3);
      if (lookahead == 'e') ADVANCE(4);
      if (lookahead == 'f') ADVANCE(5);
      if (lookahead == 'g') ADVANCE(6);
      if (lookahead == 'i') ADVANCE(7);
      if (lookahead == 'l') ADVANCE(8);
      if (lookahead == 'n') ADVANCE(9);
      if (lookahead == 'o') ADVANCE(10);
      if (lookahead == 'r') ADVANCE(11);
      if (lookahead == 't') ADVANCE(12);
      if (lookahead == 'u') ADVANCE(13);
      if (lookahead == 'w') ADVANCE(14);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'n') ADVANCE(15);
      END_STATE();
    case 2:
      if (lookahead == 'r') ADVANCE(16);
      END_STATE();
    case 3:
      if (lookahead == 'o') ADVANCE(17);
      END_STATE();
    case 4:
      if (lookahead == 'l') ADVANCE(18);
      if (lookahead == 'n') ADVANCE(19);
      END_STATE();
    case 5:
      if (lookahead == 'a') ADVANCE(20);
      if (lookahead == 'o') ADVANCE(21);
      if (lookahead == 'u') ADVANCE(22);
      END_STATE();
    case 6:
      if (lookahead == 'o') ADVANCE(23);
      END_STATE();
    case 7:
      if (lookahead == 'f') ADVANCE(24);
      if (lookahead == 'n') ADVANCE(25);
      END_STATE();
    case 8:
      if (lookahead == 'o') ADVANCE(26);
      END_STATE();
    case 9:
      if (lookahead == 'i') ADVANCE(27);
      if (lookahead == 'o') ADVANCE(28);
      END_STATE();
    case 10:
      if (lookahead == 'r') ADVANCE(29);
      END_STATE();
    case 11:
      if (lookahead == 'e') ADVANCE(30);
      END_STATE();
    case 12:
      if (lookahead == 'h') ADVANCE(31);
      if (lookahead == 'r') ADVANCE(32);
      END_STATE();
    case 13:
      if (lookahead == 'n') ADVANCE(33);
      END_STATE();
    case 14:
      if (lookahead == 'h') ADVANCE(34);
      END_STATE();
    case 15:
      if (lookahead == 'd') ADVANCE(35);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(36);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 18:
      if (lookahead == 's') ADVANCE(37);
      END_STATE();
    case 19:
      if (lookahead == 'd') ADVANCE(38);
      END_STATE();
    case 20:
      if (lookahead == 'l') ADVANCE(39);
      END_STATE();
    case 21:
      if (lookahead == 'r') ADVANCE(40);
      END_STATE();
    case 22:
      if (lookahead == 'n') ADVANCE(41);
      END_STATE();
    case 23:
      if (lookahead == 't') ADVANCE(42);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 26:
      if (lookahead == 'c') ADVANCE(43);
      END_STATE();
    case 27:
      if (lookahead == 'l') ADVANCE(44);
      END_STATE();
    case 28:
      if (lookahead == 't') ADVANCE(45);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 30:
      if (lookahead == 'p') ADVANCE(46);
      if (lookahead == 't') ADVANCE(47);
      END_STATE();
    case 31:
      if (lookahead == 'e') ADVANCE(48);
      END_STATE();
    case 32:
      if (lookahead == 'u') ADVANCE(49);
      END_STATE();
    case 33:
      if (lookahead == 't') ADVANCE(50);
      END_STATE();
    case 34:
      if (lookahead == 'i') ADVANCE(51);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 36:
      if (lookahead == 'a') ADVANCE(52);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(53);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_end);
      END_STATE();
    case 39:
      if (lookahead == 's') ADVANCE(54);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 41:
      if (lookahead == 'c') ADVANCE(55);
      END_STATE();
    case 42:
      if (lookahead == 'o') ADVANCE(56);
      END_STATE();
    case 43:
      if (lookahead == 'a') ADVANCE(57);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(sym_nil);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 46:
      if (lookahead == 'e') ADVANCE(58);
      END_STATE();
    case 47:
      if (lookahead == 'u') ADVANCE(59);
      END_STATE();
    case 48:
      if (lookahead == 'n') ADVANCE(60);
      END_STATE();
    case 49:
      if (lookahead == 'e') ADVANCE(61);
      END_STATE();
    case 50:
      if (lookahead == 'i') ADVANCE(62);
      END_STATE();
    case 51:
      if (lookahead == 'l') ADVANCE(63);
      END_STATE();
    case 52:
      if (lookahead == 'k') ADVANCE(64);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == 'i') ADVANCE(65);
      END_STATE();
    case 54:
      if (lookahead == 'e') ADVANCE(66);
      END_STATE();
    case 55:
      if (lookahead == 't') ADVANCE(67);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_goto);
      END_STATE();
    case 57:
      if (lookahead == 'l') ADVANCE(68);
      END_STATE();
    case 58:
      if (lookahead == 'a') ADVANCE(69);
      END_STATE();
    case 59:
      if (lookahead == 'r') ADVANCE(70);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 62:
      if (lookahead == 'l') ADVANCE(71);
      END_STATE();
    case 63:
      if (lookahead == 'e') ADVANCE(72);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_break_statement);
      END_STATE();
    case 65:
      if (lookahead == 'f') ADVANCE(73);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 67:
      if (lookahead == 'i') ADVANCE(74);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_local);
      END_STATE();
    case 69:
      if (lookahead == 't') ADVANCE(75);
      END_STATE();
    case 70:
      if (lookahead == 'n') ADVANCE(76);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_until);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_elseif);
      END_STATE();
    case 74:
      if (lookahead == 'o') ADVANCE(77);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_repeat);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 77:
      if (lookahead == 'n') ADVANCE(78);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 19, .external_lex_state = 2},
  [2] = {.lex_state = 19, .external_lex_state = 3},
  [3] = {.lex_state = 19, .external_lex_state = 3},
  [4] = {.lex_state = 19, .external_lex_state = 3},
  [5] = {.lex_state = 19, .external_lex_state = 3},
  [6] = {.lex_state = 19, .external_lex_state = 3},
  [7] = {.lex_state = 19, .external_lex_state = 3},
  [8] = {.lex_state = 19, .external_lex_state = 3},
  [9] = {.lex_state = 19, .external_lex_state = 3},
  [10] = {.lex_state = 19, .external_lex_state = 3},
  [11] = {.lex_state = 19, .external_lex_state = 3},
  [12] = {.lex_state = 19, .external_lex_state = 3},
  [13] = {.lex_state = 19, .external_lex_state = 3},
  [14] = {.lex_state = 19, .external_lex_state = 3},
  [15] = {.lex_state = 19, .external_lex_state = 3},
  [16] = {.lex_state = 19, .external_lex_state = 3},
  [17] = {.lex_state = 19, .external_lex_state = 3},
  [18] = {.lex_state = 19, .external_lex_state = 3},
  [19] = {.lex_state = 0, .external_lex_state = 2},
  [20] = {.lex_state = 0, .external_lex_state = 2},
  [21] = {.lex_state = 0, .external_lex_state = 2},
  [22] = {.lex_state = 0, .external_lex_state = 2},
  [23] = {.lex_state = 0, .external_lex_state = 2},
  [24] = {.lex_state = 0, .external_lex_state = 2},
  [25] = {.lex_state = 0, .external_lex_state = 2},
  [26] = {.lex_state = 0, .external_lex_state = 2},
  [27] = {.lex_state = 0, .external_lex_state = 2},
  [28] = {.lex_state = 0, .external_lex_state = 2},
  [29] = {.lex_state = 0, .external_lex_state = 2},
  [30] = {.lex_state = 0, .external_lex_state = 2},
  [31] = {.lex_state = 0, .external_lex_state = 2},
  [32] = {.lex_state = 0, .external_lex_state = 2},
  [33] = {.lex_state = 0, .external_lex_state = 2},
  [34] = {.lex_state = 0, .external_lex_state = 2},
  [35] = {.lex_state = 0, .external_lex_state = 2},
  [36] = {.lex_state = 0, .external_lex_state = 2},
  [37] = {.lex_state = 0, .external_lex_state = 2},
  [38] = {.lex_state = 0, .external_lex_state = 2},
  [39] = {.lex_state = 0, .external_lex_state = 2},
  [40] = {.lex_state = 0, .external_lex_state = 2},
  [41] = {.lex_state = 0, .external_lex_state = 2},
  [42] = {.lex_state = 0, .external_lex_state = 2},
  [43] = {.lex_state = 0, .external_lex_state = 2},
  [44] = {.lex_state = 0, .external_lex_state = 2},
  [45] = {.lex_state = 0, .external_lex_state = 2},
  [46] = {.lex_state = 0, .external_lex_state = 2},
  [47] = {.lex_state = 0, .external_lex_state = 2},
  [48] = {.lex_state = 0, .external_lex_state = 2},
  [49] = {.lex_state = 0, .external_lex_state = 2},
  [50] = {.lex_state = 0, .external_lex_state = 2},
  [51] = {.lex_state = 0, .external_lex_state = 2},
  [52] = {.lex_state = 0, .external_lex_state = 2},
  [53] = {.lex_state = 0, .external_lex_state = 2},
  [54] = {.lex_state = 0, .external_lex_state = 2},
  [55] = {.lex_state = 0, .external_lex_state = 2},
  [56] = {.lex_state = 0, .external_lex_state = 2},
  [57] = {.lex_state = 0, .external_lex_state = 2},
  [58] = {.lex_state = 0, .external_lex_state = 2},
  [59] = {.lex_state = 18, .external_lex_state = 3},
  [60] = {.lex_state = 18, .external_lex_state = 3},
  [61] = {.lex_state = 18, .external_lex_state = 3},
  [62] = {.lex_state = 18, .external_lex_state = 3},
  [63] = {.lex_state = 18, .external_lex_state = 3},
  [64] = {.lex_state = 18, .external_lex_state = 3},
  [65] = {.lex_state = 19, .external_lex_state = 3},
  [66] = {.lex_state = 18, .external_lex_state = 3},
  [67] = {.lex_state = 18, .external_lex_state = 3},
  [68] = {.lex_state = 18, .external_lex_state = 3},
  [69] = {.lex_state = 18, .external_lex_state = 3},
  [70] = {.lex_state = 18, .external_lex_state = 3},
  [71] = {.lex_state = 18, .external_lex_state = 3},
  [72] = {.lex_state = 18, .external_lex_state = 3},
  [73] = {.lex_state = 18, .external_lex_state = 3},
  [74] = {.lex_state = 18, .external_lex_state = 3},
  [75] = {.lex_state = 18, .external_lex_state = 3},
  [76] = {.lex_state = 18, .external_lex_state = 3},
  [77] = {.lex_state = 18, .external_lex_state = 3},
  [78] = {.lex_state = 18, .external_lex_state = 3},
  [79] = {.lex_state = 18, .external_lex_state = 3},
  [80] = {.lex_state = 18, .external_lex_state = 3},
  [81] = {.lex_state = 18, .external_lex_state = 3},
  [82] = {.lex_state = 18, .external_lex_state = 3},
  [83] = {.lex_state = 18, .external_lex_state = 3},
  [84] = {.lex_state = 18, .external_lex_state = 3},
  [85] = {.lex_state = 18, .external_lex_state = 3},
  [86] = {.lex_state = 18, .external_lex_state = 3},
  [87] = {.lex_state = 18, .external_lex_state = 3},
  [88] = {.lex_state = 18, .external_lex_state = 3},
  [89] = {.lex_state = 18, .external_lex_state = 3},
  [90] = {.lex_state = 18, .external_lex_state = 3},
  [91] = {.lex_state = 18, .external_lex_state = 3},
  [92] = {.lex_state = 18, .external_lex_state = 3},
  [93] = {.lex_state = 18, .external_lex_state = 3},
  [94] = {.lex_state = 18, .external_lex_state = 3},
  [95] = {.lex_state = 18, .external_lex_state = 3},
  [96] = {.lex_state = 18, .external_lex_state = 3},
  [97] = {.lex_state = 18, .external_lex_state = 3},
  [98] = {.lex_state = 0, .external_lex_state = 2},
  [99] = {.lex_state = 0, .external_lex_state = 2},
  [100] = {.lex_state = 19, .external_lex_state = 3},
  [101] = {.lex_state = 0, .external_lex_state = 2},
  [102] = {.lex_state = 0, .external_lex_state = 2},
  [103] = {.lex_state = 0, .external_lex_state = 2},
  [104] = {.lex_state = 0, .external_lex_state = 2},
  [105] = {.lex_state = 0, .external_lex_state = 2},
  [106] = {.lex_state = 0, .external_lex_state = 2},
  [107] = {.lex_state = 0, .external_lex_state = 2},
  [108] = {.lex_state = 0, .external_lex_state = 2},
  [109] = {.lex_state = 0, .external_lex_state = 2},
  [110] = {.lex_state = 0, .external_lex_state = 2},
  [111] = {.lex_state = 0, .external_lex_state = 2},
  [112] = {.lex_state = 0, .external_lex_state = 2},
  [113] = {.lex_state = 0, .external_lex_state = 2},
  [114] = {.lex_state = 0, .external_lex_state = 2},
  [115] = {.lex_state = 0, .external_lex_state = 2},
  [116] = {.lex_state = 0, .external_lex_state = 2},
  [117] = {.lex_state = 0, .external_lex_state = 2},
  [118] = {.lex_state = 0, .external_lex_state = 2},
  [119] = {.lex_state = 0, .external_lex_state = 2},
  [120] = {.lex_state = 0, .external_lex_state = 2},
  [121] = {.lex_state = 0, .external_lex_state = 2},
  [122] = {.lex_state = 0, .external_lex_state = 2},
  [123] = {.lex_state = 0, .external_lex_state = 2},
  [124] = {.lex_state = 0, .external_lex_state = 2},
  [125] = {.lex_state = 0, .external_lex_state = 2},
  [126] = {.lex_state = 0, .external_lex_state = 2},
  [127] = {.lex_state = 0, .external_lex_state = 2},
  [128] = {.lex_state = 0, .external_lex_state = 2},
  [129] = {.lex_state = 0, .external_lex_state = 2},
  [130] = {.lex_state = 0, .external_lex_state = 2},
  [131] = {.lex_state = 0, .external_lex_state = 2},
  [132] = {.lex_state = 0, .external_lex_state = 2},
  [133] = {.lex_state = 0, .external_lex_state = 2},
  [134] = {.lex_state = 0, .external_lex_state = 2},
  [135] = {.lex_state = 0, .external_lex_state = 2},
  [136] = {.lex_state = 0, .external_lex_state = 2},
  [137] = {.lex_state = 0, .external_lex_state = 2},
  [138] = {.lex_state = 0, .external_lex_state = 2},
  [139] = {.lex_state = 0, .external_lex_state = 2},
  [140] = {.lex_state = 0, .external_lex_state = 2},
  [141] = {.lex_state = 0, .external_lex_state = 2},
  [142] = {.lex_state = 0, .external_lex_state = 2},
  [143] = {.lex_state = 0, .external_lex_state = 2},
  [144] = {.lex_state = 0, .external_lex_state = 2},
  [145] = {.lex_state = 0, .external_lex_state = 2},
  [146] = {.lex_state = 0, .external_lex_state = 2},
  [147] = {.lex_state = 0, .external_lex_state = 2},
  [148] = {.lex_state = 0, .external_lex_state = 2},
  [149] = {.lex_state = 0, .external_lex_state = 2},
  [150] = {.lex_state = 0, .external_lex_state = 2},
  [151] = {.lex_state = 0, .external_lex_state = 2},
  [152] = {.lex_state = 0, .external_lex_state = 2},
  [153] = {.lex_state = 18, .external_lex_state = 3},
  [154] = {.lex_state = 0, .external_lex_state = 2},
  [155] = {.lex_state = 0, .external_lex_state = 2},
  [156] = {.lex_state = 19, .external_lex_state = 3},
  [157] = {.lex_state = 19, .external_lex_state = 3},
  [158] = {.lex_state = 0, .external_lex_state = 2},
  [159] = {.lex_state = 0, .external_lex_state = 3},
  [160] = {.lex_state = 19, .external_lex_state = 3},
  [161] = {.lex_state = 0, .external_lex_state = 2},
  [162] = {.lex_state = 0, .external_lex_state = 2},
  [163] = {.lex_state = 19, .external_lex_state = 3},
  [164] = {.lex_state = 0, .external_lex_state = 2},
  [165] = {.lex_state = 0, .external_lex_state = 2},
  [166] = {.lex_state = 0, .external_lex_state = 2},
  [167] = {.lex_state = 0, .external_lex_state = 2},
  [168] = {.lex_state = 0, .external_lex_state = 2},
  [169] = {.lex_state = 0, .external_lex_state = 3},
  [170] = {.lex_state = 0, .external_lex_state = 2},
  [171] = {.lex_state = 0, .external_lex_state = 2},
  [172] = {.lex_state = 0, .external_lex_state = 2},
  [173] = {.lex_state = 0, .external_lex_state = 2},
  [174] = {.lex_state = 0, .external_lex_state = 2},
  [175] = {.lex_state = 0, .external_lex_state = 2},
  [176] = {.lex_state = 2, .external_lex_state = 2},
  [177] = {.lex_state = 18, .external_lex_state = 2},
  [178] = {.lex_state = 0, .external_lex_state = 2},
  [179] = {.lex_state = 2, .external_lex_state = 2},
  [180] = {.lex_state = 2, .external_lex_state = 2},
  [181] = {.lex_state = 1, .external_lex_state = 2},
  [182] = {.lex_state = 0, .external_lex_state = 2},
  [183] = {.lex_state = 1, .external_lex_state = 2},
  [184] = {.lex_state = 1, .external_lex_state = 2},
  [185] = {.lex_state = 1, .external_lex_state = 2},
  [186] = {.lex_state = 0, .external_lex_state = 2},
  [187] = {.lex_state = 2, .external_lex_state = 2},
  [188] = {.lex_state = 2, .external_lex_state = 2},
  [189] = {.lex_state = 0, .external_lex_state = 2},
  [190] = {.lex_state = 0, .external_lex_state = 2},
  [191] = {.lex_state = 0, .external_lex_state = 2},
  [192] = {.lex_state = 1, .external_lex_state = 2},
  [193] = {.lex_state = 0, .external_lex_state = 2},
  [194] = {.lex_state = 1, .external_lex_state = 2},
  [195] = {.lex_state = 0, .external_lex_state = 2},
  [196] = {.lex_state = 0, .external_lex_state = 2},
  [197] = {.lex_state = 0, .external_lex_state = 2},
  [198] = {.lex_state = 0, .external_lex_state = 2},
  [199] = {.lex_state = 19, .external_lex_state = 2},
  [200] = {.lex_state = 19, .external_lex_state = 2},
  [201] = {.lex_state = 19, .external_lex_state = 2},
  [202] = {.lex_state = 0, .external_lex_state = 2},
  [203] = {.lex_state = 0, .external_lex_state = 2},
  [204] = {.lex_state = 0, .external_lex_state = 2},
  [205] = {.lex_state = 19, .external_lex_state = 2},
  [206] = {.lex_state = 0, .external_lex_state = 2},
  [207] = {.lex_state = 0, .external_lex_state = 2},
  [208] = {.lex_state = 0, .external_lex_state = 2},
  [209] = {.lex_state = 0, .external_lex_state = 2},
  [210] = {.lex_state = 2, .external_lex_state = 2},
  [211] = {.lex_state = 0, .external_lex_state = 2},
  [212] = {.lex_state = 18, .external_lex_state = 2},
  [213] = {.lex_state = 0, .external_lex_state = 4},
  [214] = {.lex_state = 18, .external_lex_state = 2},
  [215] = {.lex_state = 0, .external_lex_state = 2},
  [216] = {.lex_state = 0, .external_lex_state = 2},
  [217] = {.lex_state = 0, .external_lex_state = 2},
  [218] = {.lex_state = 0, .external_lex_state = 2},
  [219] = {.lex_state = 0, .external_lex_state = 2},
  [220] = {.lex_state = 0, .external_lex_state = 2},
  [221] = {.lex_state = 0, .external_lex_state = 2},
  [222] = {.lex_state = 0, .external_lex_state = 2},
  [223] = {.lex_state = 0, .external_lex_state = 2},
  [224] = {.lex_state = 0, .external_lex_state = 2},
  [225] = {.lex_state = 18, .external_lex_state = 2},
  [226] = {.lex_state = 0, .external_lex_state = 2},
  [227] = {.lex_state = 0, .external_lex_state = 5},
  [228] = {.lex_state = 0, .external_lex_state = 2},
  [229] = {.lex_state = 0, .external_lex_state = 6},
  [230] = {.lex_state = 0, .external_lex_state = 2},
  [231] = {.lex_state = 0, .external_lex_state = 2},
  [232] = {.lex_state = 0, .external_lex_state = 2},
  [233] = {.lex_state = 0, .external_lex_state = 2},
  [234] = {.lex_state = 0, .external_lex_state = 2},
  [235] = {.lex_state = 0, .external_lex_state = 2},
  [236] = {.lex_state = 0, .external_lex_state = 2},
  [237] = {.lex_state = 0, .external_lex_state = 2},
  [238] = {.lex_state = 0, .external_lex_state = 2},
  [239] = {.lex_state = 0, .external_lex_state = 2},
  [240] = {.lex_state = 0, .external_lex_state = 2},
  [241] = {.lex_state = 0, .external_lex_state = 2},
  [242] = {.lex_state = 0, .external_lex_state = 2},
  [243] = {.lex_state = 0, .external_lex_state = 2},
  [244] = {.lex_state = 0, .external_lex_state = 2},
  [245] = {.lex_state = 0, .external_lex_state = 2},
  [246] = {.lex_state = 0, .external_lex_state = 2},
  [247] = {.lex_state = 0, .external_lex_state = 2},
  [248] = {.lex_state = 0, .external_lex_state = 2},
  [249] = {.lex_state = 0, .external_lex_state = 6},
  [250] = {.lex_state = 0, .external_lex_state = 2},
  [251] = {.lex_state = 0, .external_lex_state = 2},
  [252] = {.lex_state = 80, .external_lex_state = 2},
  [253] = {.lex_state = 0, .external_lex_state = 7},
  [254] = {.lex_state = 0, .external_lex_state = 2},
  [255] = {.lex_state = 0, .external_lex_state = 2},
  [256] = {.lex_state = 0, .external_lex_state = 2},
  [257] = {.lex_state = 0, .external_lex_state = 2},
  [258] = {.lex_state = 0, .external_lex_state = 5},
  [259] = {.lex_state = 0, .external_lex_state = 2},
  [260] = {(TSStateId)(-1)},
  [261] = {(TSStateId)(-1)},
  [262] = {(TSStateId)(-1)},
};

enum {
  ts_external_token__block_comment_start = 0,
  ts_external_token__block_comment_content = 1,
  ts_external_token__block_comment_end = 2,
  ts_external_token__block_string_start = 3,
  ts_external_token__block_string_content = 4,
  ts_external_token__block_string_end = 5,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__block_comment_start] = sym__block_comment_start,
  [ts_external_token__block_comment_content] = sym__block_comment_content,
  [ts_external_token__block_comment_end] = sym__block_comment_end,
  [ts_external_token__block_string_start] = sym__block_string_start,
  [ts_external_token__block_string_content] = sym__block_string_content,
  [ts_external_token__block_string_end] = sym__block_string_end,
};

static const bool ts_external_scanner_states[8][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__block_comment_start] = true,
    [ts_external_token__block_comment_content] = true,
    [ts_external_token__block_comment_end] = true,
    [ts_external_token__block_string_start] = true,
    [ts_external_token__block_string_content] = true,
    [ts_external_token__block_string_end] = true,
  },
  [2] = {
    [ts_external_token__block_comment_start] = true,
  },
  [3] = {
    [ts_external_token__block_comment_start] = true,
    [ts_external_token__block_string_start] = true,
  },
  [4] = {
    [ts_external_token__block_comment_start] = true,
    [ts_external_token__block_comment_content] = true,
    [ts_external_token__block_comment_end] = true,
  },
  [5] = {
    [ts_external_token__block_comment_start] = true,
    [ts_external_token__block_string_end] = true,
  },
  [6] = {
    [ts_external_token__block_comment_start] = true,
    [ts_external_token__block_string_content] = true,
  },
  [7] = {
    [ts_external_token__block_comment_start] = true,
    [ts_external_token__block_comment_end] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [sym_break_statement] = ACTIONS(1),
    [anon_sym_goto] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_end] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_repeat] = ACTIONS(1),
    [anon_sym_until] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_elseif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_local] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [sym_nil] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_TILDE_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [sym__block_comment_start] = ACTIONS(5),
    [sym__block_comment_content] = ACTIONS(1),
    [sym__block_comment_end] = ACTIONS(1),
    [sym__block_string_start] = ACTIONS(1),
    [sym__block_string_content] = ACTIONS(1),
    [sym__block_string_end] = ACTIONS(1),
  },
  [1] = {
    [sym_chunk] = STATE(256),
    [sym_statement] = STATE(134),
    [sym_return_statement] = STATE(255),
    [sym_empty_statement] = STATE(136),
    [sym_assignment_statement] = STATE(136),
    [sym__variable_assignment_varlist] = STATE(254),
    [sym_label_statement] = STATE(136),
    [sym_goto_statement] = STATE(136),
    [sym_do_statement] = STATE(136),
    [sym_while_statement] = STATE(136),
    [sym_repeat_statement] = STATE(136),
    [sym_if_statement] = STATE(136),
    [sym_for_statement] = STATE(136),
    [sym_declaration] = STATE(142),
    [sym_function_declaration] = STATE(144),
    [sym__local_function_declaration] = STATE(146),
    [sym_variable_declaration] = STATE(147),
    [sym__prefix_expression] = STATE(156),
    [sym_variable] = STATE(157),
    [sym_bracket_index_expression] = STATE(4),
    [sym_dot_index_expression] = STATE(4),
    [sym_function_call] = STATE(100),
    [sym_method_index_expression] = STATE(159),
    [sym_parenthesized_expression] = STATE(163),
    [sym_comment] = STATE(1),
    [aux_sym_chunk_repeat1] = STATE(58),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_identifier] = ACTIONS(9),
    [sym_hash_bang_line] = ACTIONS(11),
    [anon_sym_return] = ACTIONS(13),
    [anon_sym_SEMI] = ACTIONS(15),
    [anon_sym_COLON_COLON] = ACTIONS(17),
    [sym_break_statement] = ACTIONS(19),
    [anon_sym_goto] = ACTIONS(21),
    [anon_sym_do] = ACTIONS(23),
    [anon_sym_while] = ACTIONS(25),
    [anon_sym_repeat] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_function] = ACTIONS(33),
    [anon_sym_local] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [sym__block_comment_start] = ACTIONS(5),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(2), 1,
      sym_comment,
    ACTIONS(41), 26,
      anon_sym_return,
      anon_sym_EQ,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(39), 27,
      sym__block_string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [67] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(3), 1,
      sym_comment,
    ACTIONS(45), 26,
      anon_sym_return,
      anon_sym_EQ,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(43), 27,
      sym__block_string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [134] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(4), 1,
      sym_comment,
    ACTIONS(49), 26,
      anon_sym_return,
      anon_sym_EQ,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(47), 27,
      sym__block_string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [201] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(5), 1,
      sym_comment,
    ACTIONS(53), 25,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(51), 27,
      sym__block_string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [267] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(6), 1,
      sym_comment,
    ACTIONS(57), 25,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(55), 27,
      sym__block_string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [333] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(7), 1,
      sym_comment,
    ACTIONS(61), 25,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(59), 27,
      sym__block_string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [399] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(8), 1,
      sym_comment,
    ACTIONS(65), 25,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(63), 27,
      sym__block_string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [465] = 7,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(9), 1,
      sym_comment,
    ACTIONS(71), 2,
      anon_sym_DOT,
      anon_sym_COLON,
    ACTIONS(73), 6,
      sym__block_string_start,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
    ACTIONS(67), 21,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(69), 23,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [535] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(10), 1,
      sym_comment,
    ACTIONS(77), 25,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(75), 27,
      sym__block_string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [601] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(11), 1,
      sym_comment,
    ACTIONS(81), 25,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(79), 27,
      sym__block_string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [667] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(12), 1,
      sym_comment,
    ACTIONS(85), 25,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(83), 27,
      sym__block_string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [733] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(13), 1,
      sym_comment,
    ACTIONS(89), 25,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(87), 27,
      sym__block_string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [799] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(14), 1,
      sym_comment,
    ACTIONS(89), 25,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(87), 27,
      sym__block_string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [865] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(15), 1,
      sym_comment,
    ACTIONS(93), 25,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(91), 27,
      sym__block_string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [931] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(16), 1,
      sym_comment,
    ACTIONS(97), 25,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(95), 27,
      sym__block_string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [997] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(17), 1,
      sym_comment,
    ACTIONS(101), 25,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(99), 27,
      sym__block_string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [1063] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(18), 1,
      sym_comment,
    ACTIONS(105), 25,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(103), 27,
      sym__block_string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [1129] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(19), 1,
      sym_comment,
    ACTIONS(99), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(101), 23,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [1188] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(20), 1,
      sym_comment,
    ACTIONS(67), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(69), 23,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [1247] = 12,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(113), 1,
      anon_sym_PLUS,
    ACTIONS(115), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_SLASH,
    ACTIONS(121), 1,
      anon_sym_DOT_DOT,
    ACTIONS(123), 1,
      anon_sym_CARET,
    STATE(21), 1,
      sym_comment,
    ACTIONS(111), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(117), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(107), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(109), 21,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      sym_identifier,
  [1320] = 13,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(113), 1,
      anon_sym_PLUS,
    ACTIONS(115), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_SLASH,
    ACTIONS(121), 1,
      anon_sym_DOT_DOT,
    ACTIONS(123), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_AMP,
    STATE(22), 1,
      sym_comment,
    ACTIONS(111), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(117), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(107), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(109), 21,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      sym_identifier,
  [1395] = 14,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(113), 1,
      anon_sym_PLUS,
    ACTIONS(115), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_SLASH,
    ACTIONS(121), 1,
      anon_sym_DOT_DOT,
    ACTIONS(123), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_AMP,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    STATE(23), 1,
      sym_comment,
    ACTIONS(111), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(117), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(107), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(109), 20,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      sym_identifier,
  [1472] = 17,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(113), 1,
      anon_sym_PLUS,
    ACTIONS(115), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_SLASH,
    ACTIONS(121), 1,
      anon_sym_DOT_DOT,
    ACTIONS(123), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_AMP,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(133), 1,
      anon_sym_PIPE,
    STATE(24), 1,
      sym_comment,
    ACTIONS(111), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(129), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(117), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(131), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(107), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(109), 18,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      sym_identifier,
  [1555] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(113), 1,
      anon_sym_PLUS,
    ACTIONS(115), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_SLASH,
    ACTIONS(121), 1,
      anon_sym_DOT_DOT,
    ACTIONS(123), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_AMP,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(133), 1,
      anon_sym_PIPE,
    ACTIONS(135), 1,
      anon_sym_and,
    STATE(25), 1,
      sym_comment,
    ACTIONS(111), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(129), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(117), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(131), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(107), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(109), 17,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      sym_identifier,
  [1640] = 15,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(113), 1,
      anon_sym_PLUS,
    ACTIONS(115), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_SLASH,
    ACTIONS(121), 1,
      anon_sym_DOT_DOT,
    ACTIONS(123), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_AMP,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(133), 1,
      anon_sym_PIPE,
    STATE(26), 1,
      sym_comment,
    ACTIONS(111), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(117), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(107), 12,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(109), 20,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      sym_identifier,
  [1719] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(27), 1,
      sym_comment,
    ACTIONS(87), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(89), 23,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [1778] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(28), 1,
      sym_comment,
    ACTIONS(51), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(53), 23,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [1837] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(29), 1,
      sym_comment,
    ACTIONS(103), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(105), 23,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [1896] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(30), 1,
      sym_comment,
    ACTIONS(137), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(139), 23,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [1955] = 39,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(15), 1,
      anon_sym_SEMI,
    ACTIONS(17), 1,
      anon_sym_COLON_COLON,
    ACTIONS(19), 1,
      sym_break_statement,
    ACTIONS(21), 1,
      anon_sym_goto,
    ACTIONS(23), 1,
      anon_sym_do,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      anon_sym_repeat,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      anon_sym_for,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_local,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(141), 1,
      anon_sym_return,
    ACTIONS(143), 1,
      anon_sym_end,
    ACTIONS(145), 1,
      anon_sym_elseif,
    ACTIONS(147), 1,
      anon_sym_else,
    STATE(31), 1,
      sym_comment,
    STATE(44), 1,
      aux_sym_chunk_repeat1,
    STATE(100), 1,
      sym_function_call,
    STATE(134), 1,
      sym_statement,
    STATE(142), 1,
      sym_declaration,
    STATE(144), 1,
      sym_function_declaration,
    STATE(146), 1,
      sym__local_function_declaration,
    STATE(147), 1,
      sym_variable_declaration,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(157), 1,
      sym_variable,
    STATE(159), 1,
      sym_method_index_expression,
    STATE(163), 1,
      sym_parenthesized_expression,
    STATE(164), 1,
      sym__block,
    STATE(165), 1,
      aux_sym_if_statement_repeat1,
    STATE(191), 1,
      sym_return_statement,
    STATE(198), 1,
      sym_elseif_statement,
    STATE(243), 1,
      sym_else_statement,
    STATE(254), 1,
      sym__variable_assignment_varlist,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(136), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [2082] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(32), 1,
      sym_comment,
    ACTIONS(149), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(151), 23,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [2141] = 8,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(119), 1,
      anon_sym_SLASH,
    ACTIONS(123), 1,
      anon_sym_CARET,
    STATE(33), 1,
      sym_comment,
    ACTIONS(117), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(107), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DOT_DOT,
    ACTIONS(109), 22,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_DASH,
      sym_identifier,
  [2206] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(123), 1,
      anon_sym_CARET,
    STATE(34), 1,
      sym_comment,
    ACTIONS(107), 21,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
    ACTIONS(109), 23,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [2267] = 11,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(113), 1,
      anon_sym_PLUS,
    ACTIONS(115), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_SLASH,
    ACTIONS(121), 1,
      anon_sym_DOT_DOT,
    ACTIONS(123), 1,
      anon_sym_CARET,
    STATE(35), 1,
      sym_comment,
    ACTIONS(117), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(107), 16,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(109), 21,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      sym_identifier,
  [2338] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(123), 1,
      anon_sym_CARET,
    STATE(36), 1,
      sym_comment,
    ACTIONS(107), 21,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
    ACTIONS(109), 23,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [2399] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(37), 1,
      sym_comment,
    ACTIONS(95), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(97), 23,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [2458] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(38), 1,
      sym_comment,
    ACTIONS(153), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(155), 23,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [2517] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(39), 1,
      sym_comment,
    ACTIONS(91), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(93), 23,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [2576] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(123), 1,
      anon_sym_CARET,
    STATE(40), 1,
      sym_comment,
    ACTIONS(157), 21,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
    ACTIONS(159), 23,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [2637] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(41), 1,
      sym_comment,
    ACTIONS(87), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(89), 23,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [2696] = 11,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(113), 1,
      anon_sym_PLUS,
    ACTIONS(115), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_SLASH,
    ACTIONS(121), 1,
      anon_sym_DOT_DOT,
    ACTIONS(123), 1,
      anon_sym_CARET,
    STATE(42), 1,
      sym_comment,
    ACTIONS(117), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(107), 16,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(109), 21,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      sym_identifier,
  [2767] = 21,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(113), 1,
      anon_sym_PLUS,
    ACTIONS(115), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_SLASH,
    ACTIONS(121), 1,
      anon_sym_DOT_DOT,
    ACTIONS(123), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_AMP,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(133), 1,
      anon_sym_PIPE,
    ACTIONS(135), 1,
      anon_sym_and,
    ACTIONS(165), 1,
      anon_sym_COMMA,
    ACTIONS(167), 1,
      anon_sym_or,
    STATE(43), 1,
      sym_comment,
    STATE(122), 1,
      aux_sym__variable_assignment_explist_repeat1,
    ACTIONS(111), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(129), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(117), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(131), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(161), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(163), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [2855] = 33,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(15), 1,
      anon_sym_SEMI,
    ACTIONS(17), 1,
      anon_sym_COLON_COLON,
    ACTIONS(19), 1,
      sym_break_statement,
    ACTIONS(21), 1,
      anon_sym_goto,
    ACTIONS(23), 1,
      anon_sym_do,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      anon_sym_repeat,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      anon_sym_for,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_local,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(141), 1,
      anon_sym_return,
    STATE(44), 1,
      sym_comment,
    STATE(46), 1,
      aux_sym_chunk_repeat1,
    STATE(100), 1,
      sym_function_call,
    STATE(134), 1,
      sym_statement,
    STATE(142), 1,
      sym_declaration,
    STATE(144), 1,
      sym_function_declaration,
    STATE(146), 1,
      sym__local_function_declaration,
    STATE(147), 1,
      sym_variable_declaration,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(157), 1,
      sym_variable,
    STATE(159), 1,
      sym_method_index_expression,
    STATE(163), 1,
      sym_parenthesized_expression,
    STATE(190), 1,
      sym_return_statement,
    STATE(254), 1,
      sym__variable_assignment_varlist,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(169), 4,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
      anon_sym_else,
    STATE(136), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [2967] = 34,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(15), 1,
      anon_sym_SEMI,
    ACTIONS(17), 1,
      anon_sym_COLON_COLON,
    ACTIONS(19), 1,
      sym_break_statement,
    ACTIONS(21), 1,
      anon_sym_goto,
    ACTIONS(23), 1,
      anon_sym_do,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      anon_sym_repeat,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      anon_sym_for,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_local,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(141), 1,
      anon_sym_return,
    STATE(44), 1,
      aux_sym_chunk_repeat1,
    STATE(45), 1,
      sym_comment,
    STATE(100), 1,
      sym_function_call,
    STATE(134), 1,
      sym_statement,
    STATE(142), 1,
      sym_declaration,
    STATE(144), 1,
      sym_function_declaration,
    STATE(146), 1,
      sym__local_function_declaration,
    STATE(147), 1,
      sym_variable_declaration,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(157), 1,
      sym_variable,
    STATE(159), 1,
      sym_method_index_expression,
    STATE(163), 1,
      sym_parenthesized_expression,
    STATE(191), 1,
      sym_return_statement,
    STATE(197), 1,
      sym__block,
    STATE(254), 1,
      sym__variable_assignment_varlist,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(171), 3,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
    STATE(136), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [3081] = 31,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(173), 1,
      ts_builtin_sym_end,
    ACTIONS(175), 1,
      sym_identifier,
    ACTIONS(180), 1,
      anon_sym_SEMI,
    ACTIONS(183), 1,
      anon_sym_COLON_COLON,
    ACTIONS(186), 1,
      sym_break_statement,
    ACTIONS(189), 1,
      anon_sym_goto,
    ACTIONS(192), 1,
      anon_sym_do,
    ACTIONS(195), 1,
      anon_sym_while,
    ACTIONS(198), 1,
      anon_sym_repeat,
    ACTIONS(201), 1,
      anon_sym_if,
    ACTIONS(204), 1,
      anon_sym_for,
    ACTIONS(207), 1,
      anon_sym_function,
    ACTIONS(210), 1,
      anon_sym_local,
    ACTIONS(213), 1,
      anon_sym_LPAREN,
    STATE(100), 1,
      sym_function_call,
    STATE(134), 1,
      sym_statement,
    STATE(142), 1,
      sym_declaration,
    STATE(144), 1,
      sym_function_declaration,
    STATE(146), 1,
      sym__local_function_declaration,
    STATE(147), 1,
      sym_variable_declaration,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(157), 1,
      sym_variable,
    STATE(159), 1,
      sym_method_index_expression,
    STATE(163), 1,
      sym_parenthesized_expression,
    STATE(254), 1,
      sym__variable_assignment_varlist,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(46), 2,
      sym_comment,
      aux_sym_chunk_repeat1,
    ACTIONS(178), 5,
      anon_sym_return,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
      anon_sym_else,
    STATE(136), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [3189] = 19,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(113), 1,
      anon_sym_PLUS,
    ACTIONS(115), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_SLASH,
    ACTIONS(121), 1,
      anon_sym_DOT_DOT,
    ACTIONS(123), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_AMP,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(133), 1,
      anon_sym_PIPE,
    ACTIONS(135), 1,
      anon_sym_and,
    ACTIONS(167), 1,
      anon_sym_or,
    STATE(47), 1,
      sym_comment,
    ACTIONS(111), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(129), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(117), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(131), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(216), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(218), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [3272] = 34,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(15), 1,
      anon_sym_SEMI,
    ACTIONS(17), 1,
      anon_sym_COLON_COLON,
    ACTIONS(19), 1,
      sym_break_statement,
    ACTIONS(21), 1,
      anon_sym_goto,
    ACTIONS(23), 1,
      anon_sym_do,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      anon_sym_repeat,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      anon_sym_for,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_local,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(141), 1,
      anon_sym_return,
    ACTIONS(220), 1,
      anon_sym_end,
    STATE(44), 1,
      aux_sym_chunk_repeat1,
    STATE(48), 1,
      sym_comment,
    STATE(100), 1,
      sym_function_call,
    STATE(134), 1,
      sym_statement,
    STATE(142), 1,
      sym_declaration,
    STATE(144), 1,
      sym_function_declaration,
    STATE(146), 1,
      sym__local_function_declaration,
    STATE(147), 1,
      sym_variable_declaration,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(157), 1,
      sym_variable,
    STATE(159), 1,
      sym_method_index_expression,
    STATE(163), 1,
      sym_parenthesized_expression,
    STATE(191), 1,
      sym_return_statement,
    STATE(246), 1,
      sym__block,
    STATE(254), 1,
      sym__variable_assignment_varlist,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(136), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [3384] = 34,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(15), 1,
      anon_sym_SEMI,
    ACTIONS(17), 1,
      anon_sym_COLON_COLON,
    ACTIONS(19), 1,
      sym_break_statement,
    ACTIONS(21), 1,
      anon_sym_goto,
    ACTIONS(23), 1,
      anon_sym_do,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      anon_sym_repeat,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      anon_sym_for,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_local,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(141), 1,
      anon_sym_return,
    ACTIONS(222), 1,
      anon_sym_end,
    STATE(44), 1,
      aux_sym_chunk_repeat1,
    STATE(49), 1,
      sym_comment,
    STATE(100), 1,
      sym_function_call,
    STATE(134), 1,
      sym_statement,
    STATE(142), 1,
      sym_declaration,
    STATE(144), 1,
      sym_function_declaration,
    STATE(146), 1,
      sym__local_function_declaration,
    STATE(147), 1,
      sym_variable_declaration,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(157), 1,
      sym_variable,
    STATE(159), 1,
      sym_method_index_expression,
    STATE(163), 1,
      sym_parenthesized_expression,
    STATE(191), 1,
      sym_return_statement,
    STATE(230), 1,
      sym__block,
    STATE(254), 1,
      sym__variable_assignment_varlist,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(136), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [3496] = 19,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(113), 1,
      anon_sym_PLUS,
    ACTIONS(115), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_SLASH,
    ACTIONS(121), 1,
      anon_sym_DOT_DOT,
    ACTIONS(123), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_AMP,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(133), 1,
      anon_sym_PIPE,
    ACTIONS(135), 1,
      anon_sym_and,
    ACTIONS(167), 1,
      anon_sym_or,
    STATE(50), 1,
      sym_comment,
    ACTIONS(111), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(129), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(117), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(131), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(224), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(226), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [3578] = 34,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(15), 1,
      anon_sym_SEMI,
    ACTIONS(17), 1,
      anon_sym_COLON_COLON,
    ACTIONS(19), 1,
      sym_break_statement,
    ACTIONS(21), 1,
      anon_sym_goto,
    ACTIONS(23), 1,
      anon_sym_do,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      anon_sym_repeat,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      anon_sym_for,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_local,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(141), 1,
      anon_sym_return,
    ACTIONS(228), 1,
      anon_sym_end,
    STATE(44), 1,
      aux_sym_chunk_repeat1,
    STATE(51), 1,
      sym_comment,
    STATE(100), 1,
      sym_function_call,
    STATE(134), 1,
      sym_statement,
    STATE(142), 1,
      sym_declaration,
    STATE(144), 1,
      sym_function_declaration,
    STATE(146), 1,
      sym__local_function_declaration,
    STATE(147), 1,
      sym_variable_declaration,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(157), 1,
      sym_variable,
    STATE(159), 1,
      sym_method_index_expression,
    STATE(163), 1,
      sym_parenthesized_expression,
    STATE(191), 1,
      sym_return_statement,
    STATE(239), 1,
      sym__block,
    STATE(254), 1,
      sym__variable_assignment_varlist,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(136), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [3690] = 34,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(15), 1,
      anon_sym_SEMI,
    ACTIONS(17), 1,
      anon_sym_COLON_COLON,
    ACTIONS(19), 1,
      sym_break_statement,
    ACTIONS(21), 1,
      anon_sym_goto,
    ACTIONS(23), 1,
      anon_sym_do,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      anon_sym_repeat,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      anon_sym_for,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_local,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(141), 1,
      anon_sym_return,
    ACTIONS(230), 1,
      anon_sym_end,
    STATE(44), 1,
      aux_sym_chunk_repeat1,
    STATE(52), 1,
      sym_comment,
    STATE(100), 1,
      sym_function_call,
    STATE(134), 1,
      sym_statement,
    STATE(142), 1,
      sym_declaration,
    STATE(144), 1,
      sym_function_declaration,
    STATE(146), 1,
      sym__local_function_declaration,
    STATE(147), 1,
      sym_variable_declaration,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(157), 1,
      sym_variable,
    STATE(159), 1,
      sym_method_index_expression,
    STATE(163), 1,
      sym_parenthesized_expression,
    STATE(191), 1,
      sym_return_statement,
    STATE(237), 1,
      sym__block,
    STATE(254), 1,
      sym__variable_assignment_varlist,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(136), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [3802] = 34,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(15), 1,
      anon_sym_SEMI,
    ACTIONS(17), 1,
      anon_sym_COLON_COLON,
    ACTIONS(19), 1,
      sym_break_statement,
    ACTIONS(21), 1,
      anon_sym_goto,
    ACTIONS(23), 1,
      anon_sym_do,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      anon_sym_repeat,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      anon_sym_for,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_local,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(141), 1,
      anon_sym_return,
    ACTIONS(232), 1,
      anon_sym_end,
    STATE(44), 1,
      aux_sym_chunk_repeat1,
    STATE(53), 1,
      sym_comment,
    STATE(100), 1,
      sym_function_call,
    STATE(134), 1,
      sym_statement,
    STATE(142), 1,
      sym_declaration,
    STATE(144), 1,
      sym_function_declaration,
    STATE(146), 1,
      sym__local_function_declaration,
    STATE(147), 1,
      sym_variable_declaration,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(157), 1,
      sym_variable,
    STATE(159), 1,
      sym_method_index_expression,
    STATE(163), 1,
      sym_parenthesized_expression,
    STATE(191), 1,
      sym_return_statement,
    STATE(219), 1,
      sym__block,
    STATE(254), 1,
      sym__variable_assignment_varlist,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(136), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [3914] = 19,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(113), 1,
      anon_sym_PLUS,
    ACTIONS(115), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_SLASH,
    ACTIONS(121), 1,
      anon_sym_DOT_DOT,
    ACTIONS(123), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_AMP,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(133), 1,
      anon_sym_PIPE,
    ACTIONS(135), 1,
      anon_sym_and,
    ACTIONS(167), 1,
      anon_sym_or,
    STATE(54), 1,
      sym_comment,
    ACTIONS(111), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(129), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(117), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(131), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(234), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(236), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [3996] = 34,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(15), 1,
      anon_sym_SEMI,
    ACTIONS(17), 1,
      anon_sym_COLON_COLON,
    ACTIONS(19), 1,
      sym_break_statement,
    ACTIONS(21), 1,
      anon_sym_goto,
    ACTIONS(23), 1,
      anon_sym_do,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      anon_sym_repeat,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      anon_sym_for,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_local,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(141), 1,
      anon_sym_return,
    ACTIONS(238), 1,
      anon_sym_until,
    STATE(44), 1,
      aux_sym_chunk_repeat1,
    STATE(55), 1,
      sym_comment,
    STATE(100), 1,
      sym_function_call,
    STATE(134), 1,
      sym_statement,
    STATE(142), 1,
      sym_declaration,
    STATE(144), 1,
      sym_function_declaration,
    STATE(146), 1,
      sym__local_function_declaration,
    STATE(147), 1,
      sym_variable_declaration,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(157), 1,
      sym_variable,
    STATE(159), 1,
      sym_method_index_expression,
    STATE(163), 1,
      sym_parenthesized_expression,
    STATE(191), 1,
      sym_return_statement,
    STATE(245), 1,
      sym__block,
    STATE(254), 1,
      sym__variable_assignment_varlist,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(136), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [4108] = 33,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_return,
    ACTIONS(15), 1,
      anon_sym_SEMI,
    ACTIONS(17), 1,
      anon_sym_COLON_COLON,
    ACTIONS(19), 1,
      sym_break_statement,
    ACTIONS(21), 1,
      anon_sym_goto,
    ACTIONS(23), 1,
      anon_sym_do,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      anon_sym_repeat,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      anon_sym_for,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_local,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      ts_builtin_sym_end,
    STATE(56), 1,
      sym_comment,
    STATE(57), 1,
      aux_sym_chunk_repeat1,
    STATE(100), 1,
      sym_function_call,
    STATE(134), 1,
      sym_statement,
    STATE(142), 1,
      sym_declaration,
    STATE(144), 1,
      sym_function_declaration,
    STATE(146), 1,
      sym__local_function_declaration,
    STATE(147), 1,
      sym_variable_declaration,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(157), 1,
      sym_variable,
    STATE(159), 1,
      sym_method_index_expression,
    STATE(163), 1,
      sym_parenthesized_expression,
    STATE(250), 1,
      sym_return_statement,
    STATE(254), 1,
      sym__variable_assignment_varlist,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(136), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [4217] = 33,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_return,
    ACTIONS(15), 1,
      anon_sym_SEMI,
    ACTIONS(17), 1,
      anon_sym_COLON_COLON,
    ACTIONS(19), 1,
      sym_break_statement,
    ACTIONS(21), 1,
      anon_sym_goto,
    ACTIONS(23), 1,
      anon_sym_do,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      anon_sym_repeat,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      anon_sym_for,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_local,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(242), 1,
      ts_builtin_sym_end,
    STATE(46), 1,
      aux_sym_chunk_repeat1,
    STATE(57), 1,
      sym_comment,
    STATE(100), 1,
      sym_function_call,
    STATE(134), 1,
      sym_statement,
    STATE(142), 1,
      sym_declaration,
    STATE(144), 1,
      sym_function_declaration,
    STATE(146), 1,
      sym__local_function_declaration,
    STATE(147), 1,
      sym_variable_declaration,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(157), 1,
      sym_variable,
    STATE(159), 1,
      sym_method_index_expression,
    STATE(163), 1,
      sym_parenthesized_expression,
    STATE(215), 1,
      sym_return_statement,
    STATE(254), 1,
      sym__variable_assignment_varlist,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(136), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [4326] = 33,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_return,
    ACTIONS(15), 1,
      anon_sym_SEMI,
    ACTIONS(17), 1,
      anon_sym_COLON_COLON,
    ACTIONS(19), 1,
      sym_break_statement,
    ACTIONS(21), 1,
      anon_sym_goto,
    ACTIONS(23), 1,
      anon_sym_do,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      anon_sym_repeat,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      anon_sym_for,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_local,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      ts_builtin_sym_end,
    STATE(46), 1,
      aux_sym_chunk_repeat1,
    STATE(58), 1,
      sym_comment,
    STATE(100), 1,
      sym_function_call,
    STATE(134), 1,
      sym_statement,
    STATE(142), 1,
      sym_declaration,
    STATE(144), 1,
      sym_function_declaration,
    STATE(146), 1,
      sym__local_function_declaration,
    STATE(147), 1,
      sym_variable_declaration,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(157), 1,
      sym_variable,
    STATE(159), 1,
      sym_method_index_expression,
    STATE(163), 1,
      sym_parenthesized_expression,
    STATE(250), 1,
      sym_return_statement,
    STATE(254), 1,
      sym__variable_assignment_varlist,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(136), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [4435] = 25,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(244), 1,
      anon_sym_SEMI,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    STATE(27), 1,
      sym__quote_string,
    STATE(41), 1,
      sym__block_string,
    STATE(59), 1,
      sym_comment,
    STATE(99), 1,
      sym_expression,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    STATE(166), 1,
      sym__expression_list,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    ACTIONS(246), 4,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
      anon_sym_else,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4526] = 26,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    ACTIONS(266), 1,
      sym_identifier,
    ACTIONS(268), 1,
      anon_sym_LBRACK,
    ACTIONS(270), 1,
      anon_sym_RBRACE,
    STATE(27), 1,
      sym__quote_string,
    STATE(41), 1,
      sym__block_string,
    STATE(60), 1,
      sym_comment,
    STATE(104), 1,
      sym_expression,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    STATE(174), 1,
      sym_field,
    STATE(251), 1,
      sym__field_list,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4617] = 26,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    ACTIONS(266), 1,
      sym_identifier,
    ACTIONS(268), 1,
      anon_sym_LBRACK,
    ACTIONS(272), 1,
      anon_sym_RBRACE,
    STATE(27), 1,
      sym__quote_string,
    STATE(41), 1,
      sym__block_string,
    STATE(61), 1,
      sym_comment,
    STATE(104), 1,
      sym_expression,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    STATE(174), 1,
      sym_field,
    STATE(224), 1,
      sym__field_list,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4708] = 25,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    ACTIONS(266), 1,
      sym_identifier,
    ACTIONS(268), 1,
      anon_sym_LBRACK,
    ACTIONS(274), 1,
      anon_sym_RBRACE,
    STATE(27), 1,
      sym__quote_string,
    STATE(41), 1,
      sym__block_string,
    STATE(62), 1,
      sym_comment,
    STATE(104), 1,
      sym_expression,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    STATE(211), 1,
      sym_field,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4796] = 25,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(244), 1,
      anon_sym_SEMI,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    ACTIONS(276), 1,
      ts_builtin_sym_end,
    STATE(27), 1,
      sym__quote_string,
    STATE(41), 1,
      sym__block_string,
    STATE(63), 1,
      sym_comment,
    STATE(99), 1,
      sym_expression,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    STATE(166), 1,
      sym__expression_list,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4884] = 25,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    ACTIONS(266), 1,
      sym_identifier,
    ACTIONS(268), 1,
      anon_sym_LBRACK,
    ACTIONS(278), 1,
      anon_sym_RBRACE,
    STATE(27), 1,
      sym__quote_string,
    STATE(41), 1,
      sym__block_string,
    STATE(64), 1,
      sym_comment,
    STATE(104), 1,
      sym_expression,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    STATE(211), 1,
      sym_field,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4972] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(280), 1,
      anon_sym_EQ,
    STATE(65), 1,
      sym_comment,
    ACTIONS(49), 6,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
    ACTIONS(47), 26,
      sym__block_string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [5021] = 24,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    ACTIONS(266), 1,
      sym_identifier,
    ACTIONS(268), 1,
      anon_sym_LBRACK,
    STATE(27), 1,
      sym__quote_string,
    STATE(41), 1,
      sym__block_string,
    STATE(66), 1,
      sym_comment,
    STATE(104), 1,
      sym_expression,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    STATE(211), 1,
      sym_field,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5106] = 23,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    ACTIONS(282), 1,
      anon_sym_RPAREN,
    STATE(27), 1,
      sym__quote_string,
    STATE(41), 1,
      sym__block_string,
    STATE(67), 1,
      sym_comment,
    STATE(103), 1,
      sym_expression,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5188] = 23,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    STATE(27), 1,
      sym__quote_string,
    STATE(41), 1,
      sym__block_string,
    STATE(68), 1,
      sym_comment,
    STATE(99), 1,
      sym_expression,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    STATE(226), 1,
      sym__expression_list,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5270] = 23,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    STATE(27), 1,
      sym__quote_string,
    STATE(41), 1,
      sym__block_string,
    STATE(43), 1,
      sym_expression,
    STATE(69), 1,
      sym_comment,
    STATE(140), 1,
      sym__variable_assignment_explist,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5352] = 23,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    STATE(27), 1,
      sym__quote_string,
    STATE(41), 1,
      sym__block_string,
    STATE(43), 1,
      sym_expression,
    STATE(70), 1,
      sym_comment,
    STATE(137), 1,
      sym__variable_assignment_explist,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5434] = 22,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    STATE(22), 1,
      sym_expression,
    STATE(27), 1,
      sym__quote_string,
    STATE(41), 1,
      sym__block_string,
    STATE(71), 1,
      sym_comment,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5513] = 22,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    STATE(27), 1,
      sym__quote_string,
    STATE(36), 1,
      sym_expression,
    STATE(41), 1,
      sym__block_string,
    STATE(72), 1,
      sym_comment,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5592] = 22,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    STATE(27), 1,
      sym__quote_string,
    STATE(41), 1,
      sym__block_string,
    STATE(73), 1,
      sym_comment,
    STATE(108), 1,
      sym_expression,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5671] = 22,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    STATE(27), 1,
      sym__quote_string,
    STATE(41), 1,
      sym__block_string,
    STATE(54), 1,
      sym_expression,
    STATE(74), 1,
      sym_comment,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5750] = 22,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    STATE(27), 1,
      sym__quote_string,
    STATE(41), 1,
      sym__block_string,
    STATE(47), 1,
      sym_expression,
    STATE(75), 1,
      sym_comment,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5829] = 22,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    STATE(27), 1,
      sym__quote_string,
    STATE(40), 1,
      sym_expression,
    STATE(41), 1,
      sym__block_string,
    STATE(76), 1,
      sym_comment,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5908] = 22,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    STATE(27), 1,
      sym__quote_string,
    STATE(41), 1,
      sym__block_string,
    STATE(77), 1,
      sym_comment,
    STATE(101), 1,
      sym_expression,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5987] = 22,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    STATE(27), 1,
      sym__quote_string,
    STATE(35), 1,
      sym_expression,
    STATE(41), 1,
      sym__block_string,
    STATE(78), 1,
      sym_comment,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6066] = 22,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    STATE(27), 1,
      sym__quote_string,
    STATE(34), 1,
      sym_expression,
    STATE(41), 1,
      sym__block_string,
    STATE(79), 1,
      sym_comment,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6145] = 22,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    STATE(27), 1,
      sym__quote_string,
    STATE(33), 1,
      sym_expression,
    STATE(41), 1,
      sym__block_string,
    STATE(80), 1,
      sym_comment,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6224] = 22,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    STATE(27), 1,
      sym__quote_string,
    STATE(41), 1,
      sym__block_string,
    STATE(42), 1,
      sym_expression,
    STATE(81), 1,
      sym_comment,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6303] = 22,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    STATE(27), 1,
      sym__quote_string,
    STATE(41), 1,
      sym__block_string,
    STATE(82), 1,
      sym_comment,
    STATE(109), 1,
      sym_expression,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6382] = 22,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    STATE(23), 1,
      sym_expression,
    STATE(27), 1,
      sym__quote_string,
    STATE(41), 1,
      sym__block_string,
    STATE(83), 1,
      sym_comment,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6461] = 22,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    STATE(24), 1,
      sym_expression,
    STATE(27), 1,
      sym__quote_string,
    STATE(41), 1,
      sym__block_string,
    STATE(84), 1,
      sym_comment,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6540] = 22,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    STATE(27), 1,
      sym__quote_string,
    STATE(41), 1,
      sym__block_string,
    STATE(85), 1,
      sym_comment,
    STATE(102), 1,
      sym_expression,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6619] = 22,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    STATE(27), 1,
      sym__quote_string,
    STATE(41), 1,
      sym__block_string,
    STATE(86), 1,
      sym_comment,
    STATE(116), 1,
      sym_expression,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6698] = 22,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    STATE(27), 1,
      sym__quote_string,
    STATE(41), 1,
      sym__block_string,
    STATE(87), 1,
      sym_comment,
    STATE(115), 1,
      sym_expression,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6777] = 22,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    STATE(25), 1,
      sym_expression,
    STATE(27), 1,
      sym__quote_string,
    STATE(41), 1,
      sym__block_string,
    STATE(88), 1,
      sym_comment,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6856] = 22,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    STATE(26), 1,
      sym_expression,
    STATE(27), 1,
      sym__quote_string,
    STATE(41), 1,
      sym__block_string,
    STATE(89), 1,
      sym_comment,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6935] = 22,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    STATE(27), 1,
      sym__quote_string,
    STATE(41), 1,
      sym__block_string,
    STATE(90), 1,
      sym_comment,
    STATE(98), 1,
      sym_expression,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [7014] = 22,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    STATE(27), 1,
      sym__quote_string,
    STATE(41), 1,
      sym__block_string,
    STATE(91), 1,
      sym_comment,
    STATE(119), 1,
      sym_expression,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [7093] = 22,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    STATE(27), 1,
      sym__quote_string,
    STATE(41), 1,
      sym__block_string,
    STATE(92), 1,
      sym_comment,
    STATE(110), 1,
      sym_expression,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [7172] = 22,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    STATE(27), 1,
      sym__quote_string,
    STATE(41), 1,
      sym__block_string,
    STATE(93), 1,
      sym_comment,
    STATE(114), 1,
      sym_expression,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [7251] = 22,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    STATE(27), 1,
      sym__quote_string,
    STATE(41), 1,
      sym__block_string,
    STATE(94), 1,
      sym_comment,
    STATE(106), 1,
      sym_expression,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [7330] = 22,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    STATE(27), 1,
      sym__quote_string,
    STATE(41), 1,
      sym__block_string,
    STATE(50), 1,
      sym_expression,
    STATE(95), 1,
      sym_comment,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [7409] = 22,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    STATE(27), 1,
      sym__quote_string,
    STATE(41), 1,
      sym__block_string,
    STATE(96), 1,
      sym_comment,
    STATE(111), 1,
      sym_expression,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [7488] = 22,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_function,
    ACTIONS(254), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_SQUOTE,
    ACTIONS(258), 1,
      anon_sym_LBRACE,
    ACTIONS(264), 1,
      sym__block_string_start,
    STATE(21), 1,
      sym_expression,
    STATE(27), 1,
      sym__quote_string,
    STATE(41), 1,
      sym__block_string,
    STATE(97), 1,
      sym_comment,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    ACTIONS(252), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(260), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(262), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(250), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(9), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(20), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [7567] = 19,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(113), 1,
      anon_sym_PLUS,
    ACTIONS(115), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_SLASH,
    ACTIONS(121), 1,
      anon_sym_DOT_DOT,
    ACTIONS(123), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_AMP,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(133), 1,
      anon_sym_PIPE,
    ACTIONS(286), 1,
      anon_sym_else,
    ACTIONS(288), 1,
      anon_sym_or,
    ACTIONS(290), 1,
      anon_sym_and,
    STATE(98), 1,
      sym_comment,
    ACTIONS(111), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(129), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(117), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(131), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(284), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_do,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
      anon_sym_RPAREN,
  [7639] = 21,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(113), 1,
      anon_sym_PLUS,
    ACTIONS(115), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_SLASH,
    ACTIONS(121), 1,
      anon_sym_DOT_DOT,
    ACTIONS(123), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_AMP,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(133), 1,
      anon_sym_PIPE,
    ACTIONS(288), 1,
      anon_sym_or,
    ACTIONS(290), 1,
      anon_sym_and,
    ACTIONS(294), 1,
      anon_sym_COMMA,
    ACTIONS(296), 1,
      anon_sym_else,
    STATE(99), 1,
      sym_comment,
    STATE(162), 1,
      aux_sym__expression_list_repeat1,
    ACTIONS(111), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(129), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(117), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(131), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(292), 6,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_do,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
  [7715] = 7,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(71), 1,
      anon_sym_COLON,
    STATE(100), 1,
      sym_comment,
    ACTIONS(298), 3,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
    ACTIONS(73), 7,
      sym__block_string_start,
      anon_sym_DOT,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
    ACTIONS(300), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [7759] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(113), 1,
      anon_sym_PLUS,
    ACTIONS(115), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_SLASH,
    ACTIONS(121), 1,
      anon_sym_DOT_DOT,
    ACTIONS(123), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_AMP,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(133), 1,
      anon_sym_PIPE,
    ACTIONS(288), 1,
      anon_sym_or,
    ACTIONS(290), 1,
      anon_sym_and,
    STATE(101), 1,
      sym_comment,
    ACTIONS(111), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(129), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(117), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(302), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    ACTIONS(131), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [7823] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(113), 1,
      anon_sym_PLUS,
    ACTIONS(115), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_SLASH,
    ACTIONS(121), 1,
      anon_sym_DOT_DOT,
    ACTIONS(123), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_AMP,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(133), 1,
      anon_sym_PIPE,
    ACTIONS(288), 1,
      anon_sym_or,
    ACTIONS(290), 1,
      anon_sym_and,
    STATE(102), 1,
      sym_comment,
    ACTIONS(111), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(129), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(117), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(304), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    ACTIONS(131), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [7887] = 20,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(113), 1,
      anon_sym_PLUS,
    ACTIONS(115), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_SLASH,
    ACTIONS(121), 1,
      anon_sym_DOT_DOT,
    ACTIONS(123), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_AMP,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(133), 1,
      anon_sym_PIPE,
    ACTIONS(288), 1,
      anon_sym_or,
    ACTIONS(290), 1,
      anon_sym_and,
    ACTIONS(294), 1,
      anon_sym_COMMA,
    ACTIONS(306), 1,
      anon_sym_RPAREN,
    STATE(103), 1,
      sym_comment,
    STATE(203), 1,
      aux_sym__expression_list_repeat1,
    ACTIONS(111), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(129), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(117), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(131), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [7955] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(113), 1,
      anon_sym_PLUS,
    ACTIONS(115), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_SLASH,
    ACTIONS(121), 1,
      anon_sym_DOT_DOT,
    ACTIONS(123), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_AMP,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(133), 1,
      anon_sym_PIPE,
    ACTIONS(288), 1,
      anon_sym_or,
    ACTIONS(290), 1,
      anon_sym_and,
    STATE(104), 1,
      sym_comment,
    ACTIONS(111), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(129), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(117), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(308), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    ACTIONS(131), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [8019] = 9,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(314), 1,
      anon_sym_COMMA,
    ACTIONS(316), 1,
      anon_sym_LT,
    STATE(105), 1,
      sym_comment,
    STATE(117), 1,
      aux_sym__att_name_list_repeat1,
    STATE(118), 1,
      sym__attrib,
    ACTIONS(310), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(312), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8065] = 19,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(113), 1,
      anon_sym_PLUS,
    ACTIONS(115), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_SLASH,
    ACTIONS(121), 1,
      anon_sym_DOT_DOT,
    ACTIONS(123), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_AMP,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(133), 1,
      anon_sym_PIPE,
    ACTIONS(288), 1,
      anon_sym_or,
    ACTIONS(290), 1,
      anon_sym_and,
    ACTIONS(318), 1,
      anon_sym_COMMA,
    ACTIONS(320), 1,
      anon_sym_do,
    STATE(106), 1,
      sym_comment,
    ACTIONS(111), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(129), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(117), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(131), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [8130] = 7,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(316), 1,
      anon_sym_LT,
    STATE(107), 1,
      sym_comment,
    STATE(121), 1,
      sym__attrib,
    ACTIONS(322), 6,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(324), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8171] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(113), 1,
      anon_sym_PLUS,
    ACTIONS(115), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_SLASH,
    ACTIONS(121), 1,
      anon_sym_DOT_DOT,
    ACTIONS(123), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_AMP,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(133), 1,
      anon_sym_PIPE,
    ACTIONS(288), 1,
      anon_sym_or,
    ACTIONS(290), 1,
      anon_sym_and,
    ACTIONS(326), 1,
      anon_sym_COMMA,
    STATE(108), 1,
      sym_comment,
    ACTIONS(111), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(129), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(117), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(131), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [8233] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(113), 1,
      anon_sym_PLUS,
    ACTIONS(115), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_SLASH,
    ACTIONS(121), 1,
      anon_sym_DOT_DOT,
    ACTIONS(123), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_AMP,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(133), 1,
      anon_sym_PIPE,
    ACTIONS(288), 1,
      anon_sym_or,
    ACTIONS(290), 1,
      anon_sym_and,
    ACTIONS(328), 1,
      anon_sym_do,
    STATE(109), 1,
      sym_comment,
    ACTIONS(111), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(129), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(117), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(131), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [8295] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(113), 1,
      anon_sym_PLUS,
    ACTIONS(115), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_SLASH,
    ACTIONS(121), 1,
      anon_sym_DOT_DOT,
    ACTIONS(123), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_AMP,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(133), 1,
      anon_sym_PIPE,
    ACTIONS(288), 1,
      anon_sym_or,
    ACTIONS(290), 1,
      anon_sym_and,
    ACTIONS(330), 1,
      anon_sym_then,
    STATE(110), 1,
      sym_comment,
    ACTIONS(111), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(129), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(117), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(131), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [8357] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(113), 1,
      anon_sym_PLUS,
    ACTIONS(115), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_SLASH,
    ACTIONS(121), 1,
      anon_sym_DOT_DOT,
    ACTIONS(123), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_AMP,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(133), 1,
      anon_sym_PIPE,
    ACTIONS(288), 1,
      anon_sym_or,
    ACTIONS(290), 1,
      anon_sym_and,
    ACTIONS(332), 1,
      anon_sym_RBRACK,
    STATE(111), 1,
      sym_comment,
    ACTIONS(111), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(129), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(117), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(131), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [8419] = 7,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(314), 1,
      anon_sym_COMMA,
    STATE(112), 1,
      sym_comment,
    STATE(113), 1,
      aux_sym__att_name_list_repeat1,
    ACTIONS(334), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(336), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8459] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(342), 1,
      anon_sym_COMMA,
    STATE(113), 2,
      sym_comment,
      aux_sym__att_name_list_repeat1,
    ACTIONS(338), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(340), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8497] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(113), 1,
      anon_sym_PLUS,
    ACTIONS(115), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_SLASH,
    ACTIONS(121), 1,
      anon_sym_DOT_DOT,
    ACTIONS(123), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_AMP,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(133), 1,
      anon_sym_PIPE,
    ACTIONS(288), 1,
      anon_sym_or,
    ACTIONS(290), 1,
      anon_sym_and,
    ACTIONS(345), 1,
      anon_sym_RPAREN,
    STATE(114), 1,
      sym_comment,
    ACTIONS(111), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(129), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(117), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(131), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [8559] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(113), 1,
      anon_sym_PLUS,
    ACTIONS(115), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_SLASH,
    ACTIONS(121), 1,
      anon_sym_DOT_DOT,
    ACTIONS(123), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_AMP,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(133), 1,
      anon_sym_PIPE,
    ACTIONS(288), 1,
      anon_sym_or,
    ACTIONS(290), 1,
      anon_sym_and,
    ACTIONS(347), 1,
      anon_sym_do,
    STATE(115), 1,
      sym_comment,
    ACTIONS(111), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(129), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(117), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(131), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [8621] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(113), 1,
      anon_sym_PLUS,
    ACTIONS(115), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_SLASH,
    ACTIONS(121), 1,
      anon_sym_DOT_DOT,
    ACTIONS(123), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_AMP,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(133), 1,
      anon_sym_PIPE,
    ACTIONS(288), 1,
      anon_sym_or,
    ACTIONS(290), 1,
      anon_sym_and,
    ACTIONS(349), 1,
      anon_sym_RBRACK,
    STATE(116), 1,
      sym_comment,
    ACTIONS(111), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(129), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(117), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(131), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [8683] = 7,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(314), 1,
      anon_sym_COMMA,
    STATE(113), 1,
      aux_sym__att_name_list_repeat1,
    STATE(117), 1,
      sym_comment,
    ACTIONS(351), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(353), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8723] = 7,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(314), 1,
      anon_sym_COMMA,
    STATE(112), 1,
      aux_sym__att_name_list_repeat1,
    STATE(118), 1,
      sym_comment,
    ACTIONS(355), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(357), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8763] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(113), 1,
      anon_sym_PLUS,
    ACTIONS(115), 1,
      anon_sym_DASH,
    ACTIONS(119), 1,
      anon_sym_SLASH,
    ACTIONS(121), 1,
      anon_sym_DOT_DOT,
    ACTIONS(123), 1,
      anon_sym_CARET,
    ACTIONS(125), 1,
      anon_sym_AMP,
    ACTIONS(127), 1,
      anon_sym_TILDE,
    ACTIONS(133), 1,
      anon_sym_PIPE,
    ACTIONS(288), 1,
      anon_sym_or,
    ACTIONS(290), 1,
      anon_sym_and,
    ACTIONS(359), 1,
      anon_sym_then,
    STATE(119), 1,
      sym_comment,
    ACTIONS(111), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(129), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(117), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(131), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [8825] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(120), 1,
      sym_comment,
    ACTIONS(361), 6,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(363), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8860] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(121), 1,
      sym_comment,
    ACTIONS(365), 6,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(367), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8895] = 7,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(165), 1,
      anon_sym_COMMA,
    STATE(122), 1,
      sym_comment,
    STATE(123), 1,
      aux_sym__variable_assignment_explist_repeat1,
    ACTIONS(369), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(371), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8934] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(377), 1,
      anon_sym_COMMA,
    STATE(123), 2,
      sym_comment,
      aux_sym__variable_assignment_explist_repeat1,
    ACTIONS(373), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(375), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8971] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(384), 1,
      anon_sym_EQ,
    STATE(124), 1,
      sym_comment,
    ACTIONS(380), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(382), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [9007] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(125), 1,
      sym_comment,
    ACTIONS(386), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(388), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [9040] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(126), 1,
      sym_comment,
    ACTIONS(390), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(392), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [9073] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(127), 1,
      sym_comment,
    ACTIONS(394), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(396), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [9106] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(128), 1,
      sym_comment,
    ACTIONS(398), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(400), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [9139] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(129), 1,
      sym_comment,
    ACTIONS(402), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(404), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [9172] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(130), 1,
      sym_comment,
    ACTIONS(406), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(408), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [9205] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(131), 1,
      sym_comment,
    ACTIONS(410), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(412), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [9238] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(132), 1,
      sym_comment,
    ACTIONS(414), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(416), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [9271] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(133), 1,
      sym_comment,
    ACTIONS(418), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(420), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [9304] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(134), 1,
      sym_comment,
    ACTIONS(422), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(424), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [9337] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(135), 1,
      sym_comment,
    ACTIONS(426), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(428), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [9370] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(136), 1,
      sym_comment,
    ACTIONS(298), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(300), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [9403] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(137), 1,
      sym_comment,
    ACTIONS(430), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(432), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [9436] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(138), 1,
      sym_comment,
    ACTIONS(434), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(436), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [9469] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(139), 1,
      sym_comment,
    ACTIONS(438), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(440), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [9502] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(140), 1,
      sym_comment,
    ACTIONS(442), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(444), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [9535] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(141), 1,
      sym_comment,
    ACTIONS(446), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(448), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [9568] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(142), 1,
      sym_comment,
    ACTIONS(450), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(452), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [9601] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(143), 1,
      sym_comment,
    ACTIONS(454), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(456), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [9634] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(144), 1,
      sym_comment,
    ACTIONS(458), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(460), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [9667] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(145), 1,
      sym_comment,
    ACTIONS(462), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(464), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [9700] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(146), 1,
      sym_comment,
    ACTIONS(466), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(468), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [9733] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(147), 1,
      sym_comment,
    ACTIONS(470), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(472), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [9766] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(148), 1,
      sym_comment,
    ACTIONS(474), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(476), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [9799] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(149), 1,
      sym_comment,
    ACTIONS(478), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(480), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [9832] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(150), 1,
      sym_comment,
    ACTIONS(482), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(484), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [9865] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(151), 1,
      sym_comment,
    ACTIONS(486), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(488), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [9898] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(152), 1,
      sym_comment,
    ACTIONS(490), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(492), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [9931] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(153), 1,
      sym_comment,
    ACTIONS(494), 7,
      anon_sym_function,
      sym_nil,
      sym_false,
      sym_true,
      anon_sym_DASH,
      anon_sym_not,
      sym_identifier,
    ACTIONS(496), 11,
      sym__block_string_start,
      sym_number,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_vararg_expression,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_POUND,
  [9963] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(154), 1,
      sym_comment,
    ACTIONS(500), 3,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(498), 12,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_if,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [9992] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(155), 1,
      sym_comment,
    ACTIONS(504), 3,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(502), 12,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_if,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [10021] = 15,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(506), 1,
      anon_sym_DOT,
    ACTIONS(508), 1,
      anon_sym_COLON,
    ACTIONS(510), 1,
      anon_sym_DQUOTE,
    ACTIONS(512), 1,
      anon_sym_SQUOTE,
    ACTIONS(514), 1,
      anon_sym_LPAREN,
    ACTIONS(516), 1,
      anon_sym_LBRACK,
    ACTIONS(518), 1,
      anon_sym_LBRACE,
    ACTIONS(520), 1,
      sym__block_string_start,
    STATE(6), 1,
      sym_arguments,
    STATE(13), 1,
      sym__quote_string,
    STATE(14), 1,
      sym__block_string,
    STATE(156), 1,
      sym_comment,
    STATE(7), 2,
      sym_string,
      sym_table_constructor,
  [10068] = 7,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(522), 1,
      anon_sym_EQ,
    ACTIONS(524), 1,
      anon_sym_COMMA,
    STATE(157), 1,
      sym_comment,
    STATE(207), 1,
      aux_sym__variable_assignment_varlist_repeat1,
    ACTIONS(73), 8,
      sym__block_string_start,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
  [10097] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(286), 1,
      anon_sym_else,
    ACTIONS(526), 1,
      anon_sym_COMMA,
    STATE(158), 2,
      sym_comment,
      aux_sym__expression_list_repeat1,
    ACTIONS(284), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_do,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
      anon_sym_RPAREN,
  [10123] = 12,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(510), 1,
      anon_sym_DQUOTE,
    ACTIONS(512), 1,
      anon_sym_SQUOTE,
    ACTIONS(514), 1,
      anon_sym_LPAREN,
    ACTIONS(518), 1,
      anon_sym_LBRACE,
    ACTIONS(520), 1,
      sym__block_string_start,
    STATE(6), 1,
      sym_arguments,
    STATE(13), 1,
      sym__quote_string,
    STATE(14), 1,
      sym__block_string,
    STATE(159), 1,
      sym_comment,
    STATE(7), 2,
      sym_string,
      sym_table_constructor,
  [10161] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(160), 1,
      sym_comment,
    ACTIONS(529), 2,
      anon_sym_EQ,
      anon_sym_COMMA,
    ACTIONS(73), 8,
      sym__block_string_start,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
  [10185] = 10,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(531), 1,
      sym_identifier,
    STATE(156), 1,
      sym__prefix_expression,
    STATE(159), 1,
      sym_method_index_expression,
    STATE(160), 1,
      sym_variable,
    STATE(161), 1,
      sym_comment,
    STATE(4), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(163), 2,
      sym_function_call,
      sym_parenthesized_expression,
  [10218] = 7,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(294), 1,
      anon_sym_COMMA,
    ACTIONS(535), 1,
      anon_sym_else,
    STATE(158), 1,
      aux_sym__expression_list_repeat1,
    STATE(162), 1,
      sym_comment,
    ACTIONS(533), 6,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_do,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
  [10245] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(163), 1,
      sym_comment,
    ACTIONS(73), 8,
      sym__block_string_start,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
  [10265] = 9,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(147), 1,
      anon_sym_else,
    ACTIONS(537), 1,
      anon_sym_end,
    ACTIONS(539), 1,
      anon_sym_elseif,
    STATE(164), 1,
      sym_comment,
    STATE(167), 1,
      aux_sym_if_statement_repeat1,
    STATE(198), 1,
      sym_elseif_statement,
    STATE(220), 1,
      sym_else_statement,
  [10293] = 9,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(147), 1,
      anon_sym_else,
    ACTIONS(539), 1,
      anon_sym_elseif,
    ACTIONS(541), 1,
      anon_sym_end,
    STATE(165), 1,
      sym_comment,
    STATE(175), 1,
      aux_sym_if_statement_repeat1,
    STATE(198), 1,
      sym_elseif_statement,
    STATE(222), 1,
      sym_else_statement,
  [10321] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(545), 1,
      anon_sym_SEMI,
    ACTIONS(547), 1,
      anon_sym_else,
    STATE(166), 1,
      sym_comment,
    ACTIONS(543), 4,
      ts_builtin_sym_end,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
  [10343] = 9,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(147), 1,
      anon_sym_else,
    ACTIONS(539), 1,
      anon_sym_elseif,
    ACTIONS(549), 1,
      anon_sym_end,
    STATE(167), 1,
      sym_comment,
    STATE(175), 1,
      aux_sym_if_statement_repeat1,
    STATE(198), 1,
      sym_elseif_statement,
    STATE(216), 1,
      sym_else_statement,
  [10371] = 8,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(551), 1,
      sym_identifier,
    STATE(168), 1,
      sym_comment,
    STATE(193), 1,
      sym__function_name,
    STATE(200), 1,
      sym__function_name_prefix_expression,
    STATE(201), 1,
      sym__function_name_dot_index_expression,
    STATE(236), 1,
      sym__function_name_method_index_expression,
  [10396] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(169), 1,
      sym_comment,
    ACTIONS(553), 5,
      sym__block_string_start,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
  [10413] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(557), 1,
      anon_sym_else,
    STATE(170), 1,
      sym_comment,
    ACTIONS(555), 4,
      ts_builtin_sym_end,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
  [10432] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(547), 1,
      anon_sym_else,
    STATE(171), 1,
      sym_comment,
    ACTIONS(543), 4,
      ts_builtin_sym_end,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
  [10451] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(562), 1,
      anon_sym_RBRACE,
    STATE(66), 1,
      sym__field_sep,
    ACTIONS(559), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    STATE(172), 2,
      sym_comment,
      aux_sym__field_list_repeat1,
  [10472] = 7,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(274), 1,
      anon_sym_RBRACE,
    STATE(64), 1,
      sym__field_sep,
    STATE(172), 1,
      aux_sym__field_list_repeat1,
    STATE(173), 1,
      sym_comment,
    ACTIONS(564), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
  [10495] = 7,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(566), 1,
      anon_sym_RBRACE,
    STATE(62), 1,
      sym__field_sep,
    STATE(173), 1,
      aux_sym__field_list_repeat1,
    STATE(174), 1,
      sym_comment,
    ACTIONS(564), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
  [10518] = 7,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(568), 1,
      anon_sym_end,
    ACTIONS(570), 1,
      anon_sym_elseif,
    ACTIONS(573), 1,
      anon_sym_else,
    STATE(198), 1,
      sym_elseif_statement,
    STATE(175), 2,
      sym_comment,
      aux_sym_if_statement_repeat1,
  [10541] = 6,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(575), 1,
      anon_sym_SQUOTE,
    ACTIONS(579), 1,
      anon_sym_DASH_DASH,
    STATE(176), 1,
      sym_comment,
    STATE(180), 1,
      aux_sym__singlequote_string_content,
    ACTIONS(577), 2,
      aux_sym__singlequote_string_content_token1,
      sym_escape_sequence,
  [10561] = 7,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(581), 1,
      sym_identifier,
    ACTIONS(583), 1,
      sym_vararg_expression,
    ACTIONS(585), 1,
      anon_sym_RPAREN,
    STATE(177), 1,
      sym_comment,
    STATE(248), 1,
      sym__parameter_list,
  [10583] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(587), 1,
      anon_sym_COMMA,
    ACTIONS(590), 2,
      anon_sym_in,
      anon_sym_RPAREN,
    STATE(178), 2,
      sym_comment,
      aux_sym__name_list_repeat1,
  [10601] = 6,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(579), 1,
      anon_sym_DASH_DASH,
    ACTIONS(592), 1,
      anon_sym_SQUOTE,
    STATE(179), 1,
      sym_comment,
    STATE(180), 1,
      aux_sym__singlequote_string_content,
    ACTIONS(577), 2,
      aux_sym__singlequote_string_content_token1,
      sym_escape_sequence,
  [10621] = 5,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(579), 1,
      anon_sym_DASH_DASH,
    ACTIONS(594), 1,
      anon_sym_SQUOTE,
    ACTIONS(596), 2,
      aux_sym__singlequote_string_content_token1,
      sym_escape_sequence,
    STATE(180), 2,
      aux_sym__singlequote_string_content,
      sym_comment,
  [10639] = 5,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(579), 1,
      anon_sym_DASH_DASH,
    ACTIONS(599), 1,
      anon_sym_DQUOTE,
    ACTIONS(601), 2,
      aux_sym__doublequote_string_content_token1,
      sym_escape_sequence,
    STATE(181), 2,
      aux_sym__doublequote_string_content,
      sym_comment,
  [10657] = 7,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(604), 1,
      sym_identifier,
    ACTIONS(606), 1,
      anon_sym_function,
    STATE(124), 1,
      sym__att_name_list,
    STATE(145), 1,
      sym__local_variable_assignment,
    STATE(182), 1,
      sym_comment,
  [10679] = 6,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(579), 1,
      anon_sym_DASH_DASH,
    ACTIONS(592), 1,
      anon_sym_DQUOTE,
    STATE(181), 1,
      aux_sym__doublequote_string_content,
    STATE(183), 1,
      sym_comment,
    ACTIONS(608), 2,
      aux_sym__doublequote_string_content_token1,
      sym_escape_sequence,
  [10699] = 6,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(579), 1,
      anon_sym_DASH_DASH,
    ACTIONS(610), 1,
      anon_sym_DQUOTE,
    STATE(183), 1,
      aux_sym__doublequote_string_content,
    STATE(184), 1,
      sym_comment,
    ACTIONS(608), 2,
      aux_sym__doublequote_string_content_token1,
      sym_escape_sequence,
  [10719] = 6,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(579), 1,
      anon_sym_DASH_DASH,
    ACTIONS(612), 1,
      anon_sym_DQUOTE,
    STATE(185), 1,
      sym_comment,
    STATE(192), 1,
      aux_sym__doublequote_string_content,
    ACTIONS(608), 2,
      aux_sym__doublequote_string_content_token1,
      sym_escape_sequence,
  [10739] = 7,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(614), 1,
      anon_sym_EQ,
    ACTIONS(616), 1,
      anon_sym_COMMA,
    ACTIONS(618), 1,
      anon_sym_in,
    STATE(186), 1,
      sym_comment,
    STATE(209), 1,
      aux_sym__name_list_repeat1,
  [10761] = 6,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(579), 1,
      anon_sym_DASH_DASH,
    ACTIONS(612), 1,
      anon_sym_SQUOTE,
    STATE(176), 1,
      aux_sym__singlequote_string_content,
    STATE(187), 1,
      sym_comment,
    ACTIONS(577), 2,
      aux_sym__singlequote_string_content_token1,
      sym_escape_sequence,
  [10781] = 6,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(579), 1,
      anon_sym_DASH_DASH,
    ACTIONS(610), 1,
      anon_sym_SQUOTE,
    STATE(179), 1,
      aux_sym__singlequote_string_content,
    STATE(188), 1,
      sym_comment,
    ACTIONS(577), 2,
      aux_sym__singlequote_string_content_token1,
      sym_escape_sequence,
  [10801] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(620), 1,
      sym_identifier,
    STATE(189), 1,
      sym_comment,
    STATE(242), 1,
      sym__name_list,
    STATE(244), 2,
      sym_for_generic_clause,
      sym_for_numeric_clause,
  [10821] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(624), 1,
      anon_sym_else,
    STATE(190), 1,
      sym_comment,
    ACTIONS(622), 3,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
  [10839] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(169), 1,
      anon_sym_else,
    STATE(191), 1,
      sym_comment,
    ACTIONS(626), 3,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
  [10857] = 6,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(575), 1,
      anon_sym_DQUOTE,
    ACTIONS(579), 1,
      anon_sym_DASH_DASH,
    STATE(181), 1,
      aux_sym__doublequote_string_content,
    STATE(192), 1,
      sym_comment,
    ACTIONS(608), 2,
      aux_sym__doublequote_string_content_token1,
      sym_escape_sequence,
  [10877] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(628), 1,
      anon_sym_LPAREN,
    STATE(52), 1,
      sym_parameters,
    STATE(125), 1,
      sym__function_body,
    STATE(193), 1,
      sym_comment,
  [10896] = 5,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(579), 1,
      anon_sym_DASH_DASH,
    ACTIONS(630), 1,
      anon_sym_DQUOTE,
    STATE(194), 1,
      sym_comment,
    ACTIONS(632), 2,
      aux_sym__doublequote_string_content_token1,
      sym_escape_sequence,
  [10913] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(634), 1,
      anon_sym_COMMA,
    ACTIONS(636), 1,
      anon_sym_RPAREN,
    STATE(195), 1,
      sym_comment,
    STATE(206), 1,
      aux_sym__name_list_repeat1,
  [10932] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(628), 1,
      anon_sym_LPAREN,
    STATE(32), 1,
      sym__function_body,
    STATE(52), 1,
      sym_parameters,
    STATE(196), 1,
      sym_comment,
  [10951] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(640), 1,
      anon_sym_else,
    STATE(197), 1,
      sym_comment,
    ACTIONS(638), 2,
      anon_sym_end,
      anon_sym_elseif,
  [10968] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(644), 1,
      anon_sym_else,
    STATE(198), 1,
      sym_comment,
    ACTIONS(642), 2,
      anon_sym_end,
      anon_sym_elseif,
  [10985] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(199), 1,
      sym_comment,
    ACTIONS(646), 3,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
  [11000] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(648), 1,
      anon_sym_DOT,
    ACTIONS(650), 1,
      anon_sym_COLON,
    ACTIONS(652), 1,
      anon_sym_LPAREN,
    STATE(200), 1,
      sym_comment,
  [11019] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(201), 1,
      sym_comment,
    ACTIONS(654), 3,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
  [11034] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(202), 1,
      sym_comment,
    ACTIONS(656), 3,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_RPAREN,
  [11049] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(294), 1,
      anon_sym_COMMA,
    ACTIONS(658), 1,
      anon_sym_RPAREN,
    STATE(158), 1,
      aux_sym__expression_list_repeat1,
    STATE(203), 1,
      sym_comment,
  [11068] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(628), 1,
      anon_sym_LPAREN,
    STATE(52), 1,
      sym_parameters,
    STATE(149), 1,
      sym__function_body,
    STATE(204), 1,
      sym_comment,
  [11087] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(205), 1,
      sym_comment,
    ACTIONS(660), 3,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
  [11102] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(662), 1,
      anon_sym_COMMA,
    ACTIONS(664), 1,
      anon_sym_RPAREN,
    STATE(178), 1,
      aux_sym__name_list_repeat1,
    STATE(206), 1,
      sym_comment,
  [11121] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(524), 1,
      anon_sym_COMMA,
    ACTIONS(666), 1,
      anon_sym_EQ,
    STATE(207), 1,
      sym_comment,
    STATE(208), 1,
      aux_sym__variable_assignment_varlist_repeat1,
  [11140] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(668), 1,
      anon_sym_EQ,
    ACTIONS(670), 1,
      anon_sym_COMMA,
    STATE(208), 2,
      sym_comment,
      aux_sym__variable_assignment_varlist_repeat1,
  [11157] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(616), 1,
      anon_sym_COMMA,
    ACTIONS(673), 1,
      anon_sym_in,
    STATE(178), 1,
      aux_sym__name_list_repeat1,
    STATE(209), 1,
      sym_comment,
  [11176] = 5,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(579), 1,
      anon_sym_DASH_DASH,
    ACTIONS(675), 1,
      anon_sym_SQUOTE,
    STATE(210), 1,
      sym_comment,
    ACTIONS(677), 2,
      aux_sym__singlequote_string_content_token1,
      sym_escape_sequence,
  [11193] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(211), 1,
      sym_comment,
    ACTIONS(562), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [11208] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(679), 1,
      sym_identifier,
    ACTIONS(681), 1,
      sym_vararg_expression,
    STATE(212), 1,
      sym_comment,
  [11224] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(683), 1,
      sym__block_comment_content,
    ACTIONS(685), 1,
      sym__block_comment_end,
    STATE(213), 1,
      sym_comment,
  [11240] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(679), 1,
      sym_identifier,
    ACTIONS(687), 1,
      sym_vararg_expression,
    STATE(214), 1,
      sym_comment,
  [11256] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(689), 1,
      ts_builtin_sym_end,
    STATE(215), 1,
      sym_comment,
  [11269] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(691), 1,
      anon_sym_end,
    STATE(216), 1,
      sym_comment,
  [11282] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(693), 1,
      sym_identifier,
    STATE(217), 1,
      sym_comment,
  [11295] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(695), 1,
      sym_identifier,
    STATE(218), 1,
      sym_comment,
  [11308] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(697), 1,
      anon_sym_end,
    STATE(219), 1,
      sym_comment,
  [11321] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(699), 1,
      anon_sym_end,
    STATE(220), 1,
      sym_comment,
  [11334] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(701), 1,
      sym_identifier,
    STATE(221), 1,
      sym_comment,
  [11347] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(703), 1,
      anon_sym_end,
    STATE(222), 1,
      sym_comment,
  [11360] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(679), 1,
      sym_identifier,
    STATE(223), 1,
      sym_comment,
  [11373] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(705), 1,
      anon_sym_RBRACE,
    STATE(224), 1,
      sym_comment,
  [11386] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(707), 1,
      anon_sym_GT,
    STATE(225), 1,
      sym_comment,
  [11399] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(709), 1,
      anon_sym_do,
    STATE(226), 1,
      sym_comment,
  [11412] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(711), 1,
      sym__block_string_end,
    STATE(227), 1,
      sym_comment,
  [11425] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(713), 1,
      anon_sym_EQ,
    STATE(228), 1,
      sym_comment,
  [11438] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(715), 1,
      sym__block_string_content,
    STATE(229), 1,
      sym_comment,
  [11451] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(717), 1,
      anon_sym_end,
    STATE(230), 1,
      sym_comment,
  [11464] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(719), 1,
      anon_sym_RPAREN,
    STATE(231), 1,
      sym_comment,
  [11477] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(721), 1,
      anon_sym_RPAREN,
    STATE(232), 1,
      sym_comment,
  [11490] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(723), 1,
      sym_identifier,
    STATE(233), 1,
      sym_comment,
  [11503] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(725), 1,
      sym_identifier,
    STATE(234), 1,
      sym_comment,
  [11516] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(727), 1,
      sym_identifier,
    STATE(235), 1,
      sym_comment,
  [11529] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(729), 1,
      anon_sym_LPAREN,
    STATE(236), 1,
      sym_comment,
  [11542] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(731), 1,
      anon_sym_end,
    STATE(237), 1,
      sym_comment,
  [11555] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(733), 1,
      anon_sym_LPAREN,
    STATE(238), 1,
      sym_comment,
  [11568] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(735), 1,
      anon_sym_end,
    STATE(239), 1,
      sym_comment,
  [11581] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(737), 1,
      sym_identifier,
    STATE(240), 1,
      sym_comment,
  [11594] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(739), 1,
      anon_sym_RPAREN,
    STATE(241), 1,
      sym_comment,
  [11607] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(741), 1,
      anon_sym_in,
    STATE(242), 1,
      sym_comment,
  [11620] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(743), 1,
      anon_sym_end,
    STATE(243), 1,
      sym_comment,
  [11633] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(745), 1,
      anon_sym_do,
    STATE(244), 1,
      sym_comment,
  [11646] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(747), 1,
      anon_sym_until,
    STATE(245), 1,
      sym_comment,
  [11659] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(749), 1,
      anon_sym_end,
    STATE(246), 1,
      sym_comment,
  [11672] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(751), 1,
      anon_sym_COLON_COLON,
    STATE(247), 1,
      sym_comment,
  [11685] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(753), 1,
      anon_sym_RPAREN,
    STATE(248), 1,
      sym_comment,
  [11698] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(755), 1,
      sym__block_string_content,
    STATE(249), 1,
      sym_comment,
  [11711] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(242), 1,
      ts_builtin_sym_end,
    STATE(250), 1,
      sym_comment,
  [11724] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(757), 1,
      anon_sym_RBRACE,
    STATE(251), 1,
      sym_comment,
  [11737] = 4,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(579), 1,
      anon_sym_DASH_DASH,
    ACTIONS(759), 1,
      aux_sym_comment_token1,
    STATE(252), 1,
      sym_comment,
  [11750] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(761), 1,
      sym__block_comment_end,
    STATE(253), 1,
      sym_comment,
  [11763] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(763), 1,
      anon_sym_EQ,
    STATE(254), 1,
      sym_comment,
  [11776] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(240), 1,
      ts_builtin_sym_end,
    STATE(255), 1,
      sym_comment,
  [11789] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(765), 1,
      ts_builtin_sym_end,
    STATE(256), 1,
      sym_comment,
  [11802] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(767), 1,
      sym_identifier,
    STATE(257), 1,
      sym_comment,
  [11815] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(769), 1,
      sym__block_string_end,
    STATE(258), 1,
      sym_comment,
  [11828] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(771), 1,
      sym_identifier,
    STATE(259), 1,
      sym_comment,
  [11841] = 1,
    ACTIONS(773), 1,
      ts_builtin_sym_end,
  [11845] = 1,
    ACTIONS(775), 1,
      ts_builtin_sym_end,
  [11849] = 1,
    ACTIONS(777), 1,
      ts_builtin_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 67,
  [SMALL_STATE(4)] = 134,
  [SMALL_STATE(5)] = 201,
  [SMALL_STATE(6)] = 267,
  [SMALL_STATE(7)] = 333,
  [SMALL_STATE(8)] = 399,
  [SMALL_STATE(9)] = 465,
  [SMALL_STATE(10)] = 535,
  [SMALL_STATE(11)] = 601,
  [SMALL_STATE(12)] = 667,
  [SMALL_STATE(13)] = 733,
  [SMALL_STATE(14)] = 799,
  [SMALL_STATE(15)] = 865,
  [SMALL_STATE(16)] = 931,
  [SMALL_STATE(17)] = 997,
  [SMALL_STATE(18)] = 1063,
  [SMALL_STATE(19)] = 1129,
  [SMALL_STATE(20)] = 1188,
  [SMALL_STATE(21)] = 1247,
  [SMALL_STATE(22)] = 1320,
  [SMALL_STATE(23)] = 1395,
  [SMALL_STATE(24)] = 1472,
  [SMALL_STATE(25)] = 1555,
  [SMALL_STATE(26)] = 1640,
  [SMALL_STATE(27)] = 1719,
  [SMALL_STATE(28)] = 1778,
  [SMALL_STATE(29)] = 1837,
  [SMALL_STATE(30)] = 1896,
  [SMALL_STATE(31)] = 1955,
  [SMALL_STATE(32)] = 2082,
  [SMALL_STATE(33)] = 2141,
  [SMALL_STATE(34)] = 2206,
  [SMALL_STATE(35)] = 2267,
  [SMALL_STATE(36)] = 2338,
  [SMALL_STATE(37)] = 2399,
  [SMALL_STATE(38)] = 2458,
  [SMALL_STATE(39)] = 2517,
  [SMALL_STATE(40)] = 2576,
  [SMALL_STATE(41)] = 2637,
  [SMALL_STATE(42)] = 2696,
  [SMALL_STATE(43)] = 2767,
  [SMALL_STATE(44)] = 2855,
  [SMALL_STATE(45)] = 2967,
  [SMALL_STATE(46)] = 3081,
  [SMALL_STATE(47)] = 3189,
  [SMALL_STATE(48)] = 3272,
  [SMALL_STATE(49)] = 3384,
  [SMALL_STATE(50)] = 3496,
  [SMALL_STATE(51)] = 3578,
  [SMALL_STATE(52)] = 3690,
  [SMALL_STATE(53)] = 3802,
  [SMALL_STATE(54)] = 3914,
  [SMALL_STATE(55)] = 3996,
  [SMALL_STATE(56)] = 4108,
  [SMALL_STATE(57)] = 4217,
  [SMALL_STATE(58)] = 4326,
  [SMALL_STATE(59)] = 4435,
  [SMALL_STATE(60)] = 4526,
  [SMALL_STATE(61)] = 4617,
  [SMALL_STATE(62)] = 4708,
  [SMALL_STATE(63)] = 4796,
  [SMALL_STATE(64)] = 4884,
  [SMALL_STATE(65)] = 4972,
  [SMALL_STATE(66)] = 5021,
  [SMALL_STATE(67)] = 5106,
  [SMALL_STATE(68)] = 5188,
  [SMALL_STATE(69)] = 5270,
  [SMALL_STATE(70)] = 5352,
  [SMALL_STATE(71)] = 5434,
  [SMALL_STATE(72)] = 5513,
  [SMALL_STATE(73)] = 5592,
  [SMALL_STATE(74)] = 5671,
  [SMALL_STATE(75)] = 5750,
  [SMALL_STATE(76)] = 5829,
  [SMALL_STATE(77)] = 5908,
  [SMALL_STATE(78)] = 5987,
  [SMALL_STATE(79)] = 6066,
  [SMALL_STATE(80)] = 6145,
  [SMALL_STATE(81)] = 6224,
  [SMALL_STATE(82)] = 6303,
  [SMALL_STATE(83)] = 6382,
  [SMALL_STATE(84)] = 6461,
  [SMALL_STATE(85)] = 6540,
  [SMALL_STATE(86)] = 6619,
  [SMALL_STATE(87)] = 6698,
  [SMALL_STATE(88)] = 6777,
  [SMALL_STATE(89)] = 6856,
  [SMALL_STATE(90)] = 6935,
  [SMALL_STATE(91)] = 7014,
  [SMALL_STATE(92)] = 7093,
  [SMALL_STATE(93)] = 7172,
  [SMALL_STATE(94)] = 7251,
  [SMALL_STATE(95)] = 7330,
  [SMALL_STATE(96)] = 7409,
  [SMALL_STATE(97)] = 7488,
  [SMALL_STATE(98)] = 7567,
  [SMALL_STATE(99)] = 7639,
  [SMALL_STATE(100)] = 7715,
  [SMALL_STATE(101)] = 7759,
  [SMALL_STATE(102)] = 7823,
  [SMALL_STATE(103)] = 7887,
  [SMALL_STATE(104)] = 7955,
  [SMALL_STATE(105)] = 8019,
  [SMALL_STATE(106)] = 8065,
  [SMALL_STATE(107)] = 8130,
  [SMALL_STATE(108)] = 8171,
  [SMALL_STATE(109)] = 8233,
  [SMALL_STATE(110)] = 8295,
  [SMALL_STATE(111)] = 8357,
  [SMALL_STATE(112)] = 8419,
  [SMALL_STATE(113)] = 8459,
  [SMALL_STATE(114)] = 8497,
  [SMALL_STATE(115)] = 8559,
  [SMALL_STATE(116)] = 8621,
  [SMALL_STATE(117)] = 8683,
  [SMALL_STATE(118)] = 8723,
  [SMALL_STATE(119)] = 8763,
  [SMALL_STATE(120)] = 8825,
  [SMALL_STATE(121)] = 8860,
  [SMALL_STATE(122)] = 8895,
  [SMALL_STATE(123)] = 8934,
  [SMALL_STATE(124)] = 8971,
  [SMALL_STATE(125)] = 9007,
  [SMALL_STATE(126)] = 9040,
  [SMALL_STATE(127)] = 9073,
  [SMALL_STATE(128)] = 9106,
  [SMALL_STATE(129)] = 9139,
  [SMALL_STATE(130)] = 9172,
  [SMALL_STATE(131)] = 9205,
  [SMALL_STATE(132)] = 9238,
  [SMALL_STATE(133)] = 9271,
  [SMALL_STATE(134)] = 9304,
  [SMALL_STATE(135)] = 9337,
  [SMALL_STATE(136)] = 9370,
  [SMALL_STATE(137)] = 9403,
  [SMALL_STATE(138)] = 9436,
  [SMALL_STATE(139)] = 9469,
  [SMALL_STATE(140)] = 9502,
  [SMALL_STATE(141)] = 9535,
  [SMALL_STATE(142)] = 9568,
  [SMALL_STATE(143)] = 9601,
  [SMALL_STATE(144)] = 9634,
  [SMALL_STATE(145)] = 9667,
  [SMALL_STATE(146)] = 9700,
  [SMALL_STATE(147)] = 9733,
  [SMALL_STATE(148)] = 9766,
  [SMALL_STATE(149)] = 9799,
  [SMALL_STATE(150)] = 9832,
  [SMALL_STATE(151)] = 9865,
  [SMALL_STATE(152)] = 9898,
  [SMALL_STATE(153)] = 9931,
  [SMALL_STATE(154)] = 9963,
  [SMALL_STATE(155)] = 9992,
  [SMALL_STATE(156)] = 10021,
  [SMALL_STATE(157)] = 10068,
  [SMALL_STATE(158)] = 10097,
  [SMALL_STATE(159)] = 10123,
  [SMALL_STATE(160)] = 10161,
  [SMALL_STATE(161)] = 10185,
  [SMALL_STATE(162)] = 10218,
  [SMALL_STATE(163)] = 10245,
  [SMALL_STATE(164)] = 10265,
  [SMALL_STATE(165)] = 10293,
  [SMALL_STATE(166)] = 10321,
  [SMALL_STATE(167)] = 10343,
  [SMALL_STATE(168)] = 10371,
  [SMALL_STATE(169)] = 10396,
  [SMALL_STATE(170)] = 10413,
  [SMALL_STATE(171)] = 10432,
  [SMALL_STATE(172)] = 10451,
  [SMALL_STATE(173)] = 10472,
  [SMALL_STATE(174)] = 10495,
  [SMALL_STATE(175)] = 10518,
  [SMALL_STATE(176)] = 10541,
  [SMALL_STATE(177)] = 10561,
  [SMALL_STATE(178)] = 10583,
  [SMALL_STATE(179)] = 10601,
  [SMALL_STATE(180)] = 10621,
  [SMALL_STATE(181)] = 10639,
  [SMALL_STATE(182)] = 10657,
  [SMALL_STATE(183)] = 10679,
  [SMALL_STATE(184)] = 10699,
  [SMALL_STATE(185)] = 10719,
  [SMALL_STATE(186)] = 10739,
  [SMALL_STATE(187)] = 10761,
  [SMALL_STATE(188)] = 10781,
  [SMALL_STATE(189)] = 10801,
  [SMALL_STATE(190)] = 10821,
  [SMALL_STATE(191)] = 10839,
  [SMALL_STATE(192)] = 10857,
  [SMALL_STATE(193)] = 10877,
  [SMALL_STATE(194)] = 10896,
  [SMALL_STATE(195)] = 10913,
  [SMALL_STATE(196)] = 10932,
  [SMALL_STATE(197)] = 10951,
  [SMALL_STATE(198)] = 10968,
  [SMALL_STATE(199)] = 10985,
  [SMALL_STATE(200)] = 11000,
  [SMALL_STATE(201)] = 11019,
  [SMALL_STATE(202)] = 11034,
  [SMALL_STATE(203)] = 11049,
  [SMALL_STATE(204)] = 11068,
  [SMALL_STATE(205)] = 11087,
  [SMALL_STATE(206)] = 11102,
  [SMALL_STATE(207)] = 11121,
  [SMALL_STATE(208)] = 11140,
  [SMALL_STATE(209)] = 11157,
  [SMALL_STATE(210)] = 11176,
  [SMALL_STATE(211)] = 11193,
  [SMALL_STATE(212)] = 11208,
  [SMALL_STATE(213)] = 11224,
  [SMALL_STATE(214)] = 11240,
  [SMALL_STATE(215)] = 11256,
  [SMALL_STATE(216)] = 11269,
  [SMALL_STATE(217)] = 11282,
  [SMALL_STATE(218)] = 11295,
  [SMALL_STATE(219)] = 11308,
  [SMALL_STATE(220)] = 11321,
  [SMALL_STATE(221)] = 11334,
  [SMALL_STATE(222)] = 11347,
  [SMALL_STATE(223)] = 11360,
  [SMALL_STATE(224)] = 11373,
  [SMALL_STATE(225)] = 11386,
  [SMALL_STATE(226)] = 11399,
  [SMALL_STATE(227)] = 11412,
  [SMALL_STATE(228)] = 11425,
  [SMALL_STATE(229)] = 11438,
  [SMALL_STATE(230)] = 11451,
  [SMALL_STATE(231)] = 11464,
  [SMALL_STATE(232)] = 11477,
  [SMALL_STATE(233)] = 11490,
  [SMALL_STATE(234)] = 11503,
  [SMALL_STATE(235)] = 11516,
  [SMALL_STATE(236)] = 11529,
  [SMALL_STATE(237)] = 11542,
  [SMALL_STATE(238)] = 11555,
  [SMALL_STATE(239)] = 11568,
  [SMALL_STATE(240)] = 11581,
  [SMALL_STATE(241)] = 11594,
  [SMALL_STATE(242)] = 11607,
  [SMALL_STATE(243)] = 11620,
  [SMALL_STATE(244)] = 11633,
  [SMALL_STATE(245)] = 11646,
  [SMALL_STATE(246)] = 11659,
  [SMALL_STATE(247)] = 11672,
  [SMALL_STATE(248)] = 11685,
  [SMALL_STATE(249)] = 11698,
  [SMALL_STATE(250)] = 11711,
  [SMALL_STATE(251)] = 11724,
  [SMALL_STATE(252)] = 11737,
  [SMALL_STATE(253)] = 11750,
  [SMALL_STATE(254)] = 11763,
  [SMALL_STATE(255)] = 11776,
  [SMALL_STATE(256)] = 11789,
  [SMALL_STATE(257)] = 11802,
  [SMALL_STATE(258)] = 11815,
  [SMALL_STATE(259)] = 11828,
  [SMALL_STATE(260)] = 11841,
  [SMALL_STATE(261)] = 11845,
  [SMALL_STATE(262)] = 11849,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [7] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_chunk, 0),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(4),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(63),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(136),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(257),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(48),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(87),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(55),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(92),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(189),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(168),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(182),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [39] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bracket_index_expression, 4, .production_id = 23),
  [41] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bracket_index_expression, 4, .production_id = 23),
  [43] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dot_index_expression, 3, .production_id = 23),
  [45] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dot_index_expression, 3, .production_id = 23),
  [47] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable, 1),
  [49] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable, 1),
  [51] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table_constructor, 3),
  [53] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table_constructor, 3),
  [55] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_call, 2, .production_id = 11),
  [57] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_call, 2, .production_id = 11),
  [59] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 1),
  [61] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 1),
  [63] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 4),
  [65] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 4),
  [67] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression, 1),
  [69] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expression, 1),
  [71] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__prefix_expression, 1),
  [73] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__prefix_expression, 1),
  [75] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_expression, 3),
  [77] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_expression, 3),
  [79] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 3),
  [81] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 3),
  [83] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 2),
  [85] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 2),
  [87] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 1, .production_id = 7),
  [89] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 1, .production_id = 7),
  [91] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__quote_string, 2, .production_id = 5),
  [93] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__quote_string, 2, .production_id = 5),
  [95] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table_constructor, 2),
  [97] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table_constructor, 2),
  [99] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__block_string, 3, .production_id = 13),
  [101] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__block_string, 3, .production_id = 13),
  [103] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__quote_string, 3, .production_id = 28),
  [105] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__quote_string, 3, .production_id = 28),
  [107] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expression, 3, .production_id = 29),
  [109] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expression, 3, .production_id = 29),
  [111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [115] = {.entry = {.count = 1, .reusable = false}}, SHIFT(80),
  [117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [119] = {.entry = {.count = 1, .reusable = false}}, SHIFT(79),
  [121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [127] = {.entry = {.count = 1, .reusable = false}}, SHIFT(71),
  [129] = {.entry = {.count = 1, .reusable = false}}, SHIFT(89),
  [131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [135] = {.entry = {.count = 1, .reusable = false}}, SHIFT(84),
  [137] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_body, 2, .production_id = 27),
  [139] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__function_body, 2, .production_id = 27),
  [141] = {.entry = {.count = 1, .reusable = false}}, SHIFT(59),
  [143] = {.entry = {.count = 1, .reusable = false}}, SHIFT(151),
  [145] = {.entry = {.count = 1, .reusable = false}}, SHIFT(91),
  [147] = {.entry = {.count = 1, .reusable = false}}, SHIFT(53),
  [149] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_definition, 2, .production_id = 14),
  [151] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_definition, 2, .production_id = 14),
  [153] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_body, 3, .production_id = 41),
  [155] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__function_body, 3, .production_id = 41),
  [157] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 2, .production_id = 16),
  [159] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 2, .production_id = 16),
  [161] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__variable_assignment_explist, 1, .production_id = 15),
  [163] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__variable_assignment_explist, 1, .production_id = 15),
  [165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [167] = {.entry = {.count = 1, .reusable = false}}, SHIFT(88),
  [169] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__block, 1),
  [171] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_elseif_statement, 3, .production_id = 30),
  [173] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_chunk_repeat1, 2),
  [175] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(4),
  [178] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2),
  [180] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(131),
  [183] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(259),
  [186] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(136),
  [189] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(257),
  [192] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(48),
  [195] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(87),
  [198] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(55),
  [201] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(92),
  [204] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(189),
  [207] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(168),
  [210] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(182),
  [213] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(93),
  [216] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__variable_assignment_explist_repeat1, 2, .production_id = 50),
  [218] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__variable_assignment_explist_repeat1, 2, .production_id = 50),
  [220] = {.entry = {.count = 1, .reusable = false}}, SHIFT(133),
  [222] = {.entry = {.count = 1, .reusable = false}}, SHIFT(150),
  [224] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_repeat_statement, 3, .production_id = 18),
  [226] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_repeat_statement, 3, .production_id = 18),
  [228] = {.entry = {.count = 1, .reusable = false}}, SHIFT(148),
  [230] = {.entry = {.count = 1, .reusable = false}}, SHIFT(30),
  [232] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_statement, 1),
  [234] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_repeat_statement, 4, .production_id = 31),
  [236] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_repeat_statement, 4, .production_id = 31),
  [238] = {.entry = {.count = 1, .reusable = false}}, SHIFT(95),
  [240] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_chunk, 1),
  [242] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_chunk, 2),
  [244] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [246] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_statement, 1),
  [248] = {.entry = {.count = 1, .reusable = false}}, SHIFT(196),
  [250] = {.entry = {.count = 1, .reusable = false}}, SHIFT(20),
  [252] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [254] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [256] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [258] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [260] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [262] = {.entry = {.count = 1, .reusable = false}}, SHIFT(76),
  [264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [266] = {.entry = {.count = 1, .reusable = false}}, SHIFT(65),
  [268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [272] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [274] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__field_list, 2),
  [276] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 1),
  [278] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__field_list, 3),
  [280] = {.entry = {.count = 1, .reusable = false}}, SHIFT(77),
  [282] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [284] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__expression_list_repeat1, 2),
  [286] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__expression_list_repeat1, 2),
  [288] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [290] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [292] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression_list, 1),
  [294] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [296] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression_list, 1),
  [298] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 1),
  [300] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 1),
  [302] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 3, .production_id = 42),
  [304] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 5, .production_id = 56),
  [306] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [308] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 1, .production_id = 15),
  [310] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__att_name_list, 1, .production_id = 4),
  [312] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__att_name_list, 1, .production_id = 4),
  [314] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [316] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [318] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [320] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_numeric_clause, 5, .production_id = 55),
  [322] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__att_name_list_repeat1, 2, .production_id = 25),
  [324] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__att_name_list_repeat1, 2, .production_id = 25),
  [326] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [328] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_numeric_clause, 7, .production_id = 58),
  [330] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [334] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__att_name_list, 3, .production_id = 36),
  [336] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__att_name_list, 3, .production_id = 36),
  [338] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__att_name_list_repeat1, 2, .production_id = 37),
  [340] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__att_name_list_repeat1, 2, .production_id = 37),
  [342] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__att_name_list_repeat1, 2, .production_id = 37), SHIFT_REPEAT(218),
  [345] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [347] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [349] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [351] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__att_name_list, 2, .production_id = 21),
  [353] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__att_name_list, 2, .production_id = 21),
  [355] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__att_name_list, 2, .production_id = 20),
  [357] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__att_name_list, 2, .production_id = 20),
  [359] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [361] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__attrib, 3),
  [363] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__attrib, 3),
  [365] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__att_name_list_repeat1, 3, .production_id = 49),
  [367] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__att_name_list_repeat1, 3, .production_id = 49),
  [369] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__variable_assignment_explist, 2, .production_id = 39),
  [371] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__variable_assignment_explist, 2, .production_id = 39),
  [373] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__variable_assignment_explist_repeat1, 2, .production_id = 51),
  [375] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__variable_assignment_explist_repeat1, 2, .production_id = 51),
  [377] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__variable_assignment_explist_repeat1, 2, .production_id = 51), SHIFT_REPEAT(75),
  [380] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_declaration, 2, .production_id = 10),
  [382] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_declaration, 2, .production_id = 10),
  [384] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [386] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_declaration, 3, .production_id = 19),
  [388] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_declaration, 3, .production_id = 19),
  [390] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_statement, 5, .production_id = 48),
  [392] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_statement, 5, .production_id = 48),
  [394] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 5, .production_id = 46),
  [396] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 5, .production_id = 46),
  [398] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 5, .production_id = 45),
  [400] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 5, .production_id = 45),
  [402] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 7, .production_id = 57),
  [404] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 7, .production_id = 57),
  [406] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 5, .production_id = 44),
  [408] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 5, .production_id = 44),
  [410] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_empty_statement, 1),
  [412] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_empty_statement, 1),
  [414] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_statement, 5, .production_id = 43),
  [416] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_statement, 5, .production_id = 43),
  [418] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_do_statement, 2),
  [420] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_do_statement, 2),
  [422] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_chunk_repeat1, 1),
  [424] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 1),
  [426] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_do_statement, 3, .production_id = 17),
  [428] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_do_statement, 3, .production_id = 17),
  [430] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment_statement, 3, .production_id = 22),
  [432] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assignment_statement, 3, .production_id = 22),
  [434] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_label_statement, 3),
  [436] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_label_statement, 3),
  [438] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 6, .production_id = 54),
  [440] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 6, .production_id = 54),
  [442] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__local_variable_assignment, 3, .production_id = 38),
  [444] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__local_variable_assignment, 3, .production_id = 38),
  [446] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 6, .production_id = 53),
  [448] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 6, .production_id = 53),
  [450] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 1, .production_id = 1),
  [452] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 1, .production_id = 1),
  [454] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 6, .production_id = 52),
  [456] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 6, .production_id = 52),
  [458] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_declaration, 1),
  [460] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_declaration, 1),
  [462] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_declaration, 2),
  [464] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_declaration, 2),
  [466] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_declaration, 1, .production_id = 2),
  [468] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_declaration, 1, .production_id = 2),
  [470] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_declaration, 1, .production_id = 3),
  [472] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_declaration, 1, .production_id = 3),
  [474] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_statement, 4, .production_id = 30),
  [476] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_statement, 4, .production_id = 30),
  [478] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__local_function_declaration, 4, .production_id = 35),
  [480] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__local_function_declaration, 4, .production_id = 35),
  [482] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_statement, 4, .production_id = 33),
  [484] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_statement, 4, .production_id = 33),
  [486] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 4, .production_id = 30),
  [488] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 4, .production_id = 30),
  [490] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_goto_statement, 2),
  [492] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_goto_statement, 2),
  [494] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__field_sep, 1),
  [496] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__field_sep, 1),
  [498] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameters, 2),
  [500] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters, 2),
  [502] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameters, 3, .production_id = 40),
  [504] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters, 3, .production_id = 40),
  [506] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [508] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [510] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [512] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [514] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [516] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [518] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [520] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [522] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__variable_assignment_varlist, 1, .production_id = 4),
  [524] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [526] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__expression_list_repeat1, 2), SHIFT_REPEAT(90),
  [529] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__variable_assignment_varlist_repeat1, 2, .production_id = 25),
  [531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [533] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression_list, 2),
  [535] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression_list, 2),
  [537] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [539] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [541] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [543] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 2),
  [545] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [547] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_statement, 2),
  [549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [551] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [553] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_index_expression, 3, .production_id = 24),
  [555] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 3),
  [557] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_statement, 3),
  [559] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__field_list_repeat1, 2), SHIFT_REPEAT(153),
  [562] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__field_list_repeat1, 2),
  [564] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [566] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__field_list, 1),
  [568] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 2, .production_id = 47),
  [570] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 2, .production_id = 47), SHIFT_REPEAT(91),
  [573] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_if_statement_repeat1, 2, .production_id = 47),
  [575] = {.entry = {.count = 1, .reusable = false}}, SHIFT(18),
  [577] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [579] = {.entry = {.count = 1, .reusable = false}}, SHIFT(252),
  [581] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [583] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [585] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [587] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__name_list_repeat1, 2, .production_id = 26), SHIFT_REPEAT(223),
  [590] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__name_list_repeat1, 2, .production_id = 26),
  [592] = {.entry = {.count = 1, .reusable = false}}, SHIFT(29),
  [594] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__singlequote_string_content, 2),
  [596] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__singlequote_string_content, 2), SHIFT_REPEAT(210),
  [599] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__doublequote_string_content, 2),
  [601] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__doublequote_string_content, 2), SHIFT_REPEAT(194),
  [604] = {.entry = {.count = 1, .reusable = false}}, SHIFT(105),
  [606] = {.entry = {.count = 1, .reusable = false}}, SHIFT(235),
  [608] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [610] = {.entry = {.count = 1, .reusable = false}}, SHIFT(39),
  [612] = {.entry = {.count = 1, .reusable = false}}, SHIFT(15),
  [614] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [616] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [618] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__name_list, 1, .production_id = 4),
  [620] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [622] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__block, 2),
  [624] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__block, 2),
  [626] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__block, 1),
  [628] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [630] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__doublequote_string_content, 1),
  [632] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__doublequote_string_content, 1),
  [634] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [636] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parameter_list, 1, .production_id = 4),
  [638] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_elseif_statement, 4, .production_id = 44),
  [640] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_elseif_statement, 4, .production_id = 44),
  [642] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 1, .production_id = 32),
  [644] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_if_statement_repeat1, 1, .production_id = 32),
  [646] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_name_prefix_expression, 1),
  [648] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [650] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [652] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_name, 1),
  [654] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_name_prefix_expression, 1, .production_id = 8),
  [656] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__name_list_repeat1, 2, .production_id = 25),
  [658] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [660] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_name_dot_index_expression, 3, .production_id = 23),
  [662] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [664] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parameter_list, 2, .production_id = 12),
  [666] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__variable_assignment_varlist, 2, .production_id = 12),
  [668] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__variable_assignment_varlist_repeat1, 2, .production_id = 26),
  [670] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__variable_assignment_varlist_repeat1, 2, .production_id = 26), SHIFT_REPEAT(161),
  [673] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__name_list, 2, .production_id = 12),
  [675] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__singlequote_string_content, 1),
  [677] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__singlequote_string_content, 1),
  [679] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [681] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [683] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [685] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [687] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [689] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_chunk, 3),
  [691] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [693] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [695] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [697] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_statement, 2, .production_id = 17),
  [699] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [701] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [703] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [705] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [707] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [709] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_generic_clause, 3, .production_id = 34),
  [711] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [713] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [715] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [717] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [719] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parameter_list, 3, .production_id = 4),
  [721] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parameter_list, 1),
  [723] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [725] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [727] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [729] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_name, 1, .production_id = 9),
  [731] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [733] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_name_method_index_expression, 3, .production_id = 24),
  [735] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [737] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [739] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parameter_list, 4, .production_id = 12),
  [741] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [743] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [745] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [747] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [749] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [751] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [753] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [755] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [757] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [759] = {.entry = {.count = 1, .reusable = false}}, SHIFT(261),
  [761] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [763] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [765] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [767] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [769] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [771] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [773] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 2, .production_id = 5),
  [775] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 2, .production_id = 6),
  [777] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 3, .production_id = 13),
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_lua_external_scanner_create(void);
void tree_sitter_lua_external_scanner_destroy(void *);
bool tree_sitter_lua_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_lua_external_scanner_serialize(void *, char *);
void tree_sitter_lua_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_lua(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_identifier,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_lua_external_scanner_create,
      tree_sitter_lua_external_scanner_destroy,
      tree_sitter_lua_external_scanner_scan,
      tree_sitter_lua_external_scanner_serialize,
      tree_sitter_lua_external_scanner_deserialize,
    },
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
