/* This is part of tmview, a dvi previewer. (c) 1995 Thomas Moor         */
/*                                                                       */
/* This program may be used without any warranty. It may be modified and */
/* distributed without any restrictions.                                 */


/* 
The source in this file handles a tiny aspect of the Color-special:
the aim is just to get black text not overdrawn by a >>black<< rule 
when there was a light grey (or whatever colored) box meant to be 
behind. While the below machinerie seem to be slightly oversized
for our simple purpose there is room for future extensions ... 
*/

#include "defs.h"

/* #define DEBUGCOLOR  */ /* debug color push/pop */
/* #define DEBUGCOLORP */ /* debug parseing */

#define COLORCHUNK 10
#define MAXCOL     1024
int cstp=0;
int maxcol=0;
color* colorstack=NULL;

void killcolorstack(void){
#ifdef DEBUGCOLOR
  pfprot("(killcolorstack)");
#endif
  dimmcolor=0;
  cstp=0;  
}

void initcolorstack(void){
#ifdef DEBUGCOLOR
  pfprot("(initcolorstack)");
#endif
  killcolorstack();
};


void savecolorstack(pagelistelement* apage){
  apage->cstackp=cstp;
  if(cstp==0) 
    apage->cstack=NULL;
  else {
    allocmem(&apage->cstack,sizeof(color)*cstp);
    memcpy(apage->cstack,colorstack,sizeof(color)*cstp);
  }
#ifdef DEBUGCOLOR
  pfprot("(savecolorstack: page %d colors %d)",apage->num,cstp);
#endif
}


void loadcolorstack(pagelistelement* apage){
  cstp=apage->cstackp;
  if(cstp<0){ /* this shall never happen */
    cstp=0;
    pfprot("(loadcolorstack: found invalide stack on page %d)",apage->num);
  }  
  if(cstp>0) {
    if(cstp>=maxcol){
      maxcol=cstp;
      reallocmem(&colorstack,maxcol*sizeof(color));
    }
    memcpy(colorstack,apage->cstack,sizeof(color)*cstp);
  }
#ifdef DEBUGCOLOR
  pfprot("(loadcolorstack: page %d colors %d)",apage->num,cstp);
#endif
}


/* dimm=0,1,2 <===> not dimmned, a little dimmed, rather dimmended */
/*            <===> black,       dark grey,       light grey       */
/* dimm=3     <===> only black is black .. anything else is white  */
/* dimmthresh 0...8: factor of thresholds, lower <=> blacker       */

void setdimmcolor(void){
  float gl;
  dimmcolor=0;
  if(cstp>0){
    gl= 
      colorstack[cstp-1].r/255. 
    + colorstack[cstp-1].g/255.
    + colorstack[cstp-1].b/255.;
    if(dimmthresh<=4){ /* ***************** rather black */
      if(gl > dimmthresh/4. * DIMMTHRESHOLDDG + (1.-dimmthresh/4.) * 3.) dimmcolor=1;
      if(gl > dimmthresh/4. * DIMMTHRESHOLDLG + (1.-dimmthresh/4.) * 3.) dimmcolor=2;
    } else {
    if(dimmthresh<8){  /* ***************** rather dimmned */
      if(gl > (1.-(dimmthresh-4)/4.) * DIMMTHRESHOLDDG) dimmcolor=1;
      if(gl > (1.-(dimmthresh-4)/4.) * DIMMTHRESHOLDLG) dimmcolor=2;
    } else { /* *************** draw only true black */
      if(gl>0) dimmcolor=3;
    }}
  } 
#ifdef DEBUGCOLOR
  if(dimmcolor==0) pfprot("(dimm off)");
  if(dimmcolor==1) pfprot("(dimm dark)");
  if(dimmcolor==2) pfprot("(dimm light)");
  if(dimmcolor==3) pfprot("(dimm ignore)");
#endif 
}


void pushcolor(float r, float g, float b){
#ifdef DEBUGCOLOR
  pfprot("(pushcolor)");
#endif 
  if(cstp>MAXCOL){
    pfprot("(color push: stack overflow)");
    return;
  }
  if(cstp>=maxcol){
    maxcol+=COLORCHUNK;
    reallocmem(&colorstack,maxcol*sizeof(color));
  }
  colorstack[cstp].r=MAX(0,255*r);
  colorstack[cstp].g=MAX(0,255*g);
  colorstack[cstp].b=MAX(0,255*b);
  cstp++;
  setdimmcolor();
}
  
void popcolor(void){
#ifdef DEBUGCOLOR
  pfprot("(popcolor)");
#endif 
  cstp--;
  setdimmcolor();
  if(cstp<0){
    pfprot("(color pop: stack underflow)");
    cstp=0;
  } 
}

/****************************************************************************/
/* parsing the arguments of the color-special                               */
/* this is to be called from the dvi-reader when a special occures          */
/****************************************************************************/

int checkndoColor(char* specstr){
  char* cp;
  float r,g,b,gl,c,y,m,k;
#ifndef LETSTRYCOLOR
  return(0);
#endif
  cp=specstr;
  if(STRNCASECMP(cp,"color",5)!=0) return(0);
  cp += 5;
#ifdef DEBUGCOLORP
  pfprot("(cndColor: <%s> ...)",cp);
#endif
  while(isspace(*++cp));
  if(STRNCASECMP(cp,"push",4)==0){
    cp += 4;
    while(isspace(*++cp));
    if(STRNCASECMP(cp,"Black",5)==0){
      pushcolor(0,0,0); 
    } else {
    if(STRNCASECMP(cp,"White",5)==0){
      pushcolor(1,1,1); 
    } else {
    if(STRNCASECMP(cp,"cmyk",4)==0){
      cp += 4;
      if(sscanf(cp," %g%g%g%g",&c,&m,&y,&k)<4){
        pfprot("(color push cmyk: parse error)");
      } else {
        pushcolor(MAX(0,1-c-k),MAX(0,1-m-k),MAX(0,1-y-k));
      }
    } else {
    if(STRNCASECMP(cp,"grey",4)==0 || STRNCASECMP(cp,"gray",4)==0 ){
      cp += 4;
      if(sscanf(cp," %g",&gl)<1){
        pfprot("(color push grey: parse error)");
      } else {
        pushcolor(gl,gl,gl); 
      }
    } else {   
    if(STRNCASECMP(cp,"rgb",3)==0){
      cp += 3;
      if(sscanf(cp," %g%g%g",&r,&g,&b)<3){
        pfprot("(color push rgb: parse error)");
      } else {
        pushcolor(r,g,b); 
      }
    }}}}}    
  } else {
  if(STRNCASECMP(cp,"pop",3)==0){
    cp+=3;
    while(isspace(*++cp));
    popcolor();
  } else {
    pfverb("(cndColor: <%s> ingnored)",cp);
  }}
#ifdef DEBUGCOLORP
  pfprot("(cndColor: done)");
#endif       
  return(1);
}



