from sfc import *

# Define elements
polygon = "tetrahedron"
P2 = FiniteElement("CG", polygon, 2)
T0 = TensorElement("DG", polygon, 0)

# Define form arguments
u = TrialFunction(P2)
v = TestFunction(P2)
M = Function(T0)

# Define integrand for a weighted stiffness matrix
def stiffness(v, u, M, itg):
    GinvT = itg.GinvT()
    Du = grad(u, GinvT)
    Dv = grad(v, GinvT)
    return inner(M*Du, Dv)

# Collect the pieces as a form
a = CallbackForm(basisfunctions  = [v, u],
                 coefficients    = [M],
                 cell_integrands = [stiffness])

# Generate UFC code, compile and import
a_form = compile_form(a)

# Assemble the global system using PyDOLFIN
from dolfin import *
n = 10
mesh = UnitCube(n, n, n)

class Conductivity(cpp_Function):
    def __init__(self, mesh):
        cpp_Function.__init__(self, mesh)
    def rank(self):
        return 2
    def dim(self, i):
        return 3
    def eval(self, v, x):
        v[0], v[1], v[2] = 1.0, 0.0, 0.0
        v[3], v[4], v[5] = 0.0, 2.0, 0.0
        v[6], v[7], v[8] = 0.0, 0.0, 3.0

M = Conductivity(mesh)

A = assemble(a_form, mesh, coefficients = [M])

