/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */


// sc
#include "PropListItem.h"
#include "util/apr.h"

// svn
#include <svn_client.h>


namespace svn
{

PropListItem::PropListItem( svn_client_proplist_item_t* item )
{
  _name = sc::String(item->node_name->data,item->node_name->len);

  apr::Pool         pool(item->node_name->pool);
  apr_hash_index_t *hi;
  for( hi = apr_hash_first(pool,item->prop_hash); hi; hi = apr_hash_next(hi) )
  {
    const char*   key;
    svn_string_t* val;

    apr_hash_this( hi, (const void**)&key, NULL, (void**)&val );

    sc::String skey(key);
    sc::String sval(val->data,val->len);

    _props.insert( Props::value_type(skey,sval) );
  }
}

PropListItem::PropListItem( const PropListItem& src )
{
}

const sc::String& PropListItem::getName() const
{
  return _name;
}

const PropListItem::Props& PropListItem::getProps() const
{
  return _props;
}


} // namespace
