/* ====================================================================
 * Copyright (c) 2008-2009  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_WCVIEWITEMMODEL_H
#define _SC_WCVIEWITEMMODEL_H

// sc
#include "WcViewItem.h"
#include "util/String.h"

// qt
#include <QtCore/QModelIndex>


/**
 * WcView item model interface.
 */
class WcViewItemModel
{
  typedef QAbstractItemModel super;
  //Q_OBJECT

public:
  /** Custom Roles. */
  enum Roles {
    WcViewItemRole = Qt::UserRole,
    DeepRole,
    NameRole,
    DragRole,
    DirRole,
    ChangedRole,
    IgnoredRole,
    SwitchedRole,
    OutOfDateRole,
    TextStatusRole,
    SortRole
  };

  /** find row index of @a name. The index is invalid if the item was
   *  not found. */
  virtual QModelIndex index( const sc::String& name ) const = 0;
  
  /** insert the @a WcViewItems entries for @a path to the model. */
  virtual void insert( const sc::String& path, const WcViewItems& ) = 0;
  /** remove the @a path from the model. */
  virtual void remove( const sc::String& path ) = 0;
};

#endif // _SC_WCVIEWITEMMODEL_H
