/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg" on Wed Aug  1 15:15:05 2012

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_37 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def (filter, first, last, 32117, "epsg", 32117,
        "NAD83 / New York West");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=-78.58333333333333 +k=0.999");
    add_proj4text (p, 1,
        "9375 +x_0=350000 +y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / New York West\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",40],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",-78.58333333333333],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",0.9999375],PARAMETER[\"false_easting\",350000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"32117\"]]");
    p = add_epsg_def (filter, first, last, 32118, "epsg", 32118,
        "NAD83 / New York Long Island");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.03333333333333 +lat_2=40.66666666666");
    add_proj4text (p, 1,
        "666 +lat_0=40.16666666666666 +lon_0=-74 +x_0=300000 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / New York Long Island\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",41");
    add_srs_wkt (p, 8,
        ".03333333333333],PARAMETER[\"standard_parallel_2\",40.66");
    add_srs_wkt (p, 9,
        "666666666666],PARAMETER[\"latitude_of_origin\",40.166666");
    add_srs_wkt (p, 10,
        "66666666],PARAMETER[\"central_meridian\",-74],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_easting\",300000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 12,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32118\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def (filter, first, last, 32119, "epsg", 32119,
        "NAD83 / North Carolina");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.16666666666666 +lat_2=34.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=33.75 +lon_0=-79 +x_0=609601.22 +y_0=0 +datum");
    add_proj4text (p, 2,
        "=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / North Carolina\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 7,
        "_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",36.16666");
    add_srs_wkt (p, 8,
        "666666666],PARAMETER[\"standard_parallel_2\",34.33333333");
    add_srs_wkt (p, 9,
        "333334],PARAMETER[\"latitude_of_origin\",33.75],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"central_meridian\",-79],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "609601.22],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 12,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"32119\"]]");
    p = add_epsg_def (filter, first, last, 32120, "epsg", 32120,
        "NAD83 / North Dakota North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.73333333333333 +lat_2=47.43333333333");
    add_proj4text (p, 1,
        "333 +lat_0=47 +lon_0=-100.5 +x_0=600000 +y_0=0 +datum=NA");
    add_proj4text (p, 2,
        "D83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / North Dakota North\",GEOGCS[\"NAD83\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
        "rmal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",48.7");
    add_srs_wkt (p, 8,
        "3333333333333],PARAMETER[\"standard_parallel_2\",47.4333");
    add_srs_wkt (p, 9,
        "3333333333],PARAMETER[\"latitude_of_origin\",47],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"central_meridian\",-100.5],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",600000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 13,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32120\"]]");
    p = add_epsg_def (filter, first, last, 32121, "epsg", 32121,
        "NAD83 / North Dakota South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.48333333333333 +lat_2=46.18333333333");
    add_proj4text (p, 1,
        "333 +lat_0=45.66666666666666 +lon_0=-100.5 +x_0=600000 +");
    add_proj4text (p, 2,
        "y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / North Dakota South\",GEOGCS[\"NAD83\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
        "rmal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",47.4");
    add_srs_wkt (p, 8,
        "8333333333333],PARAMETER[\"standard_parallel_2\",46.1833");
    add_srs_wkt (p, 9,
        "3333333333],PARAMETER[\"latitude_of_origin\",45.66666666");
    add_srs_wkt (p, 10,
        "666666],PARAMETER[\"central_meridian\",-100.5],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_easting\",600000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 12,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32121\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def (filter, first, last, 32122, "epsg", 32122,
        "NAD83 / Ohio North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.7 +lat_2=40.43333333333333 +lat_0=39");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-82.5 +x_0=600000 +y_0=0 +datum=N");
    add_proj4text (p, 2,
        "AD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Ohio North\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 7,
        "ic_2SP\"],PARAMETER[\"standard_parallel_1\",41.7],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"standard_parallel_2\",40.43333333333333],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"latitude_of_origin\",39.66666666666666],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",-82.5],PARAMETER[\"false_easting\",600");
    add_srs_wkt (p, 11,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 13,
        "NORTH],AUTHORITY[\"EPSG\",\"32122\"]]");
    p = add_epsg_def (filter, first, last, 32123, "epsg", 32123,
        "NAD83 / Ohio South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.03333333333333 +lat_2=38.73333333333");
    add_proj4text (p, 1,
        "333 +lat_0=38 +lon_0=-82.5 +x_0=600000 +y_0=0 +datum=NAD");
    add_proj4text (p, 2,
        "83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Ohio South\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 7,
        "ic_2SP\"],PARAMETER[\"standard_parallel_1\",40.033333333");
    add_srs_wkt (p, 8,
        "33333],PARAMETER[\"standard_parallel_2\",38.733333333333");
    add_srs_wkt (p, 9,
        "33],PARAMETER[\"latitude_of_origin\",38],PARAMETER[\"cen");
    add_srs_wkt (p, 10,
        "tral_meridian\",-82.5],PARAMETER[\"false_easting\",60000");
    add_srs_wkt (p, 11,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NO");
    add_srs_wkt (p, 13,
        "RTH],AUTHORITY[\"EPSG\",\"32123\"]]");
    p = add_epsg_def (filter, first, last, 32124, "epsg", 32124,
        "NAD83 / Oklahoma North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.76666666666667 +lat_2=35.56666666666");
    add_proj4text (p, 1,
        "667 +lat_0=35 +lon_0=-98 +x_0=600000 +y_0=0 +datum=NAD83");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Oklahoma North\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 7,
        "_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",36.76666");
    add_srs_wkt (p, 8,
        "666666667],PARAMETER[\"standard_parallel_2\",35.56666666");
    add_srs_wkt (p, 9,
        "666667],PARAMETER[\"latitude_of_origin\",35],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "central_meridian\",-98],PARAMETER[\"false_easting\",6000");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",N");
    add_srs_wkt (p, 13,
        "ORTH],AUTHORITY[\"EPSG\",\"32124\"]]");
    p = add_epsg_def (filter, first, last, 32125, "epsg", 32125,
        "NAD83 / Oklahoma South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35.23333333333333 +lat_2=33.93333333333");
    add_proj4text (p, 1,
        "333 +lat_0=33.33333333333334 +lon_0=-98 +x_0=600000 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Oklahoma South\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 7,
        "_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",35.23333");
    add_srs_wkt (p, 8,
        "333333333],PARAMETER[\"standard_parallel_2\",33.93333333");
    add_srs_wkt (p, 9,
        "333333],PARAMETER[\"latitude_of_origin\",33.333333333333");
    add_srs_wkt (p, 10,
        "34],PARAMETER[\"central_meridian\",-98],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",600000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 12,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EA");
    add_srs_wkt (p, 13,
        "ST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32125\"]]");
    p = add_epsg_def (filter, first, last, 32126, "epsg", 32126,
        "NAD83 / Oregon North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46 +lat_2=44.33333333333334 +lat_0=43.6");
    add_proj4text (p, 1,
        "6666666666666 +lon_0=-120.5 +x_0=2500000 +y_0=0 +datum=N");
    add_proj4text (p, 2,
        "AD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Oregon North\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Co");
    add_srs_wkt (p, 7,
        "nic_2SP\"],PARAMETER[\"standard_parallel_1\",46],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_2\",44.33333333333334],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"latitude_of_origin\",43.66666666666666],PARAMETER[\"ce");
    add_srs_wkt (p, 10,
        "ntral_meridian\",-120.5],PARAMETER[\"false_easting\",250");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"32126\"]]");
    p = add_epsg_def (filter, first, last, 32127, "epsg", 32127,
        "NAD83 / Oregon South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44 +lat_2=42.33333333333334 +lat_0=41.6");
    add_proj4text (p, 1,
        "6666666666666 +lon_0=-120.5 +x_0=1500000 +y_0=0 +datum=N");
    add_proj4text (p, 2,
        "AD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Oregon South\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Co");
    add_srs_wkt (p, 7,
        "nic_2SP\"],PARAMETER[\"standard_parallel_1\",44],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_2\",42.33333333333334],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"latitude_of_origin\",41.66666666666666],PARAMETER[\"ce");
    add_srs_wkt (p, 10,
        "ntral_meridian\",-120.5],PARAMETER[\"false_easting\",150");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"32127\"]]");
    p = add_epsg_def (filter, first, last, 32128, "epsg", 32128,
        "NAD83 / Pennsylvania North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.95 +lat_2=40.88333333333333 +lat_0=4");
    add_proj4text (p, 1,
        "0.16666666666666 +lon_0=-77.75 +x_0=600000 +y_0=0 +datum");
    add_proj4text (p, 2,
        "=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Pennsylvania North\",GEOGCS[\"NAD83\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
        "rmal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",41.9");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"standard_parallel_2\",40.88333333333333],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"latitude_of_origin\",40.16666666666666],PARA");
    add_srs_wkt (p, 10,
        "METER[\"central_meridian\",-77.75],PARAMETER[\"false_eas");
    add_srs_wkt (p, 11,
        "ting\",600000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 12,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32128\"]]");
    p = add_epsg_def (filter, first, last, 32129, "epsg", 32129,
        "NAD83 / Pennsylvania South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.96666666666667 +lat_2=39.93333333333");
    add_proj4text (p, 1,
        "333 +lat_0=39.33333333333334 +lon_0=-77.75 +x_0=600000 +");
    add_proj4text (p, 2,
        "y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Pennsylvania South\",GEOGCS[\"NAD83\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
        "rmal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",40.9");
    add_srs_wkt (p, 8,
        "6666666666667],PARAMETER[\"standard_parallel_2\",39.9333");
    add_srs_wkt (p, 9,
        "3333333333],PARAMETER[\"latitude_of_origin\",39.33333333");
    add_srs_wkt (p, 10,
        "333334],PARAMETER[\"central_meridian\",-77.75],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_easting\",600000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 12,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32129\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def (filter, first, last, 32130, "epsg", 32130,
        "NAD83 / Rhode Island");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.08333333333334 +lon_0=-71.5 +k=0.9");
    add_proj4text (p, 1,
        "9999375 +x_0=100000 +y_0=0 +datum=NAD83 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Rhode Island\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",41.08333333333334],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",-71.5],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",0.99999375],PARAMETER[\"false_easting\",100000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"32130\"]]");
    p = add_epsg_def (filter, first, last, 32133, "epsg", 32133,
        "NAD83 / South Carolina");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.83333333333334 +lat_2=32.5 +lat_0=31");
    add_proj4text (p, 1,
        ".83333333333333 +lon_0=-81 +x_0=609600 +y_0=0 +datum=NAD");
    add_proj4text (p, 2,
        "83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / South Carolina\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 7,
        "_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",34.83333");
    add_srs_wkt (p, 8,
        "333333334],PARAMETER[\"standard_parallel_2\",32.5],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"latitude_of_origin\",31.83333333333333],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"central_meridian\",-81],PARAMETER[\"false_easting\",6");
    add_srs_wkt (p, 11,
        "09600],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"32133\"]]");
    p = add_epsg_def (filter, first, last, 32134, "epsg", 32134,
        "NAD83 / South Dakota North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.68333333333333 +lat_2=44.41666666666");
    add_proj4text (p, 1,
        "666 +lat_0=43.83333333333334 +lon_0=-100 +x_0=600000 +y_");
    add_proj4text (p, 2,
        "0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / South Dakota North\",GEOGCS[\"NAD83\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
        "rmal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",45.6");
    add_srs_wkt (p, 8,
        "8333333333333],PARAMETER[\"standard_parallel_2\",44.4166");
    add_srs_wkt (p, 9,
        "6666666666],PARAMETER[\"latitude_of_origin\",43.83333333");
    add_srs_wkt (p, 10,
        "333334],PARAMETER[\"central_meridian\",-100],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",600000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 12,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32134\"]]");
    p = add_epsg_def (filter, first, last, 32135, "epsg", 32135,
        "NAD83 / South Dakota South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.4 +lat_2=42.83333333333334 +lat_0=42");
    add_proj4text (p, 1,
        ".33333333333334 +lon_0=-100.3333333333333 +x_0=600000 +y");
    add_proj4text (p, 2,
        "_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / South Dakota South\",GEOGCS[\"NAD83\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
        "rmal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",44.4");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"standard_parallel_2\",42.83333333333334],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"latitude_of_origin\",42.33333333333334],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"central_meridian\",-100.3333333333333],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_easting\",600000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 12,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32135\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def (filter, first, last, 32136, "epsg", 32136,
        "NAD83 / Tennessee");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.41666666666666 +lat_2=35.25 +lat_0=3");
    add_proj4text (p, 1,
        "4.33333333333334 +lon_0=-86 +x_0=600000 +y_0=0 +datum=NA");
    add_proj4text (p, 2,
        "D83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Tennessee\",GEOGCS[\"NAD83\",DATUM[\"No");
    add_srs_wkt (p, 1,
        "rth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,");
    add_srs_wkt (p, 2,
        "298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Coni");
    add_srs_wkt (p, 7,
        "c_2SP\"],PARAMETER[\"standard_parallel_1\",36.4166666666");
    add_srs_wkt (p, 8,
        "6666],PARAMETER[\"standard_parallel_2\",35.25],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"latitude_of_origin\",34.33333333333334],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",-86],PARAMETER[\"false_easting\",60000");
    add_srs_wkt (p, 11,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NO");
    add_srs_wkt (p, 13,
        "RTH],AUTHORITY[\"EPSG\",\"32136\"]]");
    p = add_epsg_def (filter, first, last, 32137, "epsg", 32137,
        "NAD83 / Texas North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.18333333333333 +lat_2=34.65 +lat_0=3");
    add_proj4text (p, 1,
        "4 +lon_0=-101.5 +x_0=200000 +y_0=1000000 +datum=NAD83 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Texas North\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Co");
    add_srs_wkt (p, 7,
        "nic_2SP\"],PARAMETER[\"standard_parallel_1\",36.18333333");
    add_srs_wkt (p, 8,
        "333333],PARAMETER[\"standard_parallel_2\",34.65],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"latitude_of_origin\",34],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 10,
        "an\",-101.5],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"32137\"]]");
    p = add_epsg_def (filter, first, last, 32138, "epsg", 32138,
        "NAD83 / Texas North Central");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.96666666666667 +lat_2=32.13333333333");
    add_proj4text (p, 1,
        "333 +lat_0=31.66666666666667 +lon_0=-98.5 +x_0=600000 +y");
    add_proj4text (p, 2,
        "_0=2000000 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Texas North Central\",GEOGCS[\"NAD83\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
        "rmal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",33.9");
    add_srs_wkt (p, 8,
        "6666666666667],PARAMETER[\"standard_parallel_2\",32.1333");
    add_srs_wkt (p, 9,
        "3333333333],PARAMETER[\"latitude_of_origin\",31.66666666");
    add_srs_wkt (p, 10,
        "666667],PARAMETER[\"central_meridian\",-98.5],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_easting\",600000],PARAMETER[\"false_northing\",2");
    add_srs_wkt (p, 12,
        "000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 13,
        "XIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 14,
        "2138\"]]");
    p = add_epsg_def (filter, first, last, 32139, "epsg", 32139,
        "NAD83 / Texas Central");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=31.88333333333333 +lat_2=30.11666666666");
    add_proj4text (p, 1,
        "667 +lat_0=29.66666666666667 +lon_0=-100.3333333333333 +");
    add_proj4text (p, 2,
        "x_0=700000 +y_0=3000000 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Texas Central\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 7,
        "onic_2SP\"],PARAMETER[\"standard_parallel_1\",31.8833333");
    add_srs_wkt (p, 8,
        "3333333],PARAMETER[\"standard_parallel_2\",30.1166666666");
    add_srs_wkt (p, 9,
        "6667],PARAMETER[\"latitude_of_origin\",29.66666666666667");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"central_meridian\",-100.3333333333333],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",700000],PARAMETER[\"false_north");
    add_srs_wkt (p, 12,
        "ing\",3000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 13,
        "1\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"32139\"]]");
    p = add_epsg_def (filter, first, last, 32140, "epsg", 32140,
        "NAD83 / Texas South Central");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30.28333333333333 +lat_2=28.38333333333");
    add_proj4text (p, 1,
        "333 +lat_0=27.83333333333333 +lon_0=-99 +x_0=600000 +y_0");
    add_proj4text (p, 2,
        "=4000000 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Texas South Central\",GEOGCS[\"NAD83\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
        "rmal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",30.2");
    add_srs_wkt (p, 8,
        "8333333333333],PARAMETER[\"standard_parallel_2\",28.3833");
    add_srs_wkt (p, 9,
        "3333333333],PARAMETER[\"latitude_of_origin\",27.83333333");
    add_srs_wkt (p, 10,
        "333333],PARAMETER[\"central_meridian\",-99],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",600000],PARAMETER[\"false_northing\",400");
    add_srs_wkt (p, 12,
        "0000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 13,
        "S[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"321");
    add_srs_wkt (p, 14,
        "40\"]]");
    p = add_epsg_def (filter, first, last, 32141, "epsg", 32141,
        "NAD83 / Texas South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666");
    add_proj4text (p, 1,
        "667 +lat_0=25.66666666666667 +lon_0=-98.5 +x_0=300000 +y");
    add_proj4text (p, 2,
        "_0=5000000 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Texas South\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Co");
    add_srs_wkt (p, 7,
        "nic_2SP\"],PARAMETER[\"standard_parallel_1\",27.83333333");
    add_srs_wkt (p, 8,
        "333333],PARAMETER[\"standard_parallel_2\",26.16666666666");
    add_srs_wkt (p, 9,
        "667],PARAMETER[\"latitude_of_origin\",25.66666666666667]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"central_meridian\",-98.5],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_easting\",300000],PARAMETER[\"false_northing\",5000000]");
    add_srs_wkt (p, 12,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X");
    add_srs_wkt (p, 13,
        "\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32141\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def (filter, first, last, 32142, "epsg", 32142,
        "NAD83 / Utah North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000 +");
    add_proj4text (p, 2,
        "y_0=1000000 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Utah North\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 7,
        "ic_2SP\"],PARAMETER[\"standard_parallel_1\",41.783333333");
    add_srs_wkt (p, 8,
        "33333],PARAMETER[\"standard_parallel_2\",40.716666666666");
    add_srs_wkt (p, 9,
        "67],PARAMETER[\"latitude_of_origin\",40.33333333333334],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"central_meridian\",-111.5],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_easting\",500000],PARAMETER[\"false_northing\",1000000]");
    add_srs_wkt (p, 12,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X");
    add_srs_wkt (p, 13,
        "\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32142\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def (filter, first, last, 32143, "epsg", 32143,
        "NAD83 / Utah Central");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=3");
    add_proj4text (p, 1,
        "8.33333333333334 +lon_0=-111.5 +x_0=500000 +y_0=2000000 ");
    add_proj4text (p, 2,
        "+datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Utah Central\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Co");
    add_srs_wkt (p, 7,
        "nic_2SP\"],PARAMETER[\"standard_parallel_1\",40.65],PARA");
    add_srs_wkt (p, 8,
        "METER[\"standard_parallel_2\",39.01666666666667],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"latitude_of_origin\",38.33333333333334],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "central_meridian\",-111.5],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 11,
        "00000],PARAMETER[\"false_northing\",2000000],UNIT[\"metr");
    add_srs_wkt (p, 12,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXI");
    add_srs_wkt (p, 13,
        "S[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32143\"]]");
    p = add_epsg_def (filter, first, last, 32144, "epsg", 32144,
        "NAD83 / Utah South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=3");
    add_proj4text (p, 1,
        "6.66666666666666 +lon_0=-111.5 +x_0=500000 +y_0=3000000 ");
    add_proj4text (p, 2,
        "+datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Utah South\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 7,
        "ic_2SP\"],PARAMETER[\"standard_parallel_1\",38.35],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"standard_parallel_2\",37.21666666666667],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"latitude_of_origin\",36.66666666666666],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "central_meridian\",-111.5],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 11,
        "00000],PARAMETER[\"false_northing\",3000000],UNIT[\"metr");
    add_srs_wkt (p, 12,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXI");
    add_srs_wkt (p, 13,
        "S[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32144\"]]");
    p = add_epsg_def (filter, first, last, 32145, "epsg", 32145,
        "NAD83 / Vermont");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-72.5 +k=0.999964286 +x_0");
    add_proj4text (p, 1,
        "=500000 +y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Vermont\",GEOGCS[\"NAD83\",DATUM[\"Nort");
    add_srs_wkt (p, 1,
        "h_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 2,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,");
    add_srs_wkt (p, 3,
        "0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",42.5],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",-72.5],PARAMETER[\"scale_factor\",0.99996428");
    add_srs_wkt (p, 9,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"32145\"]]");
    p = add_epsg_def (filter, first, last, 32146, "epsg", 32146,
        "NAD83 / Virginia North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.2 +lat_2=38.03333333333333 +lat_0=37");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-78.5 +x_0=3500000 +y_0=2000000 +");
    add_proj4text (p, 2,
        "datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Virginia North\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 7,
        "_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",39.2],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"standard_parallel_2\",38.03333333333333],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"latitude_of_origin\",37.66666666666666],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"central_meridian\",-78.5],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",3500000],PARAMETER[\"false_northing\",2000000],UNIT[\"m");
    add_srs_wkt (p, 12,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],");
    add_srs_wkt (p, 13,
        "AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32146\"]]");
    p = add_epsg_def (filter, first, last, 32147, "epsg", 32147,
        "NAD83 / Virginia South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.96666666666667 +lat_2=36.76666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.33333333333334 +lon_0=-78.5 +x_0=3500000 +");
    add_proj4text (p, 2,
        "y_0=1000000 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Virginia South\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 7,
        "_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",37.96666");
    add_srs_wkt (p, 8,
        "666666667],PARAMETER[\"standard_parallel_2\",36.76666666");
    add_srs_wkt (p, 9,
        "666667],PARAMETER[\"latitude_of_origin\",36.333333333333");
    add_srs_wkt (p, 10,
        "34],PARAMETER[\"central_meridian\",-78.5],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",3500000],PARAMETER[\"false_northing\",1000");
    add_srs_wkt (p, 12,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 13,
        "[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3214");
    add_srs_wkt (p, 14,
        "7\"]]");
    p = add_epsg_def (filter, first, last, 32148, "epsg", 32148,
        "NAD83 / Washington North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.73333333333333 +lat_2=47.5 +lat_0=47");
    add_proj4text (p, 1,
        " +lon_0=-120.8333333333333 +x_0=500000 +y_0=0 +datum=NAD");
    add_proj4text (p, 2,
        "83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Washington North\",GEOGCS[\"NAD83\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 2,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",48.7333");
    add_srs_wkt (p, 8,
        "3333333333],PARAMETER[\"standard_parallel_2\",47.5],PARA");
    add_srs_wkt (p, 9,
        "METER[\"latitude_of_origin\",47],PARAMETER[\"central_mer");
    add_srs_wkt (p, 10,
        "idian\",-120.8333333333333],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"32148\"]]");
    p = add_epsg_def (filter, first, last, 32149, "epsg", 32149,
        "NAD83 / Washington South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.33333333333334 +lat_2=45.83333333333");
    add_proj4text (p, 1,
        "334 +lat_0=45.33333333333334 +lon_0=-120.5 +x_0=500000 +");
    add_proj4text (p, 2,
        "y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Washington South\",GEOGCS[\"NAD83\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 2,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",47.3333");
    add_srs_wkt (p, 8,
        "3333333334],PARAMETER[\"standard_parallel_2\",45.8333333");
    add_srs_wkt (p, 9,
        "3333334],PARAMETER[\"latitude_of_origin\",45.33333333333");
    add_srs_wkt (p, 10,
        "334],PARAMETER[\"central_meridian\",-120.5],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 12,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32149\"]]");
    p = add_epsg_def (filter, first, last, 32150, "epsg", 32150,
        "NAD83 / West Virginia North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.");
    add_proj4text (p, 1,
        "5 +x_0=600000 +y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / West Virginia North\",GEOGCS[\"NAD83\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
        "rmal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",40.2");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"standard_parallel_2\",39],PARAMETER[\"lat");
    add_srs_wkt (p, 9,
        "itude_of_origin\",38.5],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 10,
        "79.5],PARAMETER[\"false_easting\",600000],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"32150\"]]");
    p = add_epsg_def (filter, first, last, 32151, "epsg", 32151,
        "NAD83 / West Virginia South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333");
    add_proj4text (p, 1,
        "333 +lat_0=37 +lon_0=-81 +x_0=600000 +y_0=0 +datum=NAD83");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / West Virginia South\",GEOGCS[\"NAD83\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
        "rmal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",38.8");
    add_srs_wkt (p, 8,
        "8333333333333],PARAMETER[\"standard_parallel_2\",37.4833");
    add_srs_wkt (p, 9,
        "3333333333],PARAMETER[\"latitude_of_origin\",37],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"central_meridian\",-81],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",600000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"32151\"]]");
    p = add_epsg_def (filter, first, last, 32152, "epsg", 32152,
        "NAD83 / Wisconsin North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.76666666666667 +lat_2=45.56666666666");
    add_proj4text (p, 1,
        "667 +lat_0=45.16666666666666 +lon_0=-90 +x_0=600000 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Wisconsin North\",GEOGCS[\"NAD83\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",46.7666");
    add_srs_wkt (p, 8,
        "6666666667],PARAMETER[\"standard_parallel_2\",45.5666666");
    add_srs_wkt (p, 9,
        "6666667],PARAMETER[\"latitude_of_origin\",45.16666666666");
    add_srs_wkt (p, 10,
        "666],PARAMETER[\"central_meridian\",-90],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_easting\",600000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 12,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 13,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32152\"]]");
    p = add_epsg_def (filter, first, last, 32153, "epsg", 32153,
        "NAD83 / Wisconsin Central");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.5 +lat_2=44.25 +lat_0=43.83333333333");
    add_proj4text (p, 1,
        "334 +lon_0=-90 +x_0=600000 +y_0=0 +datum=NAD83 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Wisconsin Central\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confor");
    add_srs_wkt (p, 7,
        "mal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",45.5]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"standard_parallel_2\",44.25],PARAMETER[\"la");
    add_srs_wkt (p, 9,
        "titude_of_origin\",43.83333333333334],PARAMETER[\"centra");
    add_srs_wkt (p, 10,
        "l_meridian\",-90],PARAMETER[\"false_easting\",600000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"32153\"]]");
    p = add_epsg_def (filter, first, last, 32154, "epsg", 32154,
        "NAD83 / Wisconsin South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.06666666666667 +lat_2=42.73333333333");
    add_proj4text (p, 1,
        "333 +lat_0=42 +lon_0=-90 +x_0=600000 +y_0=0 +datum=NAD83");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Wisconsin South\",GEOGCS[\"NAD83\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",44.0666");
    add_srs_wkt (p, 8,
        "6666666667],PARAMETER[\"standard_parallel_2\",42.7333333");
    add_srs_wkt (p, 9,
        "3333333],PARAMETER[\"latitude_of_origin\",42],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",-90],PARAMETER[\"false_easting\",60");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"32154\"]]");
    p = add_epsg_def (filter, first, last, 32155, "epsg", 32155,
        "NAD83 / Wyoming East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-105.1666666666667 +k=0.9");
    add_proj4text (p, 1,
        "999375 +x_0=200000 +y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Wyoming East\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",40.5],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",-105.1666666666667],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",0.9999375],PARAMETER[\"false_easting\",200000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"32155\"]]");
    p = add_epsg_def (filter, first, last, 32156, "epsg", 32156,
        "NAD83 / Wyoming East Central");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-107.3333333333333 +k=0.9");
    add_proj4text (p, 1,
        "999375 +x_0=400000 +y_0=100000 +datum=NAD83 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Wyoming East Central\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",40.5],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-107.3333333333333],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",0.9999375],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "400000],PARAMETER[\"false_northing\",100000],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXI");
    add_srs_wkt (p, 12,
        "S[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32156\"]]");
    p = add_epsg_def (filter, first, last, 32157, "epsg", 32157,
        "NAD83 / Wyoming West Central");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-108.75 +k=0.9999375 +x_0");
    add_proj4text (p, 1,
        "=600000 +y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Wyoming West Central\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",40.5],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-108.75],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9999375],PARAMETER[\"false_easting\",600000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"32157\"]]");
    p = add_epsg_def (filter, first, last, 32158, "epsg", 32158,
        "NAD83 / Wyoming West");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-110.0833333333333 +k=0.9");
    add_proj4text (p, 1,
        "999375 +x_0=800000 +y_0=100000 +datum=NAD83 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Wyoming West\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",40.5],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",-110.0833333333333],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",0.9999375],PARAMETER[\"false_easting\",800000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",100000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NO");
    add_srs_wkt (p, 12,
        "RTH],AUTHORITY[\"EPSG\",\"32158\"]]");
    p = add_epsg_def (filter, first, last, 32161, "epsg", 32161,
        "NAD83 / Puerto Rico & Virgin Is.");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=18.43333333333333 +lat_2=18.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=17.83333333333333 +lon_0=-66.43333333333334 +");
    add_proj4text (p, 2,
        "x_0=200000 +y_0=200000 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Puerto Rico & Virgin Is.\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 8,
        ",18.43333333333333],PARAMETER[\"standard_parallel_2\",18");
    add_srs_wkt (p, 9,
        ".03333333333333],PARAMETER[\"latitude_of_origin\",17.833");
    add_srs_wkt (p, 10,
        "33333333333],PARAMETER[\"central_meridian\",-66.43333333");
    add_srs_wkt (p, 11,
        "333334],PARAMETER[\"false_easting\",200000],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",200000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"32161\"]]");
    p = add_epsg_def (filter, first, last, 32164, "epsg", 32164,
        "NAD83 / BLM 14N (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-99 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD83 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 14N (ftUS)\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 8,
        "ntral_meridian\",-99],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",1640416.67],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",0],UNIT[\"US survey foot\",0.3048006096012");
    add_srs_wkt (p, 11,
        "192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32164\"]]");
    p = add_epsg_def (filter, first, last, 32165, "epsg", 32165,
        "NAD83 / BLM 15N (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-93 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD83 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 15N (ftUS)\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 8,
        "ntral_meridian\",-93],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",1640416.67],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",0],UNIT[\"US survey foot\",0.3048006096012");
    add_srs_wkt (p, 11,
        "192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32165\"]]");
    p = add_epsg_def (filter, first, last, 32166, "epsg", 32166,
        "NAD83 / BLM 16N (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-87 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD83 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 16N (ftUS)\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 8,
        "ntral_meridian\",-87],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",1640416.67],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",0],UNIT[\"US survey foot\",0.3048006096012");
    add_srs_wkt (p, 11,
        "192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32166\"]]");
    p = add_epsg_def (filter, first, last, 32167, "epsg", 32167,
        "NAD83 / BLM 17N (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-81 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD83 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 17N (ftUS)\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 8,
        "ntral_meridian\",-81],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",1640416.67],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",0],UNIT[\"US survey foot\",0.3048006096012");
    add_srs_wkt (p, 11,
        "192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32167\"]]");
    p = add_epsg_def (filter, first, last, 32180, "epsg", 32180,
        "NAD83 / SCoPQ zone 2 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-55.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / SCoPQ zone 2 (deprecated)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",-55.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",304800],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"32180\"]]");
    p = add_epsg_def (filter, first, last, 32181, "epsg", 32181,
        "NAD83 / MTM zone 1");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-53 +k=0.9999 +x_0=304800 +y");
    add_proj4text (p, 1,
        "_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / MTM zone 1\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-53],PARAMETER[\"scale_factor\",0.9999],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",304800],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"E(X)\",EAST],AXIS[\"N(Y)\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"32181\"]]");
    p = add_epsg_def (filter, first, last, 32182, "epsg", 32182,
        "NAD83 / MTM zone 2");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-56 +k=0.9999 +x_0=304800 +y");
    add_proj4text (p, 1,
        "_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / MTM zone 2\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-56],PARAMETER[\"scale_factor\",0.9999],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",304800],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"E(X)\",EAST],AXIS[\"N(Y)\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"32182\"]]");
    p = add_epsg_def (filter, first, last, 32183, "epsg", 32183,
        "NAD83 / MTM zone 3");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-58.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / MTM zone 3\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-58.5],PARAMETER[\"scale_factor\",0.9999],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",304800],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"E(X)\",EAST],AXIS[\"N(Y)\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"32183\"]]");
    p = add_epsg_def (filter, first, last, 32184, "epsg", 32184,
        "NAD83 / MTM zone 4");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-61.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / MTM zone 4\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-61.5],PARAMETER[\"scale_factor\",0.9999],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",304800],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"E(X)\",EAST],AXIS[\"N(Y)\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"32184\"]]");
    p = add_epsg_def (filter, first, last, 32185, "epsg", 32185,
        "NAD83 / MTM zone 5");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-64.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / MTM zone 5\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-64.5],PARAMETER[\"scale_factor\",0.9999],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",304800],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"E(X)\",EAST],AXIS[\"N(Y)\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"32185\"]]");
    p = add_epsg_def (filter, first, last, 32186, "epsg", 32186,
        "NAD83 / MTM zone 6");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-67.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / MTM zone 6\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-67.5],PARAMETER[\"scale_factor\",0.9999],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",304800],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"E(X)\",EAST],AXIS[\"N(Y)\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"32186\"]]");
    p = add_epsg_def (filter, first, last, 32187, "epsg", 32187,
        "NAD83 / MTM zone 7");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-70.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / MTM zone 7\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-70.5],PARAMETER[\"scale_factor\",0.9999],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",304800],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"E(X)\",EAST],AXIS[\"N(Y)\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"32187\"]]");
    p = add_epsg_def (filter, first, last, 32188, "epsg", 32188,
        "NAD83 / MTM zone 8");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-73.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / MTM zone 8\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-73.5],PARAMETER[\"scale_factor\",0.9999],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",304800],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"E(X)\",EAST],AXIS[\"N(Y)\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"32188\"]]");
    p = add_epsg_def (filter, first, last, 32189, "epsg", 32189,
        "NAD83 / MTM zone 9");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-76.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / MTM zone 9\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-76.5],PARAMETER[\"scale_factor\",0.9999],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",304800],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"E(X)\",EAST],AXIS[\"N(Y)\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"32189\"]]");
    p = add_epsg_def (filter, first, last, 32190, "epsg", 32190,
        "NAD83 / MTM zone 10");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-79.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / MTM zone 10\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-79.5],PARAMETER[\"scale_factor\",0.9999],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",304800],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"E(X)\",EAST],AXIS[\"N(Y)\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"32190\"]]");
    p = add_epsg_def (filter, first, last, 32191, "epsg", 32191,
        "NAD83 / MTM zone 11");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-82.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / MTM zone 11\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-82.5],PARAMETER[\"scale_factor\",0.9999],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",304800],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"32191\"]]");
    p = add_epsg_def (filter, first, last, 32192, "epsg", 32192,
        "NAD83 / MTM zone 12");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-81 +k=0.9999 +x_0=304800 +y");
    add_proj4text (p, 1,
        "_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / MTM zone 12\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-81],PARAMETER[\"scale_factor\",0.9999],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",304800],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"32192\"]]");
    p = add_epsg_def (filter, first, last, 32193, "epsg", 32193,
        "NAD83 / MTM zone 13");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-84 +k=0.9999 +x_0=304800 +y");
    add_proj4text (p, 1,
        "_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / MTM zone 13\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-84],PARAMETER[\"scale_factor\",0.9999],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",304800],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"32193\"]]");
    p = add_epsg_def (filter, first, last, 32194, "epsg", 32194,
        "NAD83 / MTM zone 14");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-87 +k=0.9999 +x_0=304800 +y");
    add_proj4text (p, 1,
        "_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / MTM zone 14\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-87],PARAMETER[\"scale_factor\",0.9999],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",304800],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"32194\"]]");
    p = add_epsg_def (filter, first, last, 32195, "epsg", 32195,
        "NAD83 / MTM zone 15");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-90 +k=0.9999 +x_0=304800 +y");
    add_proj4text (p, 1,
        "_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / MTM zone 15\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-90],PARAMETER[\"scale_factor\",0.9999],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",304800],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"32195\"]]");
    p = add_epsg_def (filter, first, last, 32196, "epsg", 32196,
        "NAD83 / MTM zone 16");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-93 +k=0.9999 +x_0=304800 +y");
    add_proj4text (p, 1,
        "_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / MTM zone 16\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-93],PARAMETER[\"scale_factor\",0.9999],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",304800],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"32196\"]]");
    p = add_epsg_def (filter, first, last, 32197, "epsg", 32197,
        "NAD83 / MTM zone 17");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-96 +k=0.9999 +x_0=304800 +y");
    add_proj4text (p, 1,
        "_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / MTM zone 17\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-96],PARAMETER[\"scale_factor\",0.9999],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",304800],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"32197\"]]");
    p = add_epsg_def (filter, first, last, 32198, "epsg", 32198,
        "NAD83 / Quebec Lambert");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=60 +lat_2=46 +lat_0=44 +lon_0=-68.5 +x_");
    add_proj4text (p, 1,
        "0=0 +y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Quebec Lambert\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 7,
        "_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",60],PARA");
    add_srs_wkt (p, 8,
        "METER[\"standard_parallel_2\",46],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 9,
        "f_origin\",44],PARAMETER[\"central_meridian\",-68.5],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32198");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def (filter, first, last, 32199, "epsg", 32199,
        "NAD83 / Louisiana Offshore");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666");
    add_proj4text (p, 1,
        "667 +lat_0=25.5 +lon_0=-91.33333333333333 +x_0=1000000 +");
    add_proj4text (p, 2,
        "y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Louisiana Offshore\",GEOGCS[\"NAD83\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
        "rmal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",27.8");
    add_srs_wkt (p, 8,
        "3333333333333],PARAMETER[\"standard_parallel_2\",26.1666");
    add_srs_wkt (p, 9,
        "6666666667],PARAMETER[\"latitude_of_origin\",25.5],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"central_meridian\",-91.33333333333333],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_easting\",1000000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 12,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32199\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def (filter, first, last, 32201, "epsg", 32201,
        "WGS 72 / UTM zone 1N");
    add_proj4text (p, 0,
        "+proj=utm +zone=1 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.55");
    add_proj4text (p, 1,
        "4,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 1N\",GEOGCS[\"WGS 72\",DATUM[");
    add_srs_wkt (p, 1,
        "\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "177],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32201\"]]");
    p = add_epsg_def (filter, first, last, 32202, "epsg", 32202,
        "WGS 72 / UTM zone 2N");
    add_proj4text (p, 0,
        "+proj=utm +zone=2 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.55");
    add_proj4text (p, 1,
        "4,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 2N\",GEOGCS[\"WGS 72\",DATUM[");
    add_srs_wkt (p, 1,
        "\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "171],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32202\"]]");
    p = add_epsg_def (filter, first, last, 32203, "epsg", 32203,
        "WGS 72 / UTM zone 3N");
    add_proj4text (p, 0,
        "+proj=utm +zone=3 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.55");
    add_proj4text (p, 1,
        "4,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 3N\",GEOGCS[\"WGS 72\",DATUM[");
    add_srs_wkt (p, 1,
        "\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "165],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32203\"]]");
    p = add_epsg_def (filter, first, last, 32204, "epsg", 32204,
        "WGS 72 / UTM zone 4N");
    add_proj4text (p, 0,
        "+proj=utm +zone=4 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.55");
    add_proj4text (p, 1,
        "4,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 4N\",GEOGCS[\"WGS 72\",DATUM[");
    add_srs_wkt (p, 1,
        "\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "159],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32204\"]]");
    p = add_epsg_def (filter, first, last, 32205, "epsg", 32205,
        "WGS 72 / UTM zone 5N");
    add_proj4text (p, 0,
        "+proj=utm +zone=5 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.55");
    add_proj4text (p, 1,
        "4,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 5N\",GEOGCS[\"WGS 72\",DATUM[");
    add_srs_wkt (p, 1,
        "\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "153],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32205\"]]");
    p = add_epsg_def (filter, first, last, 32206, "epsg", 32206,
        "WGS 72 / UTM zone 6N");
    add_proj4text (p, 0,
        "+proj=utm +zone=6 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.55");
    add_proj4text (p, 1,
        "4,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 6N\",GEOGCS[\"WGS 72\",DATUM[");
    add_srs_wkt (p, 1,
        "\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "147],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32206\"]]");
    p = add_epsg_def (filter, first, last, 32207, "epsg", 32207,
        "WGS 72 / UTM zone 7N");
    add_proj4text (p, 0,
        "+proj=utm +zone=7 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.55");
    add_proj4text (p, 1,
        "4,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 7N\",GEOGCS[\"WGS 72\",DATUM[");
    add_srs_wkt (p, 1,
        "\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "141],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32207\"]]");
    p = add_epsg_def (filter, first, last, 32208, "epsg", 32208,
        "WGS 72 / UTM zone 8N");
    add_proj4text (p, 0,
        "+proj=utm +zone=8 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.55");
    add_proj4text (p, 1,
        "4,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 8N\",GEOGCS[\"WGS 72\",DATUM[");
    add_srs_wkt (p, 1,
        "\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "135],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32208\"]]");
    p = add_epsg_def (filter, first, last, 32209, "epsg", 32209,
        "WGS 72 / UTM zone 9N");
    add_proj4text (p, 0,
        "+proj=utm +zone=9 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.55");
    add_proj4text (p, 1,
        "4,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 9N\",GEOGCS[\"WGS 72\",DATUM[");
    add_srs_wkt (p, 1,
        "\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "129],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32209\"]]");
    p = add_epsg_def (filter, first, last, 32210, "epsg", 32210,
        "WGS 72 / UTM zone 10N");
    add_proj4text (p, 0,
        "+proj=utm +zone=10 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 10N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-123],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 11,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"32210\"]]");
    p = add_epsg_def (filter, first, last, 32211, "epsg", 32211,
        "WGS 72 / UTM zone 11N");
    add_proj4text (p, 0,
        "+proj=utm +zone=11 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 11N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-117],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 11,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"32211\"]]");
    p = add_epsg_def (filter, first, last, 32212, "epsg", 32212,
        "WGS 72 / UTM zone 12N");
    add_proj4text (p, 0,
        "+proj=utm +zone=12 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 12N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-111],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 11,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"32212\"]]");
    p = add_epsg_def (filter, first, last, 32213, "epsg", 32213,
        "WGS 72 / UTM zone 13N");
    add_proj4text (p, 0,
        "+proj=utm +zone=13 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 13N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-105],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 11,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"32213\"]]");
    p = add_epsg_def (filter, first, last, 32214, "epsg", 32214,
        "WGS 72 / UTM zone 14N");
    add_proj4text (p, 0,
        "+proj=utm +zone=14 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 14N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-99],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32214\"]]");
    p = add_epsg_def (filter, first, last, 32215, "epsg", 32215,
        "WGS 72 / UTM zone 15N");
    add_proj4text (p, 0,
        "+proj=utm +zone=15 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 15N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-93],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32215\"]]");
    p = add_epsg_def (filter, first, last, 32216, "epsg", 32216,
        "WGS 72 / UTM zone 16N");
    add_proj4text (p, 0,
        "+proj=utm +zone=16 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 16N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-87],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32216\"]]");
    p = add_epsg_def (filter, first, last, 32217, "epsg", 32217,
        "WGS 72 / UTM zone 17N");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 17N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-81],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32217\"]]");
    p = add_epsg_def (filter, first, last, 32218, "epsg", 32218,
        "WGS 72 / UTM zone 18N");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 18N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-75],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32218\"]]");
    p = add_epsg_def (filter, first, last, 32219, "epsg", 32219,
        "WGS 72 / UTM zone 19N");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 19N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-69],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32219\"]]");
    p = add_epsg_def (filter, first, last, 32220, "epsg", 32220,
        "WGS 72 / UTM zone 20N");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 20N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-63],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32220\"]]");
    p = add_epsg_def (filter, first, last, 32221, "epsg", 32221,
        "WGS 72 / UTM zone 21N");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 21N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-57],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32221\"]]");
    p = add_epsg_def (filter, first, last, 32222, "epsg", 32222,
        "WGS 72 / UTM zone 22N");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 22N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-51],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32222\"]]");
    p = add_epsg_def (filter, first, last, 32223, "epsg", 32223,
        "WGS 72 / UTM zone 23N");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 23N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-45],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32223\"]]");
    p = add_epsg_def (filter, first, last, 32224, "epsg", 32224,
        "WGS 72 / UTM zone 24N");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 24N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-39],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32224\"]]");
    p = add_epsg_def (filter, first, last, 32225, "epsg", 32225,
        "WGS 72 / UTM zone 25N");
    add_proj4text (p, 0,
        "+proj=utm +zone=25 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 25N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-33],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32225\"]]");
    p = add_epsg_def (filter, first, last, 32226, "epsg", 32226,
        "WGS 72 / UTM zone 26N");
    add_proj4text (p, 0,
        "+proj=utm +zone=26 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 26N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-27],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32226\"]]");
    p = add_epsg_def (filter, first, last, 32227, "epsg", 32227,
        "WGS 72 / UTM zone 27N");
    add_proj4text (p, 0,
        "+proj=utm +zone=27 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 27N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-21],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32227\"]]");
    p = add_epsg_def (filter, first, last, 32228, "epsg", 32228,
        "WGS 72 / UTM zone 28N");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 28N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-15],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32228\"]]");
    p = add_epsg_def (filter, first, last, 32229, "epsg", 32229,
        "WGS 72 / UTM zone 29N");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 29N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32229\"]]");
    p = add_epsg_def (filter, first, last, 32230, "epsg", 32230,
        "WGS 72 / UTM zone 30N");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 30N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32230\"]]");
    p = add_epsg_def (filter, first, last, 32231, "epsg", 32231,
        "WGS 72 / UTM zone 31N");
    add_proj4text (p, 0,
        "+proj=utm +zone=31 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 31N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 12,
        "2231\"]]");
    p = add_epsg_def (filter, first, last, 32232, "epsg", 32232,
        "WGS 72 / UTM zone 32N");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 32N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 12,
        "2232\"]]");
    p = add_epsg_def (filter, first, last, 32233, "epsg", 32233,
        "WGS 72 / UTM zone 33N");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 33N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",15],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32233\"]]");
    p = add_epsg_def (filter, first, last, 32234, "epsg", 32234,
        "WGS 72 / UTM zone 34N");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 34N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",21],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32234\"]]");
    p = add_epsg_def (filter, first, last, 32235, "epsg", 32235,
        "WGS 72 / UTM zone 35N");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 35N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",27],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32235\"]]");
    p = add_epsg_def (filter, first, last, 32236, "epsg", 32236,
        "WGS 72 / UTM zone 36N");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 36N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",33],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32236\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

