% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join.R
\name{stri_join_list}
\alias{stri_join_list}
\alias{stri_c_list}
\alias{stri_paste_list}
\title{Concatenate Strings in a List}
\usage{
stri_join_list(x, sep = "", collapse = NULL)

stri_c_list(x, sep = "", collapse = NULL)

stri_paste_list(x, sep = "", collapse = NULL)
}
\arguments{
\item{x}{a list consisting of character vectors}

\item{sep}{a single string; separates strings in each of the character
vectors in \code{x}}

\item{collapse}{a single string or \code{NULL}; an optional
results separator}
}
\value{
Returns a character vector.
}
\description{
These functions concatenate all the strings in each character vector
in a given list.
\code{stri_c_list} and \code{stri_paste_list} are aliases for
\code{stri_join_list}.
}
\details{
Unless \code{collapse} is \code{NULL}, the result will be a single string.
Otherwise, you get a character vector of length equal
to the length of \code{x}.

Vectors in \code{x} of length 0 are silently ignored.

If \code{collapse} or \code{sep} has length greater than 1,
then only the first string will be used.
}
\examples{
stri_join_list(
   stri_extract_all_words(c("Lorem ipsum dolor sit amet.",
   "Spam spam bacon sausage and spam.")),
sep=", ")

stri_join_list(
   stri_extract_all_words(c("Lorem ipsum dolor sit amet.",
   "Spam spam bacon sausage and spam.")),
sep=", ", collapse=". ")

stri_join_list(
   stri_extract_all_regex(
      c("spam spam bacon", "123 456", "spam 789 sausage"), "\\\\p{L}+"
   ),
sep=",")

stri_join_list(
   stri_extract_all_regex(
      c("spam spam bacon", "123 456", "spam 789 sausage"), "\\\\p{L}+",
      omit_no_match=TRUE
   ),
sep=",", collapse="; ")

}
\seealso{
Other join: 
\code{\link{\%s+\%}()},
\code{\link{stri_dup}()},
\code{\link{stri_flatten}()},
\code{\link{stri_join}()}
}
\concept{join}
