% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svyglmnb.R
\name{svyglm.nb}
\alias{svyglm.nb}
\title{Survey-weighted negative binomial generalised linear model}
\usage{
svyglm.nb(formula, design, ...)
}
\arguments{
\item{formula}{An object of class \code{formula}, i.e. a symbolic description
of the model to be fitted. See 'Details' in \code{\link[stats]{glm}}.}

\item{design}{An object of class \code{\link[survey]{svydesign}}, providing
a specification of the survey design.}

\item{...}{Other arguments passed down to \code{\link[MASS]{glm.nb}}.}
}
\value{
An object of class \code{\link[survey]{svymle}} and \code{svyglm.nb},
with some additional information about the model.
}
\description{
\code{svyglm.nb()} is an extension to the \CRANpkg{survey}-package
to fit survey-weighted negative binomial models. It uses
\code{\link[survey]{svymle}} to fit sampling-weighted
maximum likelihood estimates, based on starting values provided
by \code{\link[MASS]{glm.nb}}, as proposed by \emph{Lumley
(2010, pp249)}.
}
\details{
For details on the computation method, see Lumley (2010), Appendix E
(especially 254ff.)
\cr \cr
\pkg{sjstats} implements following S3-methods for \code{svyglm.nb}-objects:
\code{family()}, \code{model.frame()}, \code{formula()}, \code{print()},
\code{predict()} and \code{residuals()}. However, these functions have some
limitations:
\itemize{
\item{\code{family()} simply returns the family-object from the
underlying \code{\link[MASS]{glm.nb}}-model.}
\item{The \code{predict()}-method just re-fits the \code{svyglm.nb}-model
with \code{\link[MASS]{glm.nb}}, overwrites the \code{$coefficients}
from this model-object with the coefficients from the returned
\code{\link[survey]{svymle}}-object and finally calls
\code{\link[stats]{predict.glm}} to compute the predicted values.}
\item{\code{residuals()} re-fits the \code{svyglm.nb}-model with
\code{\link[MASS]{glm.nb}} and then computes the Pearson-residuals
from the \code{glm.nb}-object.}
}
}
\examples{
# ------------------------------------------
# This example reproduces the results from
# Lumley 2010, figure E.7 (Appendix E, p256)
# ------------------------------------------
if (require("survey")) {
  data(nhanes_sample)

  # create survey design
  des <- svydesign(
    id = ~SDMVPSU,
    strat = ~SDMVSTRA,
    weights = ~WTINT2YR,
    nest = TRUE,
    data = nhanes_sample
  )

  # fit negative binomial regression
  fit <- svyglm.nb(total ~ factor(RIAGENDR) * (log(age) + factor(RIDRETH1)), des)

  # print coefficients and standard errors
  fit
}
}
\references{
Lumley T (2010). Complex Surveys: a guide to analysis using R. Wiley
}
