	INTEGER FUNCTION DATE_PREC( grid, idim, dt )

*
*
*  This software was developed by the Thermal Modeling and Analysis
*  Project(TMAP) of the National Oceanographic and Atmospheric
*  Administration's (NOAA) Pacific Marine Environmental Lab(PMEL),
*  hereafter referred to as NOAA/PMEL/TMAP.
*
*  Access and use of this software shall impose the following
*  obligations and understandings on the user. The user is granted the
*  right, without any fee or cost, to use, copy, modify, alter, enhance
*  and distribute this software, and any derivative works thereof, and
*  its supporting documentation for any purpose whatsoever, provided
*  that this entire notice appears in all copies of the software,
*  derivative works and supporting documentation.  Further, the user
*  agrees to credit NOAA/PMEL/TMAP in any publications that result from
*  the use of this software or in any product that includes this
*  software. The names TMAP, NOAA and/or PMEL, however, may not be used
*  in any advertising or publicity to endorse or promote any products
*  or commercial entity unless specific written permission is obtained
*  from NOAA/PMEL/TMAP. The user also understands that NOAA/PMEL/TMAP
*  is not obligated to provide the user with any support, consulting,
*  training or assistance of any kind with regard to the use, operation
*  and performance of this software nor to provide the user with any
*  updates, revisions, new versions or "bug fixes".
*
*  THIS SOFTWARE IS PROVIDED BY NOAA/PMEL/TMAP "AS IS" AND ANY EXPRESS
*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
*  ARE DISCLAIMED. IN NO EVENT SHALL NOAA/PMEL/TMAP BE LIABLE FOR ANY SPECIAL,
*  INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
*  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
*  CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
*  CONNECTION WITH THE ACCESS, USE OR PERFORMANCE OF THIS SOFTWARE. 
*
*
* determine the precision level needed for a date string to resolve "dt"
* in units appropriate for the given grid time axis

* programmer - steve hankin
* NOAA/PMEL, Seattle, WA - Tropical Modeling and Analysis Program
* written for VAX computer under VMS operating system
*
* revision 0.0 - 3/18/88
*       *acm* 3/12 cleanup ifdefs and unnecessary include files
*       *acm* 4/12 6D Ferret: time axis may be in t or f direction. 
* V71 12/16 *acm* For ticket 2158: working with true monthly time axes.

	include 'tmap_dims.parm'
	include 'xtm_grid.cmn_text'
	external xgt_grid_data
        include 'xunits.cmn_text'
	include	'ferret.parm'

* calling argument declarations
	INTEGER	grid, idim
	REAL	dt

* internal variable declarations:
	LOGICAL ITSA_TRUEMONTH_AXIS
	INTEGER	i
	REAL	convert(5), delta
	DATA	convert(1)/ 60. /,	! sec --> min
     .		convert(2)/ 60. /,	! min --> hour
     .		convert(3)/ 24. /,	! hr  --> day
     .		convert(4)/ 30. /,	! day --> mon
     .		convert(5)/ 12. /	! mon --> year

* get the dt interval expressed in seconds
	delta = dt * line_tunit( grid_line(idim,grid) )

* A true-month axis has line-units of month, but output units of days
	IF (ITSA_TRUEMONTH_AXIS(grid_line(idim,grid))) delta = dt * un_convert(pun_day)

* see how big it is
	DO 100 i = 1, 5
	   delta = delta / convert(i)
	   IF ( delta .LT. 1.0 ) THEN
	      DATE_PREC = 7-i
	      RETURN
	   ENDIF
 100	CONTINUE

* very big ! use years, only to label
	DATE_PREC = 1
	RETURN
	END
