/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <GlobalAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for GlobalAttributes::PrecisionType
//

static const char *PrecisionType_strings[] = {
"Float", "Native", "Double"
};

std::string
GlobalAttributes::PrecisionType_ToString(GlobalAttributes::PrecisionType t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return PrecisionType_strings[index];
}

std::string
GlobalAttributes::PrecisionType_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return PrecisionType_strings[index];
}

bool
GlobalAttributes::PrecisionType_FromString(const std::string &s, GlobalAttributes::PrecisionType &val)
{
    val = GlobalAttributes::Float;
    for(int i = 0; i < 3; ++i)
    {
        if(s == PrecisionType_strings[i])
        {
            val = (PrecisionType)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for GlobalAttributes::BackendType
//

static const char *BackendType_strings[] = {
"VTK", "EAVL", "VTKM"
};

std::string
GlobalAttributes::BackendType_ToString(GlobalAttributes::BackendType t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return BackendType_strings[index];
}

std::string
GlobalAttributes::BackendType_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return BackendType_strings[index];
}

bool
GlobalAttributes::BackendType_FromString(const std::string &s, GlobalAttributes::BackendType &val)
{
    val = GlobalAttributes::VTK;
    for(int i = 0; i < 3; ++i)
    {
        if(s == BackendType_strings[i])
        {
            val = (BackendType)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: GlobalAttributes::GlobalAttributes
//
// Purpose: 
//   Init utility for the GlobalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void GlobalAttributes::Init()
{
    activeWindow = 1;
    iconifiedFlag = false;
    autoUpdateFlag = false;
    replacePlots = false;
    applyOperator = true;
    applySelection = true;
    applyWindow = false;
    executing = false;
    windowLayout = 1;
    makeDefaultConfirm = true;
    cloneWindowOnFirstRef = false;
    automaticallyAddOperator = false;
    tryHarderCyclesTimes = false;
    treatAllDBsAsTimeVarying = false;
    createMeshQualityExpressions = true;
    createTimeDerivativeExpressions = true;
    createVectorMagnitudeExpressions = true;
    newPlotsInheritSILRestriction = true;
#ifdef WIN32
    userDirForSessionFiles = true;
#else
    userDirForSessionFiles = false;
#endif
    saveCrashRecoveryFile = true;
    ignoreExtentsFromDbs = false;
    expandNewPlots = false;
    userRestoreSessionFile = false;
    precisionType = Native;
    backendType = VTK;
    removeDuplicateNodes = false;

    GlobalAttributes::SelectAll();
}

// ****************************************************************************
// Method: GlobalAttributes::GlobalAttributes
//
// Purpose: 
//   Copy utility for the GlobalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void GlobalAttributes::Copy(const GlobalAttributes &obj)
{
    sources = obj.sources;
    windows = obj.windows;
    activeWindow = obj.activeWindow;
    iconifiedFlag = obj.iconifiedFlag;
    autoUpdateFlag = obj.autoUpdateFlag;
    replacePlots = obj.replacePlots;
    applyOperator = obj.applyOperator;
    applySelection = obj.applySelection;
    applyWindow = obj.applyWindow;
    executing = obj.executing;
    windowLayout = obj.windowLayout;
    makeDefaultConfirm = obj.makeDefaultConfirm;
    cloneWindowOnFirstRef = obj.cloneWindowOnFirstRef;
    automaticallyAddOperator = obj.automaticallyAddOperator;
    tryHarderCyclesTimes = obj.tryHarderCyclesTimes;
    treatAllDBsAsTimeVarying = obj.treatAllDBsAsTimeVarying;
    createMeshQualityExpressions = obj.createMeshQualityExpressions;
    createTimeDerivativeExpressions = obj.createTimeDerivativeExpressions;
    createVectorMagnitudeExpressions = obj.createVectorMagnitudeExpressions;
    newPlotsInheritSILRestriction = obj.newPlotsInheritSILRestriction;
    userDirForSessionFiles = obj.userDirForSessionFiles;
    saveCrashRecoveryFile = obj.saveCrashRecoveryFile;
    ignoreExtentsFromDbs = obj.ignoreExtentsFromDbs;
    expandNewPlots = obj.expandNewPlots;
    userRestoreSessionFile = obj.userRestoreSessionFile;
    precisionType = obj.precisionType;
    backendType = obj.backendType;
    removeDuplicateNodes = obj.removeDuplicateNodes;

    GlobalAttributes::SelectAll();
}

// Type map format string
const char *GlobalAttributes::TypeMapFormatString = GLOBALATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t GlobalAttributes::TmfsStruct = {GLOBALATTRIBUTES_TMFS};


// ****************************************************************************
// Method: GlobalAttributes::GlobalAttributes
//
// Purpose: 
//   Default constructor for the GlobalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

GlobalAttributes::GlobalAttributes() : 
    AttributeSubject(GlobalAttributes::TypeMapFormatString)
{
    GlobalAttributes::Init();
}

// ****************************************************************************
// Method: GlobalAttributes::GlobalAttributes
//
// Purpose: 
//   Constructor for the derived classes of GlobalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

GlobalAttributes::GlobalAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    GlobalAttributes::Init();
}

// ****************************************************************************
// Method: GlobalAttributes::GlobalAttributes
//
// Purpose: 
//   Copy constructor for the GlobalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

GlobalAttributes::GlobalAttributes(const GlobalAttributes &obj) : 
    AttributeSubject(GlobalAttributes::TypeMapFormatString)
{
    GlobalAttributes::Copy(obj);
}

// ****************************************************************************
// Method: GlobalAttributes::GlobalAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the GlobalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

GlobalAttributes::GlobalAttributes(const GlobalAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    GlobalAttributes::Copy(obj);
}

// ****************************************************************************
// Method: GlobalAttributes::~GlobalAttributes
//
// Purpose: 
//   Destructor for the GlobalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

GlobalAttributes::~GlobalAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: GlobalAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the GlobalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

GlobalAttributes& 
GlobalAttributes::operator = (const GlobalAttributes &obj)
{
    if (this == &obj) return *this;

    GlobalAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: GlobalAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the GlobalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
GlobalAttributes::operator == (const GlobalAttributes &obj) const
{
    // Create the return value
    return ((sources == obj.sources) &&
            (windows == obj.windows) &&
            (activeWindow == obj.activeWindow) &&
            (iconifiedFlag == obj.iconifiedFlag) &&
            (autoUpdateFlag == obj.autoUpdateFlag) &&
            (replacePlots == obj.replacePlots) &&
            (applyOperator == obj.applyOperator) &&
            (applySelection == obj.applySelection) &&
            (applyWindow == obj.applyWindow) &&
            (executing == obj.executing) &&
            (windowLayout == obj.windowLayout) &&
            (makeDefaultConfirm == obj.makeDefaultConfirm) &&
            (cloneWindowOnFirstRef == obj.cloneWindowOnFirstRef) &&
            (automaticallyAddOperator == obj.automaticallyAddOperator) &&
            (tryHarderCyclesTimes == obj.tryHarderCyclesTimes) &&
            (treatAllDBsAsTimeVarying == obj.treatAllDBsAsTimeVarying) &&
            (createMeshQualityExpressions == obj.createMeshQualityExpressions) &&
            (createTimeDerivativeExpressions == obj.createTimeDerivativeExpressions) &&
            (createVectorMagnitudeExpressions == obj.createVectorMagnitudeExpressions) &&
            (newPlotsInheritSILRestriction == obj.newPlotsInheritSILRestriction) &&
            (userDirForSessionFiles == obj.userDirForSessionFiles) &&
            (saveCrashRecoveryFile == obj.saveCrashRecoveryFile) &&
            (ignoreExtentsFromDbs == obj.ignoreExtentsFromDbs) &&
            (expandNewPlots == obj.expandNewPlots) &&
            (userRestoreSessionFile == obj.userRestoreSessionFile) &&
            (precisionType == obj.precisionType) &&
            (backendType == obj.backendType) &&
            (removeDuplicateNodes == obj.removeDuplicateNodes));
}

// ****************************************************************************
// Method: GlobalAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the GlobalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
GlobalAttributes::operator != (const GlobalAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: GlobalAttributes::TypeName
//
// Purpose: 
//   Type name method for the GlobalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
GlobalAttributes::TypeName() const
{
    return "GlobalAttributes";
}

// ****************************************************************************
// Method: GlobalAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the GlobalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
GlobalAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const GlobalAttributes *tmp = (const GlobalAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: GlobalAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the GlobalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
GlobalAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new GlobalAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: GlobalAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the GlobalAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
GlobalAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new GlobalAttributes(*this);
    else
        retval = new GlobalAttributes;

    return retval;
}

// ****************************************************************************
// Method: GlobalAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
GlobalAttributes::SelectAll()
{
    Select(ID_sources,                          (void *)&sources);
    Select(ID_windows,                          (void *)&windows);
    Select(ID_activeWindow,                     (void *)&activeWindow);
    Select(ID_iconifiedFlag,                    (void *)&iconifiedFlag);
    Select(ID_autoUpdateFlag,                   (void *)&autoUpdateFlag);
    Select(ID_replacePlots,                     (void *)&replacePlots);
    Select(ID_applyOperator,                    (void *)&applyOperator);
    Select(ID_applySelection,                   (void *)&applySelection);
    Select(ID_applyWindow,                      (void *)&applyWindow);
    Select(ID_executing,                        (void *)&executing);
    Select(ID_windowLayout,                     (void *)&windowLayout);
    Select(ID_makeDefaultConfirm,               (void *)&makeDefaultConfirm);
    Select(ID_cloneWindowOnFirstRef,            (void *)&cloneWindowOnFirstRef);
    Select(ID_automaticallyAddOperator,         (void *)&automaticallyAddOperator);
    Select(ID_tryHarderCyclesTimes,             (void *)&tryHarderCyclesTimes);
    Select(ID_treatAllDBsAsTimeVarying,         (void *)&treatAllDBsAsTimeVarying);
    Select(ID_createMeshQualityExpressions,     (void *)&createMeshQualityExpressions);
    Select(ID_createTimeDerivativeExpressions,  (void *)&createTimeDerivativeExpressions);
    Select(ID_createVectorMagnitudeExpressions, (void *)&createVectorMagnitudeExpressions);
    Select(ID_newPlotsInheritSILRestriction,    (void *)&newPlotsInheritSILRestriction);
    Select(ID_userDirForSessionFiles,           (void *)&userDirForSessionFiles);
    Select(ID_saveCrashRecoveryFile,            (void *)&saveCrashRecoveryFile);
    Select(ID_ignoreExtentsFromDbs,             (void *)&ignoreExtentsFromDbs);
    Select(ID_expandNewPlots,                   (void *)&expandNewPlots);
    Select(ID_userRestoreSessionFile,           (void *)&userRestoreSessionFile);
    Select(ID_precisionType,                    (void *)&precisionType);
    Select(ID_backendType,                      (void *)&backendType);
    Select(ID_removeDuplicateNodes,             (void *)&removeDuplicateNodes);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: GlobalAttributes::CreateNode
//
// Purpose: 
//   Creates a node called "GlobalAttributes" that has all of the 
//   GlobalAttributes in it.
//
// Arguments:
//   parentNode   : The node under which the globalAtts node is created.
//   completeSave : Tells the method to save all fields even if they are not
//                  different.
//   forceAdd     : Tells the method to add a node to the parent node.
//
// Notes:
//   Only a handful of the attributes that this object contains are
//   made persistent. Other values are not good to save out since they
//   would have to update the state in other state objects in order to
//   work properly. Eventually, we might do that.
//
// Programmer: Brad Whitlock
// Creation:   Thu Sep 28 13:02:04 PST 2000
//
// Modifications:
//   Brad Whitlock, Mon Sep 16 14:50:20 PST 2002
//   I added the window layout.
//
//   Brad Whitlock, Mon Nov 4 13:51:39 PST 2002
//   I added makeDefaultConfirmation.
//
//   Eric Brugger, Thu Mar 13 14:05:40 PST 2003
//   I added cloneWindowOnFirstRef.
//
//   Brad Whitlock, Thu Mar 20 10:19:35 PDT 2003
//   I removed maintainView and maintainData.
//
//   Eric Brugger, Fri Apr 18 10:27:53 PDT 2003
//   I added maintainView.
//
//   Brad Whitlock, Tue May 20 10:43:27 PDT 2003
//   I made it made it save only what differs from the defaults.
//
//   Brad Whitlock, Wed Dec 17 12:09:40 PDT 2003
//   I added a completeSave flag.
//
//   Brad Whitlock, Fri Jan 23 16:16:02 PST 2004
//   I changed the numbering due to a change in attribute ordering.
//
//   Eric Brugger, Tue Mar 30 08:39:07 PST 2004
//   I added maintainData.
//
//   Brad Whitlock, Thu Aug 5 16:48:46 PST 2004
//   I added automaticallyAddOperator.
//
//   Mark C. Miller, Thu Mar 22 13:32:05 PDT 2007
//   Added tryHarderCyclesTimes
//
//   Hank Childs, Wed Aug 15 18:42:46 CDT 2007
//   Added treatAllDBsAsTimeVarying.
//
//   Kathleen Bonnell, Mon Oct  8 18:17:24 PDT 2007 
//   Added createMeshQuality/TimeDerivativeExpressions.
//
//   Cyrus Harrison, Wed Nov 28 15:22:42 PST 2007
//   Added createVectorMagnitudeExpressions
//
//   Brad Whitlock, Fri Dec 14 15:02:46 PST 2007
//   Made it use IDs.
//
//   Brad Whitlock, Thu Jan 24 11:34:45 PDT 2008
//   Made it save newPlotsInheritSILRestriction.
//
//   Brad Whitlock, Thu Jan 31 10:03:01 PST 2008
//   Made it save userDirForSessionFiles, saveCrashRecovery.
//
//   Gunther H. Weber, Mon Feb  4 15:13:11 PST 2008
//   Made it save applySelection.
//
//   Jeremy Meredith, Wed Feb  3 14:54:47 EST 2010
//   Removed maintainData, moved maintainView to view settings, not global.
//
//   Kathleen Biagas, Thu Jul 25 13:47:07 PDT 2013
//   Add precision.
//
//   David Camp, Thu Aug  8 08:50:06 PDT 2013
//   Added the restore from last session feature. 
//
//   Cameron Christensen, Tuesday, June 10, 2014 
//   Add backend.
//
// ****************************************************************************

bool
GlobalAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    bool addToParent = false;
    GlobalAttributes defaultObject;

    // Create a node for GlobalAttributes.
    DataNode *node = new DataNode("GlobalAttributes");

    if(completeSave || !FieldsEqual(ID_autoUpdateFlag, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("autoUpdateFlag", autoUpdateFlag));
    }

    if(completeSave || !FieldsEqual(ID_replacePlots, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("replacePlots", replacePlots));
    }

    if(completeSave || !FieldsEqual(ID_applyWindow, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("applyWindow", applyWindow));
    }

    if(completeSave || !FieldsEqual(ID_applyOperator, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("applyOperator", applyOperator));
    }

    if(completeSave || !FieldsEqual(ID_windowLayout, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("windowLayout", windowLayout));
    }

    if(completeSave || !FieldsEqual(ID_makeDefaultConfirm, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("makeDefaultConfirm", makeDefaultConfirm));
    }

    if(completeSave || !FieldsEqual(ID_cloneWindowOnFirstRef, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("cloneWindowOnFirstRef",
                                    cloneWindowOnFirstRef));
    }

    if(completeSave || !FieldsEqual(ID_automaticallyAddOperator, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("automaticallyAddOperator",
            automaticallyAddOperator));
    }

    if(completeSave || !FieldsEqual(ID_tryHarderCyclesTimes, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("tryHarderCyclesTimes",
            tryHarderCyclesTimes));
    }

    if(completeSave || !FieldsEqual(ID_treatAllDBsAsTimeVarying, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("treatAllDBsAsTimeVarying",
                      treatAllDBsAsTimeVarying));
    }

    if(completeSave || !FieldsEqual(ID_createMeshQualityExpressions, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("createMeshQualityExpressions",
                      createMeshQualityExpressions));
    }

    if(completeSave || !FieldsEqual(ID_createTimeDerivativeExpressions, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("createTimeDerivativeExpressions",
                      createTimeDerivativeExpressions));
    }

    if(completeSave || !FieldsEqual(ID_createVectorMagnitudeExpressions, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("createVectorMagnitudeExpressions",
                      createVectorMagnitudeExpressions));
    }

    if(completeSave || !FieldsEqual(ID_newPlotsInheritSILRestriction, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("newPlotsInheritSILRestriction",
                      newPlotsInheritSILRestriction));
    }

    if(completeSave || !FieldsEqual(ID_userDirForSessionFiles, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("userDirForSessionFiles",
                      userDirForSessionFiles));
    }

    if(completeSave || !FieldsEqual(ID_saveCrashRecoveryFile, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("saveCrashRecoveryFile",
                      saveCrashRecoveryFile));
    }

    if(completeSave || !FieldsEqual(ID_applySelection, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("applySelection",
                      applySelection));
    }

    if(completeSave || !FieldsEqual(ID_userRestoreSessionFile, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("userRestoreSessionFile",
                      userRestoreSessionFile));
    }

    if(completeSave || !FieldsEqual(ID_precisionType, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("precisionType",
                      precisionType));
    }

    if(completeSave || !FieldsEqual(ID_backendType, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("backendType",
                      backendType));
    }

    if(completeSave || !FieldsEqual(ID_removeDuplicateNodes, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("removeDuplicateNodes",
                      removeDuplicateNodes));
    }

    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}
// ****************************************************************************
// Method: GlobalAttributes::SetFromNode
//
// Purpose: 
//   Looks for a node called "GlobalAttributes" under the parentNode. If
//   it is found, then it looks for various properties and sets the
//   object's attributes accordingly.
//
// Arguments:
//   parentNode : The node to start looking for "GlobalAttributes".
//
// Notes:
//   Only a handful of the attributes that this object contains are
//   made persistent. Other values are not good to save out since they
//   would have to update the state in other state objects in order to
//   work properly. Eventually, we might do that.
//
// Programmer: Brad Whitlock
// Creation:   Thu Sep 28 13:02:57 PST 2000
//
// Modifications:
//   Brad Whitlock, Mon Sep 16 14:51:35 PST 2002
//   I added the window layout.
//
//   Brad Whitlock, Mon Nov 4 13:52:32 PST 2002
//   I added makeDefaultConfirm.
//
//   Eric Brugger, Thu Mar 13 14:05:40 PST 2003
//   I added cloneWindowOnFirstRef.
//
//   Brad Whitlock, Thu Mar 20 10:19:35 PDT 2003
//   I removed maintainView and maintainData.
//
//   Eric Brugger, Fri Apr 18 10:27:53 PDT 2003
//   I added maintainView.
//
//   Eric Brugger, Tue Mar 30 08:39:07 PST 2004
//   I added maintainData.
//
//   Brad Whitlock, Thu Aug 5 16:51:14 PST 2004
//   I added automaticallyAddOperator.
//
//   Mark C. Miller, Thu Mar 22 13:32:05 PDT 2007
//   Added tryHarderCyclesTimes
//
//   Hank Childs, Wed Aug 15 18:42:46 CDT 2007
//   Added treatAllDBsAsTimeVarying.
//
//   Kathleen Bonnell, Mon Oct  8 18:17:24 PDT 2007 
//   Added createMeshQuality/TimeDerivativeExpressions.
//
//   Cyrus Harrison, Wed Nov 28 15:22:42 PST 2007
//   Added createVectorMagnitudeExpressions
//
//   Brad Whitlock, Thu Jan 24 11:35:54 PDT 2008
//   Added newPlotsInheritSILRestriction.
//
//   Brad Whitlock, Thu Jan 31 10:03:01 PST 2008
//   Made it read userDirForSessionFiles, saveCrashRecovery.
//
//   Gunther H. Weber, Mon Feb  4 15:14:51 PST 2008
//   Made it read applySelection.
//
//   Jeremy Meredith, Wed Feb  3 14:54:47 EST 2010
//   Removed maintainData, moved maintainView to view settings, not global.
//
//   Kathleen Biagas, Thu Jul 25 13:47:07 PDT 2013
//   Add precision.
//
//   David Camp, Thu Aug  8 08:50:06 PDT 2013
//   Added the restore from last session feature. 
//
//   Cameron Christensen, Tuesday, June 10, 2014 
//   Add backend.
//
// ****************************************************************************

void
GlobalAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("GlobalAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("autoUpdateFlag")) != 0)
        SetAutoUpdateFlag(node->AsBool());
    if((node = searchNode->GetNode("replacePlots")) != 0)
        SetReplacePlots(node->AsBool());
    if((node = searchNode->GetNode("applyWindow")) != 0)
        SetApplyWindow(node->AsBool());
    if((node = searchNode->GetNode("applyOperator")) != 0)
        SetApplyOperator(node->AsBool());
    if((node = searchNode->GetNode("windowLayout")) != 0)
        SetWindowLayout(node->AsInt());
    if((node = searchNode->GetNode("makeDefaultConfirm")) != 0)
        SetMakeDefaultConfirm(node->AsBool());
    if((node = searchNode->GetNode("cloneWindowOnFirstRef")) != 0)
        SetCloneWindowOnFirstRef(node->AsBool());
    if((node = searchNode->GetNode("automaticallyAddOperator")) != 0)
        SetAutomaticallyAddOperator(node->AsBool());
    if((node = searchNode->GetNode("tryHarderCyclesTimes")) != 0)
        SetTryHarderCyclesTimes(node->AsBool());
    if((node = searchNode->GetNode("treatAllDBsAsTimeVarying")) != 0)
        SetTreatAllDBsAsTimeVarying(node->AsBool());
    if((node = searchNode->GetNode("createMeshQualityExpressions")) != 0)
        SetCreateMeshQualityExpressions(node->AsBool());
    if((node = searchNode->GetNode("createTimeDerivativeExpressions")) != 0)
        SetCreateTimeDerivativeExpressions(node->AsBool());
    if((node = searchNode->GetNode("createVectorMagnitudeExpressions")) != 0)
        SetCreateVectorMagnitudeExpressions(node->AsBool());
    if((node = searchNode->GetNode("newPlotsInheritSILRestriction")) != 0)
        SetNewPlotsInheritSILRestriction(node->AsBool());
    if((node = searchNode->GetNode("userDirForSessionFiles")) != 0)
        SetUserDirForSessionFiles(node->AsBool());
    if((node = searchNode->GetNode("saveCrashRecoveryFile")) != 0)
        SetSaveCrashRecoveryFile(node->AsBool());
    if((node = searchNode->GetNode("applySelection")) != 0)
        SetApplySelection(node->AsBool());
    if((node = searchNode->GetNode("userRestoreSessionFile")) != 0)
        SetUserRestoreSessionFile(node->AsBool());
    if((node = searchNode->GetNode("precisionType")) != 0)
    {
        if (node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if (ival >= 0 && ival < 3)
                SetPrecisionType(PrecisionType(ival));
        }
        else if (node->GetNodeType() == STRING_NODE)
        {
            PrecisionType value;
            if (PrecisionType_FromString(node->AsString(), value))
                SetPrecisionType(value);
        }
    }
    if((node = searchNode->GetNode("backendType")) != 0)
    {
        if (node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if (ival >= 0 && ival < 4)
                SetBackendType(BackendType(ival));
        }
        else if (node->GetNodeType() == STRING_NODE)
        {
            BackendType value;
            if (BackendType_FromString(node->AsString(), value))
                SetBackendType(value);
        }
    }
    if((node = searchNode->GetNode("removeDuplicateNodes")) != 0)
        SetRemoveDuplicateNodes(node->AsBool());
}
///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
GlobalAttributes::SetSources(const stringVector &sources_)
{
    sources = sources_;
    Select(ID_sources, (void *)&sources);
}

void
GlobalAttributes::SetWindows(const intVector &windows_)
{
    windows = windows_;
    Select(ID_windows, (void *)&windows);
}

void
GlobalAttributes::SetActiveWindow(int activeWindow_)
{
    activeWindow = activeWindow_;
    Select(ID_activeWindow, (void *)&activeWindow);
}

void
GlobalAttributes::SetIconifiedFlag(bool iconifiedFlag_)
{
    iconifiedFlag = iconifiedFlag_;
    Select(ID_iconifiedFlag, (void *)&iconifiedFlag);
}

void
GlobalAttributes::SetAutoUpdateFlag(bool autoUpdateFlag_)
{
    autoUpdateFlag = autoUpdateFlag_;
    Select(ID_autoUpdateFlag, (void *)&autoUpdateFlag);
}

void
GlobalAttributes::SetReplacePlots(bool replacePlots_)
{
    replacePlots = replacePlots_;
    Select(ID_replacePlots, (void *)&replacePlots);
}

void
GlobalAttributes::SetApplyOperator(bool applyOperator_)
{
    applyOperator = applyOperator_;
    Select(ID_applyOperator, (void *)&applyOperator);
}

void
GlobalAttributes::SetApplySelection(bool applySelection_)
{
    applySelection = applySelection_;
    Select(ID_applySelection, (void *)&applySelection);
}

void
GlobalAttributes::SetApplyWindow(bool applyWindow_)
{
    applyWindow = applyWindow_;
    Select(ID_applyWindow, (void *)&applyWindow);
}

void
GlobalAttributes::SetExecuting(bool executing_)
{
    executing = executing_;
    Select(ID_executing, (void *)&executing);
}

void
GlobalAttributes::SetWindowLayout(int windowLayout_)
{
    windowLayout = windowLayout_;
    Select(ID_windowLayout, (void *)&windowLayout);
}

void
GlobalAttributes::SetMakeDefaultConfirm(bool makeDefaultConfirm_)
{
    makeDefaultConfirm = makeDefaultConfirm_;
    Select(ID_makeDefaultConfirm, (void *)&makeDefaultConfirm);
}

void
GlobalAttributes::SetCloneWindowOnFirstRef(bool cloneWindowOnFirstRef_)
{
    cloneWindowOnFirstRef = cloneWindowOnFirstRef_;
    Select(ID_cloneWindowOnFirstRef, (void *)&cloneWindowOnFirstRef);
}

void
GlobalAttributes::SetAutomaticallyAddOperator(bool automaticallyAddOperator_)
{
    automaticallyAddOperator = automaticallyAddOperator_;
    Select(ID_automaticallyAddOperator, (void *)&automaticallyAddOperator);
}

void
GlobalAttributes::SetTryHarderCyclesTimes(bool tryHarderCyclesTimes_)
{
    tryHarderCyclesTimes = tryHarderCyclesTimes_;
    Select(ID_tryHarderCyclesTimes, (void *)&tryHarderCyclesTimes);
}

void
GlobalAttributes::SetTreatAllDBsAsTimeVarying(bool treatAllDBsAsTimeVarying_)
{
    treatAllDBsAsTimeVarying = treatAllDBsAsTimeVarying_;
    Select(ID_treatAllDBsAsTimeVarying, (void *)&treatAllDBsAsTimeVarying);
}

void
GlobalAttributes::SetCreateMeshQualityExpressions(bool createMeshQualityExpressions_)
{
    createMeshQualityExpressions = createMeshQualityExpressions_;
    Select(ID_createMeshQualityExpressions, (void *)&createMeshQualityExpressions);
}

void
GlobalAttributes::SetCreateTimeDerivativeExpressions(bool createTimeDerivativeExpressions_)
{
    createTimeDerivativeExpressions = createTimeDerivativeExpressions_;
    Select(ID_createTimeDerivativeExpressions, (void *)&createTimeDerivativeExpressions);
}

void
GlobalAttributes::SetCreateVectorMagnitudeExpressions(bool createVectorMagnitudeExpressions_)
{
    createVectorMagnitudeExpressions = createVectorMagnitudeExpressions_;
    Select(ID_createVectorMagnitudeExpressions, (void *)&createVectorMagnitudeExpressions);
}

void
GlobalAttributes::SetNewPlotsInheritSILRestriction(bool newPlotsInheritSILRestriction_)
{
    newPlotsInheritSILRestriction = newPlotsInheritSILRestriction_;
    Select(ID_newPlotsInheritSILRestriction, (void *)&newPlotsInheritSILRestriction);
}

void
GlobalAttributes::SetUserDirForSessionFiles(bool userDirForSessionFiles_)
{
    userDirForSessionFiles = userDirForSessionFiles_;
    Select(ID_userDirForSessionFiles, (void *)&userDirForSessionFiles);
}

void
GlobalAttributes::SetSaveCrashRecoveryFile(bool saveCrashRecoveryFile_)
{
    saveCrashRecoveryFile = saveCrashRecoveryFile_;
    Select(ID_saveCrashRecoveryFile, (void *)&saveCrashRecoveryFile);
}

void
GlobalAttributes::SetIgnoreExtentsFromDbs(bool ignoreExtentsFromDbs_)
{
    ignoreExtentsFromDbs = ignoreExtentsFromDbs_;
    Select(ID_ignoreExtentsFromDbs, (void *)&ignoreExtentsFromDbs);
}

void
GlobalAttributes::SetExpandNewPlots(bool expandNewPlots_)
{
    expandNewPlots = expandNewPlots_;
    Select(ID_expandNewPlots, (void *)&expandNewPlots);
}

void
GlobalAttributes::SetUserRestoreSessionFile(bool userRestoreSessionFile_)
{
    userRestoreSessionFile = userRestoreSessionFile_;
    Select(ID_userRestoreSessionFile, (void *)&userRestoreSessionFile);
}

void
GlobalAttributes::SetPrecisionType(GlobalAttributes::PrecisionType precisionType_)
{
    precisionType = precisionType_;
    Select(ID_precisionType, (void *)&precisionType);
}

void
GlobalAttributes::SetBackendType(GlobalAttributes::BackendType backendType_)
{
    backendType = backendType_;
    Select(ID_backendType, (void *)&backendType);
}

void
GlobalAttributes::SetRemoveDuplicateNodes(bool removeDuplicateNodes_)
{
    removeDuplicateNodes = removeDuplicateNodes_;
    Select(ID_removeDuplicateNodes, (void *)&removeDuplicateNodes);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const stringVector &
GlobalAttributes::GetSources() const
{
    return sources;
}

stringVector &
GlobalAttributes::GetSources()
{
    return sources;
}

const intVector &
GlobalAttributes::GetWindows() const
{
    return windows;
}

intVector &
GlobalAttributes::GetWindows()
{
    return windows;
}

int
GlobalAttributes::GetActiveWindow() const
{
    return activeWindow;
}

bool
GlobalAttributes::GetIconifiedFlag() const
{
    return iconifiedFlag;
}

bool
GlobalAttributes::GetAutoUpdateFlag() const
{
    return autoUpdateFlag;
}

bool
GlobalAttributes::GetReplacePlots() const
{
    return replacePlots;
}

bool
GlobalAttributes::GetApplyOperator() const
{
    return applyOperator;
}

bool
GlobalAttributes::GetApplySelection() const
{
    return applySelection;
}

bool
GlobalAttributes::GetApplyWindow() const
{
    return applyWindow;
}

bool
GlobalAttributes::GetExecuting() const
{
    return executing;
}

int
GlobalAttributes::GetWindowLayout() const
{
    return windowLayout;
}

bool
GlobalAttributes::GetMakeDefaultConfirm() const
{
    return makeDefaultConfirm;
}

bool
GlobalAttributes::GetCloneWindowOnFirstRef() const
{
    return cloneWindowOnFirstRef;
}

bool
GlobalAttributes::GetAutomaticallyAddOperator() const
{
    return automaticallyAddOperator;
}

bool
GlobalAttributes::GetTryHarderCyclesTimes() const
{
    return tryHarderCyclesTimes;
}

bool
GlobalAttributes::GetTreatAllDBsAsTimeVarying() const
{
    return treatAllDBsAsTimeVarying;
}

bool
GlobalAttributes::GetCreateMeshQualityExpressions() const
{
    return createMeshQualityExpressions;
}

bool
GlobalAttributes::GetCreateTimeDerivativeExpressions() const
{
    return createTimeDerivativeExpressions;
}

bool
GlobalAttributes::GetCreateVectorMagnitudeExpressions() const
{
    return createVectorMagnitudeExpressions;
}

bool
GlobalAttributes::GetNewPlotsInheritSILRestriction() const
{
    return newPlotsInheritSILRestriction;
}

bool
GlobalAttributes::GetUserDirForSessionFiles() const
{
    return userDirForSessionFiles;
}

bool
GlobalAttributes::GetSaveCrashRecoveryFile() const
{
    return saveCrashRecoveryFile;
}

bool
GlobalAttributes::GetIgnoreExtentsFromDbs() const
{
    return ignoreExtentsFromDbs;
}

bool
GlobalAttributes::GetExpandNewPlots() const
{
    return expandNewPlots;
}

bool
GlobalAttributes::GetUserRestoreSessionFile() const
{
    return userRestoreSessionFile;
}

GlobalAttributes::PrecisionType
GlobalAttributes::GetPrecisionType() const
{
    return PrecisionType(precisionType);
}

GlobalAttributes::BackendType
GlobalAttributes::GetBackendType() const
{
    return BackendType(backendType);
}

bool
GlobalAttributes::GetRemoveDuplicateNodes() const
{
    return removeDuplicateNodes;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
GlobalAttributes::SelectSources()
{
    Select(ID_sources, (void *)&sources);
}

void
GlobalAttributes::SelectWindows()
{
    Select(ID_windows, (void *)&windows);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: GlobalAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
GlobalAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_sources:                          return "sources";
    case ID_windows:                          return "windows";
    case ID_activeWindow:                     return "activeWindow";
    case ID_iconifiedFlag:                    return "iconifiedFlag";
    case ID_autoUpdateFlag:                   return "autoUpdateFlag";
    case ID_replacePlots:                     return "replacePlots";
    case ID_applyOperator:                    return "applyOperator";
    case ID_applySelection:                   return "applySelection";
    case ID_applyWindow:                      return "applyWindow";
    case ID_executing:                        return "executing";
    case ID_windowLayout:                     return "windowLayout";
    case ID_makeDefaultConfirm:               return "makeDefaultConfirm";
    case ID_cloneWindowOnFirstRef:            return "cloneWindowOnFirstRef";
    case ID_automaticallyAddOperator:         return "automaticallyAddOperator";
    case ID_tryHarderCyclesTimes:             return "tryHarderCyclesTimes";
    case ID_treatAllDBsAsTimeVarying:         return "treatAllDBsAsTimeVarying";
    case ID_createMeshQualityExpressions:     return "createMeshQualityExpressions";
    case ID_createTimeDerivativeExpressions:  return "createTimeDerivativeExpressions";
    case ID_createVectorMagnitudeExpressions: return "createVectorMagnitudeExpressions";
    case ID_newPlotsInheritSILRestriction:    return "newPlotsInheritSILRestriction";
    case ID_userDirForSessionFiles:           return "userDirForSessionFiles";
    case ID_saveCrashRecoveryFile:            return "saveCrashRecoveryFile";
    case ID_ignoreExtentsFromDbs:             return "ignoreExtentsFromDbs";
    case ID_expandNewPlots:                   return "expandNewPlots";
    case ID_userRestoreSessionFile:           return "userRestoreSessionFile";
    case ID_precisionType:                    return "precisionType";
    case ID_backendType:                      return "backendType";
    case ID_removeDuplicateNodes:             return "removeDuplicateNodes";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: GlobalAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
GlobalAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_sources:                          return FieldType_stringVector;
    case ID_windows:                          return FieldType_intVector;
    case ID_activeWindow:                     return FieldType_int;
    case ID_iconifiedFlag:                    return FieldType_bool;
    case ID_autoUpdateFlag:                   return FieldType_bool;
    case ID_replacePlots:                     return FieldType_bool;
    case ID_applyOperator:                    return FieldType_bool;
    case ID_applySelection:                   return FieldType_bool;
    case ID_applyWindow:                      return FieldType_bool;
    case ID_executing:                        return FieldType_bool;
    case ID_windowLayout:                     return FieldType_int;
    case ID_makeDefaultConfirm:               return FieldType_bool;
    case ID_cloneWindowOnFirstRef:            return FieldType_bool;
    case ID_automaticallyAddOperator:         return FieldType_bool;
    case ID_tryHarderCyclesTimes:             return FieldType_bool;
    case ID_treatAllDBsAsTimeVarying:         return FieldType_bool;
    case ID_createMeshQualityExpressions:     return FieldType_bool;
    case ID_createTimeDerivativeExpressions:  return FieldType_bool;
    case ID_createVectorMagnitudeExpressions: return FieldType_bool;
    case ID_newPlotsInheritSILRestriction:    return FieldType_bool;
    case ID_userDirForSessionFiles:           return FieldType_bool;
    case ID_saveCrashRecoveryFile:            return FieldType_bool;
    case ID_ignoreExtentsFromDbs:             return FieldType_bool;
    case ID_expandNewPlots:                   return FieldType_bool;
    case ID_userRestoreSessionFile:           return FieldType_bool;
    case ID_precisionType:                    return FieldType_enum;
    case ID_backendType:                      return FieldType_enum;
    case ID_removeDuplicateNodes:             return FieldType_bool;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: GlobalAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
GlobalAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_sources:                          return "stringVector";
    case ID_windows:                          return "intVector";
    case ID_activeWindow:                     return "int";
    case ID_iconifiedFlag:                    return "bool";
    case ID_autoUpdateFlag:                   return "bool";
    case ID_replacePlots:                     return "bool";
    case ID_applyOperator:                    return "bool";
    case ID_applySelection:                   return "bool";
    case ID_applyWindow:                      return "bool";
    case ID_executing:                        return "bool";
    case ID_windowLayout:                     return "int";
    case ID_makeDefaultConfirm:               return "bool";
    case ID_cloneWindowOnFirstRef:            return "bool";
    case ID_automaticallyAddOperator:         return "bool";
    case ID_tryHarderCyclesTimes:             return "bool";
    case ID_treatAllDBsAsTimeVarying:         return "bool";
    case ID_createMeshQualityExpressions:     return "bool";
    case ID_createTimeDerivativeExpressions:  return "bool";
    case ID_createVectorMagnitudeExpressions: return "bool";
    case ID_newPlotsInheritSILRestriction:    return "bool";
    case ID_userDirForSessionFiles:           return "bool";
    case ID_saveCrashRecoveryFile:            return "bool";
    case ID_ignoreExtentsFromDbs:             return "bool";
    case ID_expandNewPlots:                   return "bool";
    case ID_userRestoreSessionFile:           return "bool";
    case ID_precisionType:                    return "enum";
    case ID_backendType:                      return "enum";
    case ID_removeDuplicateNodes:             return "bool";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: GlobalAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
GlobalAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const GlobalAttributes &obj = *((const GlobalAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_sources:
        {  // new scope
        retval = (sources == obj.sources);
        }
        break;
    case ID_windows:
        {  // new scope
        retval = (windows == obj.windows);
        }
        break;
    case ID_activeWindow:
        {  // new scope
        retval = (activeWindow == obj.activeWindow);
        }
        break;
    case ID_iconifiedFlag:
        {  // new scope
        retval = (iconifiedFlag == obj.iconifiedFlag);
        }
        break;
    case ID_autoUpdateFlag:
        {  // new scope
        retval = (autoUpdateFlag == obj.autoUpdateFlag);
        }
        break;
    case ID_replacePlots:
        {  // new scope
        retval = (replacePlots == obj.replacePlots);
        }
        break;
    case ID_applyOperator:
        {  // new scope
        retval = (applyOperator == obj.applyOperator);
        }
        break;
    case ID_applySelection:
        {  // new scope
        retval = (applySelection == obj.applySelection);
        }
        break;
    case ID_applyWindow:
        {  // new scope
        retval = (applyWindow == obj.applyWindow);
        }
        break;
    case ID_executing:
        {  // new scope
        retval = (executing == obj.executing);
        }
        break;
    case ID_windowLayout:
        {  // new scope
        retval = (windowLayout == obj.windowLayout);
        }
        break;
    case ID_makeDefaultConfirm:
        {  // new scope
        retval = (makeDefaultConfirm == obj.makeDefaultConfirm);
        }
        break;
    case ID_cloneWindowOnFirstRef:
        {  // new scope
        retval = (cloneWindowOnFirstRef == obj.cloneWindowOnFirstRef);
        }
        break;
    case ID_automaticallyAddOperator:
        {  // new scope
        retval = (automaticallyAddOperator == obj.automaticallyAddOperator);
        }
        break;
    case ID_tryHarderCyclesTimes:
        {  // new scope
        retval = (tryHarderCyclesTimes == obj.tryHarderCyclesTimes);
        }
        break;
    case ID_treatAllDBsAsTimeVarying:
        {  // new scope
        retval = (treatAllDBsAsTimeVarying == obj.treatAllDBsAsTimeVarying);
        }
        break;
    case ID_createMeshQualityExpressions:
        {  // new scope
        retval = (createMeshQualityExpressions == obj.createMeshQualityExpressions);
        }
        break;
    case ID_createTimeDerivativeExpressions:
        {  // new scope
        retval = (createTimeDerivativeExpressions == obj.createTimeDerivativeExpressions);
        }
        break;
    case ID_createVectorMagnitudeExpressions:
        {  // new scope
        retval = (createVectorMagnitudeExpressions == obj.createVectorMagnitudeExpressions);
        }
        break;
    case ID_newPlotsInheritSILRestriction:
        {  // new scope
        retval = (newPlotsInheritSILRestriction == obj.newPlotsInheritSILRestriction);
        }
        break;
    case ID_userDirForSessionFiles:
        {  // new scope
        retval = (userDirForSessionFiles == obj.userDirForSessionFiles);
        }
        break;
    case ID_saveCrashRecoveryFile:
        {  // new scope
        retval = (saveCrashRecoveryFile == obj.saveCrashRecoveryFile);
        }
        break;
    case ID_ignoreExtentsFromDbs:
        {  // new scope
        retval = (ignoreExtentsFromDbs == obj.ignoreExtentsFromDbs);
        }
        break;
    case ID_expandNewPlots:
        {  // new scope
        retval = (expandNewPlots == obj.expandNewPlots);
        }
        break;
    case ID_userRestoreSessionFile:
        {  // new scope
        retval = (userRestoreSessionFile == obj.userRestoreSessionFile);
        }
        break;
    case ID_precisionType:
        {  // new scope
        retval = (precisionType == obj.precisionType);
        }
        break;
    case ID_backendType:
        {  // new scope
        retval = (backendType == obj.backendType);
        }
        break;
    case ID_removeDuplicateNodes:
        {  // new scope
        retval = (removeDuplicateNodes == obj.removeDuplicateNodes);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

