/*
 * Copyright (c) 2011 Google, Inc
 * Contributed by Stephane Eranian <eranian@gmail.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * This file is part of libpfm, a performance monitoring support library for
 * applications on Linux.
 *
 * This file has been automatically generated.
 *
 * PMU: ppro (Intel Pentium Pro)
 */

static const intel_x86_umask_t ppro_l2_ifetch[]={
   { .uname  = "I",
     .udesc  = "Invalid state",
     .ucode = 0x100,
   },
   { .uname  = "S",
     .udesc  = "Shared state",
     .ucode = 0x200,
   },
   { .uname  = "E",
     .udesc  = "Exclusive state",
     .ucode = 0x400,
   },
   { .uname  = "M",
     .udesc  = "Modified state",
     .ucode = 0x800,
   },
};

static const intel_x86_umask_t ppro_bus_drdy_clocks[]={
   { .uname  = "SELF",
     .udesc  = "Clocks when processor is driving bus",
     .ucode = 0x0,
     .uflags= INTEL_X86_NCOMBO | INTEL_X86_DFL,
   },
   { .uname  = "ANY",
     .udesc  = "Clocks when any agent is driving bus",
     .ucode = 0x2000,
     .uflags= INTEL_X86_NCOMBO,
   },
};

static const intel_x86_entry_t intel_ppro_pe[]={
{ .name   = "CPU_CLK_UNHALTED",
  .desc   = "Number cycles during which the processor is not halted",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x79,
},
{ .name   = "INST_RETIRED",
  .desc   = "Number of instructions retired",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0xc0,
},
{ .name   = "DATA_MEM_REFS",
  .desc   = "All loads from any memory type. All stores to any memory typeEach part of a split is counted separately. The internal logic counts not only memory loads and stores but also internal retries. 80-bit floating point accesses are double counted, since they are decomposed into a 16-bit exponent load and a 64-bit mantissa load. Memory accesses are only counted when they are  actually performed (such as a load that gets squashed because a previous cache miss is outstanding to the same address, and which finally gets performe, is only counted once). Does ot include I/O accesses or other non-memory accesses",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x43,
},
{ .name   = "DCU_LINES_IN",
  .desc   = "Total lines allocated in the DCU",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x45,
},
{ .name   = "DCU_M_LINES_IN",
  .desc   = "Number of M state lines allocated in the DCU",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x46,
},
{ .name   = "DCU_M_LINES_OUT",
  .desc   = "Number of M state lines evicted from the DCU. This includes evictions via snoop HITM, intervention or replacement",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x47,
},
{ .name   = "DCU_MISS_OUTSTANDING",
  .desc   = "Weighted number of cycle while a DCU miss is outstanding, incremented by the number of cache misses at any particular time. Cacheable read requests only are considered. Uncacheable requests are excluded Read-for-ownerships are counted, as well as line fills, invalidates, and stores",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x48,
},
{ .name   = "IFU_IFETCH",
  .desc   = "Number of instruction fetches, both cacheable and noncacheable including UC fetches",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x80,
},
{ .name   = "IFU_IFETCH_MISS",
  .desc   = "Number of instruction fetch misses. All instructions fetches that do not hit the IFU (i.e., that produce memory requests). Includes UC accesses",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x81,
},
{ .name   = "ITLB_MISS",
  .desc   = "Number of ITLB misses",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x85,
},
{ .name   = "IFU_MEM_STALL",
  .desc   = "Number of cycles instruction fetch is stalled for any reason. Includs IFU cache misses, ITLB misses, ITLB faults, and other minor stalls",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x86,
},
{ .name   = "ILD_STALL",
  .desc   = "Number of cycles that the instruction length decoder is stalled",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x87,
},
{ .name   = "L2_IFETCH",
  .desc   = "Number of L2 instruction fetches. This event indicates that a normal instruction fetch was received by the L2. The count includes only L2 cacheable instruction fetches: it does not include UC instruction fetches It does not include ITLB miss accesses",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x28,
  .numasks = LIBPFM_ARRAY_SIZE(ppro_l2_ifetch),
  .ngrp = 1,
  .umasks = ppro_l2_ifetch,
},
{ .name   = "L2_ST",
  .desc   = "Number of L2 data stores. This event indicates that a normal, unlocked, store memory access was received by the L2. Specifically, it indictes that the DCU sent a read-for ownership request to the L2. It also includes Invalid to Modified reqyests sent by the DCU to the L2. It includes only L2 cacheable memory accesses;  it does not include I/O accesses, other non-memory accesses, or memory accesses such as UC/WT memory accesses. It does include L2 cacheable TLB miss memory accesses",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x2a,
  .numasks = LIBPFM_ARRAY_SIZE(ppro_l2_ifetch),
  .ngrp = 1,
  .umasks = ppro_l2_ifetch, /* identical to actual umasks list for this event */
},
{ .name   = "L2_M_LINES_INM",
  .desc   = "Number of modified lines allocated in the L2",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x25,
},
{ .name   = "L2_RQSTS",
  .desc   = "Total number of L2 requests",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x2e,
  .numasks = LIBPFM_ARRAY_SIZE(ppro_l2_ifetch),
  .ngrp = 1,
  .umasks = ppro_l2_ifetch, /* identical to actual umasks list for this event */
},
{ .name   = "L2_ADS",
  .desc   = "Number of L2 address strobes",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x21,
},
{ .name   = "L2_DBUS_BUSY",
  .desc   = "Number of cycles during which the L2 cache data bus was busy",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x22,
},
{ .name   = "L2_DBUS_BUSY_RD",
  .desc   = "Number of cycles during which the data bus was busy transferring read data from L2 to the processor",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x23,
},
{ .name   = "BUS_DRDY_CLOCKS",
  .desc   = "Number of clocks during which DRDY# is asserted. Utilization of the external system data bus during data transfers",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x62,
  .numasks = LIBPFM_ARRAY_SIZE(ppro_bus_drdy_clocks),
  .ngrp = 1,
  .umasks = ppro_bus_drdy_clocks,
},
{ .name   = "BUS_LOCK_CLOCKS",
  .desc   = "Number of clocks during which LOCK# is asserted on the external system bus",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x63,
  .numasks = LIBPFM_ARRAY_SIZE(ppro_bus_drdy_clocks),
  .ngrp = 1,
  .umasks = ppro_bus_drdy_clocks, /* identical to actual umasks list for this event */
},
{ .name   = "BUS_REQ_OUTSTANDING",
  .desc   = "Number of bus requests outstanding. This counter is incremented by the number of cacheable read bus requests outstanding in any given cycle",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x60,
},
{ .name   = "BUS_TRANS_BRD",
  .desc   = "Number of burst read transactions",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x65,
  .numasks = LIBPFM_ARRAY_SIZE(ppro_bus_drdy_clocks),
  .ngrp = 1,
  .umasks = ppro_bus_drdy_clocks, /* identical to actual umasks list for this event */
},
{ .name   = "BUS_TRANS_RFO",
  .desc   = "Number of completed read for ownership transactions",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x66,
  .numasks = LIBPFM_ARRAY_SIZE(ppro_bus_drdy_clocks),
  .ngrp = 1,
  .umasks = ppro_bus_drdy_clocks, /* identical to actual umasks list for this event */
},
{ .name   = "BUS_TRANS_WB",
  .desc   = "Number of completed write back transactions",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x67,
  .numasks = LIBPFM_ARRAY_SIZE(ppro_bus_drdy_clocks),
  .ngrp = 1,
  .umasks = ppro_bus_drdy_clocks, /* identical to actual umasks list for this event */
},
{ .name   = "BUS_TRAN_IFETCH",
  .desc   = "Number of completed instruction fetch transactions",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x68,
  .numasks = LIBPFM_ARRAY_SIZE(ppro_bus_drdy_clocks),
  .ngrp = 1,
  .umasks = ppro_bus_drdy_clocks, /* identical to actual umasks list for this event */
},
{ .name   = "BUS_TRAN_INVAL",
  .desc   = "Number of completed invalidate transactions",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x69,
  .numasks = LIBPFM_ARRAY_SIZE(ppro_bus_drdy_clocks),
  .ngrp = 1,
  .umasks = ppro_bus_drdy_clocks, /* identical to actual umasks list for this event */
},
{ .name   = "BUS_TRAN_PWR",
  .desc   = "Number of completed partial write transactions",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x6a,
  .numasks = LIBPFM_ARRAY_SIZE(ppro_bus_drdy_clocks),
  .ngrp = 1,
  .umasks = ppro_bus_drdy_clocks, /* identical to actual umasks list for this event */
},
{ .name   = "BUS_TRANS_P",
  .desc   = "Number of completed partial transactions",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x6b,
  .numasks = LIBPFM_ARRAY_SIZE(ppro_bus_drdy_clocks),
  .ngrp = 1,
  .umasks = ppro_bus_drdy_clocks, /* identical to actual umasks list for this event */
},
{ .name   = "BUS_TRANS_IO",
  .desc   = "Number of completed I/O transactions",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x6c,
  .numasks = LIBPFM_ARRAY_SIZE(ppro_bus_drdy_clocks),
  .ngrp = 1,
  .umasks = ppro_bus_drdy_clocks, /* identical to actual umasks list for this event */
},
{ .name   = "BUS_TRAN_DEF",
  .desc   = "Number of completed deferred transactions",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x6d,
  .numasks = LIBPFM_ARRAY_SIZE(ppro_bus_drdy_clocks),
  .ngrp = 1,
  .umasks = ppro_bus_drdy_clocks, /* identical to actual umasks list for this event */
},
{ .name   = "BUS_TRAN_BURST",
  .desc   = "Number of completed burst transactions",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x6e,
  .numasks = LIBPFM_ARRAY_SIZE(ppro_bus_drdy_clocks),
  .ngrp = 1,
  .umasks = ppro_bus_drdy_clocks, /* identical to actual umasks list for this event */
},
{ .name   = "BUS_TRAN_ANY",
  .desc   = "Number of all completed bus transactions. Address bus utilization can be calculated knowing the minimum address bus occupancy. Includes special cycles, etc.",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x70,
  .numasks = LIBPFM_ARRAY_SIZE(ppro_bus_drdy_clocks),
  .ngrp = 1,
  .umasks = ppro_bus_drdy_clocks, /* identical to actual umasks list for this event */
},
{ .name   = "BUS_TRAN_MEM",
  .desc   = "Number of completed memory transactions",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x6f,
  .numasks = LIBPFM_ARRAY_SIZE(ppro_bus_drdy_clocks),
  .ngrp = 1,
  .umasks = ppro_bus_drdy_clocks, /* identical to actual umasks list for this event */
},
{ .name   = "BUS_DATA_RECV",
  .desc   = "Number of bus clock cycles during which this processor is receiving data",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x64,
},
{ .name   = "BUS_BNR_DRV",
  .desc   = "Number of bus clock cycles during which this processor is driving the BNR# pin",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x61,
},
{ .name   = "BUS_HIT_DRV",
  .desc   = "Number of bus clock cycles during which this processor is driving the HIT# pin",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x7a,
},
{ .name   = "BUS_HITM_DRV",
  .desc   = "Number of bus clock cycles during which this processor is driving the HITM# pin",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x7b,
},
{ .name   = "BUS_SNOOP_STALL",
  .desc   = "Number of clock cycles during which the bus is snoop stalled",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x7e,
},
{ .name   = "FLOPS",
  .desc   = "Number of computational floating-point operations retired. Excludes floating-point computational operations that cause traps or assists. Includes internal sub-operations for complex floating-point instructions like transcendentals. Excludes floating point loads and stores",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x1,
  .code = 0xc1,
},
{ .name   = "FP_COMP_OPS_EXE",
  .desc   = "Number of computational floating-point operations executed. The number of FADD, FSUB, FCOM, FMULs, integer MULs and IMULs, FDIVs, FPREMs, FSQRTS, integer DIVs, and IDIVs. This number does not include the number of cycles, but the number of operations. This event does not distinguish an FADD used in the middle of a transcendental flow from a separate FADD instruction",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x1,
  .code = 0x10,
},
{ .name   = "FP_ASSIST",
  .desc   = "Number of floating-point exception cases handled by microcode.",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x2,
  .code = 0x11,
},
{ .name   = "MUL",
  .desc   = "Number of multiplies.This count includes integer as well as FP multiplies and is speculative",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x2,
  .code = 0x12,
},
{ .name   = "DIV",
  .desc   = "Number of divides.This count includes integer as well as FP divides and is speculative",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x2,
  .code = 0x13,
},
{ .name   = "CYCLES_DIV_BUSY",
  .desc   = "Number of cycles during which the divider is busy, and cannot accept new divides. This includes integer and FP divides, FPREM, FPSQRT, etc. and is speculative",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x1,
  .code = 0x14,
},
{ .name   = "LD_BLOCKS",
  .desc   = "Number of load operations delayed due to store buffer blocks. Includes counts caused by preceding stores whose addresses are unknown, preceding stores whose addresses are known but whose data is unknown, and preceding stores that conflicts with the load but which incompletely overlap the load",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x3,
},
{ .name   = "SB_DRAINS",
  .desc   = "Number of store buffer drain cycles. Incremented every cycle the store buffer is draining. Draining is caused by serializing operations like CPUID, synchronizing operations like XCHG, interrupt acknowledgment, as well as other conditions (such as cache flushing).",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x4,
},
{ .name   = "MISALIGN_MEM_REF",
  .desc   = "Number of misaligned data memory references. Incremented by 1 every cycle during which, either the processor's load or store pipeline dispatches a misaligned micro-op Counting is performed if it is the first or second half or if it is blocked, squashed, or missed. In this context, misaligned means crossing a 64-bit boundary",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x5,
},
{ .name   = "UOPS_RETIRED",
  .desc   = "Number of micro-ops retired",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0xc2,
},
{ .name   = "INST_DECODED",
  .desc   = "Number of instructions decoded",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0xd0,
},
{ .name   = "HW_INT_RX",
  .desc   = "Number of hardware interrupts received",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0xc8,
},
{ .name   = "CYCLES_INT_MASKED",
  .desc   = "Number of processor cycles for which interrupts are disabled",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0xc6,
},
{ .name   = "CYCLES_INT_PENDING_AND_MASKED",
  .desc   = "Number of processor cycles for which interrupts are disabled and interrupts are pending.",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0xc7,
},
{ .name   = "BR_INST_RETIRED",
  .desc   = "Number of branch instructions retired",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0xc4,
},
{ .name   = "BR_MISS_PRED_RETIRED",
  .desc   = "Number of mispredicted branches retired",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0xc5,
},
{ .name   = "BR_TAKEN_RETIRED",
  .desc   = "Number of taken branches retired",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0xc9,
},
{ .name   = "BR_MISS_PRED_TAKEN_RET",
  .desc   = "Number of taken mispredicted branches retired",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0xca,
},
{ .name   = "BR_INST_DECODED",
  .desc   = "Number of branch instructions decoded",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0xe0,
},
{ .name   = "BTB_MISSES",
  .desc   = "Number of branches for which the BTB did not produce a prediction",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0xe2,
},
{ .name   = "BR_BOGUS",
  .desc   = "Number of bogus branches",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0xe4,
},
{ .name   = "BACLEARS",
  .desc   = "Number of times BACLEAR is asserted. This is the number of times that a static branch prediction was made, in which the branch decoder decided to make a branch prediction because the BTB did not",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0xe6,
},
{ .name   = "RESOURCE_STALLS",
  .desc   = "Incremented by 1 during every cycle for which there is a resource related stall. Includes register renaming buffer entries, memory buffer entries. Does not include stalls due to bus queue full, too many cache misses, etc. In addition to resource related stalls, this event counts some other events. Includes stalls arising during branch misprediction recovery, such as if retirement of the mispredicted branch is delayed and stalls arising while store buffer is draining from synchronizing operations",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0xa2,
},
{ .name   = "PARTIAL_RAT_STALLS",
  .desc   = "Number of cycles or events for partial stalls. This includes flag partial stalls",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0xd2,
},
{ .name   = "SEGMENT_REG_LOADS",
  .desc   = "Number of segment register loads.",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x6,
},
{ .name   = "L2_LD",
  .desc   = "Number of L2 data loads. This event indicates that a normal, unlocked, load memory access was received by the L2. It includes only L2 cacheable memory accesses; it does not include I/O accesses, other non-memory accesses, or memory accesses such as UC/WT memory accesses. It does include L2 cacheable TLB miss memory accesses",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x29,
  .numasks = LIBPFM_ARRAY_SIZE(ppro_l2_ifetch),
  .ngrp = 1,
  .umasks = ppro_l2_ifetch, /* identical to actual umasks list for this event */
},
{ .name   = "L2_LINES_IN",
  .desc   = "Number of lines allocated in the L2",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x24,
},
{ .name   = "L2_LINES_OUT",
  .desc   = "Number of lines removed from the L2 for any reason",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x26,
},
{ .name   = "L2_M_LINES_OUTM",
  .desc   = "Number of modified lines removed from the L2 for any reason",
  .modmsk = INTEL_X86_ATTRS,
  .cntmsk = 0x3,
  .code = 0x27,
},
};
