'\"
'\" Copyright (c) 2003-2004 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Device manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No waranty. None. Use at your own risk.
'\" $Id$
'\"
.TH DS2436 3  2003 "OWFS Manpage" "One-Wire File System"
.SH NAME
.B DS2436
\- Battery ID/Monitor Chip
.SH SYNOPSIS
Temperature Voltage and Memory.
.PP
.B 1B
[.]XXXXXXXXXXXX[XX][/[
.B pages/page.[0-4|ALL]
|
.B temperature
|
.B volts
|
.B counter/cycles
|
.B counter/reset
|
.B counter/increment
|
.so man3/standard_mini.3so
]]
.SH FAMILY CODE
.PP
.I 1B
.SH SPECIAL PROPERTIES
.SS pages/page.0 ... pages/page.4 pages/page.ALL
.I read-write, binary
.br
Memory is split into 5 pages of 32 bytes each. Only the first 3 pages are really available, and some of that appears to be reserved. See the datasheet for details.
.P
.I pages/page.0 
is locked and unlocked transparently for every write.
.P
.I ALL
is an aggregate of the pages. Each page is accessed sequentially.
.SS temperature
.I read-only, floating point
.br
.I Temperature
read by the chip at high resolution (~13 bits). Units are selected from the invoking command line. See
.B owfs(1)
or
.B owhttpd(1)
for choices. Default is Celsius.
Conversion takes ~20 msec.
.SS volts
.I read-only, floating point
.br
Voltage read (~10 bits) at the chip's supply voltage Vdd. Range 2.4V to 10V.
.SS counter/
A resettable non-volatile counter intended for counting battery discharge cycles.
.SS counter/cycles
.I read-only, unsigned integer
.br
Cycle counter value. Stored at memory location 0x82.
.SS counter/increment
.I write-only, yes/no
.br
Any non-zero (true) value will increment
.I counter/cycles
by one.
.SS counter/reset
.I write-only, yes/no
.br
Any non-zero (true) value will reset
.I counter/cycles
to zero.
.SH STANDARD PROPERTIES
.so man3/standard.3so
.SH ALARMS
None.
.SH DESCRIPTION
.so man3/description.3so
.SS DS2436
The
.B DS2436 (3)
is a simpler form of the
.B DS2438
battery chip. It has no counter, and only one voltage sensor.
.SH ADDRESSING
.so man3/addressing.3so
.SH DATASHEET
.br
http://pdfserv.maxim-ic.com/en/ds/DS2436.pdf
.SH SEE ALSO
.so man3/seealso.3so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille (paul.alfille@gmail.com)
