'\"
'\" Copyright (c) 2003-2004 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Device manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No waranty. None. Use at your own risk.
'\" $Id$
'\"
.TH DS2760 3  2003 "OWFS Manpage" "One-Wire File System"
.SH NAME
.B DS2760, DS2761, DS2762
\- High-Precision Li+ Battery Monitor
.SH SYNOPSIS
.SS Temperature Voltage and Current.
.PP
.B 30
[.]XXXXXXXXXXXX[XX][/[
.B amphours
|
.B current
|
.B currentbias
|
.B lock.[0-1|ALL]
|
.B memory
|
.B pages/page.[0-1|ALL]
|
.B PIO
|
.B sensed
|
.B temperature
|
.B vbias
|
.B vis
|
.B volt
|
.B volthours
|
.br
.B cc
|
.B ce
|
.B coc
|
.B defaultpmod
|
.B defaultswen
|
.B dc
|
.B de
|
.B doc
|
. B mstr
|
.B ov
|
.B ps
|
.B pmod
|
.B swen
|
.B uv
|
.br
.so man3/standard_mini.3so
]]
.SS Thermocouple
.PP
.B 30
[.]XXXXXXXXXXXX[XX][/[
.B temperature
|
.B typeX/range_low
|
.B typeX/range_high
|
.B typeX/temperature
]]
.SS Weather Station
.PP
.B 30
[.]XXXXXXXXXXXX[XX][/[
.B WS603/temperature
|
.B WS603/wind_speed
|
.B WS603/direction
|
.B WS603/volt
|
.br
.B WS603/LED/status
|
.B WS603/LED/control.ALL
|
.B WS603/LED/model
|
.br
.B WS603/calibrationwind_speed
|
.B WS603/calibration/direction
|
.br
.B WS603/light/intensity
|
.B WS603/light/threshold
.SH FAMILY CODE
.PP
.I 30
.SH SPECIAL PROPERTIES
.SS amphours
.I read-write, floating point
.br
Accumulated amperage read by current sensor. Units are in
.B Amp-hr
(Assumes internal 25mOhm resistor). Derived from
.I volthours
/ Rinternal.
.br
Formally 
.I amphours
is the integral of
.I current - currentbias
over time.
.SS current
.I read-only, floating point
.br
Current reading. Units are in
.B Amp
(Assumes internal 25 mOhm resistor). Derived from
.I vis
/ Rinternal.
.SS currentbias
.I read-write, floating point
.br
Fixed offset applied to each 
.I current
measurement. Used in the
.I amphours
value. Assumes internal 25mOhm resistor. Units are 
.B Amp
and range from -.08A to .08A.
.br
Derived from
.I vbias
/ Rinternal.
.SS lock.[0-1|ALL]
.I read-write, yes-no
.br
Lock either of the two eprom pages to prevent further writes. Apparently setting
.I lock
is permanent.
.SS memory
.I read-write, binary
.br
Access to the full 256 byte memory range. Much of this space is reserved or special use. User space is the
.I page
area.
.br
See the
.I DATASHEET
for a full memory map.
.SS pages/pages.[0-1|ALL]
.I read-write, binary
Two 16 byte areas of memory for user application. The
.I lock
property can prevent further alteration.
.br
NOTE that the
.I page
property is different from the common 
.I OWFS
implementation in that all of
.I memory
is not accessible.
.SS PIO
.I write-only, yes-no
.br
Controls the PIO pin allowing external switching.
.br
Writing "1" turns the PIO pin on (conducting). Writing "0" makes the pin non-conducting.
The logical state of the voltage can be read with the
.I sensed
property. This will reflect the current voltage at the pin, not the value sent to
.I PIO
.br
Note also that
.I PIO
will also be altered by the power-status of the
.I DS2670
See the datasheet for details.
.SS sensed
.I read-only, yes-no
.br
The logical voltage at the PIO pin. Useful only if the
.I PIO
property is set to "0" (non-conducting).
.br
Value will be 0 or 1 depending on the voltage threshold.
.SS temperature
.I read-only, floating point
.br
.I Temperature
read by the chip at high resolution (~13 bits). Units are selected from the invoking command line. See
.B owfs(1)
or
.B owhttpd(1)
for choices. Default is Celsius.
.br
Conversion is continuous.
.SS vbias
.I read-write, floating point
.br
Fixed offset applied to each
.I vis
measurement. Used for the
.I volthours
value. Units are in
.B Volts.
.br
Range \-2.0mV to 2.0mV
.SS vis
.I read-only, floating point
.br
Current sensor reading (unknown external resistor). Measures the voltage gradient between the Vis pins. Units are in
.B Volts
.br
The
.I vis
readings are integrated over time to provide the
.I volthours
property.
.br
The
.I current
reading is derived from
.I vis
assuming the internal 25 mOhm resistor is employed. There is no way to know this through software.
.SS volt
.I read-only, floating point
.br
Voltage read at the voltage sensor;. This is separate from the
.I vis
voltage that is used for
.I current
measurement. Units are
.B Volts
.br
Range is between 0 and 4.75V
.SS volthours
.I read-write, floating point
.br
Integral of
.I vis - vbias
over time. Units are in
.B volthours
.SH THERMOCOUPLE
.SS typeX/
.I directory
.br
Thermocouple circuit using the
.I  DS2760
to read the Seebeck voltage and the reference temperature. Since the type interpretation of the values read depends on the type of thermocouple, the correct directory must be chosen. Supported thermocouple types include types B, E, J, K, N, R, S and T.
.SS typeX/range_low typeX/ranges_high
.I read-only, flaoting point
.br
The lower and upper temperature supported by this thermocouple (at least by the conversion routines). In the globally chosen temperature units.
.SS typeX/temperature
.I read-only, floating point
.br
Thermocouple temperature. Requires a voltage and temperature conversion. Returned in globally chosen temperature units.
.br
Note: there are two types of temperature measurements possible. The
.I temperature
value in the main device directory is the reference temperature read at the chip. The
.I typeX/temperature
value is at the thermocouple junction, probably remote from the chip.
.SH WEATHER STATION
.SS WS603
.I directory
.br
Weather station from
.I AAG electronica
that includes temperature, wind speed, wind direction, light sensor and LED lights.
.SS WS603/temperature
.I read-only, floating-point
.br
Uses the
.I DS2760
temperature sensor. This is equivalent to the
.I temperature
value. Again in the specificed temperature scale, default Celsius.
.SS WS603/wind_speed
.I read_only, floating-point
.br
Readings from the anometer, scaled using the
.I WS603/calibration/wind_speed
.SS WS603/direction
.I read_only, unsigned integer
.br
Wind direction, using the following table
.TP
1
N
.TP
2
NNE
.TP
3
NE
.TP
4
NEE
.TP
5
E
.TP
6
EES
.TP
7
ES
.TP
8
ESS
.TP
9
S
.TP
10
SSW
.TP
11
SW
.TP
12
SWW
.TP
13
W
.TP
14
WWN
.TP
15
WN
.TP
16
WWN
.PP
Values are adjusted (internally) by the
.I WS603/calibration/direction
property
.SS WS603/volt
.I read-only, unsigned integer
.br
Voltage value from the
.I WS603
device. Units and significance is unclear.
.SS WS603/calibration/wind_speed
.I read-write, unsigned integer
.br
Value between 1 and 200 for wind speed scaling. Values on of this range are ignored and the default value of 100 used.
.SS WS603/calibration/direction
.I read-write, unsigned integer
.br
Adjustment of wind direction. See datasheet.
.SS WS603/light/intensity
.I read-only, unsigned integer
.br
Uncalibrated value from an internal light sensor. Used for control of LED display (daytime vs nighttime).
.SS WS603/light/threshold
.I read-only, unsigned integer
.br
Threshold for internal light sensor. Used for control of LED display (daytime vs nighttime).
.PP
Value is set as value 4 of the array passed to
.I WS603/LED/control
.SS WS603/LED/status
.I read-only, unsigned integer
.br
Status of LED lights intensities. See datasheet.
.PP
Value is set as values 2 and 3 of the array passed to
.I WS603/LED/control
.SS WS603/LED/model
.I read-only, unsigned integer
.br
What factors control LED display. See datasheet.
.PP
Value is set as value 1 of the array passed to
.I WS603/LED/control.ALL
.SS WS603/LED/model
.I write-only, unsigned integer array of 4 values
.br
Four integers sent to control LED display. All four values must be sent, comma separated.
.TP
0
Light mode
.TP
1
Light status
.TP
2
Light level
.TP
3
Light threshold
.SH OBSCURE PROPERTIES
.SS cc ce coc dc de doc mstr ov pmod swen uv
.I varies, yes-no
.br
Bit flags corresponding to various battery management functions of the chip. See the 
.I DATASHEET
for details of the identically named entries.
.br
In general, writing "0" corresponds to a 0 bit value, and non-zero corresponds to a 1 bit value.
.SS defaultpmod defaultswen
.I read-write, yes-no
.br
Default power-on state for the corresponding properties.
.SH STANDARD PROPERTIES
.so man3/standard.3so
.SH ALARMS
None.
.SH DESCRIPTION
.so man3/description.3so
.SS DS2760 DS2761 DS2762
The
.B DS2760 (3)
is a class of battery charging controllers. There are minor hardware difference between the
.B DS2760, DS2761
and
.B DS2762
battery chip, but they are indistiguishable to the software.
.PP
A number of interesting devices can be built with the
.B DS276x 
including thermocouples. Support for thermocouples in built into the software, using the embedded thermister as the cold junction temperature.
.PP
For an explanation of the differences between the 
.B DS276x
variants, see Dallas Application Note 221.
.SH ADDRESSING
.so man3/addressing.3so
.SH DATASHEET
.br
http://pdfserv.maxim-ic.com/en/ds/DS2760.pdf
.br
http://pdfserv.maxim-ic.com/en/an/app221.pdf
.br
http://www.aag.com.mx/aagusa/contents/en-us/Description%20of%20WSV3%20Interface%20(1-wire).pdf
.SH SEE ALSO
.so man3/seealso.3so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille (paul.alfille@gmail.com)
