# This NASL script was written by Michel Arboi <arboi@alussinan.org>
# It is released under the GNU Public Licence
#
# Date:  Fri, 7 Dec 2001 14:23:10 +0100
# From: "Sebastien EXT-MICHAUD" <Sebastien.EXT-MICHAUD@atofina.com>
# Subject: Lotus Domino Web server vulnerability
# To: bugtraq@securityfocus.com


if (description)
{
  script_id(11718);
  script_bugtraq_id(3656);
  script_cve_id("CVE-2001-0954");
  script_version("$Revision: 7516 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  name = "Lotus /./ database lock";
  script_name(name);

  desc = "
It might be possible to lock out some Lotus Domino databases by 
requesting them through the web interface with a special request
like /./name.nsf 
This attack is only efficient on databases that are not used by
the server.

*** Note that no real attack was performed, 
*** so this might be a false alert

Solution: upgrade your Lotus Domino server 
Risk factor : Medium";

  script_description(desc);
 
  summary = "Locks out Lotus database with /./ request";
  script_summary(summary);
 
  script_category(ACT_GATHER_INFO);
 
  script_copyright("This script is Copyright (C) 2003 Michel Arboi");
  family = "Denial of Service";
  script_family(family);

  script_dependencie("find_service.nes", "http_login.nasl", "httpver.nasl", "no404.nasl");
  script_require_ports("Services/www", 80);
  script_require_keys("www/domino");
  exit(0);

}

include("http_func.inc");

port = get_http_port(default:80);

if (! get_port_state(port)) exit(0);


b = get_http_banner(port: port);
if(egrep(pattern: "^Server: Lotus-Domino/(Release-)?(5\.0\.[0-8][^0-9])", string:b))
  security_warning(port);
