#
#VID 2273879e-8a2f-11dd-a6fe-0030843d3802
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 2273879e-8a2f-11dd-a6fe-0030843d3802
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61654);
 script_cve_id("CVE-2008-0016", "CVE-2008-3835", "CVE-2008-3836", "CVE-2008-3837", "CVE-2008-4058", "CVE-2008-4059", "CVE-2008-4060", "CVE-2008-4061", "CVE-2008-4062", "CVE-2008-4063", "CVE-2008-4064", "CVE-2008-4065", "CVE-2008-4067", "CVE-2008-4068", "CVE-2008-4069");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "FreeBSD Ports: firefox";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   firefox
   linux-firefox
   firefox3
   seamonkey
   linux-seamonkey
   thunderbird
   linux-thunderbird
   flock
   linux-flock
   linux-firefox-devel
   linux-seamonkey-devel

For details, please visit the referenced security advisories.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.mozilla.org/security/announce/2008/mfsa2008-37.html
http://www.mozilla.org/security/announce/2008/mfsa2008-38.html
http://www.mozilla.org/security/announce/2008/mfsa2008-39.html
http://www.mozilla.org/security/announce/2008/mfsa2008-40.html
http://www.mozilla.org/security/announce/2008/mfsa2008-41.html
http://www.mozilla.org/security/announce/2008/mfsa2008-42.html
http://www.mozilla.org/security/announce/2008/mfsa2008-43.html
http://www.mozilla.org/security/announce/2008/mfsa2008-44.html
http://www.mozilla.org/security/announce/2008/mfsa2008-45.html
http://www.vuxml.org/freebsd/2273879e-8a2f-11dd-a6fe-0030843d3802.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: firefox";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"firefox");
if(!isnull(bver) && revcomp(a:bver, b:"2.0.0.17,1")<0) {
    security_note(0, data:"Package firefox version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux-firefox");
if(!isnull(bver) && revcomp(a:bver, b:"2.0.0.17")<0) {
    security_note(0, data:"Package linux-firefox version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"firefox3");
if(!isnull(bver) && revcomp(a:bver, b:"3.0.2,1")<0) {
    security_note(0, data:"Package firefox3 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"seamonkey");
if(!isnull(bver) && revcomp(a:bver, b:"1.1.12")<0) {
    security_note(0, data:"Package seamonkey version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux-seamonkey");
if(!isnull(bver) && revcomp(a:bver, b:"1.1.12")<0) {
    security_note(0, data:"Package linux-seamonkey version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"thunderbird");
if(!isnull(bver) && revcomp(a:bver, b:"2.0.17")<0) {
    security_note(0, data:"Package thunderbird version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux-thunderbird");
if(!isnull(bver) && revcomp(a:bver, b:"2.0.17")<0) {
    security_note(0, data:"Package linux-thunderbird version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"flock");
if(!isnull(bver) && revcomp(a:bver, b:"0")>0) {
    security_note(0, data:"Package flock version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux-flock");
if(!isnull(bver) && revcomp(a:bver, b:"0")>0) {
    security_note(0, data:"Package linux-flock version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux-firefox-devel");
if(!isnull(bver) && revcomp(a:bver, b:"0")>0) {
    security_note(0, data:"Package linux-firefox-devel version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux-seamonkey-devel");
if(!isnull(bver) && revcomp(a:bver, b:"0")>0) {
    security_note(0, data:"Package linux-seamonkey-devel version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
