# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-0636 (libnasl)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63271);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Fedora Core 9 FEDORA-2009-0636 (libnasl)";
 script_name(name);

 desc = "The remote host is missing an update to libnasl
announced via advisory FEDORA-2009-0636.

ChangeLog:

* Mon Jan 12 2009 Andreas Bierfert 
- 2.2.11-3
- fix #479655

References:

[ 1 ] Bug #479655 - libnasl: OpenSSL incorrect checks for malformed signatures
https://bugzilla.redhat.com/show_bug.cgi?id=479655

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update libnasl' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-0636

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 9 FEDORA-2009-0636 (libnasl)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"libnasl", rpm:"libnasl~2.2.11~3.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libnasl-devel", rpm:"libnasl-devel~2.2.11~3.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libnasl-doc", rpm:"libnasl-doc~2.2.11~3.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libnasl-debuginfo", rpm:"libnasl-debuginfo~2.2.11~3.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
