# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 495-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53708);
 script_cve_id("CVE-2003-0127", "CVE-2004-0003", "CVE-2004-0010", "CVE-2004-0109", "CVE-2004-0177", "CVE-2004-0178");
 script_bugtraq_id(10152);
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.2");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 495-1 (kernel)";
 script_name(name);

 desc = "The remote host is missing an update to kernel-source-2.4.16 kernel-patch-2.4.16-arm kernel-image-2.4.16-lart kernel-image-2.4.16-netwinder kernel-image-2.4.16-riscpc
announced via advisory DSA 495-1.

These problems are also fixed by upstream in Linux 2.4.26 and will be
fixed in Linux 2.6.6.

For a more detailed description of the problems addressed,
please visit the referenced security advisory.

The following security matrix explains which kernel versions for which
architectures are already fixed and which will be removed instead.

Architecture      stable (woody)            unstable (sid)
source            2.4.16-1woody2            2.4.25-3
arm/patch         20040419                  20040316
arm/lart          20040419                  2.4.25-4
arm/netwinder     20040419                  2.4.25-4
arm/riscpc        20040419                  2.4.25-4

We recommend that you upgrade your kernel packages immediately.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20495-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 495-1 (kernel)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kernel-doc-2.4.16", ver:"2.4.16-1woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-source-2.4.16", ver:"2.4.16-1woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-patch-2.4.16-arm", ver:"20040419", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.4.16-lart", ver:"20040419", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.4.16", ver:"20040419", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.4.16-netwinder", ver:"20040419", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.4.16-riscpc", ver:"20040419", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
