# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1885-1 (xulrunner)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64870);
 script_cve_id("CVE-2009-3070", "CVE-2009-3071", "CVE-2009-3072", "CVE-2009-3074", "CVE-2009-3075", "CVE-2009-3076", "CVE-2009-3077", "CVE-2009-3078");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("Debian Security Advisory DSA 1885-1 (xulrunner)");

 desc = "The remote host is missing an update to xulrunner
announced via advisory DSA 1885-1.

Several remote vulnerabilities have been discovered in Xulrunner, a
runtime environment for XUL applications, such as the Iceweasel web
browser. The Common Vulnerabilities and Exposures project identifies
the following problems:

CVE-2009-3070

Jesse Ruderman discovered crashes in the layout engine, which
might allow the execution of arbitrary code.

CVE-2009-3071

Daniel Holbert, Jesse Ruderman, Olli Pettay and toshi discovered
crashes in the layout engine, which might allow the execution of
arbitrary code.

CVE-2009-3072

Josh Soref, Jesse Ruderman and Martin Wargers discovered crashes
in the layout engine, which might allow the execution of arbitrary
code.

CVE-2009-3074

Jesse Ruderman discovered a crash in the Javascript engine, which
might allow the execution of arbitrary code.

CVE-2009-3075

Carsten Book and Taral discovered crashes in the layout engine,
which might allow the execution of arbitrary code.

CVE-2009-3076

Jesse Ruderman discovered that the user interface for installing/
removing PCKS #11 securiy modules wasn't informative enough, which
might allow social engineering attacks.

CVE-2009-3077

It was discovered that incorrect pointer handling in the XUL parser
could lead to the execution of arbitrary code.

CVE-2009-3078

Juan Pablo Lopez Yacubian discovered that incorrent rendering of
some Unicode font characters could lead to spoofing attacks on
the location bar.

For the stable distribution (lenny), these problems have been fixed
in version 1.9.0.14-0lenny1.

As indicated in the Etch release notes, security support for the
Mozilla products in the oldstable distribution needed to be stopped
before the end of the regular Etch security maintenance life cycle.
You are strongly encouraged to upgrade to stable or switch to a still
supported browser.

For the unstable distribution (sid), these problems have been fixed in
version 1.9.0.14-1.

For the experimental distribution, these problems have been fixed in
version 1.9.1.3-1.

We recommend that you upgrade your xulrunner package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201885-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1885-1 (xulrunner)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libmozillainterfaces-java", ver:"1.9.0.14-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-dev", ver:"1.9.0.14-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9-gnome-support", ver:"1.9.0.14-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9-dbg", ver:"1.9.0.14-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"spidermonkey-bin", ver:"1.9.0.14-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-xpcom", ver:"1.9.0.14-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9", ver:"1.9.0.14-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmozjs1d", ver:"1.9.0.14-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmozjs-dev", ver:"1.9.0.14-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmozjs1d-dbg", ver:"1.9.0.14-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
