###############################################################################
# OpenVAS Vulnerability Test
# $Id$
#
# IceWarp Merak Mail Server 'Base64FileEncode()' Stack-Based Buffer Overflow Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(100168);
  script_tag(name:"cvss_base", value:"7.5");
 script_cve_id("CVE-2009-1516");
 script_bugtraq_id(34739);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_version("Revision: 1.0");
  script_tag(name:"risk_factor", value:"High");
  script_category(ACT_GATHER_INFO);
  script_family("SMTP problems");
  script_name("IceWarp Merak Mail Server 'Base64FileEncode()' Stack-Based Buffer Overflow Vulnerability");
  script_summary("Check for vulnerable version of IceWarp");
  desc = "
  Overview:
   IceWarp Merak Mail Server s prone to a stack-based buffer-overflow
   vulnerability because the application fails to bounds-check
   user-supplied data before copying it into an insufficiently sized
   buffer.

   An attacker could exploit this issue to execute arbitrary code in
   the context of the affected application. Failed exploit attempts
   will likely result in denial-of-service conditions.

   IceWarp Merak Mail Server 9.4.1 is vulnerable; other versions may
   also be affected.

  See also:
   http://www.securityfocus.com/bid/34739

  Risk factor: Medium";

  script_description(desc);
  script_dependencies("gb_merak_mail_server_detect.nasl");
  script_require_keys("MerakMailServer/Ver");
  exit(0);
}


include("version_func.inc");
  
merakVer = get_kb_item("MerakMailServer/Ver");
if(merakVer == NULL){
  exit(0);
} 
 
if(version_is_less_equal(version:merakVer, test_version:"9.4.1")){
  security_hole(0);
}
