/*
 *  Copyright (c) 2009 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "OpenShiva/Kernel.h"
#include "GTLCore/Image.h"
#include "GTLCore/Type.h"

class TestKernelChannel : public GTLTest::Case {
  public:
    TestKernelChannel() : GTLTest::Case("KernelChannel")
    {
    }
    virtual void runTest()
    {
      OpenShiva::Kernel k;
      k.setSource(
"kernel PlainGenerator \
{ \
  void evaluatePixel(out pixel4 result) \
  { \
    result[0] = 1.0; result[1] = 1.0; result[2] = 1.0; result[3] = 1.0; \
  } \
}" );
      k.compile();
      GTLTEST_CHECK_REQUIRED(k.isCompiled());
      GTLCore::Image img(1, 1, GTLCore::PixelDescription(GTLCore::Type::UnsignedInteger8, 4));
      img.data<gtl_uint8>(0,0)[0] = 0;
      img.data<gtl_uint8>(0,0)[1] = 0;
      img.data<gtl_uint8>(0,0)[2] = 0;
      img.data<gtl_uint8>(0,0)[3] = 0;
      GTLCore::ChannelsFlags flags;
      flags.disableChannel(1);
      k.evaluatePixels( GTLCore::RegionI(0,0,1,1), std::list< const GTLCore::AbstractImage* >(), &img, 0, GTLCore::Transform(), flags);
      
      GTLTEST_CHECK_EQUAL( img.data<gtl_uint8>(0,0)[0], 255 );
      GTLTEST_CHECK_EQUAL( int(img.data<gtl_uint8>(0,0)[1]), 0 );
      GTLTEST_CHECK_EQUAL( img.data<gtl_uint8>(0,0)[2], 255 );
      GTLTEST_CHECK_EQUAL( img.data<gtl_uint8>(0,0)[3], 255 );
    }
};
