/*
 *  Copyright (c) 2004,2007,2008,2009,2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENRIJN_IMAGEENGINE_SHAPE_GENERATOR_H_
#define _OPENRIJN_IMAGEENGINE_SHAPE_GENERATOR_H_

#include <GTLCore/Macros.h>

namespace OpenRijn {
  namespace ImageEngine {
    class AbstractShapeGenerator {
      GTL_NO_COPY(AbstractShapeGenerator)
      protected:
        AbstractShapeGenerator(float radius, float ratio, float fh, float fv, int spikes);
      public:
        virtual ~AbstractShapeGenerator();
        virtual float valueAt(float x, float y) const = 0;
        float radius() const;
      protected:
        float m_radius, m_ratio, m_fh, m_fv, m_spikes, m_cs, m_ss;
        bool m_empty;
    };
    class CircleShapeGenerator : public AbstractShapeGenerator {
      GTL_NO_COPY(CircleShapeGenerator)
      public:
        CircleShapeGenerator(float radius, float ratio, float fh, float fv, int spikes);
        virtual ~CircleShapeGenerator();
        virtual float valueAt(float x, float y) const;
      private:
        float m_xcoef, m_ycoef;
        float m_xfadecoef, m_yfadecoef;
        float m_cachedSpikesAngle;
    };
    class RectangleShapeGenerator : public AbstractShapeGenerator {
      GTL_NO_COPY(RectangleShapeGenerator)
      public:
        RectangleShapeGenerator(float radius, float ratio, float fh, float fv, int spikes);
        virtual ~RectangleShapeGenerator();
        virtual float valueAt(float x, float y) const;
      private:
        float m_c;
    };
  }
}

#endif
