# {%= name %} {%= badge("fury") %}

> {%= description %}

This really just checks to make sure that a pattern is either a string or array, and if it's an array it's either empty or consists of only strings. 

## Install
{%= include("install-npm", {save: true}) %}

## Usage

```js
var isValidGlob = require('{%= name %}');

isValidGlob('foo/*.js');
//=> true
```

**Valid patterns**

```js
isValidGlob('a');
isValidGlob('a.js');
isValidGlob('*.js');
isValidGlob(['a', 'b']);
//=> all true
```

**Invalid patterns**

```js
isValidGlob();
isValidGlob('');
isValidGlob(null);
isValidGlob(undefined);
isValidGlob(new Buffer('foo'));
isValidGlob(['foo', [[]]]);
isValidGlob(['foo', [['bar']]]);
isValidGlob(['foo', {}]);
isValidGlob({});
isValidGlob([]);
isValidGlob(['']);
//=> all false
```

## Related projects
{%= related(verb.related.list, {remove: name}) %}  

## Running tests
{%= include("tests") %}

## Contributing
{%= include("contributing") %}

## Author
{%= include("author") %}

## License
{%= copyright() %}
{%= license() %}

***

{%= include("footer") %}
