/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.javafx2.project.ui;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.DialogDescriptor;

/**
 *
 * @author Petr Somol
 */
public class JFXRequestRuntimePanel extends javax.swing.JPanel implements DocumentListener{

    private DialogDescriptor desc;

    /**
     * Creates new form JFXRequestRuntimePanel
     */
    public JFXRequestRuntimePanel() {
        initComponents();
        textFieldRT.setText(null);
    }

    public void registerListener() {
        textFieldRT.getDocument().addDocumentListener(this);
    }
    
    public void unregisterListener() {
        textFieldRT.getDocument().removeDocumentListener(this);
    }

    public void setDialogDescriptor(DialogDescriptor desc) {
        this.desc = desc;
        updateButtons();
    }
    
    public String getInputText() {
        return textFieldRT.getText();
    }
    
    public void setInputText(String text) {
        textFieldRT.setText(text);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        labelRT = new javax.swing.JLabel();
        textFieldRT = new javax.swing.JTextField();

        labelRT.setLabelFor(textFieldRT);
        org.openide.awt.Mnemonics.setLocalizedText(labelRT, org.openide.util.NbBundle.getMessage(JFXRequestRuntimePanel.class, "JFXRequestRuntimePanel.labelRT.text")); // NOI18N
        labelRT.setToolTipText(org.openide.util.NbBundle.getMessage(JFXRequestRuntimePanel.class, "AD_JFXDeploymentPanel.textFieldRT.text")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(labelRT)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(textFieldRT, javax.swing.GroupLayout.DEFAULT_SIZE, 231, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(labelRT)
                    .addComponent(textFieldRT, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        textFieldRT.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(JFXRequestRuntimePanel.class, "AN_JFXDeploymentPanel.textFieldRT.text")); // NOI18N
        textFieldRT.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(JFXRequestRuntimePanel.class, "AD_JFXDeploymentPanel.textFieldRT.text")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel labelRT;
    private javax.swing.JTextField textFieldRT;
    // End of variables declaration//GEN-END:variables

    @Override
    public void insertUpdate(DocumentEvent e) {
        updateButtons();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        updateButtons();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        updateButtons();
    }
    
    private void updateButtons() {
        String s = textFieldRT.getText();
        if(s == null || s.trim().isEmpty()) {
           desc.setValid(false);
        } else {
           desc.setValid(true);
        }
    }
}
