def create_iso15924_script_list_file
  content = Mtx::OnlineFile.download("https://unicode.org/iso15924/iso15924.txt.zip")

  rows = content.
    force_encoding("UTF-8").
    split(%r{\n+}).
    map(&:chomp).
    reject { |line| %r{^#}.match(line) }.
    reject { |line| %r{^Qa(a|b[a-x])}.match(line) }.
    select { |line| %r{;.*;.*;}.match(line) }.
    map    { |line| line.split(';') }.
    map    { |line| [
      (line[0][0..0].upcase + line[0][1..line[0].length].downcase).to_cpp_string,
      sprintf('%03s', line[1].gsub(%r{^0}, '')),
      line[2].to_u8_cpp_string,
    ] }

  rows += (0..49).map do |idx|
    [
      sprintf('"Qa%s%s"s', ('a'.ord + (idx / 26)).chr, ('a'.ord + (idx % 26)).chr),
      (900 + idx).to_s,
      'u8"Reserved for private use"s',
    ]
  end

  header = <<EOT
/*
   mkvmerge -- utility for splicing together matroska files
   from component media subtypes

   Distributed under the GPL v2
   see the file COPYING for details
   or visit https://www.gnu.org/licenses/old-licenses/gpl-2.0.html

   ISO 15924 script list

   Written by Moritz Bunkus <moritz@bunkus.org>.
*/

// -------------------------------------------------------------------------
// NOTE: this file is auto-generated by the "dev:iso15924_list" rake target.
// -------------------------------------------------------------------------

#include "common/common_pch.h"

#include "common/iso15924.h"

namespace mtx::iso15924 {

std::vector<script_t> g_scripts;

void
init() {
  g_scripts.reserve(#{rows.size});

EOT

  footer = <<EOT
}

} // namespace mtx::iso15924
EOT

  content       = header + format_table(rows.sort, :column_suffix => ',', :row_prefix => "  g_scripts.emplace_back(", :row_suffix => ");").join("\n") + "\n" + footer
  cpp_file_name = "src/common/iso15924_script_list.cpp"

  runq("write", cpp_file_name) { IO.write("#{$source_dir}/#{cpp_file_name}", content); 0 }
end
