package org.apache.maven.scm.provider.perforce.command.edit;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmTestCase;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.plexus.util.cli.Commandline;

import java.io.File;
import java.util.Arrays;

/**
 * @author <a href="mailto:evenisse@apache.org">Emmanuel Venisse</a>
 * @author <a href="mailto:trygvis@inamo.no">Trygve Laugst&oslash;l</a>
 *
 */
public class PerforceEditCommandTest
    extends ScmTestCase
{
    private static final String cmdPrefix = "p4 -d ";

    public void testGetCommandLine()
        throws Exception
    {
        File workingDir = new File( "." );
        ScmFileSet files = new ScmFileSet( new File( "." ), Arrays.asList(
            new File[]{ new File( "foo.xml" ), new File( "bar.xml" ) } ) );
        String commandLineString = cmdPrefix + workingDir.getAbsolutePath() + " edit";
        for ( File file : files.getFileList() )
        {
            commandLineString += " " + file.getPath();
        }
        testCommandLine( "scm:perforce://depot/projects/pathname", commandLineString, workingDir, files );
    }

    public void testRelativeCommandLine()
        throws Exception
    {
        File workingDir = new File( "baz/qux" );
        ScmFileSet files = new ScmFileSet( new File( "." ), Arrays.asList(
            new File[]{ new File( "foo.xml" ), new File( "bar.xml" ) } ) );
        String commandLineString = cmdPrefix + workingDir.getAbsolutePath() + " edit";
        for ( File file : files.getFileList() )
        {
            commandLineString += " " + file.getPath();
        }
        testCommandLine( "scm:perforce://depot/projects/pathname", commandLineString, workingDir, files );
    }

    public void testAbsoluteCommandLine()
        throws Exception
    {
        File workingDir = new File( "." ).getAbsoluteFile();
        ScmFileSet files = new ScmFileSet( new File( "." ), Arrays.asList(
            new File[]{ new File( "foo.xml" ), new File( "bar.xml" ) } ) );
        String commandLineString = cmdPrefix + workingDir.getAbsolutePath() + " edit";
        for ( File file : files.getFileList() )
        {
            commandLineString += " " + file.getPath();
        }
        testCommandLine( "scm:perforce://depot/projects/pathname", commandLineString, workingDir, files );
    }

    // ----------------------------------------------------------------------
    //
    // ----------------------------------------------------------------------

    private void testCommandLine( String scmUrl, String commandLine, File workingDir, ScmFileSet files )
        throws Exception
    {
        ScmRepository repository = getScmManager().makeScmRepository( scmUrl );
        PerforceScmProviderRepository svnRepository =
            (PerforceScmProviderRepository) repository.getProviderRepository();
        Commandline cl = PerforceEditCommand.createCommandLine( svnRepository, workingDir, files );

        assertCommandLine( commandLine, null, cl );
    }

}
