/* ----- core/scale3sntrup857, derived from supercop/crypto_core/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *core_scale3sntrup857_checksums[] = {
  "9a0c86ef536b17661fc00fb0a1d3bbaeb811467e20cdaf7f3b2e9d11c157e112",
  "60cf4ed2b17e4f69461e1edebcc59e2a39c232d1d352b51f4ebb2b578f4833fe",
} ;

static void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
#define crypto_core_OUTPUTBYTES ntruprime_core_scale3sntrup857_OUTPUTBYTES
#define crypto_core_INPUTBYTES ntruprime_core_scale3sntrup857_INPUTBYTES
#define crypto_core_KEYBYTES ntruprime_core_scale3sntrup857_KEYBYTES
#define crypto_core_CONSTBYTES ntruprime_core_scale3sntrup857_CONSTBYTES

static void *storage_core_scale3sntrup857_h;
static unsigned char *test_core_scale3sntrup857_h;
static void *storage_core_scale3sntrup857_n;
static unsigned char *test_core_scale3sntrup857_n;
static void *storage_core_scale3sntrup857_k;
static unsigned char *test_core_scale3sntrup857_k;
static void *storage_core_scale3sntrup857_c;
static unsigned char *test_core_scale3sntrup857_c;
static void *storage_core_scale3sntrup857_h2;
static unsigned char *test_core_scale3sntrup857_h2;
static void *storage_core_scale3sntrup857_n2;
static unsigned char *test_core_scale3sntrup857_n2;
static void *storage_core_scale3sntrup857_k2;
static unsigned char *test_core_scale3sntrup857_k2;
static void *storage_core_scale3sntrup857_c2;
static unsigned char *test_core_scale3sntrup857_c2;

#define precomputed_core_scale3sntrup857_NUM 4

static const unsigned char precomputed_core_scale3sntrup857_h[precomputed_core_scale3sntrup857_NUM][crypto_core_OUTPUTBYTES] = {
  {130,161,204,252,160,188,30,23,95,40,0,14,106,4,230,108,151,192,74,238,68,4,77,174,63,95,183,215,46,183,74,29,33,245,35,227,229,6,202,250,131,74,131,248,3,52,181,250,187,76,29,172,115,66,56,201,167,243,53,112,100,245,47,95,117,64,172,6,149,37,20,0,25,218,37,243,91,169,0,110,58,87,97,11,29,48,5,254,145,117,12,9,187,11,76,61,212,205,108,5,194,75,90,40,27,17,126,192,191,42,238,253,88,65,27,73,220,53,40,20,33,247,218,79,99,61,74,15,249,218,20,58,170,36,99,3,153,211,159,238,171,1,96,1,83,44,255,26,61,254,104,216,249,80,137,69,69,242,236,10,151,232,92,105,35,228,76,190,103,0,32,237,4,247,110,247,92,230,34,214,16,252,66,188,117,163,63,31,244,71,144,32,72,50,46,162,113,252,21,217,11,50,27,189,166,24,19,0,149,248,64,228,174,242,27,97,72,110,103,94,228,212,231,202,250,174,204,7,3,89,45,30,193,65,80,57,112,192,160,76,38,92,165,247,243,177,207,31,88,185,175,90,37,253,134,4,10,169,61,93,21,54,136,165,42,182,48,160,18,1,77,94,157,20,255,6,71,190,146,2,160,8,246,199,113,8,194,5,164,187,127,211,130,110,13,169,104,99,99,236,33,26,64,45,189,234,95,207,134,80,140,191,204,57,100,205,150,34,120,247,101,210,41,74,6,60,31,106,56,83,189,238,75,10,137,92,75,66,222,23,204,114,124,3,177,51,48,84,33,253,90,250,51,240,182,40,57,222,143,217,85,223,86,104,102,168,154,158,235,169,222,9,140,176,194,216,82,3,249,249,180,217,231,160,250,161,18,174,60,237,207,204,146,187,7,44,104,7,252,35,143,2,70,64,4,80,248,22,141,200,38,240,82,6,20,222,84,178,137,183,38,250,74,163,158,110,175,1,44,72,34,91,92,175,110,175,113,18,99,3,59,250,58,8,120,85,236,196,178,106,98,232,226,224,119,88,77,91,98,168,174,71,47,175,178,60,154,219,219,247,144,29,96,37,161,205,73,249,208,215,69,248,157,173,97,253,222,109,129,223,103,247,249,58,41,105,12,95,165,255,18,227,177,67,33,79,45,240,225,105,244,22,213,54,252,236,155,235,89,1,46,220,125,50,18,231,175,209,224,173,116,41,114,243,204,51,69,70,21,107,80,105,47,248,67,175,1,79,141,192,127,44,0,172,245,93,50,83,72,250,25,215,73,36,66,47,121,164,3,13,106,29,217,177,130,89,222,1,233,69,253,184,113,3,240,59,125,9,156,203,122,106,31,222,215,11,97,42,114,7,151,6,19,82,138,87,238,5,165,249,16,68,43,216,33,47,58,208,174,9,26,249,165,222,250,186,184,246,249,206,162,176,123,214,227,162,12,1,68,3,36,17,145,254,252,192,40,98,82,219,183,16,90,164,35,213,241,85,98,161,113,212,59,242,183,230,246,93,55,203,29,178,223,187,2,101,188,24,67,47,249,57,164,41,109,228,238,7,189,4,183,253,101,250,78,175,228,17,166,246,101,213,35,82,111,254,189,209,219,180,208,253,111,0,237,248,34,94,157,237,42,75,110,85,21,216,88,7,167,16,32,59,6,161,78,28,144,180,227,247,112,99,140,163,219,158,210,236,13,59,101,54,80,215,183,65,209,206,96,238,82,159,79,202,99,235,3,21,29,250,66,199,238,167,49,183,220,65,222,248,196,102,150,3,158,70,117,54,131,1,236,182,98,64,61,109,34,250,28,9,213,30,107,55,50,250,139,91,158,254,238,219,185,163,241,249,244,106,249,11,129,102,180,247,174,196,245,82,225,165,29,33,17,4,2,180,93,93,234,180,245,5,64,174,157,221,102,12,100,9,215,34,165,37,122,248,86,52,242,229,204,234,192,222,144,185,152,7,141,252,35,20,136,163,119,58,32,52,55,251,192,178,163,186,207,19,136,222,45,225,224,99,35,166,9,87,139,190,181,216,240,177,41,255,76,6,21,178,147,180,209,31,127,115,153,252,166,198,250,229,70,1,53,2,113,249,98,3,223,14,40,213,132,254,174,254,3,36,169,207,140,239,196,253,100,246,81,246,5,176,6,43,86,238,235,8,90,43,79,1,0,11,85,173,180,17,41,78,80,97,164,182,99,195,12,250,204,253,82,252,144,15,215,254,97,32,186,106,205,44,81,4,93,235,185,248,245,70,65,101,164,214,92,7,126,67,204,198,55,21,94,178,84,97,118,0,133,52,110,95,249,3,207,176,71,224,167,58,168,189,66,255,88,243,15,249,80,11,174,62,253,57,143,64,140,250,199,178,209,215,76,181,247,79,8,12,57,188,41,5,216,179,222,3,140,87,82,71,21,242,6,40,212,207,63,104,77,15,78,78,88,22,206,246,24,25,202,87,254,47,100,97,164,45,239,252,194,25,152,255,235,163,112,214,23,0,146,192,54,76,69,51,140,247,9,188,55,180,153,234,161,108,243,91,224,248,112,62,110,33,178,40,214,250,236,106,165,178,109,53,230,112,231,252,185,86,17,190,248,112,50,83,26,32,6,3,235,37,68,6,180,4,180,13,78,46,252,253,71,1,111,229,42,215,171,249,85,214,6,28,85,185,157,19,68,56,201,196,199,103,91,22,22,195,22,101,80,216,152,4,90,246,199,251,95,78,153,3,75,246,7,214,34,226,78,107,194,228,63,4,180,248,251,248,3,94,18,76,25,52,240,65,57,70,127,205,145,169,91,202,221,65,214,203,14,202,33,9,130,76,70,179,102,2,203,28,123,34,117,80,234,249,70,221,151,236,249,162,97,254,133,174,44,168,178,77,38,97,139,46,158,248,79,207,131,42,60,115,174,4,33,91,139,75,238,9,37,6,47,8,225,255,180,238,27,16,208,194,178,7,76,26,98,8,50,249,124,237,122,225,197,250,197,93,198,10,197,249,208,6,42,71,254,252,233,57,159,62,163,104,128,53,253,14,71,46,23,2,78,19,153,35,222,191,172,38,48,16,8,98,64,64,178,252,149,185,253,232,92,13,209,21,89,12,178,114,248,244,213,95,153,76,187,247,6,255,80,71,68,37,240,34,211,81,94,13,149,52,162,26,170,38,247,217,92,229,69,238,212,23,217,56,55,23,2,249,206,98,141,255,63,62,160,175,85,55,214,65,110,247,121,6,61,115,215,26,45,201,35,22,48,192,225,228,175,253,127,5,169,206,10,86,74,197,43,85,76,45,133,8,158,56,177,110,43,102,24,166,13,194,23,70,87,2,155,253,69,71,111,28,97,112,16,12,172,217,80,0,19,28,216,53,37,8,31,114,234,46,202,240,210,223,48,102,143,224,40,29,231,1,176,48,218,163,118,247,144,192,61,7,53,19,36,80,206,253,36,175,147,3,152,50,233,23,191,255,190,159,177,12,217,5,92,64,239,110,37,6,227,79,254,252,125,115,131,66,255,254,150,223,76,31,199,111,202,101,50,255,44,228,204,181,155,74,199,163,16,28,64,64,84,44,203,92,167,77,44,7,246,219,39,247,214,177,121,39,7,228,125,237,255,1,131,95,45,26,125,6,74,50,68,82,215,66,86,163,179,160,227,41,219,40,68,204,28,89,14,23,4,55,218,0,253,189,116,224,143,250,73,114,150,169,57,215,123,26,4,10,162,6,53,57,81,82,246,195,155,220,226,248,123,17,107,184,197,214,103,246,132,57,84,25,39,77,29,255,230,68,179,41,9,179,238,254,186,2,39,229,191,3,32,78,87,219,98,222,46,195,162,49,130,3,225,9,21,93,87,52,87,160,80,226,144,14},
  {83,216,52,5,74,4,255,43,231,246,220,245,37,62,48,165,210,103,213,1,136,89,232,234,234,73,139,227,201,94,251,73,119,67,140,90,134,17,81,224,42,253,163,254,12,13,116,56,40,49,221,44,180,64,129,249,50,103,107,185,10,159,33,69,143,47,216,177,185,79,166,110,74,213,63,115,192,45,10,180,86,117,112,235,19,174,159,212,43,163,24,38,76,197,144,182,189,103,234,9,170,247,165,173,237,201,140,250,10,232,43,76,136,114,253,223,173,228,146,52,78,67,101,250,132,186,217,247,1,68,77,97,173,0,226,177,72,218,152,163,11,9,123,3,42,99,55,165,234,42,160,2,10,85,36,71,111,89,155,65,143,7,20,254,52,87,243,247,66,22,185,178,3,2,164,18,96,15,185,49,212,172,122,202,122,108,167,65,36,244,110,114,107,58,240,205,6,78,255,234,73,189,151,58,97,251,196,230,113,58,14,225,163,67,219,8,6,183,153,180,109,96,91,5,2,108,193,164,4,215,129,250,57,116,197,81,32,215,193,252,161,181,224,255,194,7,45,56,107,226,122,158,254,49,146,77,223,91,119,24,218,69,233,9,235,9,140,208,247,194,52,249,10,44,233,192,60,248,191,231,235,15,2,86,9,252,221,6,187,24,35,248,102,182,22,225,253,51,161,91,173,16,230,195,34,20,165,21,117,104,93,251,147,27,30,1,56,29,97,13,157,244,9,231,75,32,198,7,14,68,129,168,185,81,52,5,186,3,200,45,82,162,46,79,213,34,117,90,140,224,121,214,49,17,194,39,98,2,22,208,223,174,174,224,145,195,33,2,49,247,149,9,98,202,6,37,20,8,184,236,85,66,129,219,180,21,74,49,248,39,121,193,34,47,244,34,184,210,52,70,218,2,69,189,209,250,79,33,118,14,253,170,251,74,221,107,92,193,66,164,150,67,75,181,143,243,46,90,252,7,144,58,166,65,102,59,125,112,190,250,109,203,130,105,177,102,246,5,89,81,232,193,82,8,114,11,7,6,213,198,142,82,64,167,28,249,52,13,182,77,35,219,4,54,192,113,207,204,202,6,185,173,104,59,56,22,60,197,73,169,75,253,164,1,6,206,136,23,48,115,78,79,136,30,219,78,40,167,139,79,173,93,98,25,237,248,228,93,48,207,209,48,247,237,198,97,156,204,63,160,237,229,241,10,252,211,74,182,113,192,41,32,236,253,116,246,238,251,176,34,24,177,185,2,84,255,225,51,127,224,213,5,102,111,19,56,202,188,209,93,246,215,107,105,178,252,148,211,198,249,227,164,77,246,199,223,223,178,111,70,125,193,156,73,44,247,175,254,169,1,249,184,137,64,67,162,144,8,69,189,76,36,247,16,132,50,38,253,241,8,228,167,178,228,222,210,163,251,98,199,236,228,199,2,49,165,78,216,216,93,94,168,105,250,9,185,195,205,5,3,191,69,184,25,62,221,152,237,112,179,59,206,32,114,90,77,100,39,1,39,138,55,4,252,120,51,114,102,200,251,41,207,229,251,111,194,91,42,218,160,19,95,80,38,89,197,42,29,167,72,84,7,24,229,20,226,228,59,253,38,31,93,126,60,61,91,231,41,224,186,36,99,190,76,62,24,8,26,78,238,234,4,250,42,207,241,86,245,102,12,248,2,217,249,196,47,170,49,225,216,248,203,213,114,106,203,207,98,147,255,83,61,203,90,146,35,241,101,23,227,61,186,91,52,218,196,226,82,237,173,111,4,14,84,63,217,156,85,114,189,112,216,86,232,131,183,217,40,195,70,198,9,86,108,106,232,57,109,244,173,110,62,115,243,199,64,126,201,183,173,6,89,152,6,51,50,150,18,174,6,133,163,101,111,223,212,31,215,255,196,156,43,83,223,142,1,229,211,193,48,6,17,207,33,106,2,61,164,237,15,74,213,1,213,251,159,234,22,199,0,132,98,138,225,205,9,178,8,106,49,93,94,62,108,65,187,246,62,131,6,158,7,46,191,191,30,164,2,192,50,201,213,243,178,217,57,21,97,239,82,82,105,198,66,167,255,201,191,50,14,230,249,227,196,208,100,206,22,201,192,137,179,124,235,232,249,60,83,235,197,236,164,103,64,68,70,15,57,42,77,50,52,250,5,168,5,168,252,235,165,246,170,115,27,190,23,197,69,116,51,218,67,4,20,204,20,75,5,134,230,59,18,179,255,233,8,207,78,20,202,192,64,133,163,131,170,160,253,227,89,160,106,171,235,225,213,205,111,106,6,234,249,172,169,194,13,182,1,61,170,200,182,35,252,223,188,100,212,24,30,215,252,178,222,99,221,82,65,43,83,4,42,47,182,249,8,161,166,81,117,62,169,143,11,220,164,12,73,159,9,41,255,147,173,117,175,132,80,17,50,125,173,182,229,188,11,3,68,54,237,63,208,105,94,22,55,205,0,153,26,239,66,216,34,248,67,84,231,43,193,46,49,136,114,13,94,136,162,72,242,40,117,123,80,144,1,210,66,172,53,24,163,225,9,217,237,82,52,31,184,224,5,140,50,16,60,177,254,61,234,199,26,114,19,76,41,204,76,17,62,138,50,10,199,129,64,9,248,214,97,122,251,214,85,126,45,46,238,96,8,120,7,55,55,10,20,2,39,160,248,243,193,238,198,39,24,43,163,152,215,162,215,207,82,9,106,185,12,70,240,209,6,196,9,225,3,87,234,119,7,110,80,233,247,142,218,61,23,237,78,88,16,228,178,228,47,188,56,102,253,106,225,166,28,216,169,10,251,241,191,198,184,208,180,219,114,164,78,124,253,17,255,105,2,55,214,9,186,150,168,131,2,252,69,159,234,163,216,254,107,108,3,223,0,225,184,42,53,226,76,46,3,80,97,53,26,242,84,37,0,75,80,183,205,164,0,216,33,124,227,83,3,196,213,75,90,66,59,245,237,78,188,201,98,87,212,192,56,228,102,232,221,206,16,212,11,24,247,176,71,212,231,9,179,79,251,83,205,211,51,167,163,169,92,109,226,185,180,39,173,83,106,216,48,120,1,41,206,124,38,215,28,177,102,0,67,111,164,206,251,115,70,156,198,167,22,20,19,220,251,234,30,46,91,40,188,204,65,177,1,37,252,218,246,12,253,166,250,133,252,185,221,172,18,110,42,199,251,155,184,169,74,77,251,142,94,0,90,152,4,189,3,119,174,134,88,7,0,201,7,88,10,79,25,60,49,219,52,53,216,207,181,29,76,86,19,216,3,85,245,102,216,8,114,68,2,78,193,78,207,58,200,143,180,76,188,130,6,236,246,217,67,162,62,88,47,26,251,116,39,70,218,76,0,77,96,212,250,239,5,73,85,197,57,14,85,37,47,45,98,23,252,27,169,88,163,131,8,25,101,2,5,128,173,142,90,31,249,45,68,241,66,0,169,78,104,2,239,96,5,180,215,18,255,239,209,203,251,1,103,225,185,190,253,246,12,61,13,87,211,70,51,235,21,130,99,229,61,140,98,203,185,231,52,253,162,95,90,57,57,185,200,203,64,210,233,217,7,238,101,98,50,83,109,90,251,236,9,172,59,198,38,50,187,135,28,42,2,39,241,111,221,156,169,204,82,20,9,222,0,222,242,193,62,72,183,210,196,123,31,117,32,224,31,202,4,213,198,121,15,18,7,160,83,83,246,218,225,222,102,16,255,123,255,82,54,98,111,120,51,124,15,248,1,168,225,165,191,254,240,23,114,32,8,249,25,65,23,84,84,90,113,3,98,6,240,182,111,44,32,164,160,227,3,197,173,156,16,86,106,84,55,191,216,83,82,121,249,49,72,182,163,80,50,244,248,194,39,159,107,3,9,22,5},
  {125,237,210,244,206,160,38,114,236,247,254,161,130,108,187,53,241,78,69,103,229,48,1,221,57,27,109,177,99,4,112,239,119,247,190,245,91,158,86,181,144,108,252,254,113,114,250,86,120,240,140,165,244,65,84,61,138,7,102,89,83,5,132,101,103,25,139,48,97,9,155,114,52,54,58,26,160,106,91,1,226,106,228,228,158,250,173,109,111,255,189,180,219,249,145,171,11,187,155,6,250,171,108,61,111,24,81,158,23,187,72,1,43,38,242,15,92,65,77,218,221,212,235,175,84,41,145,251,206,0,76,255,72,228,211,248,195,47,87,95,48,105,55,221,31,77,54,1,224,232,108,0,150,53,56,20,167,204,94,82,14,192,225,27,213,173,127,182,129,98,148,20,92,5,136,16,204,248,208,70,57,3,131,173,83,81,243,64,198,43,220,6,25,66,22,219,51,182,183,98,216,54,200,254,127,216,102,1,40,87,206,248,243,214,229,71,167,199,228,168,121,247,221,254,131,80,219,193,94,2,25,202,251,18,39,64,213,190,114,206,225,40,177,18,168,17,227,200,222,22,7,213,96,94,66,197,135,88,222,159,137,63,50,27,0,31,233,243,206,81,105,65,147,226,72,64,124,29,114,198,77,203,164,61,62,69,177,222,25,163,238,158,72,71,131,172,194,175,223,8,145,72,8,42,238,89,39,74,152,90,99,233,114,168,50,48,160,253,215,183,212,254,24,236,219,93,114,174,71,252,100,213,6,36,9,159,115,237,176,31,19,183,165,70,82,247,199,182,37,34,58,254,151,49,182,246,58,176,255,70,186,89,45,188,148,94,230,250,229,187,129,171,70,160,222,2,144,226,236,180,193,31,181,68,111,95,28,250,147,62,202,104,172,105,74,184,110,36,213,183,243,3,213,177,35,21,83,70,185,102,163,253,185,245,100,186,160,213,106,190,144,190,61,171,156,9,47,168,95,158,36,9,76,6,36,5,0,197,51,220,59,249,195,178,28,248,39,240,12,4,7,33,209,0,72,75,161,252,41,111,12,87,53,84,25,229,213,251,134,16,40,173,129,3,102,238,220,3,136,246,216,58,31,8,6,4,106,247,149,225,233,14,224,59,255,49,160,215,167,249,65,228,36,219,59,14,100,65,125,184,51,25,237,159,235,191,157,6,247,71,127,207,179,2,15,171,133,2,92,193,122,51,71,172,176,113,193,92,85,45,26,176,178,163,214,55,45,244,216,236,88,72,174,61,232,213,59,240,190,102,129,167,226,225,189,240,201,61,156,93,120,246,253,8,57,68,223,56,7,67,56,199,98,233,68,101,186,24,234,107,44,72,224,65,141,162,101,169,187,4,250,236,62,255,74,234,178,161,148,70,212,116,164,189,253,71,23,0,27,187,128,169,13,248,28,251,230,7,239,103,31,83,192,168,152,189,227,17,30,17,246,105,236,35,97,111,98,84,153,8,53,1,28,55,188,70,105,38,89,244,253,93,121,172,57,59,6,239,218,6,87,223,228,114,88,231,245,232,95,202,55,95,61,3,228,242,125,17,135,39,179,168,38,246,144,3,183,68,83,75,208,253,115,65,135,243,13,83,96,2,241,36,40,29,120,167,184,3,191,7,228,187,94,218,28,115,68,61,149,103,233,100,37,96,213,188,57,26,233,16,186,230,156,85,217,47,57,194,87,24,112,188,131,5,176,214,240,19,49,254,231,247,184,215,86,7,179,184,189,46,245,7,220,34,9,24,166,87,55,247,104,17,67,34,66,37,151,57,179,52,165,254,69,68,55,1,20,6,248,192,89,249,229,165,209,172,217,216,175,2,233,254,218,200,208,33,224,217,152,114,208,63,157,7,77,253,0,214,146,27,148,38,64,68,202,105,116,227,153,163,105,3,1,39,144,35,238,56,161,9,243,6,112,255,185,96,222,211,0,178,93,255,132,4,117,175,40,56,101,7,114,6,198,30,32,85,143,58,29,246,44,35,158,238,245,2,110,250,48,17,103,226,187,181,248,15,142,175,16,82,8,112,223,246,92,16,152,249,228,6,128,3,103,42,208,199,147,253,41,192,49,207,136,47,156,87,215,12,253,237,123,184,238,170,120,106,75,54,38,96,250,35,135,234,248,255,14,4,77,1,146,38,8,91,196,81,106,1,217,68,246,87,66,221,228,105,202,94,96,6,88,247,152,223,183,204,44,40,49,55,197,41,247,106,244,75,61,41,240,63,183,110,254,37,180,0,240,182,227,59,235,97,184,54,169,99,29,163,227,229,41,41,212,224,16,89,147,6,72,243,145,225,192,159,98,233,71,213,5,3,236,101,163,108,169,160,244,107,71,249,104,109,34,62,80,49,36,213,251,1,185,47,81,201,108,45,197,7,196,34,212,110,80,97,102,87,110,231,122,32,111,246,37,2,76,222,49,46,70,249,23,249,239,162,33,96,75,34,96,79,73,19,140,111,55,249,109,19,243,40,175,11,253,65,231,251,17,58,249,200,155,214,251,4,137,46,99,112,85,0,147,111,138,29,249,189,207,231,7,216,3,8,26,198,211,105,204,254,30,25,86,246,31,248,163,193,163,58,191,2,94,27,35,174,156,88,152,109,172,164,47,251,251,22,115,229,81,243,188,57,234,247,19,248,18,34,237,67,22,195,58,117,97,98,78,241,213,72,113,95,8,90,23,29,4,9,98,111,48,113,193,114,93,3,200,221,95,221,55,218,192,6,108,191,200,230,43,95,43,80,241,97,129,0,81,69,59,250,52,47,212,205,165,254,62,218,222,86,154,96,235,225,98,162,142,254,63,0,130,83,61,252,248,246,174,79,61,13,144,211,240,253,153,96,35,7,31,4,49,235,236,42,59,117,221,185,48,243,77,160,163,0,63,253,109,0,63,112,142,27,98,62,203,96,208,1,102,0,25,30,33,63,63,55,208,179,24,46,67,82,156,240,230,72,4,240,125,22,141,90,111,49,46,15,100,239,218,97,222,5,226,18,36,30,177,1,184,48,164,2,35,4,75,117,248,103,59,91,115,54,200,246,230,176,199,161,165,73,129,58,28,66,20,29,21,249,125,78,165,55,24,41,208,8,183,32,43,9,101,255,70,78,109,8,23,44,99,216,116,226,252,236,118,80,194,66,206,186,193,218,174,7,57,32,169,235,116,243,67,12,185,251,58,87,10,5,196,100,85,166,106,217,158,253,77,93,23,207,191,39,146,43,80,214,107,252,117,208,71,2,74,189,38,208,234,6,92,226,201,55,141,21,16,195,202,196,30,66,186,25,41,47,238,162,128,255,52,99,105,174,32,249,62,116,93,247,251,198,107,108,207,48,151,43,9,9,68,28,19,172,249,1,179,5,8,250,212,217,128,251,163,247,242,251,144,8,64,2,103,233,247,2,115,75,39,191,208,75,69,195,178,5,66,3,49,0,57,82,125,48,224,198,202,89,20,110,198,172,128,53,222,2,144,167,255,173,37,5,90,184,188,74,77,191,51,174,102,18,225,4,121,4,52,98,229,107,158,55,147,227,34,18,195,175,222,104,207,76,78,53,56,190,225,113,129,200,81,239,29,185,61,170,133,221,122,64,45,218,167,238,94,63,101,180,26,247,43,223,138,201,255,199,181,6,211,21,169,47,96,90,14,192,45,9,205,205,31,186,2,197,185,20,163,79,90,21,99,250,222,228,216,184,171,5,19,222,186,236,240,65,161,12,188,54,14,205,127,254,24,233,167,92,6,9,253,92,107,108,233,171,37,96,121,69,5,72,241,26,24,242,150,5,208,187,247,70,177,168,28,59,234,220,124,94,191,252,191,98,65,24,66,246,198,161,129,10,19,248,75,4,234,177,230,166},
  {71,99,25,96,107,3,81,5,72,228,38,22,254,58,117,229,17,40,106,194,85,248,152,231,99,222,45,49,187,194,52,53,67,192,91,5,12,182,176,38,100,247,120,65,53,177,164,3,67,23,206,178,25,19,241,64,13,116,209,79,54,14,130,240,169,175,242,22,118,7,8,67,162,158,234,78,110,246,87,253,37,159,52,106,120,112,71,78,158,251,41,48,75,193,29,105,53,46,139,163,36,112,24,177,166,17,166,40,29,250,35,106,73,9,26,249,184,62,80,96,132,84,214,1,16,3,76,78,146,53,235,253,237,28,131,28,169,60,88,78,204,168,189,189,253,219,26,223,161,17,169,9,193,2,189,220,155,107,219,114,32,86,200,9,170,103,165,213,202,0,187,199,186,81,5,247,115,115,152,218,33,234,2,83,193,25,27,80,75,88,104,171,100,176,38,113,204,44,84,166,195,223,77,172,50,184,174,199,253,79,238,4,179,58,252,29,185,77,253,229,175,41,197,22,201,73,225,77,215,102,184,249,45,53,89,235,224,208,137,115,227,253,103,7,147,0,220,200,106,254,88,56,123,105,57,79,112,241,159,176,30,107,9,176,145,95,237,245,4,80,177,11,118,247,110,178,225,225,9,246,90,6,211,55,25,252,166,13,19,186,243,115,44,89,148,78,252,235,20,250,189,215,62,217,203,248,39,8,40,8,13,193,86,6,124,253,136,70,229,26,239,200,152,76,170,46,231,48,165,186,185,204,164,74,55,229,21,93,68,37,82,52,19,222,143,78,107,13,144,106,173,74,117,180,246,13,208,180,209,197,38,66,37,44,92,67,249,20,111,225,175,200,134,254,132,0,188,6,134,113,230,211,123,70,15,57,20,8,83,219,4,160,6,18,63,252,38,23,99,105,98,0,173,248,240,226,115,232,242,14,163,75,239,57,148,172,34,208,20,247,208,8,82,167,87,90,55,34,30,227,37,87,129,60,184,4,132,247,206,99,153,247,229,109,150,39,149,227,100,237,131,78,86,3,254,73,57,9,185,6,223,66,98,186,76,246,207,55,13,249,3,33,254,89,151,17,199,75,60,89,98,165,232,15,26,65,71,9,224,214,65,75,243,25,102,65,20,228,182,21,14,62,91,50,201,251,30,114,23,67,232,85,187,184,143,80,35,4,73,84,115,9,0,40,56,110,215,39,68,16,232,186,188,68,48,220,199,247,43,6,101,240,159,159,141,6,54,92,138,110,38,63,230,7,23,2,106,255,61,92,233,204,121,185,54,249,206,67,14,192,160,43,73,253,120,59,115,232,85,234,236,81,6,200,6,45,246,36,220,6,232,205,162,49,56,237,126,237,231,3,9,249,112,23,254,84,41,71,61,14,84,159,159,103,186,113,165,9,196,252,161,47,31,249,69,102,220,114,130,117,124,84,47,246,146,230,218,183,246,235,162,198,157,113,216,50,104,204,151,5,134,225,85,210,220,15,154,249,159,255,196,197,123,216,140,53,8,175,54,244,94,78,115,64,122,15,203,233,221,209,106,193,92,166,63,54,54,4,249,72,221,240,3,162,124,55,49,203,142,116,99,3,81,251,70,65,59,7,45,236,81,31,62,111,149,223,40,162,27,36,110,3,9,246,21,236,90,42,216,22,71,0,220,35,90,1,254,247,12,225,4,249,135,239,146,234,88,252,28,89,24,189,11,56,56,163,91,250,248,251,105,170,180,92,109,109,82,191,35,237,197,204,80,255,71,202,39,3,165,33,218,162,24,170,77,202,59,9,214,5,182,4,37,40,164,199,251,4,108,45,56,18,86,222,215,190,224,116,165,83,237,99,113,251,97,198,18,112,164,174,57,20,4,14,41,3,109,84,18,95,127,224,12,168,113,38,251,198,162,0,147,207,177,27,67,88,74,104,209,53,10,63,153,249,192,252,236,255,155,161,37,72,130,233,13,83,26,211,161,3,140,4,167,37,19,53,130,195,156,114,11,237,59,95,67,74,207,5,252,244,136,61,224,171,131,253,114,11,203,80,227,39,65,175,170,9,112,235,92,51,227,219,232,247,169,116,130,228,10,115,140,79,100,230,240,4,199,81,69,211,134,3,205,28,17,192,90,34,41,227,232,64,135,112,116,161,251,222,64,211,246,12,159,36,111,9,244,7,101,112,81,105,6,78,238,45,129,255,128,45,30,98,103,28,72,221,137,106,202,61,98,109,212,66,72,15,236,172,23,27,46,117,59,59,234,84,185,171,54,247,126,165,102,186,109,49,211,161,23,219,56,18,223,240,202,1,212,237,151,8,36,26,74,218,131,37,78,101,179,31,184,192,116,69,110,37,23,193,140,246,91,41,131,217,113,13,153,76,102,114,84,0,12,38,214,9,160,204,150,93,111,195,102,175,135,204,4,77,176,250,56,220,62,44,233,76,206,75,94,232,136,14,78,7,41,12,72,64,159,229,189,180,80,176,222,252,178,12,123,226,78,4,250,195,230,86,235,178,200,73,241,91,36,32,140,112,105,232,166,1,11,166,66,86,157,37,162,166,27,52,176,251,58,197,3,184,91,117,80,3,4,207,15,114,18,252,16,12,251,17,208,243,43,1,233,75,70,240,187,45,209,220,159,81,91,190,127,242,127,98,209,6,197,43,249,244,242,167,0,60,36,9,103,5,20,95,146,182,113,45,65,7,245,3,212,50,217,38,25,114,119,6,88,225,195,24,145,246,146,48,212,213,216,99,21,209,198,224,209,21,231,41,116,233,6,108,126,8,213,249,220,160,204,253,8,170,228,221,92,29,37,84,39,199,69,40,117,56,151,77,216,186,81,200,181,209,225,75,26,15,86,190,153,17,234,55,61,209,140,0,184,30,131,55,145,16,89,192,70,13,171,178,62,211,32,241,164,81,142,221,201,46,74,239,171,113,167,215,42,94,112,50,217,6,128,2,85,252,153,248,225,246,3,190,16,100,252,53,54,20,177,192,95,39,84,173,187,2,159,231,233,250,85,93,3,4,9,56,104,94,34,11,46,217,219,176,178,5,53,52,9,65,61,60,223,37,68,248,80,178,4,35,136,251,100,0,92,227,43,11,165,85,13,78,45,210,94,206,224,253,208,189,64,17,48,216,89,69,190,198,89,89,44,211,38,187,93,64,226,26,183,251,195,7,133,12,173,49,242,240,174,194,28,219,181,81,253,9,21,11,167,38,252,210,68,97,97,60,152,246,115,113,37,162,169,251,208,251,90,19,251,57,181,48,223,0,30,251,54,164,34,107,42,167,226,9,20,34,82,8,158,28,235,114,149,8,60,22,146,188,222,84,117,8,229,165,55,74,125,199,140,216,104,253,148,227,147,48,109,207,221,66,143,206,38,91,193,185,169,4,138,104,125,229,16,160,137,78,133,191,218,103,3,101,81,117,118,240,221,108,43,46,205,210,28,221,60,0,244,1,64,30,12,12,26,252,80,173,42,102,208,211,29,238,111,114,151,109,165,170,62,24,57,5,162,254,172,107,65,254,186,88,217,253,15,31,169,6,141,8,132,59,91,185,165,207,221,105,236,9,196,74,204,167,134,24,232,161,2,210,125,178,53,28,205,92,214,32,199,7,203,160,178,236,240,3,205,186,224,75,63,169,88,48,184,87,133,225,57,252,67,11,13,194,60,225,83,78,241,62,12,236,247,5,107,15,197,80,211,23,100,71,32,26,117,41,255,63,72,6,53,193,119,58,153,39,151,6,150,46,151,228,98,64,100,78,0,70,229,47,58,231,54,9,2,242,48,10,61,7,233,104,246,6,144,174,183,24,24,199,78,81,78,69,87,65,61,94,241,180,206,182,54,86,28,40,85,236,222,1,216,208,171,25},
} ;

static const unsigned char precomputed_core_scale3sntrup857_n[precomputed_core_scale3sntrup857_NUM][crypto_core_INPUTBYTES] = {
  {113,132,68,84,123,141,111,14,218,190,101,11,206,86,7,43,120,57,9,158,209,178,10,222,122,38,216,235,85,54,211,101,166,245,252,68,92,94,137,247,230,116,230,174,102,109,130,247,78,32,250,135,54,114,3,231,40,245,204,214,103,160,202,123,140,113,127,251,236,189,193,6,78,151,82,74,100,220,101,43,35,121,48,181,196,22,87,255,64,131,4,3,78,181,41,27,55,147,191,165,251,31,131,105,110,12,197,142,250,20,149,248,45,199,110,116,89,195,29,184,166,75,3,204,134,112,211,11,238,236,193,196,243,18,134,178,206,63,208,72,158,92,133,92,214,106,186,15,36,6,19,236,184,33,232,29,178,244,9,181,120,241,217,41,252,239,95,227,50,92,251,242,71,246,223,3,15,70,81,235,75,77,177,226,194,47,122,102,97,201,149,17,125,23,85,47,22,248,162,65,190,108,164,141,71,100,177,170,135,253,91,69,213,244,110,124,125,43,50,38,231,234,232,60,153,51,169,94,102,36,116,187,80,199,213,25,107,57,69,32,199,122,156,174,236,137,170,102,99,140,74,122,28,91,231,178,73,220,36,123,108,195,115,48,169,224,171,46,6,171,212,208,68,184,85,2,8,142,235,92,123,81,237,59,224,94,251,93,39,141,112,234,59,214,74,220,221,39,188,242,112,15,37,107,218,156,16,233,231,118,31,57,169,196,103,232,151,103,141,174,18,234,200,116,103,197,26,42,205,119,218,72,126,95,232,122,126,199,175,14,169,215,111,250,160,194,117,205,11,255,30,254,172,158,247,190,174,152,32,151,98,238,215,126,189,134,121,131,148,220,74,3,31,52,49,236,198,171,184,4,215,65,232,46,153,132,161,136,175,157,224,146,33,141,18,192,221,179,185,18,234,92,39,28,17,204,13,185,202,230,253,243,43,94,247,237,183,52,30,225,253,161,9,133,239,128,229,85,201,30,27,37,15,137,21,137,224,12,188,79,105,83,190,2,141,120,63,144,75,42,17,156,145,153,226,206,212,207,17,220,159,30,0,137,75,112,121,66,73,253,149,16,133,104,38,147,94,76,139,150,23,168,122,136,203,169,175,128,198,67,205,167,184,111,200,41,105,38,55,85,161,239,160,114,112,118,170,158,176,212,97,14,172,195,239,242,36,157,115,0,85,237,228,108,161,155,128,148,59,51,225,105,193,159,169,194,124,115,108,42,213,41,0,76,92,222,16,33,202,142,58,192,155,50,12,38,203,119,179,76,78,150,40,104,123,22,110,133,102,96,51,187,142,52,59,207,74,171,8,30,154,225,224,7,181,26,228,9,207,231,227,212,80,67,2,96,48,106,139,94,221,172,22,34,147,206,95,179,156,4,21,200,84,65,112,22,89,233,159,180,94,168,210,152,153,55,77,174,238,232,209,222,196,64,60,218,105,92,7,165,113,12,64,6,239,142,29,210,97,66,162,97,185,218,252,234,96,35,17,47,22,64,4,74,216,240,183,208,88,146,250,137,144,226,187,125,249,14,38,193,184,196,241,105,106,69,95,9,164,93,162,176,119,83,181,51,177,12,226,252,18,235,198,204,37,170,218,233,228,138,240,169,192,78,234,246,27,38,122,72,115,202,223,205,162,150,45,9,242,182,197,111,157,217,127,101,203,138,161,82,53,125,31,133,228,216,225,242,20,197,220,24,11,65,162,28,54,62,187,72,97,46,96,231,188,71,102,184,196,4,177,59,149,134,86,54,89,199,175,89,81,126,205,79,239,200,140,195,28,79,63,54,219,198,36,43,81,247,25,95,172,187,222,195,1,162,62,37,37,78,149,66,46,133,96,175,97,42,184,10,144,211,60,253,213,58,12,205,230,133,196,17,246,79,241,223,132,208,233,138,66,251,91,51,122,152,135,181,49,95,2,189,156,104,126,253,215,194,65,155,223,156,219,152,203,225,35,81,202,162,198,98,115,218,226,196,197,194,34,5,219,52,124,55,170,98,115,67,170,153,5,40,252,133,104,206,116,227,130,65,235,137,254,248,95,251,162,52,204,138,0,188,58,45,152,5,125,59,153,240,194,85,204,92,123,168,118,86,90,182,83,64,44,170,58,170,102,189,126,62,31,73,236,169,103,75,128,3,242,51,103,106,13,158,148,81,131,106,42,7,101,10,98,136,161,12,200,32,213,209,39,54,188,143,4,254,223,77,198,254,149,182,56,78,48,188,163,127,84,192,182,250,186,71,46,76,12,201,208,125,39,150,15,81,143,114,223,144,34,99,101,223,129,124,210,170,60,24,223,123,238,79,224,222,8,68,242,196,211,141,177,163,99,74,106,4,213,95,159,27,100,111,234,198,233,4,136,223,54,65,95,224,98,33,189,10,174,226,99,172,227,223,74,1,233,35,43,201,162,244,103,105,55,233,122,41,212,11,127,203,45,14,255,88,109,100,83,121,15,108,49,39,241,21,165,169,251,185,136,170,148,218,107,235,248,163,33,228,119,117,124,194,132,82,158,226,88,53,206,156,240,42,182,122,160,253,53,198,223,17,75,20,87,90,9,213,210,52,52,195,7,215,77,84,248,120,246,141,13,215,203,119,195,102,157,79,94,19,108,87,215,250,161,96,127,107,185,176,109,0,192,69,169,235,212,161,98,235,103,101,98,140,68,13,209,110,222,58,82,41,46,14,77,58,23,211,11,236,237,178,185,160,237,83,218,32,152,178,25,82,72,235,81,239,127,42,49,240,176,250,60,168,169,253,102,123,107,117,24,24,181,28,120,115,112,232,118,220,100,231,4,114,141,146,245,145,112,180,59,32,93,138,135,7,254,186,142,103,140,33,179,4,93,152,120,157,238,132,48,6,114,51,255,219,75,203,199,209,62,22,37,76,96,62,230,20,121,130,159,93,112,122,62,117,149,252,82,251,101,173,176,6,215,72,110,97,139,143,129,166,41,186,219,94,203,89,111,72,25,239,252,4,252,37,167,95,252,89,240,172,115,30,15,91,8,26,154,27,70,212,229,109,100,182,210,192,93,171,127,98,152,18,229,227,73,190,117,97,189,124,37,28,75,176,34,55,154,241,217,181,0,14,216,10,75,130,67,160,172,38,152,117,78,89,103,6,213,115,209,189,181,103,86,119,47,11,236,194,155,15,243,104,152,236,15,155,178,72,1,100,88,196,34,185,241,246,255,124,148,6,122,27,123,222,44,25,87,199,223,3,110,251,36,45,2,101,170,145,198,184,171,142,230,154,128,248,213,1,126,147,19,206,9,59,30,35,41,107,60,180,239,110,160,43,30,126,163,48,74,143,194,200,29,86,238,5,124,30,138,101,48,44,21,96,127,236,11,164,22,16,173,24,28,180,26,130,179,107,137,73,225,67,117,211,32,68,29,187,178,92,245,22,57,133,109,246,203,142,191,87,204,183,113,33,255,5,167,51,150,178,237,108,8,100,149,170,133,46,160,181,243,1,217,198,10,129,82,251,6,204,69,248,228,215,230,28,240,248,205,67,41,17,82,129,83,211,203,91,255,239,223,53,238,116,136,218,21,16,37,28,129,21,254,122,242,117,255,80,237,151,13,253,141,52,56,105,72,69,26,243,186,92,230,123,116,15,228,8,211,108,209,204,2,29,13,133,44,132,6,106,174,105,7,232,25,207,191,99,17,25,3,7,154,56,23,68,133,83,40,130,205,49,174,235,142,15,172,88,155,179,204,25,128,119,237,143,36,152,91,4,142,12,20,140,50,150,104,75,145,196,129,100,114,32,250,248,7,115,246,105,158,223,95,6,163,7,168,69,48,165,197,32,184,151,17,238,85,58,155,108,113,250,230,81,108,208,130,109,184,46,11,154,149,11},
  {12,236,87,80,211,178,186,106,77,82,143,160,28,198,171,133,171,126,226,249,61,207,147,71,179,116,116,154,168,123,14,202,226,199,233,36,231,97,182,238,169,77,124,163,105,96,225,110,29,23,4,107,161,113,144,4,203,211,20,55,73,46,112,200,234,107,227,137,248,203,71,214,9,235,122,130,165,192,73,53,215,45,107,242,76,51,208,234,84,218,109,19,95,144,203,224,164,126,179,180,243,3,210,221,234,145,31,162,73,241,30,32,61,130,154,238,42,240,235,194,127,114,119,83,199,140,88,89,16,200,212,209,42,164,145,52,179,236,35,133,89,88,41,1,115,210,88,48,179,191,224,0,19,35,113,30,138,36,238,113,32,81,92,255,33,121,236,75,123,99,46,138,102,7,241,12,133,182,248,193,55,136,25,146,227,42,242,113,167,74,223,44,222,196,235,61,103,203,240,156,94,56,66,26,102,162,135,155,224,196,245,238,70,29,73,88,157,139,206,138,52,124,100,80,187,42,134,133,71,150,144,175,120,45,252,33,251,64,134,77,38,139,59,249,251,179,116,25,20,154,25,46,15,194,235,117,90,37,226,14,3,30,163,88,148,252,31,148,152,143,188,253,19,192,62,228,121,89,48,241,94,97,187,120,158,162,4,9,78,100,97,253,189,224,77,68,100,109,240,207,244,182,61,229,27,184,156,184,140,41,31,169,150,186,165,249,205,101,48,11,122,245,158,155,126,17,167,94,191,114,198,134,248,33,87,80,217,79,253,21,97,47,31,33,172,103,140,207,31,68,110,235,32,183,251,19,219,92,77,233,144,51,213,238,118,58,11,86,32,89,34,167,17,146,103,104,247,251,131,157,44,114,198,151,161,184,211,193,13,20,110,228,27,193,97,18,131,63,33,30,158,171,178,141,155,83,42,103,55,182,154,135,14,117,4,128,15,143,177,218,151,114,180,53,32,245,31,122,84,173,149,111,71,199,135,26,228,214,234,168,106,146,59,127,160,211,183,8,216,33,147,228,43,180,139,10,18,94,226,144,63,34,91,134,180,253,33,11,247,117,252,236,17,110,165,44,224,146,238,172,46,51,221,111,205,184,175,229,94,220,180,77,241,177,157,232,61,185,117,130,127,118,61,102,174,203,83,134,62,33,244,37,219,185,79,168,177,208,171,147,0,23,152,72,167,124,207,146,176,46,234,69,96,10,239,63,9,54,22,228,200,102,63,163,225,88,250,83,245,188,163,137,46,250,28,85,176,194,112,153,71,87,135,214,22,196,137,141,0,38,237,235,222,41,75,176,119,234,221,161,60,48,10,246,136,238,144,223,138,115,26,143,153,116,100,82,229,84,72,7,238,54,232,198,92,47,203,166,178,141,41,104,98,12,145,23,253,162,96,180,231,219,129,69,229,148,70,5,17,145,63,240,82,178,86,48,181,150,173,208,101,49,136,175,158,225,220,61,242,164,250,29,77,15,5,67,35,243,107,138,4,62,197,44,131,32,49,105,16,105,147,110,17,176,141,194,139,211,152,254,254,232,146,162,192,228,46,106,57,132,22,209,213,104,14,59,115,16,242,30,183,251,163,69,247,153,177,26,100,190,26,123,143,197,36,37,178,20,59,226,113,210,79,32,207,14,189,100,181,72,179,93,99,106,224,73,13,75,135,181,67,250,142,76,81,193,243,193,230,150,67,61,172,215,105,146,170,39,49,85,214,197,254,36,235,103,96,211,248,68,90,55,46,24,57,144,91,34,234,221,37,172,191,34,176,65,153,120,193,141,107,65,13,156,28,225,88,20,166,115,221,81,215,42,105,241,120,128,151,136,223,112,108,74,82,28,197,145,216,221,103,36,237,8,118,23,151,183,159,179,114,218,220,43,144,149,80,150,240,58,153,106,12,153,218,85,146,234,80,108,103,12,170,188,206,0,90,133,180,182,9,235,70,64,68,217,179,99,237,170,145,39,201,153,138,252,75,180,51,23,132,123,207,42,6,141,183,27,129,87,138,2,85,142,250,16,140,171,165,23,222,149,236,52,88,111,108,124,10,205,43,127,167,199,242,91,222,227,203,96,61,247,60,144,85,40,255,184,222,142,30,53,111,242,93,175,121,34,148,144,63,48,50,28,209,200,106,196,115,32,203,194,99,179,211,165,157,5,148,48,237,220,54,101,79,185,252,29,225,23,3,200,17,184,169,13,126,8,29,70,206,12,145,170,62,252,170,203,247,145,165,113,114,218,28,50,69,91,6,122,69,42,212,71,230,149,84,129,51,94,179,4,127,220,251,181,146,0,90,135,51,54,198,90,144,141,103,149,109,187,56,248,129,67,188,237,43,199,30,205,17,106,0,54,83,88,38,134,128,216,5,135,234,95,143,133,105,116,154,180,99,170,204,221,194,51,145,33,192,108,26,51,45,155,249,95,102,29,173,157,176,62,136,123,23,25,138,249,152,15,10,29,173,103,13,200,183,155,84,228,31,23,61,130,20,38,115,47,179,244,29,131,142,33,48,171,171,199,73,195,163,47,75,3,142,72,43,24,80,225,5,94,233,108,21,112,160,91,90,71,82,186,139,98,41,191,169,117,192,112,147,23,73,230,144,113,104,89,87,39,126,254,87,35,143,192,85,243,187,166,195,251,34,25,19,184,187,19,224,82,236,57,149,59,114,185,84,218,35,65,209,235,170,119,104,127,248,10,93,73,155,87,236,173,176,178,184,156,125,2,223,118,163,82,117,151,36,185,180,203,45,12,231,52,177,22,249,110,135,176,105,68,71,16,227,49,174,83,150,142,221,54,139,53,174,215,241,32,111,248,91,170,35,86,88,235,158,140,205,134,129,171,185,200,208,156,124,65,15,128,36,1,245,170,230,54,115,24,91,32,31,93,213,209,204,100,11,35,28,92,126,33,216,61,140,85,173,188,111,154,12,165,135,64,126,207,123,26,66,243,181,226,168,39,184,234,165,25,177,211,147,152,255,182,1,96,109,174,245,115,55,241,158,223,197,83,12,147,86,109,40,133,72,208,106,239,46,224,168,221,214,212,173,193,40,171,254,61,57,190,2,187,160,211,101,114,192,218,255,175,54,30,207,144,242,184,193,183,143,162,179,187,31,37,83,141,169,28,160,92,28,176,57,246,105,176,71,90,60,176,46,67,73,98,223,20,136,162,36,140,72,202,10,77,63,38,101,207,136,1,63,1,24,222,231,206,72,249,222,251,45,10,42,15,121,108,174,109,2,236,224,53,196,202,215,183,227,79,98,160,189,150,189,44,7,250,181,57,181,147,89,145,32,224,95,141,214,172,63,246,88,29,155,27,45,193,249,76,225,19,93,151,196,170,212,38,156,83,165,172,40,35,252,25,191,205,28,193,116,39,248,247,164,49,99,218,129,173,24,211,241,250,27,51,63,122,80,76,116,29,96,114,155,49,127,41,241,72,32,87,215,235,6,85,64,63,254,175,16,41,230,225,79,91,183,181,36,11,184,63,39,109,94,99,59,125,92,27,233,124,52,55,178,109,154,47,218,36,120,196,46,60,254,198,225,241,142,166,95,211,219,108,214,213,131,90,9,10,73,197,167,19,1,141,146,101,115,7,168,73,192,237,207,49,169,119,92,88,175,177,229,244,80,198,179,139,225,58,142,102,140,17,5,188,238,86,226,144,56,97,6,173,69,205,113,167,57,239,175,211,21,177,196,163,43,110,219,43,141,194,57,97,13,178,211,153,210,227,69,244,194,44,96,173,184,100,208,99,129,205,131,44,102,39,157,158,247,43,201,102,39,132,6,8,50,51,153,97,215,212,129,110,48,236,214,204,211,253,32,116,45,133,213,108,252,82,251,19,154,42,102,180,23,179},
  {26,243,225,74,53,132,199,44,63,161,69,47,59,128,78,195,96,118,124,126,92,108,70,152,120,186,106,52,134,93,107,158,125,82,133,160,100,131,13,139,149,213,84,170,224,44,99,206,195,158,31,219,97,199,129,112,46,173,135,36,214,93,145,40,50,15,62,108,48,95,238,44,33,110,35,186,69,42,201,85,91,42,231,154,138,83,244,213,192,163,218,138,228,161,118,50,244,140,36,166,153,50,137,112,138,185,182,216,248,140,24,171,30,190,11,12,217,113,10,66,58,64,148,222,129,20,118,162,154,85,41,177,179,154,86,4,166,22,130,38,117,212,88,152,26,203,18,171,59,156,36,0,151,24,205,98,40,232,47,34,245,227,176,186,226,221,112,139,144,39,65,184,217,93,61,12,223,246,85,30,174,79,28,51,214,33,182,113,167,106,143,251,24,114,77,66,172,224,162,39,173,195,253,176,112,65,135,92,29,121,53,76,236,64,92,201,40,145,231,134,56,89,58,78,230,118,228,57,47,178,78,231,14,13,114,113,226,56,193,232,176,105,160,183,157,12,60,60,175,99,72,64,133,123,177,229,146,121,229,131,232,27,203,15,101,102,62,245,255,33,136,28,204,68,125,113,57,187,193,144,10,61,241,197,207,29,214,152,78,218,149,131,125,30,28,136,49,137,245,2,64,116,189,20,95,207,114,31,237,36,188,241,193,134,203,22,123,248,56,225,156,255,163,242,174,208,193,136,8,248,103,64,103,189,158,131,108,72,245,187,76,54,156,115,97,246,136,139,28,18,89,163,66,23,45,246,89,137,186,115,163,36,170,226,65,38,61,162,146,226,198,135,93,217,229,164,203,68,63,224,80,17,76,200,138,38,25,90,150,27,83,212,73,127,9,140,223,18,226,139,236,79,226,137,198,13,214,200,248,40,70,91,46,75,103,55,123,64,105,227,203,56,90,50,153,180,0,220,16,46,113,180,95,251,167,165,155,229,172,66,4,247,220,52,25,4,168,158,4,172,18,103,0,7,125,202,240,90,200,43,105,206,204,34,78,240,71,169,231,182,83,136,43,1,189,72,244,171,115,75,173,111,26,180,157,250,105,246,34,239,8,97,5,112,186,108,123,150,40,247,6,240,167,151,206,96,49,199,26,140,118,100,234,131,148,142,122,251,98,201,112,62,246,92,160,135,215,0,15,143,227,23,8,136,245,129,80,208,44,107,249,51,129,218,87,25,170,74,227,242,45,116,159,112,147,64,4,244,79,126,198,219,145,68,218,158,168,112,153,208,141,3,100,180,120,29,90,196,18,29,3,145,17,71,209,125,163,185,179,42,201,30,5,114,202,132,18,135,132,165,153,157,207,91,9,242,129,132,65,30,1,131,39,227,100,201,248,163,164,55,27,135,175,82,25,5,61,81,10,212,26,205,219,134,35,227,6,98,111,12,183,212,9,104,48,129,219,34,51,88,103,0,25,25,249,200,136,19,14,160,100,123,110,221,120,26,157,243,3,9,184,67,177,215,99,70,66,156,16,146,34,209,90,250,231,244,228,97,146,190,44,220,253,245,48,1,162,29,214,31,240,169,54,199,200,159,20,205,187,164,96,104,29,187,195,219,232,171,250,179,231,55,101,151,25,45,209,197,236,211,8,211,28,124,226,226,120,15,8,183,217,240,153,120,88,193,174,228,130,185,107,141,129,172,43,150,181,98,187,84,232,75,131,150,114,2,44,140,164,107,66,81,89,18,104,185,71,121,189,167,221,97,38,18,123,104,66,111,246,194,156,91,124,29,88,164,193,8,67,228,216,89,146,48,54,136,142,65,74,178,163,255,57,60,85,103,59,151,237,44,85,113,223,87,212,5,155,64,235,15,65,190,37,200,83,127,23,69,206,47,35,1,16,105,149,18,95,196,139,88,182,179,107,78,248,38,229,63,155,52,132,6,199,250,194,51,29,196,119,2,193,80,167,187,197,205,234,196,250,245,201,103,37,158,66,250,223,4,117,12,104,239,132,224,13,12,117,222,21,34,189,214,245,252,217,182,136,168,177,179,229,7,50,106,139,230,150,176,254,227,86,62,61,193,153,206,2,11,154,72,196,54,149,135,141,127,126,195,199,38,99,189,200,156,67,249,90,1,111,0,235,104,189,207,81,119,206,85,88,200,183,206,177,237,177,212,83,38,133,179,99,246,35,153,216,146,201,190,32,25,252,105,98,42,97,117,36,191,181,198,162,43,15,190,161,177,235,224,6,112,94,39,77,110,72,125,250,132,60,155,200,105,55,68,21,207,204,80,179,159,118,68,219,131,17,71,8,235,87,86,9,126,70,128,126,217,97,213,8,247,221,213,27,198,213,193,167,149,14,178,248,107,182,145,137,192,252,179,81,18,1,129,213,209,135,206,21,241,227,102,138,3,183,0,95,67,32,22,93,76,93,168,64,218,112,209,126,103,133,118,40,13,233,43,88,76,52,13,182,105,74,181,100,199,77,169,192,196,238,230,36,150,68,80,232,192,134,129,199,170,150,214,147,16,238,141,224,155,72,65,156,166,249,229,86,127,169,91,111,100,13,246,26,4,124,228,70,26,48,250,47,101,252,221,153,121,237,213,127,133,0,77,14,185,108,240,182,159,249,25,233,75,76,161,107,103,180,114,77,58,35,131,48,210,181,73,172,201,224,123,189,36,194,101,17,95,219,43,117,44,80,130,186,79,51,67,16,67,88,151,219,80,191,227,51,70,30,209,30,204,96,39,144,177,128,200,105,83,33,193,55,147,210,248,5,66,175,35,67,124,148,68,17,218,218,84,176,78,59,205,191,254,168,167,159,118,36,11,203,63,235,77,152,209,198,179,181,86,86,242,9,21,206,45,58,55,171,159,10,132,124,249,21,255,106,249,122,129,63,101,219,112,254,38,240,85,189,78,24,102,112,198,122,110,139,138,109,107,38,34,207,158,7,31,71,73,228,184,148,207,138,108,31,97,103,158,3,210,175,8,91,98,113,187,214,249,77,108,140,171,97,1,126,216,13,212,206,207,54,110,51,246,61,52,136,132,156,116,144,111,25,114,193,101,162,161,228,32,156,110,109,20,240,2,162,17,185,173,220,91,39,118,106,81,194,106,188,150,23,154,239,242,55,204,251,28,53,226,134,151,159,94,120,17,126,242,23,245,38,96,147,254,35,121,19,179,81,40,98,219,105,236,138,84,212,37,248,232,250,19,235,191,11,150,222,90,194,62,109,171,9,227,253,147,233,80,15,154,168,110,148,184,75,58,137,229,111,199,163,100,200,107,149,47,229,91,33,125,190,136,251,246,207,130,31,253,68,230,222,42,170,193,66,21,3,3,209,186,76,221,83,171,145,172,243,161,55,151,128,254,225,167,11,176,149,9,37,178,104,156,152,79,54,117,168,227,85,117,178,143,230,1,177,79,187,170,120,119,228,22,59,230,83,207,193,128,221,50,229,109,175,7,203,219,240,221,183,1,185,54,249,116,10,57,172,136,135,183,176,93,211,86,33,210,92,213,239,195,204,239,27,98,220,51,175,41,170,117,127,24,3,142,176,44,198,230,182,243,250,54,90,135,114,152,227,198,170,236,40,158,47,113,18,224,94,82,84,238,201,145,240,59,231,172,86,99,72,193,133,207,245,227,170,81,138,232,80,55,241,58,248,98,70,33,131,184,134,175,229,154,227,54,212,165,76,67,217,242,181,28,240,10,249,24,245,146,213,84,163,241,242,122,157,81,100,208,222,42,62,221,28,124,56,115,188,30,96,186,163,244,50,87,139,226,98,30,214,134,25,197,233,66,57,38,48,248,250,124,208,14,22,82,221,217,144,95,22,4,25,172,233,137,61,134},
  {210,39,24,124,20,165,27,87,179,154,199,184,15,197,194,69,192,190,105,143,44,4,35,241,188,152,116,108,132,143,33,195,92,57,100,80,159,224,245,104,49,89,141,28,2,223,140,86,38,185,53,138,24,13,96,28,20,216,0,204,119,11,113,73,126,222,11,185,55,9,189,199,209,216,179,203,21,246,29,255,82,46,33,42,141,129,210,32,138,254,200,22,180,57,196,41,204,192,116,218,113,129,163,137,71,183,71,20,95,83,198,212,195,173,195,89,77,198,213,38,145,205,87,7,21,93,41,118,235,109,94,91,180,101,230,186,72,112,45,118,223,134,218,141,154,66,249,152,240,97,227,173,134,79,218,66,238,127,174,215,197,120,253,9,243,211,210,149,83,92,132,230,163,204,87,82,54,45,35,66,166,156,187,119,80,15,110,33,126,121,19,221,103,137,199,129,169,21,183,48,220,67,10,136,1,140,213,59,100,33,250,86,246,196,185,16,248,117,154,240,74,191,252,184,168,116,176,32,2,41,77,175,116,24,14,157,59,148,232,215,6,6,50,9,49,0,143,145,206,84,45,196,142,212,120,118,107,244,208,222,111,42,158,222,64,209,234,245,17,204,160,10,109,246,21,138,230,153,158,160,131,179,86,25,78,77,71,11,76,55,182,130,201,121,65,118,239,71,247,161,218,235,5,151,52,76,13,88,83,81,74,228,114,87,212,169,61,30,92,186,64,60,237,202,243,192,178,193,210,140,46,232,241,116,88,240,108,208,209,189,43,24,76,67,234,32,222,181,149,127,244,116,194,138,183,96,139,53,54,59,199,28,28,192,217,199,184,13,192,153,128,145,231,176,44,0,148,87,231,129,61,149,142,115,106,196,193,94,12,237,71,217,103,183,122,5,199,99,134,212,118,85,42,76,235,68,108,241,11,97,70,117,10,26,119,221,81,233,92,82,85,180,97,134,130,207,34,18,165,239,28,121,144,197,131,165,199,75,255,39,152,174,92,43,151,190,34,69,103,72,230,32,13,165,15,202,174,81,46,166,90,114,17,226,41,174,170,110,175,253,102,188,15,122,66,183,82,117,121,36,17,219,93,97,195,113,210,9,59,150,208,31,182,100,135,28,247,239,247,13,191,112,46,194,168,90,111,215,194,199,93,35,132,225,234,118,97,1,40,120,54,95,101,105,205,128,2,20,209,182,147,55,249,114,171,66,82,89,84,251,18,244,208,131,202,80,119,37,147,43,199,27,162,2,93,171,105,78,36,208,62,232,110,140,119,4,255,199,245,227,69,21,94,248,141,26,108,241,98,71,9,34,157,230,103,192,183,189,143,251,147,232,155,108,3,243,197,157,178,178,158,161,53,185,15,35,200,115,36,182,183,131,154,126,163,44,55,3,236,254,240,107,80,76,124,211,89,130,59,131,57,120,0,246,33,70,57,225,237,71,209,144,68,215,173,23,19,232,66,179,29,239,98,63,89,97,222,253,53,85,135,144,196,150,233,109,243,136,173,74,47,118,54,28,227,11,52,71,58,63,105,228,15,134,122,195,119,93,184,201,58,244,156,132,57,25,86,146,63,216,33,1,128,90,39,199,4,81,170,242,128,102,207,43,34,153,83,47,110,189,223,7,3,82,162,242,131,191,173,99,8,164,89,189,185,249,15,4,159,153,71,76,200,243,33,242,45,176,25,207,163,141,190,110,3,133,201,168,67,77,190,220,161,37,52,43,97,142,252,242,50,232,112,170,8,146,168,79,156,188,57,218,163,220,10,146,105,88,242,1,247,178,28,20,39,145,68,80,137,192,205,12,13,238,56,142,5,131,156,34,180,210,22,77,102,59,107,129,39,222,120,13,17,182,99,86,52,120,107,38,112,153,159,134,224,104,68,230,155,177,204,147,160,186,38,36,211,126,0,110,19,113,152,4,64,84,9,92,36,47,28,116,113,156,20,205,249,148,139,86,132,1,242,189,22,195,113,58,153,215,244,242,206,123,38,202,69,87,239,74,61,27,59,221,230,5,139,10,254,118,6,20,6,137,41,167,107,242,217,23,60,237,147,246,72,216,113,69,19,45,233,203,103,155,181,93,82,119,178,63,231,7,84,16,246,227,131,103,254,68,93,28,146,129,23,47,68,238,91,234,183,181,154,189,192,81,97,9,220,214,128,212,103,203,95,107,144,6,229,21,111,39,50,16,179,237,232,212,83,27,219,213,1,29,125,182,63,136,194,15,31,131,206,111,179,205,46,221,173,75,197,133,189,140,52,23,140,132,248,236,205,12,144,73,238,85,55,243,66,180,113,15,9,66,230,189,127,40,246,187,131,57,225,29,223,189,248,142,132,167,46,191,28,151,224,181,152,117,135,215,28,0,105,19,242,173,123,61,151,208,192,143,189,51,200,146,17,203,43,162,3,152,207,106,8,203,255,31,101,241,61,182,181,251,200,10,125,113,208,69,218,138,11,52,229,162,75,96,196,68,181,250,153,58,7,121,148,223,253,201,96,37,113,17,233,214,190,70,71,7,244,133,123,35,68,19,209,48,110,109,43,77,89,144,156,54,46,131,112,86,71,62,106,215,6,84,21,96,14,98,139,74,30,7,8,32,93,73,78,107,54,152,154,204,100,227,112,159,58,210,155,87,252,191,238,74,65,49,101,197,12,3,205,1,193,123,33,54,224,21,208,179,12,8,1,109,88,190,24,130,24,166,99,68,166,185,219,252,235,22,55,235,173,210,162,233,221,238,0,14,178,20,23,71,103,213,197,166,71,83,143,217,169,176,243,49,231,237,217,101,28,120,168,59,124,105,140,25,66,203,227,140,182,230,130,148,176,202,195,11,13,142,152,12,179,110,90,148,132,85,77,102,230,195,64,12,14,228,39,11,212,52,5,149,251,158,241,33,117,152,168,107,9,73,158,44,40,65,115,123,53,194,88,94,128,171,98,77,206,246,75,82,156,56,21,40,185,24,119,13,214,142,218,19,183,221,132,79,208,155,163,83,44,123,1,172,104,25,221,208,27,181,85,236,228,222,75,179,204,194,104,28,36,112,90,19,7,76,11,138,17,189,216,83,204,170,15,69,30,181,156,120,20,118,170,148,101,147,160,84,139,56,37,183,171,150,216,29,133,59,216,121,255,148,253,140,132,113,91,186,162,90,166,94,60,96,244,193,65,244,213,228,79,66,76,119,100,95,108,10,242,104,239,148,209,209,48,112,35,246,54,215,82,47,72,5,240,83,131,98,14,26,76,108,245,170,111,90,173,218,27,213,169,219,91,95,193,188,97,81,239,186,94,130,135,173,121,99,33,56,175,205,194,166,146,48,34,202,26,145,31,236,221,5,119,154,150,193,106,62,4,29,32,62,199,207,134,140,72,8,147,41,26,155,75,217,232,32,114,142,3,212,102,40,128,216,109,73,4,43,30,22,138,63,79,152,175,78,252,85,37,102,105,181,94,169,11,51,115,211,139,234,250,157,138,215,66,43,210,220,207,14,19,87,209,248,73,213,107,255,163,121,243,169,106,102,72,94,202,166,145,26,100,140,210,147,4,42,63,167,81,202,223,219,231,14,147,132,241,233,26,138,204,186,84,208,87,188,237,87,52,132,129,157,235,79,138,55,5,32,176,49,45,108,77,121,114,68,19,84,38,181,74,143,175,153,214,32,96,198,159,242,253,1,222,11,252,118,86,185,49,201,197,100,140,20,186,198,179,80,2,143,226,196,152,190,66,94,151,107,120,69,219,198,49,118,101,115,92,193,89,70,173,81,241,73,117,95,90,166,8,127,183,179,203,136,162,185,163,59,127,204,127,200,130,28,36,38,150,53,53,54,119,35,25,20,98,157,175,92,227,62,158,100},
} ;

static const unsigned char precomputed_core_scale3sntrup857_k[precomputed_core_scale3sntrup857_NUM][crypto_core_KEYBYTES] = {
  {},
  {},
  {},
  {},
} ;

static const unsigned char precomputed_core_scale3sntrup857_c[precomputed_core_scale3sntrup857_NUM][crypto_core_CONSTBYTES] = {
  {},
  {},
  {},
  {},
} ;

static void test_core_scale3sntrup857_impl(long long impl)
{
  unsigned char *h = test_core_scale3sntrup857_h;
  unsigned char *n = test_core_scale3sntrup857_n;
  unsigned char *k = test_core_scale3sntrup857_k;
  unsigned char *c = test_core_scale3sntrup857_c;
  unsigned char *h2 = test_core_scale3sntrup857_h2;
  unsigned char *n2 = test_core_scale3sntrup857_n2;
  unsigned char *k2 = test_core_scale3sntrup857_k2;
  unsigned char *c2 = test_core_scale3sntrup857_c2;
  long long hlen = crypto_core_OUTPUTBYTES;
  long long nlen = crypto_core_INPUTBYTES;
  long long klen = crypto_core_KEYBYTES;
  long long clen = crypto_core_CONSTBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_core_scale3sntrup857_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_core = ntruprime_dispatch_core_scale3sntrup857(impl);
    printf("core_scale3sntrup857 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_scale3sntrup857_implementation(impl),ntruprime_dispatch_core_scale3sntrup857_compiler(impl));
  } else {
    crypto_core = ntruprime_core_scale3sntrup857;
    printf("core_scale3sntrup857 selected implementation %s compiler %s\n",ntruprime_core_scale3sntrup857_implementation(),ntruprime_core_scale3sntrup857_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 512;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(h2,h,hlen);
      input_prepare(n2,n,nlen);
      input_prepare(k2,k,klen);
      input_prepare(c2,c,clen);
      secret(n,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(h,n,k,c);
      public(n,nlen);
      public(k,klen);
      public(c,clen);
      public(h,hlen);
      checksum(h,hlen);
      output_compare(h2,h,hlen,"crypto_core");
      input_compare(n2,n,nlen,"crypto_core");
      input_compare(k2,k,klen,"crypto_core");
      input_compare(c2,c,clen,"crypto_core");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k2,klen);
      secret(c2,clen);
      crypto_core(h2,n2,k2,c2);
      public(n2,nlen);
      public(k2,klen);
      public(c2,clen);
      public(h2,hlen);
      if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_core is nondeterministic\n");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(n2,n2,k,c);
      public(n2,hlen);
      public(k,klen);
      public(c,clen);
      if (memcmp(n2,h,hlen) != 0) fail("failure: crypto_core does not handle n=h overlap\n");
      memcpy(n2,n,nlen);
      secret(n,nlen);
      secret(k2,klen);
      secret(c,clen);
      crypto_core(k2,n,k2,c);
      public(k2,hlen);
      public(n,nlen);
      public(c,clen);
      if (memcmp(k2,h,hlen) != 0) fail("failure: crypto_core does not handle k=h overlap\n");
      memcpy(k2,k,klen);
      secret(n,nlen);
      secret(k,klen);
      secret(c2,clen);
      crypto_core(c2,n,k,c2);
      public(c2,hlen);
      public(n,nlen);
      public(k,klen);
      if (memcmp(c2,h,hlen) != 0) fail("failure: crypto_core does not handle c=h overlap\n");
      memcpy(c2,c,clen);
    }
    checksum_expected(core_scale3sntrup857_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_core_scale3sntrup857_NUM;++precomp) {
    output_prepare(h2,h,crypto_core_OUTPUTBYTES);
    input_prepare(n2,n,crypto_core_INPUTBYTES);
    memcpy(n,precomputed_core_scale3sntrup857_n[precomp],crypto_core_INPUTBYTES);
    memcpy(n2,precomputed_core_scale3sntrup857_n[precomp],crypto_core_INPUTBYTES);
    input_prepare(k2,k,crypto_core_KEYBYTES);
    memcpy(k,precomputed_core_scale3sntrup857_k[precomp],crypto_core_KEYBYTES);
    memcpy(k2,precomputed_core_scale3sntrup857_k[precomp],crypto_core_KEYBYTES);
    input_prepare(c2,c,crypto_core_CONSTBYTES);
    memcpy(c,precomputed_core_scale3sntrup857_c[precomp],crypto_core_CONSTBYTES);
    memcpy(c2,precomputed_core_scale3sntrup857_c[precomp],crypto_core_CONSTBYTES);
    crypto_core(h,n,k,c);
    if (memcmp(h,precomputed_core_scale3sntrup857_h[precomp],crypto_core_OUTPUTBYTES)) {
      fail("failure: crypto_core fails precomputed test vectors\n");
      printf("expected h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",((unsigned char *) precomputed_core_scale3sntrup857_h[precomp])[pos]);
      printf("\n");
      printf("received h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",h[pos]);
      printf("\n");
    }
    output_compare(h2,h,crypto_core_OUTPUTBYTES,"crypto_core");
    input_compare(n2,n,crypto_core_INPUTBYTES,"crypto_core");
    input_compare(k2,k,crypto_core_KEYBYTES,"crypto_core");
    input_compare(c2,c,crypto_core_CONSTBYTES,"crypto_core");
  }
}

void test_core_scale3sntrup857(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"scale3sntrup857")) return;
  storage_core_scale3sntrup857_h = callocplus(crypto_core_OUTPUTBYTES);
  test_core_scale3sntrup857_h = aligned(storage_core_scale3sntrup857_h,crypto_core_OUTPUTBYTES);
  if (crypto_core_OUTPUTBYTES > maxalloc) maxalloc = crypto_core_OUTPUTBYTES;
  storage_core_scale3sntrup857_n = callocplus(crypto_core_INPUTBYTES);
  test_core_scale3sntrup857_n = aligned(storage_core_scale3sntrup857_n,crypto_core_INPUTBYTES);
  if (crypto_core_INPUTBYTES > maxalloc) maxalloc = crypto_core_INPUTBYTES;
  storage_core_scale3sntrup857_k = callocplus(crypto_core_KEYBYTES);
  test_core_scale3sntrup857_k = aligned(storage_core_scale3sntrup857_k,crypto_core_KEYBYTES);
  if (crypto_core_KEYBYTES > maxalloc) maxalloc = crypto_core_KEYBYTES;
  storage_core_scale3sntrup857_c = callocplus(crypto_core_CONSTBYTES);
  test_core_scale3sntrup857_c = aligned(storage_core_scale3sntrup857_c,crypto_core_CONSTBYTES);
  if (crypto_core_CONSTBYTES > maxalloc) maxalloc = crypto_core_CONSTBYTES;
  storage_core_scale3sntrup857_h2 = callocplus(maxalloc);
  test_core_scale3sntrup857_h2 = aligned(storage_core_scale3sntrup857_h2,crypto_core_OUTPUTBYTES);
  storage_core_scale3sntrup857_n2 = callocplus(maxalloc);
  test_core_scale3sntrup857_n2 = aligned(storage_core_scale3sntrup857_n2,crypto_core_INPUTBYTES);
  storage_core_scale3sntrup857_k2 = callocplus(maxalloc);
  test_core_scale3sntrup857_k2 = aligned(storage_core_scale3sntrup857_k2,crypto_core_KEYBYTES);
  storage_core_scale3sntrup857_c2 = callocplus(maxalloc);
  test_core_scale3sntrup857_c2 = aligned(storage_core_scale3sntrup857_c2,crypto_core_CONSTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("core_scale3sntrup857 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_core_scale3sntrup857();++impl)
      forked(test_core_scale3sntrup857_impl,impl);
    ++test_core_scale3sntrup857_h;
    ++test_core_scale3sntrup857_n;
    ++test_core_scale3sntrup857_k;
    ++test_core_scale3sntrup857_c;
    ++test_core_scale3sntrup857_h2;
    ++test_core_scale3sntrup857_n2;
    ++test_core_scale3sntrup857_k2;
    ++test_core_scale3sntrup857_c2;
  }
  free(storage_core_scale3sntrup857_c2);
  free(storage_core_scale3sntrup857_k2);
  free(storage_core_scale3sntrup857_n2);
  free(storage_core_scale3sntrup857_h2);
  free(storage_core_scale3sntrup857_c);
  free(storage_core_scale3sntrup857_k);
  free(storage_core_scale3sntrup857_n);
  free(storage_core_scale3sntrup857_h);
}
#undef crypto_core_OUTPUTBYTES
#undef crypto_core_INPUTBYTES
#undef crypto_core_KEYBYTES
#undef crypto_core_CONSTBYTES

