/* ----- core/invsntrup953, derived from supercop/crypto_core/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *core_invsntrup953_checksums[] = {
  "e3c85424efc73a2708c2fcfe0a3f330c164eec370ed8432105e1f670e2cc7760",
  "176b39e76aaec3d9e0e1ed90902be3539020c31478076233b511e983c989d207",
} ;

static void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
#define crypto_core_OUTPUTBYTES ntruprime_core_invsntrup953_OUTPUTBYTES
#define crypto_core_INPUTBYTES ntruprime_core_invsntrup953_INPUTBYTES
#define crypto_core_KEYBYTES ntruprime_core_invsntrup953_KEYBYTES
#define crypto_core_CONSTBYTES ntruprime_core_invsntrup953_CONSTBYTES

static void *storage_core_invsntrup953_h;
static unsigned char *test_core_invsntrup953_h;
static void *storage_core_invsntrup953_n;
static unsigned char *test_core_invsntrup953_n;
static void *storage_core_invsntrup953_k;
static unsigned char *test_core_invsntrup953_k;
static void *storage_core_invsntrup953_c;
static unsigned char *test_core_invsntrup953_c;
static void *storage_core_invsntrup953_h2;
static unsigned char *test_core_invsntrup953_h2;
static void *storage_core_invsntrup953_n2;
static unsigned char *test_core_invsntrup953_n2;
static void *storage_core_invsntrup953_k2;
static unsigned char *test_core_invsntrup953_k2;
static void *storage_core_invsntrup953_c2;
static unsigned char *test_core_invsntrup953_c2;

#define precomputed_core_invsntrup953_NUM 4

static const unsigned char precomputed_core_invsntrup953_h[precomputed_core_invsntrup953_NUM][crypto_core_OUTPUTBYTES] = {
  {34,0,193,248,23,251,38,0,81,250,115,8,165,5,221,245,201,246,113,3,219,4,130,252,75,11,137,9,233,8,172,244,163,0,248,251,69,8,255,8,220,0,165,2,195,244,252,245,224,3,191,11,80,247,170,11,17,254,114,247,154,9,145,250,251,248,71,251,57,251,26,253,178,255,170,247,217,10,207,248,122,245,11,1,197,3,84,249,207,254,0,4,202,11,234,4,115,3,118,246,79,6,229,249,29,249,90,1,211,8,29,7,149,247,221,253,60,254,41,245,186,243,43,8,226,255,157,243,191,250,229,10,63,7,182,247,222,247,79,250,36,11,172,253,85,8,4,2,37,6,17,254,99,246,204,255,167,5,95,245,12,6,208,248,232,252,104,5,164,245,86,2,36,6,95,1,187,249,26,245,230,3,183,244,25,10,152,250,255,246,156,247,62,12,107,255,111,6,79,6,53,8,46,245,148,254,118,0,48,6,34,248,16,0,34,10,9,244,32,3,164,1,84,246,172,251,101,4,204,5,133,246,160,255,219,6,136,247,20,0,146,245,43,6,105,255,147,1,153,252,18,251,221,250,109,0,10,254,244,0,77,10,23,251,79,253,125,11,107,10,65,249,152,247,179,4,10,0,104,253,31,247,105,11,239,7,59,252,115,254,148,252,195,254,71,9,130,3,158,10,83,249,83,244,113,4,64,0,95,251,33,245,136,5,109,255,181,6,120,7,72,249,125,249,108,249,16,245,155,245,125,253,147,0,104,7,46,10,11,254,48,251,104,3,128,245,71,7,199,0,5,247,84,4,227,10,230,2,230,245,153,5,62,5,78,8,124,10,15,248,132,250,190,9,232,0,184,252,131,8,142,2,26,3,83,248,104,248,209,244,157,243,171,4,0,8,243,7,215,6,182,7,20,253,191,6,9,8,12,5,80,252,97,244,116,0,233,11,139,11,125,11,118,5,153,247,97,10,133,244,195,7,52,1,238,4,212,11,216,244,129,6,93,245,201,247,149,4,183,9,196,254,119,6,168,10,250,252,70,8,22,12,59,2,64,12,212,7,93,9,92,246,208,6,221,1,0,11,12,2,117,0,36,12,239,1,63,1,133,0,204,6,129,253,122,4,56,12,34,246,21,10,25,9,202,1,196,10,0,251,186,252,61,1,77,251,66,246,216,253,136,8,112,249,74,5,161,6,167,248,224,4,171,4,93,0,234,253,156,250,168,255,209,248,227,249,145,255,155,4,240,247,219,4,109,249,128,250,43,251,162,243,110,251,228,251,142,254,17,252,37,5,174,8,128,253,193,254,12,10,41,254,233,9,55,10,215,0,53,244,75,246,255,248,206,250,193,243,190,248,71,253,47,10,93,249,107,254,233,243,50,3,86,8,244,249,212,4,107,0,143,7,181,247,22,12,68,254,154,0,171,3,212,255,62,248,78,5,43,247,102,244,30,0,124,246,224,1,203,3,105,250,221,6,6,2,151,11,11,255,191,248,150,5,52,0,127,244,173,246,24,2,41,253,223,3,3,249,95,3,130,247,67,253,11,250,17,9,2,12,40,8,75,10,88,3,83,244,49,248,167,11,216,10,190,9,65,10,209,0,31,2,79,0,158,2,197,251,182,253,211,248,84,248,169,7,11,248,31,249,186,249,159,252,4,5,243,0,17,9,188,255,59,255,119,10,113,244,39,7,95,5,249,6,193,253,179,11,253,253,78,248,215,255,85,248,40,2,229,7,2,5,96,7,198,248,205,7,149,9,97,244,219,246,140,4,134,4,82,6,78,4,48,6,242,0,46,8,88,8,136,252,243,252,97,11,30,7,213,253,8,248,14,251,119,250,28,8,1,11,35,255,216,251,124,7,4,8,58,249,9,249,11,253,5,8,220,251,16,254,14,6,130,251,120,255,3,253,34,4,176,7,55,0,209,248,214,9,130,3,3,11,119,245,243,245,137,247,36,3,79,250,143,245,136,5,177,254,65,246,88,1,230,249,245,255,124,7,253,0,225,247,240,8,89,12,192,244,50,252,1,251,81,249,227,243,67,244,162,255,181,8,94,0,39,4,239,245,62,247,248,252,128,244,225,10,3,8,182,5,82,2,96,253,244,245,127,4,158,252,176,11,239,10,61,2,151,0,230,254,105,0,188,244,144,244,254,10,153,254,197,251,39,12,218,2,2,8,220,247,236,248,73,244,230,9,16,249,2,6,126,249,227,253,216,1,124,7,202,4,239,7,206,3,46,247,82,249,59,7,25,8,18,248,142,246,209,248,26,251,130,6,84,1,35,11,235,11,35,4,135,253,66,1,161,8,100,247,209,246,8,246,189,247,73,0,243,252,153,247,136,5,103,253,108,248,10,252,47,1,246,244,185,5,19,245,81,0,183,0,188,245,198,249,38,10,124,255,77,0,110,248,71,252,146,4,205,255,201,8,162,2,66,5,20,249,199,10,248,7,136,5,157,244,66,11,146,247,89,252,206,2,196,247,43,11,66,7,71,251,199,10,172,0,91,245,121,252,76,9,88,251,223,253,97,248,147,250,28,9,110,1,38,7,129,247,25,2,44,252,62,245,150,6,36,4,90,1,129,10,177,245,15,11,252,248,218,4,66,5,7,244,102,244,60,9,127,252,252,11,139,2,49,250,134,8,216,4,246,2,157,249,208,244,200,5,179,2,26,8,57,244,206,254,63,10,21,251,148,252,14,253,223,249,219,245,179,4,143,247,143,3,165,244,94,255,202,0,27,9,251,0,212,243,17,2,221,244,104,10,74,0,199,1,104,255,220,248,21,249,236,245,116,251,34,248,79,1,29,248,83,253,102,249,128,6,15,9,146,9,161,251,203,7,172,245,23,255,239,11,198,249,17,7,71,8,219,9,145,7,240,247,32,10,57,2,25,244,139,4,242,5,176,251,6,7,44,9,200,9,105,3,205,6,106,244,12,4,73,1,111,3,0,248,136,7,115,249,191,251,33,11,115,8,189,244,74,1,40,254,216,7,64,5,251,248,225,2,229,249,161,247,205,4,161,245,225,4,116,10,44,253,175,248,231,1,212,249,15,249,206,250,208,247,234,245,182,252,123,7,98,244,56,8,203,4,4,253,218,0,158,252,77,249,35,1,123,246,226,5,244,4,142,6,89,252,158,9,34,255,120,250,99,3,50,12,62,249,6,9,146,252,185,254,202,8,168,255,122,252,166,250,219,252,9,10,68,254,231,253,242,245,0,246,220,249,112,2,192,248,168,11,160,243,116,245,6,244,14,244,187,244,240,9,165,9,131,4,108,249,28,12,6,11,97,254,69,252,157,243,228,1,157,254,75,7,168,255,250,247,141,9,26,249,215,3,209,4,83,250,118,248,19,3,134,6,4,7,165,252,84,247,215,255,202,253,211,10,5,252,100,8,222,7,199,3,240,250,181,248,87,2,227,7,113,255,160,6,171,8,13,9,243,249,56,247,190,254,216,246,97,5,104,255,60,246,109,11,11,2,177,250,249,3,134,9,180,245,187,10,213,3,183,243,228,249,188,10,52,3,39,8,93,4,249,251,65,7,8,0,95,248,22,246,222,252,250,249,0,6,180,4,53,248,21,253,247,6,16,2,214,246,169,249,16,253,127,1,17,248,9,245,216,252,214,8,234,3,41,9,69,252,250,1,148,3,130,5,59,5,194,3,228,8,234,11,189,2,73,0,168,245,59,4,86,7,123,7,105,1,164,10,36,251,42,2,0,246,234,244,131,1,77,6,130,1,63,246,5,254,245,0,21,6,73,5,145,2,164,9,28,6,230,3,212,255,4,249,83,4,125,7,155,254,60,254,254,9,90,10,244,249,106,10,251,11,84,255,58,6,131,244,146,4,99,249,221,3,109,6,115,252,197,7,173,5,189,8,78,9,93,2,97,3,37,253,179,10,51,0,228,2,18,245,0,10,13,3,130,5,112,252,3,4,215,245,93,6,187,11,247,3,22,2,224,5,205,10,198,6,227,252,237,243,151,252,168,244,198,248,62,255,125,3,113,0,63,1,248,253,96,252,23,12,191,6,12,253,245,4,111,244,109,250,135,244,33,1,116,8,3,250,78,246,81,0,157,255,85,247,208,243,89,246,235,247,6,248,226,8,131,251,47,6,190,1,135,253,97,4,147,8,39,8,91,252,215,10,178,252,236,250,190,252,38,9,68,10,116,247,206,255,97,255,41,246,169,252,34,254,144,250,18,7,3,250,19,12,192,253,246,250,106,11,112,6,100,10,37,3,101,2,173,243,120,3,154,252,115,246,42,245,72,4,234,244,0},
  {112,11,55,6,234,251,238,11,212,248,187,250,57,252,162,4,20,1,42,9,188,247,174,11,145,6,247,5,234,5,197,244,192,254,54,251,34,0,170,255,125,8,51,5,17,9,8,252,236,5,240,246,236,247,253,247,203,243,26,246,136,10,251,8,234,2,35,8,3,6,90,254,74,245,102,3,6,9,18,2,78,248,72,11,82,4,41,250,58,1,171,245,1,4,94,4,228,252,220,4,180,251,64,12,43,248,104,248,83,3,79,5,204,243,112,245,136,255,45,6,223,244,182,7,137,247,78,249,185,246,161,243,14,250,106,11,45,6,211,8,209,3,88,2,8,250,12,6,46,4,227,254,197,5,5,246,102,4,69,2,33,249,115,250,117,1,239,1,162,8,97,0,114,244,31,7,195,250,82,8,73,251,222,247,171,2,136,0,224,1,192,4,107,1,64,251,200,250,93,254,77,11,86,6,96,1,186,5,98,244,229,4,71,253,80,8,133,9,23,247,90,245,75,3,210,1,21,11,137,249,28,251,194,10,152,4,237,9,91,0,26,251,82,10,227,9,92,245,80,5,121,5,69,255,164,243,74,245,90,245,249,0,30,5,166,11,46,252,103,11,228,11,119,10,222,3,91,248,73,247,216,248,137,10,107,1,54,254,146,248,187,252,53,252,86,245,26,253,80,4,180,3,110,251,196,251,166,245,232,2,202,245,175,255,121,255,140,7,180,9,21,10,136,10,106,4,128,0,224,10,44,8,224,4,61,254,67,252,170,252,154,247,81,253,174,3,166,247,179,245,89,11,135,6,53,254,27,6,52,245,1,6,212,6,160,250,77,3,107,6,117,11,73,6,36,244,45,251,149,252,239,1,8,6,226,250,245,245,189,246,245,5,146,254,243,250,184,255,164,251,183,4,81,248,56,248,117,249,11,4,161,2,228,248,33,1,225,2,112,255,41,11,52,5,165,245,43,251,141,11,188,247,201,3,111,251,244,11,110,247,92,1,210,11,212,251,74,8,202,0,217,244,86,12,158,8,31,12,92,247,60,0,249,254,202,2,82,8,251,253,83,245,165,245,73,244,179,1,187,251,126,245,244,9,8,1,227,245,150,244,66,9,194,1,248,1,84,8,230,248,253,253,159,250,208,245,76,7,123,5,255,254,147,2,100,245,81,244,196,244,34,3,154,244,212,248,85,247,161,11,238,253,202,244,175,245,139,249,174,251,226,0,107,252,186,11,176,245,217,252,83,253,214,252,227,250,54,8,21,7,247,247,32,3,206,7,187,4,191,10,233,255,70,6,173,7,176,1,178,247,203,251,41,252,53,5,115,7,165,255,250,6,28,2,249,244,99,0,212,0,27,10,217,4,168,250,136,247,227,248,21,255,215,9,244,254,231,11,80,7,238,245,246,249,186,11,196,255,99,1,182,250,183,249,68,8,124,3,97,249,154,10,151,9,53,10,194,253,75,10,226,254,31,248,75,0,58,251,24,254,67,245,45,11,85,11,106,2,140,7,222,0,147,253,64,9,5,255,40,244,245,8,20,251,106,253,249,11,59,4,7,7,241,245,68,244,20,3,124,248,234,247,169,4,63,8,17,244,58,5,17,251,23,6,47,250,215,2,106,3,31,1,172,250,0,1,98,7,61,247,69,1,80,8,126,255,165,247,10,252,117,9,5,7,0,3,32,3,242,4,58,11,204,7,167,4,213,250,9,252,223,251,123,245,62,5,116,11,51,4,95,248,126,4,193,10,4,252,75,244,248,243,59,8,219,9,122,253,217,249,54,4,127,254,145,253,205,250,246,249,237,253,170,4,38,9,179,10,91,254,114,248,3,252,150,251,179,11,57,246,102,254,143,251,32,245,44,0,255,6,42,251,36,7,40,1,239,2,184,253,141,4,79,255,58,3,55,248,198,2,65,249,172,255,64,249,40,6,219,251,219,248,56,252,167,248,215,3,249,252,191,11,158,1,32,9,11,251,203,3,208,9,45,7,53,3,193,2,5,5,89,246,122,2,26,9,41,12,142,246,107,245,211,250,181,254,71,11,250,250,134,254,239,1,57,0,212,11,152,251,126,246,176,245,2,6,202,9,46,10,202,246,244,251,58,245,155,3,59,1,177,4,203,243,13,3,73,244,80,8,244,8,218,3,23,9,112,255,124,247,17,250,98,255,159,244,66,251,28,9,15,245,241,243,118,3,128,3,96,4,156,9,5,9,185,6,69,4,225,251,205,2,57,0,118,252,109,9,146,251,99,4,221,253,226,252,65,247,31,249,133,4,202,251,75,8,214,2,253,6,140,2,5,8,64,7,27,6,17,255,115,250,251,252,22,248,99,252,9,245,249,252,35,246,85,246,47,253,192,11,74,4,229,9,197,5,159,7,38,1,63,253,130,7,241,3,173,248,177,3,6,12,205,2,217,247,73,11,36,248,203,250,227,4,160,1,202,250,158,10,210,253,223,3,226,7,207,245,196,254,15,251,244,253,28,3,222,6,145,2,154,0,195,246,11,246,178,244,238,252,150,246,119,250,98,251,93,12,89,2,21,250,40,1,190,243,25,2,72,11,204,10,227,3,10,255,127,245,40,246,80,9,218,10,49,8,222,250,196,5,145,252,145,3,159,10,140,254,115,6,113,1,239,244,115,252,126,6,76,4,84,244,131,255,106,255,180,243,53,12,44,251,84,253,22,6,133,11,19,255,8,2,194,252,26,250,124,246,9,9,18,253,211,243,170,246,39,9,14,3,156,246,231,246,78,9,24,251,129,0,82,12,219,252,199,243,25,244,103,253,67,0,97,255,152,248,165,246,34,245,59,245,33,4,93,255,90,247,237,3,152,0,222,6,148,10,93,245,0,7,252,2,17,251,156,5,0,255,64,6,41,249,251,10,250,249,75,8,109,247,143,254,224,250,148,251,54,252,165,5,241,6,25,9,81,9,137,246,13,249,184,252,2,4,28,10,89,9,253,0,16,255,108,248,73,7,56,4,104,250,48,244,212,249,152,245,198,247,253,5,225,3,8,251,33,244,61,252,112,252,175,243,39,247,12,1,98,12,14,250,142,244,153,248,68,253,170,253,166,7,62,10,218,0,74,10,191,7,88,247,191,253,255,253,243,251,136,0,252,245,79,12,154,245,177,246,172,0,133,8,161,8,42,11,74,248,110,244,58,245,139,255,4,3,96,1,39,2,224,2,100,8,173,250,16,8,42,9,62,244,225,11,46,6,184,0,209,6,195,244,88,1,246,243,135,7,253,248,154,244,186,11,135,247,134,9,189,1,58,252,112,2,68,5,182,244,129,7,123,0,6,1,11,6,174,248,67,5,124,250,96,11,186,244,245,252,164,3,3,7,42,0,129,254,58,6,1,7,243,2,207,5,233,7,57,255,224,0,202,4,155,6,64,255,33,254,152,4,67,6,86,3,195,0,197,8,70,6,104,245,132,253,171,255,10,0,52,10,55,1,108,245,98,7,189,243,61,4,66,2,204,254,28,6,60,1,24,0,58,248,179,1,165,9,16,254,165,4,10,247,11,1,248,253,147,1,115,255,6,255,72,244,125,246,59,6,134,250,247,254,6,249,187,252,174,8,169,252,133,9,129,11,252,4,46,250,125,254,177,10,19,1,214,4,254,8,169,254,163,8,44,9,239,5,229,250,160,1,129,249,217,1,118,246,183,246,222,248,142,245,6,249,147,5,157,1,200,253,248,11,34,249,183,249,88,253,41,253,122,248,166,8,249,0,158,243,53,253,185,1,20,244,96,8,52,4,206,10,184,9,217,7,249,253,209,9,213,243,127,252,125,250,168,8,224,245,52,6,85,3,48,252,233,244,180,253,106,0,214,247,238,11,26,250,252,255,34,1,252,244,232,9,211,253,199,1,50,6,173,249,162,252,186,255,249,3,189,2,203,249,236,250,33,255,30,246,93,252,159,1,243,11,219,1,26,255,224,255,79,7,208,4,183,5,174,6,63,244,240,2,168,0,159,253,145,244,199,5,107,246,50,3,142,9,210,247,53,255,222,4,81,8,212,245,39,254,108,246,132,245,121,250,119,6,226,8,184,248,13,12,49,245,247,6,120,251,147,253,239,2,88,244,114,7,200,2,194,5,56,3,197,8,236,254,96,244,177,255,242,255,196,6,152,249,69,252,68,253,254,243,11,251,128,2,140,245,86,247,165,250,114,252,85,247,184,251,94,10,252,10,200,2,191,254,31,7,140,244,153,8,160,247,108,251,234,11,97,250,61,10,40,4,170,243,240,248,198,3,2,3,62,250,178,2,193,11,0},
  {44,6,148,5,124,251,68,247,130,1,173,243,22,252,224,11,226,248,181,1,27,10,28,8,22,245,95,2,133,252,206,255,114,5,150,2,156,6,181,2,116,5,120,253,252,8,92,246,22,9,17,1,204,9,49,10,133,8,81,6,21,10,223,9,161,10,188,250,72,248,123,3,153,2,110,250,124,252,106,244,235,252,125,11,144,246,197,4,164,5,194,248,238,9,243,246,62,254,161,244,152,11,198,251,50,9,18,253,5,248,15,8,205,253,166,4,252,7,99,12,116,251,133,252,216,243,35,249,145,4,38,8,94,252,44,254,131,4,140,2,35,249,112,8,110,11,215,253,252,2,222,2,108,2,58,247,30,252,116,9,186,9,244,253,105,6,12,246,3,247,13,250,93,250,108,6,218,243,27,252,218,6,140,246,152,244,228,11,42,4,226,4,241,2,124,1,240,244,16,248,230,254,201,244,243,10,20,245,180,0,150,244,106,245,232,252,157,0,215,7,7,245,136,4,114,249,245,6,8,249,3,1,179,8,168,254,182,247,107,244,219,243,168,244,229,2,109,10,177,7,98,8,24,253,158,255,217,7,49,3,182,244,255,251,157,244,179,6,209,1,209,243,198,11,165,5,65,254,206,1,181,250,24,249,101,249,149,6,196,249,229,247,228,2,185,255,178,7,146,245,242,3,115,253,117,1,225,254,132,246,30,245,95,6,10,3,133,9,56,244,239,249,226,2,208,1,200,2,22,244,163,2,175,8,29,11,11,248,42,245,62,12,252,246,42,6,170,244,132,3,12,244,179,5,83,252,252,252,193,10,17,247,86,11,33,7,168,253,228,2,91,9,137,10,160,244,151,248,210,4,150,0,235,245,102,10,105,245,118,1,15,246,241,3,20,0,75,11,115,253,88,252,85,253,31,0,238,3,167,245,207,9,49,248,188,254,100,250,127,254,35,2,4,255,150,245,242,255,186,243,168,3,21,246,45,3,139,253,61,1,152,253,129,10,50,248,51,247,228,248,13,2,211,254,41,7,60,255,157,11,249,249,206,244,160,254,121,247,21,253,197,251,211,248,149,5,90,249,124,247,72,244,146,2,230,5,176,252,158,1,117,245,218,9,102,7,135,248,115,4,26,2,55,2,175,3,161,246,148,246,145,252,10,253,24,2,62,253,216,250,249,251,112,4,163,243,125,248,193,248,137,250,89,6,223,245,233,245,252,6,57,3,255,3,145,255,190,7,127,6,180,249,248,2,39,6,52,255,232,243,126,245,100,3,127,1,47,11,80,10,68,248,85,1,1,247,171,248,58,12,137,255,237,251,16,254,233,10,82,3,185,246,219,0,187,4,140,249,107,6,229,1,154,3,25,9,17,244,137,1,94,251,47,249,226,251,149,5,184,244,103,249,222,245,208,0,92,244,157,252,2,250,243,9,12,0,243,243,207,243,71,4,39,246,141,7,174,244,101,250,87,254,207,255,195,251,135,252,53,244,72,247,231,10,154,244,251,249,186,11,146,3,39,10,206,11,238,249,137,10,159,4,106,6,73,8,72,6,69,246,193,7,64,254,36,9,250,255,3,248,136,5,118,251,116,4,180,0,49,3,243,251,210,3,182,7,175,254,233,247,177,4,147,253,109,244,89,11,113,247,200,8,83,7,237,248,178,10,131,0,173,253,95,2,206,243,122,5,141,244,244,251,112,248,33,9,165,255,219,9,230,245,174,3,46,4,70,8,38,5,48,2,35,248,174,9,115,252,209,7,245,0,90,244,197,250,70,0,109,246,36,5,161,254,93,11,120,246,209,249,236,249,198,251,82,252,25,244,0,245,89,3,93,244,24,3,65,249,217,247,221,248,58,252,166,243,147,251,12,250,224,245,2,244,178,10,109,10,177,244,253,243,142,3,116,4,250,253,223,7,188,3,236,9,194,248,109,11,255,4,175,243,44,1,163,5,69,7,249,5,126,4,13,0,85,9,160,253,197,0,249,253,243,11,154,0,222,4,180,9,103,248,95,244,40,254,77,7,70,252,25,10,61,252,163,250,242,8,205,8,152,7,38,11,86,2,166,4,203,248,195,247,173,255,143,0,141,5,47,248,177,252,79,252,26,2,207,243,140,3,239,250,12,5,242,1,70,249,29,2,241,7,236,246,243,11,11,253,187,248,172,1,60,255,122,4,179,245,148,244,163,247,167,9,75,248,208,249,24,248,233,245,12,251,185,8,112,11,122,250,30,249,248,3,62,10,159,3,230,251,148,8,158,2,119,10,188,11,73,0,216,3,247,3,242,246,129,3,91,248,106,11,166,249,15,6,94,10,169,249,247,243,146,248,109,247,115,251,66,4,110,255,30,3,154,8,49,246,98,0,78,247,3,6,35,10,69,244,165,255,80,8,168,254,187,9,90,247,134,11,110,9,139,11,160,244,176,243,192,250,170,254,25,6,157,10,231,2,122,7,117,5,16,5,115,5,183,244,2,10,179,251,178,245,193,254,42,6,78,2,225,5,176,2,108,252,36,6,33,255,207,245,50,246,179,251,36,251,185,2,236,253,163,11,57,247,232,254,210,3,79,2,197,252,213,4,71,245,150,250,142,2,75,2,165,0,134,7,134,2,10,7,190,3,85,244,205,11,54,255,52,246,217,7,99,0,144,245,75,244,173,246,143,246,130,11,241,250,218,9,66,244,234,247,118,6,195,243,146,7,136,2,65,11,25,6,177,254,192,9,33,12,212,247,142,252,251,0,164,5,173,248,135,3,111,246,188,11,154,252,11,254,255,9,30,253,2,254,46,10,191,243,131,4,12,250,186,251,12,252,189,244,102,255,27,249,201,9,202,243,121,11,9,250,3,7,137,252,230,7,203,1,171,7,176,248,163,2,168,253,237,251,185,251,115,248,69,253,94,246,247,254,33,11,126,249,244,7,16,2,209,249,253,247,76,244,62,1,184,249,236,1,121,3,102,3,90,251,145,10,66,4,169,247,52,5,4,249,8,7,29,4,244,10,16,8,166,252,228,255,111,248,127,254,181,244,78,12,244,246,71,3,251,254,134,249,157,252,216,1,176,4,241,247,192,6,81,8,84,246,228,3,152,246,219,2,132,247,112,248,202,2,52,8,88,10,17,7,72,252,51,10,186,9,69,5,156,1,207,0,24,245,70,10,82,12,255,250,7,255,145,248,61,249,89,6,94,7,205,251,190,250,68,8,237,244,237,2,142,245,15,249,5,9,117,244,130,2,181,2,236,246,136,1,167,11,5,7,44,245,27,249,249,2,39,0,71,249,122,0,236,255,139,252,252,251,246,252,41,253,176,244,187,245,27,7,20,4,238,1,81,247,216,244,36,251,168,8,91,253,184,255,84,253,140,251,240,254,18,0,73,254,123,11,29,11,174,6,178,6,187,1,50,250,214,254,64,245,49,249,17,12,55,11,230,6,86,253,229,6,14,7,102,11,39,2,189,11,153,251,211,7,233,10,245,246,26,251,157,250,121,247,68,12,228,10,103,7,170,2,110,11,255,246,36,251,18,247,95,249,252,250,160,5,32,8,211,6,21,12,224,255,181,249,52,12,215,4,26,251,198,7,187,7,249,248,21,247,219,245,142,245,29,0,172,254,157,252,132,11,78,255,248,5,124,247,69,250,110,1,252,249,182,5,110,254,246,7,200,10,69,254,79,253,62,12,138,244,82,3,85,245,16,252,13,0,41,9,22,249,249,243,162,243,238,247,153,1,122,252,117,7,3,254,111,11,1,246,182,1,206,248,165,250,49,251,207,5,18,245,244,248,108,7,6,10,214,6,97,252,123,10,19,1,12,1,174,0,32,6,102,248,62,6,25,10,22,254,63,248,223,2,35,246,50,246,9,12,246,250,164,3,80,251,91,1,51,249,235,9,27,10,85,247,35,9,145,0,89,11,88,3,185,8,83,250,23,8,58,254,132,254,172,0,228,10,120,2,243,10,69,248,254,253,74,255,34,3,255,5,15,1,201,7,2,0,204,3,27,4,144,5,156,250,155,8,182,10,237,245,218,248,189,245,27,250,221,8,97,8,67,253,233,255,46,254,232,11,183,7,68,2,141,8,89,251,191,7,113,3,152,1,118,0,147,4,140,244,18,250,37,251,210,254,43,4,194,245,80,5,184,1,174,9,16,6,61,12,212,8,92,247,84,5,110,248,176,6,159,253,150,250,205,254,78,249,157,255,175,254,161,253,10,247,205,6,203,2,236,11,246,243,19,6,47,8,185,243,45,4,100,250,54,1,121,254,151,255,84,3,37,251,177,243,51,8,0},
  {253,0,234,252,231,9,237,245,190,247,6,1,206,244,12,1,166,243,198,244,40,6,243,2,130,254,3,7,216,252,123,11,236,243,39,251,138,255,241,9,47,251,121,9,3,249,118,250,28,11,93,250,104,244,177,0,68,10,124,252,94,2,74,1,41,250,0,8,73,9,79,2,21,11,150,255,74,11,134,245,196,254,64,1,48,248,136,249,202,253,130,248,240,5,190,246,199,243,139,6,251,3,20,12,7,244,99,253,116,1,80,255,173,244,173,244,36,1,211,6,157,8,31,248,75,3,157,253,8,5,0,6,210,255,248,250,32,10,201,244,60,7,59,244,164,11,70,3,155,247,223,253,93,5,183,251,34,4,41,4,233,252,161,245,193,254,43,247,113,255,15,8,39,244,74,9,172,246,129,245,209,246,175,251,81,10,180,246,4,248,151,2,224,248,13,246,124,255,10,246,205,8,229,251,81,245,20,5,58,250,200,10,194,249,201,4,29,7,239,243,224,10,185,4,131,246,20,10,76,248,86,10,18,3,233,1,43,4,82,249,139,253,155,5,147,255,204,247,50,245,143,244,96,246,206,249,104,10,83,11,33,8,102,245,14,250,56,249,172,7,98,249,201,254,12,253,49,9,139,8,170,1,100,1,235,254,15,254,245,252,244,3,52,8,166,7,133,0,83,246,36,254,102,9,113,248,145,10,66,246,112,251,165,248,32,244,136,248,78,1,102,0,29,11,221,10,0,249,13,245,50,253,42,253,194,3,106,6,84,11,200,0,163,244,139,247,215,2,6,250,45,9,157,6,42,12,24,254,188,5,162,245,66,0,162,3,72,245,34,245,26,5,21,2,1,254,77,253,163,247,32,12,103,247,143,251,234,1,88,6,167,248,217,0,95,0,102,8,44,246,3,4,80,7,216,8,36,6,152,245,184,8,215,10,237,249,104,11,171,246,18,9,138,0,113,11,165,0,24,2,177,253,133,2,27,252,81,4,125,10,78,8,77,253,232,8,109,250,170,11,250,254,216,1,158,255,100,9,32,5,8,0,43,4,147,252,43,5,101,1,182,254,225,1,25,249,25,244,106,0,32,2,105,9,178,244,69,10,163,255,8,12,133,252,56,248,153,3,27,253,241,246,131,10,247,250,224,245,231,255,108,10,236,243,138,249,84,2,172,0,244,3,194,5,60,3,156,4,77,245,117,249,21,249,240,8,137,255,18,254,56,6,185,254,45,10,24,252,79,5,176,3,153,9,100,250,25,245,174,0,68,247,67,8,119,246,177,252,42,2,5,6,3,255,173,250,233,243,223,248,246,243,80,0,197,245,127,7,20,249,50,12,24,6,48,9,82,248,68,251,109,8,254,250,202,247,181,5,38,11,118,246,130,247,31,249,73,249,228,250,253,245,12,248,214,253,53,7,149,5,228,249,199,246,172,246,39,246,1,6,38,248,250,252,39,11,217,8,88,11,234,243,223,8,41,246,101,11,217,253,252,248,205,247,163,253,19,250,60,6,246,7,29,3,133,6,108,253,29,7,215,252,130,8,60,244,132,254,31,244,176,244,18,2,95,11,206,5,213,8,71,11,100,4,212,7,191,254,60,246,39,10,209,250,54,255,208,2,35,245,98,10,74,245,52,254,45,244,105,250,110,3,232,243,16,9,67,247,132,251,137,5,110,248,191,11,123,1,80,244,135,8,219,4,149,0,61,8,97,8,82,4,185,2,188,6,222,1,205,248,169,255,84,253,20,254,82,2,235,2,191,249,229,4,38,245,193,4,135,244,243,7,128,244,216,244,204,11,9,0,86,252,16,5,143,3,31,10,0,254,206,250,87,244,202,249,203,247,46,3,110,249,71,253,14,9,45,9,183,4,254,252,153,0,146,8,91,12,213,252,184,7,75,253,216,4,143,1,221,3,215,3,196,8,93,253,221,5,123,6,31,3,130,244,224,254,202,253,227,244,183,9,188,243,222,10,124,3,24,4,216,244,168,251,110,6,36,6,12,7,95,0,214,247,37,2,140,249,147,244,150,3,65,4,55,248,170,251,217,252,24,12,158,245,208,249,160,250,114,3,245,244,243,10,157,246,95,8,206,243,144,8,94,248,81,255,40,252,178,244,163,250,34,255,168,255,58,10,240,6,78,255,101,9,147,249,138,251,243,2,158,0,209,2,10,6,108,1,32,5,239,6,66,1,41,250,59,249,180,255,73,12,199,9,31,5,52,251,238,255,11,8,31,249,253,250,215,245,45,1,100,252,100,3,78,248,159,247,66,247,176,254,67,255,48,2,47,252,190,0,40,7,3,2,137,4,254,1,238,8,216,243,202,249,65,2,21,249,190,0,165,255,51,5,82,245,25,4,142,247,230,250,44,2,27,0,252,255,82,3,48,247,216,255,250,1,181,9,51,2,169,254,123,2,154,254,134,1,113,245,251,6,41,1,204,1,53,1,155,7,155,10,227,250,80,248,204,255,48,254,17,248,175,3,129,0,247,6,220,254,136,4,244,2,9,11,132,244,77,6,52,10,5,2,31,247,162,10,212,3,75,4,26,250,255,243,64,245,194,250,192,250,254,246,115,244,100,3,83,253,85,10,9,0,118,249,226,250,52,250,251,253,78,7,122,6,63,8,222,249,184,251,11,9,239,252,212,10,212,250,171,5,40,1,163,4,165,243,49,0,197,250,138,246,91,248,41,244,155,2,247,251,91,4,104,0,161,7,184,11,30,4,85,7,3,249,213,251,237,5,142,246,172,247,28,8,90,8,20,4,71,251,132,244,108,247,122,255,94,9,144,2,143,3,109,255,63,246,165,0,248,0,231,6,178,255,174,4,121,1,216,255,118,5,232,249,47,254,53,244,177,9,216,11,167,7,29,5,86,254,211,3,223,0,126,254,193,243,123,253,64,245,79,251,117,6,206,249,77,249,41,12,56,249,7,249,64,0,140,10,187,5,177,2,93,248,181,246,160,9,179,254,52,10,148,0,30,252,230,10,164,246,86,3,90,247,214,4,137,10,224,1,205,245,92,11,217,11,37,11,175,3,240,253,188,9,20,8,122,245,118,3,174,9,179,255,181,244,36,253,26,251,172,3,72,1,159,10,194,245,62,252,130,9,112,1,44,250,107,0,74,247,5,9,140,8,30,244,250,253,47,11,64,250,253,253,12,4,70,1,237,251,98,3,151,247,37,250,241,245,215,245,146,4,181,245,104,255,235,0,24,11,45,3,166,249,152,252,221,0,17,255,203,3,107,0,75,1,56,12,56,10,255,253,98,10,16,5,117,2,179,244,249,247,84,250,138,246,240,6,107,252,45,255,47,253,104,244,117,250,169,3,54,255,19,7,203,243,214,8,91,250,68,247,161,5,6,251,58,0,197,10,242,245,185,1,171,253,10,7,111,9,155,250,18,246,66,1,85,10,208,5,222,0,247,253,222,10,85,4,57,10,209,252,169,251,117,9,92,249,102,3,11,252,221,249,75,6,166,253,92,2,241,0,31,3,83,10,188,253,24,8,44,254,151,4,243,11,30,254,7,5,116,9,97,244,60,249,43,8,189,247,158,243,147,5,69,6,142,245,35,245,178,250,86,245,75,252,60,248,188,7,13,0,91,6,184,9,155,1,22,8,26,2,19,3,250,249,141,251,199,247,230,10,40,247,15,10,166,10,244,254,71,11,65,11,72,249,186,248,129,251,150,250,7,11,182,254,87,251,162,251,95,253,133,244,142,3,212,5,98,1,213,251,59,4,248,1,64,248,230,1,222,2,252,251,66,9,51,245,70,8,14,244,133,255,250,2,59,247,76,251,119,1,10,1,85,252,45,250,95,245,191,248,143,7,53,0,77,251,218,1,162,243,42,3,101,244,109,249,158,246,44,4,218,253,158,11,207,247,155,6,109,248,212,253,209,245,41,244,167,254,81,12,200,8,80,6,83,253,129,8,5,7,116,245,184,251,224,9,105,5,197,10,98,250,188,247,39,3,120,6,27,6,237,8,40,7,163,253,131,8,1,254,123,6,172,253,232,10,131,244,52,4,125,250,31,9,2,244,76,7,180,255,129,4,70,254,90,254,60,4,44,248,225,11,85,1,125,4,48,10,249,248,187,252,25,12,140,5,101,246,3,244,54,2,168,248,125,5,7,11,194,247,119,1,131,9,5,6,17,254,193,11,140,4,124,244,181,246,0,255,222,246,66,246,215,255,204,252,15,244,152,251,32,7,57,11,43,7,88,5,50,7,100,252,119,6,207,3,164,247,9,1,124,255,245,0,102,250,248,9,25,244,194,243,0},
} ;

static const unsigned char precomputed_core_invsntrup953_n[precomputed_core_invsntrup953_NUM][crypto_core_INPUTBYTES] = {
  {236,62,75,14,34,121,162,154,80,90,153,200,199,162,195,24,241,27,175,53,198,149,249,249,194,232,13,193,77,247,216,227,43,237,132,57,89,240,30,31,192,176,218,69,113,64,191,165,88,179,159,106,44,124,174,23,42,224,94,250,80,115,149,171,141,62,237,238,37,228,55,220,183,218,181,68,5,150,194,129,48,75,253,4,135,114,195,22,226,214,210,30,80,245,100,248,142,112,86,129,213,243,229,50,17,135,44,139,250,53,176,252,202,157,159,217,56,159,124,177,17,85,98,152,70,18,168,191,129,209,199,59,154,28,129,25,56,146,44,151,71,197,140,246,178,122,156,233,177,44,127,111,52,67,59,201,53,193,163,164,55,69,134,38,132,102,114,164,250,185,61,196,36,64,172,14,182,20,96,44,172,234,90,159,176,87,241,43,45,72,208,46,44,148,16,9,201,99,66,224,205,62,16,107,229,19,95,187,120,99,13,46,134,255,10,212,238,161,249,65,164,246,174,224,96,230,44,185,143,135,50,96,164,174,61,155,40,12,2,232,75,170,247,197,23,79,179,26,96,45,62,111,21,220,115,122,7,146,98,146,52,208,167,3,50,25,198,188,144,244,119,55,224,206,66,174,27,133,226,152,200,61,45,170,60,31,98,195,172,189,250,83,34,115,124,212,77,254,132,51,160,64,199,93,111,63,163,20,135,111,115,203,107,124,76,26,150,130,208,226,73,128,130,70,90,146,122,1,159,174,147,39,195,132,56,176,173,110,218,99,120,240,191,71,8,122,172,221,111,20,74,70,237,254,77,100,120,233,53,99,35,237,52,94,125,11,82,49,115,107,199,170,135,41,132,19,155,51,208,161,125,88,193,121,194,197,16,63,126,249,157,133,150,227,140,241,160,158,162,228,116,41,134,161,193,12,215,177,147,124,147,43,253,37,214,6,139,205,149,145,111,251,242,207,204,211,19,147,242,21,173,66,30,147,17,14,222,103,181,154,49,18,184,198,229,132,126,234,132,112,197,15,206,188,222,232,98,129,7,137,64,10,230,80,194,162,116,227,19,202,147,13,109,250,204,31,103,11,181,12,254,142,122,185,120,11,81,1,230,125,83,149,87,182,88,22,115,83,122,2,89,103,202,120,233,43,119,17,55,76,39,139,8,91,156,205,20,54,125,239,4,63,158,100,126,133,43,178,73,128,134,139,101,73,27,18,173,240,28,249,191,50,182,240,121,72,22,12,168,243,143,180,157,31,147,69,227,195,156,209,151,235,116,70,98,163,83,154,93,2,91,94,144,253,8,158,75,248,226,6,117,233,31,28,83,252,210,134,160,240,237,154,87,78,57,90,35,26,3,186,42,212,138,156,152,59,64,139,255,232,41,243,161,223,67,24,136,89,213,17,36,78,40,42,195,11,94,162,135,80,91,52,175,138,68,77,189,69,252,172,87,165,10,1,212,251,74,83,175,0,225,27,199,196,79,44,152,37,222,22,136,88,120,19,30,133,224,240,64,51,70,83,2,86,113,91,234,165,123,170,68,150,49,160,29,130,40,101,86,140,250,10,235,133,119,98,253,216,146,250,24,21,99,251,224,211,92,210,56,25,131,238,110,154,184,192,119,31,178,113,143,253,0,108,125,237,42,236,156,40,105,41,246,187,155,180,43,131,238,114,186,178,253,70,229,167,58,15,54,153,100,171,180,223,173,68,217,16,58,103,109,252,254,53,232,245,127,112,132,150,155,132,111,55,91,7,191,28,162,47,107,244,169,117,88,145,53,30,51,234,175,53,224,209,220,109,138,30,187,50,56,77,38,238,127,40,238,120,172,244,222,44,213,240,22,105,106,74,207,251,100,97,224,170,174,124,50,54,242,207,124,30,175,204,8,125,252,252,151,56,83,85,44,81,177,103,139,176,232,241,204,130,191,172,245,132,155,13,239,203,251,252,150,140,208,216,200,207,150,223,237,184,114,141,168,205,113,155,234,64,178,215,53,226,65,13,194,74,138,154,160,227,163,116,92,35,240,195,102,56,48,159,166,98,97,252,206,6,185,74,132,78,195,47,127,102,177,143,154,255,117,17,194,209,40,150,193,211,181,9,251,89,141,161,23,26,24,30,139,178,188,158,142,218,141,125,6,255,230,40,81,210,14},
  {148,16,236,177,74,37,40,86,209,182,78,116,131,121,55,163,131,140,89,120,154,156,92,98,128,49,18,4,56,176,144,43,127,122,117,210,40,166,19,228,16,10,210,36,63,133,162,35,168,101,176,68,40,115,162,90,108,105,190,92,122,220,80,9,190,215,151,191,77,156,107,59,200,249,197,143,18,201,78,59,179,151,87,71,246,190,175,54,26,71,115,68,185,56,56,3,161,99,187,76,144,173,138,175,249,217,28,5,27,179,41,44,193,16,126,93,69,76,165,180,213,199,92,232,42,0,24,8,174,243,189,44,80,70,235,175,181,216,19,205,125,10,79,165,73,146,60,2,120,5,196,103,147,13,132,192,227,82,254,66,134,33,239,199,105,182,7,67,71,211,18,118,90,169,202,149,128,98,226,212,24,202,184,204,93,40,89,246,177,85,172,255,145,41,125,228,215,75,46,67,13,171,79,118,174,52,155,156,14,20,214,142,184,131,76,17,219,245,217,74,147,69,7,161,112,245,41,109,46,109,254,200,149,59,206,103,142,36,131,122,82,77,217,66,90,123,223,211,45,207,180,137,72,106,219,194,19,193,87,46,97,103,104,59,233,78,144,230,108,64,105,18,116,165,184,168,58,0,244,99,224,90,79,129,33,15,186,245,246,244,73,222,218,103,111,30,191,182,66,50,39,2,18,135,251,52,253,38,16,246,151,137,171,225,179,81,167,250,85,23,119,174,197,247,61,81,94,203,209,95,188,113,146,110,241,208,14,142,185,167,50,21,192,91,216,20,136,16,136,253,47,210,9,243,225,44,13,201,92,54,170,20,124,168,132,194,99,130,81,54,195,97,128,3,172,65,2,210,185,93,7,5,149,175,136,146,192,78,71,120,240,170,249,227,21,22,142,135,91,200,114,47,19,217,182,66,194,23,38,14,29,6,54,189,105,233,4,49,237,226,134,212,44,82,226,227,209,206,160,148,204,26,74,42,117,168,165,12,180,214,193,139,35,106,133,194,91,59,55,33,123,188,253,208,8,124,96,208,63,40,98,58,182,195,243,88,7,107,19,137,178,225,170,185,110,175,182,232,133,248,98,232,225,66,192,54,77,75,9,123,98,113,83,232,195,93,51,154,77,101,196,149,31,181,238,232,220,7,164,140,31,86,118,179,195,101,164,60,167,75,202,88,4,212,179,25,147,165,16,5,107,156,129,250,78,25,70,189,110,166,19,207,123,81,194,185,47,61,245,9,177,201,33,1,29,178,164,122,87,96,114,172,134,175,166,8,65,42,65,31,236,155,206,62,243,76,240,59,6,202,179,97,43,228,130,15,64,114,234,24,148,33,229,5,66,81,154,148,6,152,137,141,176,245,31,37,239,101,71,209,136,134,195,18,177,63,180,207,36,32,253,208,137,251,181,183,241,232,12,189,87,205,2,214,24,111,185,176,241,73,134,168,249,91,84,139,9,231,190,75,93,54,23,68,192,71,160,158,199,42,151,92,19,211,255,165,29,245,114,122,149,2,80,219,29,242,50,231,141,217,84,230,12,118,241,185,109,183,181,193,190,119,180,55,244,195,72,26,169,41,230,58,79,247,212,190,88,98,40,230,17,169,109,135,83,173,26,238,132,170,169,65,171,118,234,48,65,8,87,17,115,239,33,247,222,150,73,110,66,127,40,187,93,190,76,235,83,99,25,163,117,245,48,31,59,192,171,155,13,194,69,208,40,208,135,214,95,123,166,255,113,0,233,131,206,243,221,31,110,236,77,220,19,126,78,17,169,71,202,208,178,249,83,47,28,208,3,63,227,67,118,12,144,252,71,16,121,243,118,37,142,86,45,35,199,133,98,210,83,53,148,54,172,181,171,63,89,118,230,179,64,105,56,190,85,179,86,164,87,75,76,60,10,100,157,151,245,194,136,166,125,6,192,45,53,236,62,50,51,231,168,175,237,162,73,122,42,36,209,201,130,28,72,115,49,165,130,217,38,78,233,183,229,44,47,199,104,227,235,78,165,242,149,196,223,207,5,206,238,180,188,219,86,201,87,176,90,102,114,145,148,195,89,47,36,154,119,192,211,102,36,233,45,125,249,61,111,158,217,112,175,51,133,204,77,205,15,142,8,97,253,223,190,195,110,153,137,252,42,182,39,111,26},
  {152,208,180,252,179,45,169,130,184,221,73,229,5,247,91,62,105,229,14,224,182,220,15,196,2,37,189,149,185,71,7,211,83,155,119,109,23,215,56,111,250,251,161,113,42,168,65,248,57,23,228,204,35,90,62,114,216,46,141,185,231,89,99,241,219,64,188,172,30,5,187,159,185,114,237,237,238,52,233,231,61,64,181,199,124,161,61,169,92,247,242,112,60,118,248,177,103,69,143,240,250,77,71,123,113,171,231,57,241,159,253,209,214,0,42,253,8,11,14,215,169,37,119,60,180,32,103,143,117,254,247,189,139,65,255,75,187,40,247,144,164,165,65,143,33,205,210,89,225,63,218,233,157,243,243,157,235,24,235,181,62,8,249,28,115,169,54,46,210,180,76,106,159,42,70,36,97,80,226,29,13,98,34,67,112,180,190,23,136,235,176,171,98,36,246,36,107,236,12,76,142,128,112,12,60,14,93,131,133,188,87,228,109,189,59,78,68,120,214,136,7,38,131,86,25,238,155,43,247,230,207,237,73,134,190,169,199,167,196,129,187,153,41,158,123,128,211,252,113,164,117,163,98,254,205,9,23,93,184,30,219,155,142,189,245,222,184,213,6,148,195,26,91,130,158,136,114,72,131,29,106,218,23,191,137,49,224,161,238,53,161,209,101,8,55,90,185,90,233,111,233,161,107,193,155,30,15,118,73,71,185,186,166,154,225,90,184,224,97,68,113,0,96,157,234,13,196,83,143,106,1,47,209,245,103,146,117,194,151,142,63,125,155,142,229,223,119,15,228,17,203,138,55,122,131,248,214,125,158,109,100,37,224,116,206,116,152,228,31,105,218,94,78,59,94,231,116,5,13,8,229,178,89,193,81,228,76,71,115,96,29,59,191,69,75,245,181,111,143,23,101,125,88,186,220,193,119,127,127,204,129,6,2,96,20,148,65,142,167,236,84,19,79,11,16,224,142,167,193,29,244,40,147,161,205,105,4,216,40,240,236,139,234,232,157,243,67,183,84,67,140,123,65,71,160,216,70,120,188,105,79,253,209,226,207,145,65,46,81,128,33,228,206,172,153,205,104,238,236,211,82,116,3,150,122,117,171,129,56,160,193,138,180,43,38,85,116,113,220,113,126,240,223,40,95,220,208,116,173,112,2,136,216,183,6,13,205,188,82,155,116,101,171,148,85,54,158,170,40,94,102,218,238,124,238,59,104,141,79,175,115,194,149,60,14,169,174,135,214,71,171,135,245,168,21,203,46,128,214,13,197,202,33,229,54,3,202,70,200,9,30,123,191,26,254,121,165,99,74,121,249,90,125,73,108,5,92,203,232,245,115,210,130,94,33,237,145,81,195,32,151,211,88,28,2,100,225,129,151,86,226,64,79,156,111,192,204,122,31,190,198,93,9,113,34,181,179,50,195,249,74,242,151,147,167,15,188,2,187,210,247,151,69,164,230,124,134,95,25,181,80,77,198,135,205,251,201,98,16,101,49,173,51,43,70,82,26,164,33,194,105,251,139,92,169,190,147,74,229,9,82,30,43,219,194,81,162,35,136,128,8,150,232,83,121,35,119,169,189,26,99,66,168,110,123,17,23,52,183,235,233,52,211,161,158,189,3,233,219,17,229,139,58,30,178,186,206,151,28,120,78,122,49,146,96,219,57,197,157,201,173,162,76,112,224,171,38,34,201,39,211,13,75,175,108,42,164,2,171,196,88,171,81,129,20,185,128,96,175,28,137,215,43,239,71,207,124,248,228,116,185,75,35,73,247,28,77,27,122,46,136,129,12,35,68,181,66,70,59,95,11,176,123,167,173,244,68,104,148,224,112,142,187,247,46,69,115,23,156,172,2,89,142,84,140,19,4,41,38,166,186,210,240,117,104,245,218,136,126,237,107,1,146,168,169,245,144,60,60,120,79,210,240,214,159,203,169,149,112,217,182,215,180,247,146,134,26,233,194,124,42,72,164,65,148,33,186,2,247,128,224,211,19,35,151,115,56,106,86,220,25,50,95,1,28,170,251,242,78,191,51,167,238,61,207,171,212,5,3,99,1,137,145,245,180,37,67,150,204,161,34,108,76,136,121,229,34,216,136,42,11,239,148,15,137,3,42,85,3,231,24,173,130,211,250,166,102,40,160,187,163,199,11},
  {239,55,145,154,252,242,93,210,239,228,255,91,253,56,82,64,237,78,213,137,122,15,154,26,126,98,138,140,50,120,1,47,176,21,16,32,189,116,190,168,175,231,49,52,6,39,167,89,247,123,70,104,123,241,148,36,126,53,198,136,176,115,170,77,133,48,225,82,240,24,165,28,22,118,155,241,15,114,252,194,146,67,155,202,175,36,185,119,248,201,197,131,174,98,153,147,149,84,7,12,253,134,58,24,238,228,189,126,135,125,241,55,4,158,170,35,14,85,29,9,153,183,199,3,21,18,199,236,3,74,213,99,154,251,71,29,218,97,44,146,62,39,94,85,117,48,55,38,141,204,100,127,172,140,89,58,130,152,121,240,111,2,189,199,205,203,62,59,101,134,122,118,116,147,10,48,199,196,133,14,17,208,99,242,139,194,181,203,161,91,194,148,154,62,189,18,165,7,123,165,187,17,27,113,255,69,64,202,115,108,247,11,199,2,13,134,98,126,245,131,166,40,226,72,185,181,46,101,233,27,4,112,105,198,235,107,77,23,196,190,121,4,37,254,43,62,88,155,105,127,132,103,174,64,210,235,121,93,121,152,84,183,174,252,75,53,112,84,10,188,70,238,212,136,40,115,32,210,108,130,85,76,253,143,213,116,164,131,58,88,108,253,167,241,12,242,2,202,197,37,107,26,8,250,161,210,133,183,81,52,195,3,57,68,13,113,129,83,186,55,66,86,255,57,119,148,189,97,17,42,51,36,197,55,48,155,24,154,121,21,118,142,153,32,106,92,52,173,95,228,17,97,165,48,2,148,21,47,81,6,55,44,98,127,227,87,44,190,86,197,39,207,145,186,110,35,48,18,77,46,54,3,229,126,230,241,32,130,95,152,67,32,34,117,197,67,157,40,185,101,246,172,77,158,42,77,28,229,13,38,198,50,47,46,242,90,214,121,171,79,243,68,69,144,219,15,78,193,107,158,55,214,104,90,239,215,173,4,228,49,20,97,93,189,173,208,74,194,142,155,11,184,215,91,175,73,61,104,13,99,155,171,24,149,176,4,111,141,226,17,159,103,99,74,235,128,144,187,19,113,169,130,65,5,208,49,173,210,253,203,190,56,247,141,41,114,53,14,130,125,48,7,199,207,169,41,197,42,98,204,129,15,234,216,56,55,148,243,82,134,202,96,114,99,63,173,132,9,49,224,43,220,243,127,123,170,139,122,104,31,190,30,8,183,192,77,110,107,180,119,181,132,151,70,69,110,19,32,90,97,112,86,139,211,73,138,216,211,237,178,1,84,172,61,119,165,12,160,239,201,224,246,219,30,70,22,158,36,161,114,203,75,53,145,212,29,232,253,14,182,148,74,84,251,87,216,222,0,47,214,138,212,166,41,223,196,95,148,198,143,72,63,76,216,47,254,12,228,187,26,103,58,81,205,166,151,131,245,36,236,124,200,72,42,8,248,102,172,91,155,235,130,26,0,183,250,108,166,159,216,234,62,86,39,64,180,224,238,199,1,76,21,1,139,194,145,37,128,255,217,55,91,216,157,156,141,105,20,180,222,44,74,76,98,156,202,163,154,140,217,64,44,237,224,59,237,201,8,135,17,190,139,47,12,211,174,120,189,104,114,201,139,85,201,90,223,206,168,74,130,214,193,188,84,65,133,182,221,242,203,0,129,110,89,222,34,19,133,242,157,93,162,77,54,68,91,77,121,211,143,144,173,65,180,189,81,214,246,88,226,98,199,62,122,23,108,174,94,0,165,69,172,8,206,21,195,60,147,29,28,225,20,127,129,162,38,187,173,125,149,190,35,67,202,196,91,61,159,32,248,52,138,119,170,149,62,153,161,71,171,227,146,61,39,202,41,66,31,250,154,46,194,71,136,164,111,198,92,238,136,178,75,240,187,162,118,88,80,110,160,90,163,79,22,24,221,149,200,49,252,145,75,5,147,58,148,34,241,24,77,158,108,47,241,90,54,34,41,138,194,69,161,117,235,66,141,85,36,165,121,212,242,10,118,154,197,56,206,171,124,203,135,226,73,250,91,137,56,227,120,210,208,36,122,204,122,169,187,81,73,61,49,183,108,146,89,143,63,4,235,234,116,81,20,16,142,43,211,18,241,217,9,15,59,236,218,150,50,227,38,238,10,155},
} ;

static const unsigned char precomputed_core_invsntrup953_k[precomputed_core_invsntrup953_NUM][crypto_core_KEYBYTES] = {
  {},
  {},
  {},
  {},
} ;

static const unsigned char precomputed_core_invsntrup953_c[precomputed_core_invsntrup953_NUM][crypto_core_CONSTBYTES] = {
  {},
  {},
  {},
  {},
} ;

static void test_core_invsntrup953_impl(long long impl)
{
  unsigned char *h = test_core_invsntrup953_h;
  unsigned char *n = test_core_invsntrup953_n;
  unsigned char *k = test_core_invsntrup953_k;
  unsigned char *c = test_core_invsntrup953_c;
  unsigned char *h2 = test_core_invsntrup953_h2;
  unsigned char *n2 = test_core_invsntrup953_n2;
  unsigned char *k2 = test_core_invsntrup953_k2;
  unsigned char *c2 = test_core_invsntrup953_c2;
  long long hlen = crypto_core_OUTPUTBYTES;
  long long nlen = crypto_core_INPUTBYTES;
  long long klen = crypto_core_KEYBYTES;
  long long clen = crypto_core_CONSTBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_core_invsntrup953_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_core = ntruprime_dispatch_core_invsntrup953(impl);
    printf("core_invsntrup953 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_invsntrup953_implementation(impl),ntruprime_dispatch_core_invsntrup953_compiler(impl));
  } else {
    crypto_core = ntruprime_core_invsntrup953;
    printf("core_invsntrup953 selected implementation %s compiler %s\n",ntruprime_core_invsntrup953_implementation(),ntruprime_core_invsntrup953_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 512;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(h2,h,hlen);
      input_prepare(n2,n,nlen);
      input_prepare(k2,k,klen);
      input_prepare(c2,c,clen);
      secret(n,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(h,n,k,c);
      public(n,nlen);
      public(k,klen);
      public(c,clen);
      public(h,hlen);
      checksum(h,hlen);
      output_compare(h2,h,hlen,"crypto_core");
      input_compare(n2,n,nlen,"crypto_core");
      input_compare(k2,k,klen,"crypto_core");
      input_compare(c2,c,clen,"crypto_core");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k2,klen);
      secret(c2,clen);
      crypto_core(h2,n2,k2,c2);
      public(n2,nlen);
      public(k2,klen);
      public(c2,clen);
      public(h2,hlen);
      if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_core is nondeterministic\n");
    }
    checksum_expected(core_invsntrup953_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_core_invsntrup953_NUM;++precomp) {
    output_prepare(h2,h,crypto_core_OUTPUTBYTES);
    input_prepare(n2,n,crypto_core_INPUTBYTES);
    memcpy(n,precomputed_core_invsntrup953_n[precomp],crypto_core_INPUTBYTES);
    memcpy(n2,precomputed_core_invsntrup953_n[precomp],crypto_core_INPUTBYTES);
    input_prepare(k2,k,crypto_core_KEYBYTES);
    memcpy(k,precomputed_core_invsntrup953_k[precomp],crypto_core_KEYBYTES);
    memcpy(k2,precomputed_core_invsntrup953_k[precomp],crypto_core_KEYBYTES);
    input_prepare(c2,c,crypto_core_CONSTBYTES);
    memcpy(c,precomputed_core_invsntrup953_c[precomp],crypto_core_CONSTBYTES);
    memcpy(c2,precomputed_core_invsntrup953_c[precomp],crypto_core_CONSTBYTES);
    crypto_core(h,n,k,c);
    if (memcmp(h,precomputed_core_invsntrup953_h[precomp],crypto_core_OUTPUTBYTES)) {
      fail("failure: crypto_core fails precomputed test vectors\n");
      printf("expected h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",((unsigned char *) precomputed_core_invsntrup953_h[precomp])[pos]);
      printf("\n");
      printf("received h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",h[pos]);
      printf("\n");
    }
    output_compare(h2,h,crypto_core_OUTPUTBYTES,"crypto_core");
    input_compare(n2,n,crypto_core_INPUTBYTES,"crypto_core");
    input_compare(k2,k,crypto_core_KEYBYTES,"crypto_core");
    input_compare(c2,c,crypto_core_CONSTBYTES,"crypto_core");
  }
}

void test_core_invsntrup953(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"invsntrup953")) return;
  storage_core_invsntrup953_h = callocplus(crypto_core_OUTPUTBYTES);
  test_core_invsntrup953_h = aligned(storage_core_invsntrup953_h,crypto_core_OUTPUTBYTES);
  if (crypto_core_OUTPUTBYTES > maxalloc) maxalloc = crypto_core_OUTPUTBYTES;
  storage_core_invsntrup953_n = callocplus(crypto_core_INPUTBYTES);
  test_core_invsntrup953_n = aligned(storage_core_invsntrup953_n,crypto_core_INPUTBYTES);
  if (crypto_core_INPUTBYTES > maxalloc) maxalloc = crypto_core_INPUTBYTES;
  storage_core_invsntrup953_k = callocplus(crypto_core_KEYBYTES);
  test_core_invsntrup953_k = aligned(storage_core_invsntrup953_k,crypto_core_KEYBYTES);
  if (crypto_core_KEYBYTES > maxalloc) maxalloc = crypto_core_KEYBYTES;
  storage_core_invsntrup953_c = callocplus(crypto_core_CONSTBYTES);
  test_core_invsntrup953_c = aligned(storage_core_invsntrup953_c,crypto_core_CONSTBYTES);
  if (crypto_core_CONSTBYTES > maxalloc) maxalloc = crypto_core_CONSTBYTES;
  storage_core_invsntrup953_h2 = callocplus(maxalloc);
  test_core_invsntrup953_h2 = aligned(storage_core_invsntrup953_h2,crypto_core_OUTPUTBYTES);
  storage_core_invsntrup953_n2 = callocplus(maxalloc);
  test_core_invsntrup953_n2 = aligned(storage_core_invsntrup953_n2,crypto_core_INPUTBYTES);
  storage_core_invsntrup953_k2 = callocplus(maxalloc);
  test_core_invsntrup953_k2 = aligned(storage_core_invsntrup953_k2,crypto_core_KEYBYTES);
  storage_core_invsntrup953_c2 = callocplus(maxalloc);
  test_core_invsntrup953_c2 = aligned(storage_core_invsntrup953_c2,crypto_core_CONSTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("core_invsntrup953 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_core_invsntrup953();++impl)
      forked(test_core_invsntrup953_impl,impl);
    ++test_core_invsntrup953_h;
    ++test_core_invsntrup953_n;
    ++test_core_invsntrup953_k;
    ++test_core_invsntrup953_c;
    ++test_core_invsntrup953_h2;
    ++test_core_invsntrup953_n2;
    ++test_core_invsntrup953_k2;
    ++test_core_invsntrup953_c2;
  }
  free(storage_core_invsntrup953_c2);
  free(storage_core_invsntrup953_k2);
  free(storage_core_invsntrup953_n2);
  free(storage_core_invsntrup953_h2);
  free(storage_core_invsntrup953_c);
  free(storage_core_invsntrup953_k);
  free(storage_core_invsntrup953_n);
  free(storage_core_invsntrup953_h);
}
#undef crypto_core_OUTPUTBYTES
#undef crypto_core_INPUTBYTES
#undef crypto_core_KEYBYTES
#undef crypto_core_CONSTBYTES

