/*
 * @(#)AsmblTransitionUTest.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.mbtf.v1.assembler;

import org.easymock.EasyMock;
import org.easymock.MockControl;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import net.sourceforge.groboutils.mbtf.v1.ITransition;
import net.sourceforge.groboutils.mbtf.v1.IValidate;
import net.sourceforge.groboutils.mbtf.v1.ISystem;
import net.sourceforge.groboutils.mbtf.v1.IErrors;
import net.sourceforge.groboutils.mbtf.v1.IAction;

/**
 * Tests the AsmblTransition class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2003/02/10 22:52:28 $
 * @since     June 17, 2002
 */
public class AsmblTransitionUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = AsmblTransitionUTest.class;
    
    public AsmblTransitionUTest( String name )
    {
        super( name );
    }

    
    //-------------------------------------------------------------------------
    // setup

    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }


    //-------------------------------------------------------------------------
    // Tests
    
    
    public void testConstructor1()
    {
        new AsmblTransition();
    }
    
    
    public void testAddValidate1()
    {
        AsmblTransition at = new AsmblTransition();
        at.addValidate( null );
        IValidate[] v = at.getValidates();
        assertNotNull(
            "validates returned null.",
            v );
        assertEquals(
            "validates size not right.",
            0,
            v.length );
    }
    
    
    private static class MyValidate implements IValidate
    {
        public void validate( ISystem s, IErrors e ) {}
    }
    
    
    private static class MyAction implements IAction
    {
        public void performAction( ISystem s, IErrors e ) {}
    }
    
    
    public void testAddValidate2()
    {
        IValidate ov = new MyValidate();
        AsmblTransition at = new AsmblTransition();
        at.addValidate( ov );
        IValidate[] v = at.getValidates();
        assertNotNull(
            "validates returned null.",
            v );
        assertEquals(
            "validates size not right.",
            1,
            v.length );
        assertEquals(
            "validates inserted not returned.",
            ov,
            v[0] );
    }
    
    
    public void testGetTransition1()
    {
        AsmblTransition at = new AsmblTransition();
        try
        {
            at.getTransition();
            fail("did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException iae)
        {
            // test exception
        }
    }
    
    
    public void testGetTransition2()
    {
        AsmblTransition at = new AsmblTransition();
        at.setName( "trans" );
        at.setNextStateName( "state" );
        IAction act = new MyAction();
        at.setAction( act );
        ITransition t = at.getTransition();
        assertNotNull(
            "get transition returned null.",
            t );
        assertEquals(
            "wrong name.",
            "trans",
            t.getName() );
        assertEquals(
            "wrong action.",
            act,
            t.getAction() );
        
        try
        {
            t.getDestinationState();
            fail("did not throw IllegalStateException");
        }
        catch (IllegalStateException e)
        {
            // test exception
        }
    }
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        TestSuite suite = new TestSuite( THIS_CLASS );
        
        // Test the implementation's interface conformity.
        /*
        suite.addTest( IxUTestI.suite(
            new ImplementationCreator[] {
                new ImplementationCreator() {
                    public Object createImplementedObject() {
                        // XXXXXXXXXXXXXXXXXXXXXXXX
                    }
                },
            } ) );
        */
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        super.tearDown();
    }
}

