/*
 *  @(#)DefaultAttribute.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.pmti.v1.defimpl;

import net.sourceforge.groboutils.pmti.v1.IAttribute;
import net.sourceforge.groboutils.pmti.v1.IAttributeInfo;


/**
 * A simple name-value association for a specific kind of issue attribute.
 * All implementations of <tt>IAttribute</tt> are immutable, unless they also
 * implement <tt>IEditableAttribute</tt>.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version    $Date: 2003/02/10 22:51:58 $
 * @since      July 12, 2002
 */
public class DefaultAttribute implements IAttribute
{
    private Object value;
    private IAttributeInfo info;
    
    
    public DefaultAttribute( Object v, IAttributeInfo i )
    {
        if (i == null)
        {
            throw new IllegalArgumentException("no null arguments");
        }
        this.value = v;
        this.info = i;
    }
    
    
    
    /**
     * Returns the value for this attribute.
     */
    public Object getValue()
    {
        return this.value;
    }
    
    
    /**
     * Returns the meta-information for this attribute.
     */
    public IAttributeInfo getInfo()
    {
        return this.info;
    }
}

