#! /bin/bash

if [ -z $1 ]; then
    echo "You must specify the project as argument 1."
    exit 1
fi

_HERE=`dirname $0`
echo "_HERE = $_HERE"
if [ -z $_HERE -o "$_HERE" = "." ]; then
    _HERE=`pwd`
fi

if [ ! -f "$_HERE/$1/build.xml" ]; then
    echo "$1 is not a known/valid project."
    exit 1
fi

_PROJECT="$_HERE/$1"
shift
_ARGS="$*"

# OS specific support.  $var _must_ be set to either true or false.
case "`uname`" in
  CYGWIN*) _PROJECT=`cygpath --windows "$_PROJECT"` ;;
esac

if [ ! -f $_HERE/make.sh ]; then
	echo "Bad directory?"
	$_HERE=`dirname $_HERE/make.sh`
fi

. $_HERE/make.sh -f "$_PROJECT/build.xml" "-Dbasedir=$_PROJECT" $_ARGS
