/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.http;

import java.io.IOException;
import java.io.InputStream;

/**
 * Contains the contents of an HTTP response message.
 * In RFC 2616 terms, this object represents data found in the
 * <code>Response</code> body.
 */
public class ClientResponse
	extends Response
{

	InputStream is;

	/**
	 * Package-private constructor
	 */
	ClientResponse() {
    }

	/**
	 * Constructs a <code>ClientResponseImpl</code> by parsing an input stream.
	 */
	public ClientResponse(InputStream is)
		throws IOException
	{
		String line;
		do {
			line = HttpUtil.readHttpLine(is);
		} while (line.length() == 0);
		this.statusLine = StatusLine.parseStatusLine(line);
		this.headers = MessageHeaders.readHeaders(is);
		this.is = is;
	}

	/**
	 * Returns a stream for reading data from the HTTP server.
	 */
	public InputStream getInputStream() {
		return is;
	}

	/**
	 * Reads a response's input stream until EOF.
	 * Returns the number of bytes read.
	 * If the server indicates the connection was closed, does nothing.
	 */
	public int readFully()
		throws IOException
	{
		InputStream s = HttpUtil.wrapInputStream(getInputStream(), getHeaders());
		if (s != null) {
			boolean close = getHeaders().contains(MessageHeader.MH_CONNECTION_CLOSE);
			if (!close)
				return HttpUtil.readFully(s);
		}
		return 0;
	}

	/**
	 * Returns a debug string showing the response information contained
	 * within.
	 */
	public String toString() {
		return super.toString() + " is=" + is;
	}

}
