/***************************************************************************
                          cthread.h  -  description
                             -------------------
    begin                : Sun Sep 30 2001
    copyright            : (C) 2001-2004 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CTHREAD_H
#define CTHREAD_H

/**
  *@author Mathias Küster
  *
  * Threading in dclib: there isn't really any. Almost everything
  * runs on CManager's thread, there is a thread permanently waiting
  * to do DNS lookups, and a thread is started for filelist refresh
  * and to send public hubs data to CConfig.
  *
  * CConnection inherits CThread, so all hub, peer and http connections
  * are threads, but none are started, all their Thread() functions
  * get called by CConnectionManager, CDownloadManager or CManager
  * directly.
  *
  * This explains the unusual design of this class, the Thread()
  * virtual function (or the callback) is called repeatedly until
  * someone calls Stop(), to use it like a normal thread class
  * call Stop(false) at the end of your Thread() function.
  *
  * The Stop() function of course, does not halt the thread, just
  * stops the Thread() function being called again. It does however
  * wait for the thread to finish before returning unless you
  * call Stop(false). But it will not wait for a thread that has already
  * had Stop() called but hasn't finished running yet.
  */

#ifndef WIN32
#include <pthread.h>
#endif

#include <dclib/dcos.h>
#include <dclib/core/cmutex.h>

class _CCallback0;

class CThread : public CMutex {
public:
	/** */
	CThread();
	/** */
	virtual ~CThread();

	/** */
	int Start();
	/** */
	int Stop( bool bHard = true );
	/** */
	bool Stopped() const;
	/**
	 * To avoid changing Stop() this just does
	 * pthread_join, i.e. it makes the calling thread
	 * wait forever until the thread finishes.
	 *
	 * Returns true if pthread_join() returns 0 i.e.
	 * was successful.
	 *
	 * If the thread isn't running according to iRun
	 * pthread_join() is not called and false is returned.
	 */
	bool Join();

	/** */
	static void NanoSleep( unsigned long );
	/** */
	void SetThreadCallBackFunction( _CCallback0 * callback );

	/** */
	virtual void Thread() {};


protected:
	/** */
	int iRun;

private:
	/** callback function */
	_CCallback0 * _thread_callback_function;
#ifdef WIN32
	/** */
	HANDLE thread;
#else
	/** */
	pthread_t thread;
#endif
	/** */
	int iStop;
	/** */
#ifdef WIN32
	static unsigned int __stdcall MainThread( void * object );
#else
	static void * MainThread(void *object);
#endif
};

/** */
inline bool CThread::Stopped() const
{ return (iStop==1); }

#endif
