<?php
/*
# Copyright 2004, Revolution Linux Inc., Nicolas Dufresne
#
# This file is part of the MILLE-XTERM distribution.
# See the MILLE-XTERM (english) and/or the MILLE (french) project web site
#
# http://www.revolutionlinux.com/mille-xterm/
# http://www.mille.ca/
#
# The MILLE-XTERM framework is covered by the GNU General Public License. See
# the COPYING file in the top-level MILLE-XTERM directory. Software packages
# that are included in the MILLE-XTERM distribution have their own licenses.
#
# -------------------------------------------------------------------------
*/
	/*
	* This MILLE-XTERM Configurateur functions library.
	* Author: Nicolas Dufresne
	* Last Modification:
	* 		07 jul 2004 Nicolas Dufresnes <nicolas@revolutionlinux.com>
	*		- Creation
	*/

	///////////////////////////////////////////////////////////////////
	// Including files
	///////////////////////////////////////////////////////////////////
	global $first_start;
	require_once 'config.php';
	require_once 'text-en.php';
	require_once 'entityRole-config.php';
	require_once 'roles-config.php';
	require_once 'LogsViewer.php';
	if (!$first_start) {
		include "config.php";
		if (isset($CONFIG['lang']) && $CONFIG['lang'] != 'en') {
			if (is_readable("util/text-".$CONFIG['lang'].".php")) include 'text-'.$CONFIG['lang'].'.php';
			else $ERRORS[] = getMessage('no_language_file');
		}
	}

	/**
	* Return the _GET list in URL format
	*
	* This function is used to send again all GEt parameter.
	*
	* @param char Used to divide parameters (default &)
	*/
	function getGETParam($separator = '&') {
		$parameters = NULL;
		foreach ($_GET as $key => $value) {
			if ($parameters) $parameters .= $separator;
			$parameters .= $key.'='.$value;
		}
		return $parameters;
	}

	/**
	* Function that redirect to a other page
	*
	* This function redirect to the chosen page.  As default it
	* redirect to the root with all preceeding GET parameters.
	*
	* @param string PHP filename and path to redirect to (default "")
	* @param bool Tel if GET paramters will be send (default true)
	*/
	function ltsp_goto($page = "",$send_param = true) {
		global $CONFIG;
		$param = NULL;
		if ($send_param) {
			if ($_SESSION['auth_state'] &&  !ereg('PHPSESSID=',getGETParam())) {
				if (getGETParam()) $param .= '&';
			}
			if (getGETParam()) $param .= getGETParam();
			if ($param) $param = '?'.$param;
		}
		if($_SERVER['HTTP_X_FORWARDED_HOST'])
			$prefix=$_SERVER['HTTP_X_FORWARDED_HOST'];
		else
			$prefix=$_SERVER['HTTP_HOST'];
		if($CONFIG["use_https"]=="false"){
			header("Location: http://".$prefix.ereg_replace('/[^/]*\.php$','/',$_SERVER['PHP_SELF']).$page.$param);
		}else{
			header("Location: https://".$prefix.ereg_replace('/[^/]*\.php$','/',$_SERVER['PHP_SELF']).$page.$param);
		}

	}

	/**
	* Redirect to https socket if needed
	*
	* This function test if the connection with browser uses secure
	* HTTPS socket.  If not it redirects to https with all the same
	* GET parameters.
	*/
	function use_https() {
		if ($_SERVER['HTTPS'] != 'on') {
			if ($param = getGETParam()) $param = '?'.$param;
			header("Location: https://".$_SERVER['SERVER_NAME'].$_SERVER['PHP_SELF'].$param);
			return false;
		}
		return true;
	}

	/**
	* Prints HTML header with a custum title message.
	*
	* This function prints a HTML header to the page.  It sets a custum title and
	* define charset from the configuration file.
	*
	* @param string HTML page title
	*/
	function printHead($title_message) {
		global $CONFIG;
		// Printing license
?>
<!--
# Copyright 2004, Revolution Linux Inc., Nicolas Dufresne
#
# This file is part of the MILLE-XTERM distribution.
# See the MILLE-XTERM (english) and/or the MILLE (french) project web site
#
# http://www.revolutionlinux.com/mille-xterm/
# http://www.mille.ca/
#
# The MILLE-XTERM framework is covered by the GNU General Public License. See
# the COPYING file in the top-level MILLE-XTERM directory. Software packages
# that are included in the MILLE-XTERM distribution have their own licenses.
#
# -------------------------------------------------------------------------
-->
<?php

		// Checking for caracter mapping setting, defaulting to UTF-8
		if (isset($CONFIG['charset'])) $charset = $CONFIG['charset'];
		else $charset = "UTF-8";
		print '<html>'."\n";
		print '<head>'."\n";
		print '<meta http-equiv="content-type" content="text/html; charset='.$charset.'">'."\n";
		print '<link rel="stylesheet" href="css/style.css" type="text/css" />';
		print '<title>'."\n";
		print getMessage($title_message)."\n";
		print '</title>'."\n";
		print '</head>'."\n";
		print '<body>'."\n";
	}

	/**
	* Returns a message using language configuration
	*
	* This function is an abstration layer to the multilangual support.
	* It takes message name and obtain the good string from messages
	* table.  If the string doesn not exist it return the default message.
	*
	* @param string Message name
	*/
	function getMessage($messageName) {
		global $MESSAGES;
		global $CONFIG;

		// Try configured language
		if (isset($MESSAGES[$messageName][$CONFIG['lang']])) {
			return $MESSAGES[$messageName][$CONFIG['lang']];
		}
		// Try default language
		elseif (isset($MESSAGES[$messageName]['en'])) {
			return 	$MESSAGES[$messageName]['en'];
		}
		// When not defined
		else return $messageName.": ".getMessage('messages_error');
	}

	/**
	* Returns true if message is available
	*
	* This function check if a message is define.
	*
	* @param string Message name
	* @return bool True if message exist
	*/
	function isMessage($messageName) {
		global $MESSAGES;
		global $CONFIG;

		// Try configured language
		if (isset($MESSAGES[$messageName][$CONFIG['lang']])) {
			return true;
		}
		// Try default language
		elseif (isset($MESSAGES[$messageName]['en'])) {
			return true;
		}
		// When not defined
		else return false;
	}
	/**
	* Check if the user has an authenticated session on server.
	*
	* This function start a session and check if it is a valide session.
	* If not it cleans the session and return false.
	*/
	if (!$first_start) {
		function isSession() {
			session_start();
			if (!$_SESSION['auth_state']) {
				ltsp_goto();
				session_unset();
				session_destroy();
			}
			return true;
		}
	}

	/**
	* This function return the absolute inclide path
	*
	* This function return the absolute path of the libraries.
	* It adds possibility for other applications to link against
	* the Admin libraries.
	*
	* @return string Absolute libraries path
	*/
	function basePath() {
		return realpath(dirname(__File__)."/../")."/";
	}

	/**
	 * This function get the userRole.
	 *
	 * The role must be in permisssion order. The first role define must be the
	 * admin role. This is for the case with a user with more than 1 group.
	 */
	 function getUserRole($userData){
	 	global $ROLE,$GROUP_ROLE;
	 	$isUserRoleSet = false;
		foreach ($ROLE as $roleName=>$role) {
			foreach($userData->getGroups() as $group=>$groupName){
				if(strtolower($GROUP_ROLE[$groupName]) == strtolower($roleName)){
					$userRole = $roleName;
					$isUserRoleSet = true;
					break;
				}
			}
			if($isUserRoleSet){
			  break;
			}
		}
		return $userRole;
	 }
	/**
	 * This function log operation on attributes and nodes (add, delete, modify, etc)
	 */
	function logAdminAccess($operation) {
	    $conf = array('mode' => 0666, 'timeFormat' => '%x %X');
	    #$adminAccessLog = new LogsViewer('file', 'Log/admin_access.log', 'ident', $conf);

	    $line = ',';
	    foreach ($operation as $key=>$value) {
	        $line .= "$value,";
	    }
	    $sessionData  = $_SESSION['groups'];
	    $line .= $sessionData->getUsername();
	    #$adminAccessLog->log($line);
	}
	/**
	 * Check ldap connection
	 */
	function setLdapAuth(){
		// Testing ldap
		$auth = new Auth($_POST['login'],$_POST['password']);
		$error = $auth->authenticate();
		unset($CONFIG['login']);
		unset($CONFIG['password']);
		return $error;
	}
	/**
        * This function is  from AttributeManager but since it will be 
	 * useful elsewhere, it was ported here.
	 *
	 * Return the value of an value if it exists in the lang file
	 */
	function getValueMessage($attributeName, $value) {
		if (isMessage($attributeName."_".$value)) {
			return getMessage($attributeName."_".$value);
		}
		return $value;
	}
	function getNameMessage($attrName,$putSign = false) {
		if (isMessage($attrName)) {
			return getMessage($attrName);
		} else {
		if ($putSign) $equalSign = " = ";
			else $equalSign = "";
			return $attrName.$equalSign;
		}
	}
	/**
	 * Those are used to sort attributes by their name in the right langage
	 */
	function sortAttributesByLangName( $attA, $attB ){
		return strcasecmp(getNameMessage( $attA ), getNameMessage( $attB ));
	}
	function sortObjectsByLangName( $attA, $attB ){
		return strcasecmp(getNameMessage( $attA->getName() ), getNameMessage( $attB->getName() ));
	}
?>
