/*
 * Kylin-video
 *
 * Copyright (C) 2021, Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Liu Cong <liucong1@kylinos.cn>
 *
 */

#ifndef MESSAGEBOX_H
#define MESSAGEBOX_H

#include "dialog.h"

class QLabel;
class QVBoxLayout;
class QHBoxLayout;

namespace KylinUI {

#define TITLE_ICON_WIDTH 20
#define TEXT_ICON_WIDTH 22
#define WIDGET_WIDTH 380
#define WIDGET_HEIGHT 142

enum MessageType{
    INFORMATION,
    QUESTION,
    WARNING,
    ABOUT
};

/// 没写静态函数，调用接直接临时变量exec，有个确认取消，写静态太麻烦

class MessageBox : public Dialog
{
    Q_OBJECT
public:
    MessageBox(QString title, QString text, QWidget *parent = nullptr, MessageType type = INFORMATION);
    ~MessageBox();

private:
    MessageType msg_type;
    QLabel  *lab_titleIcon,
            *lab_title,
            *lab_text,
            *lab_textIcon;
    QPushButton *btn_ok,
                *btn_cancel;
    QVBoxLayout *box_v;
    QHBoxLayout *box_ht,
                *box_hm,
                *box_hb;

    void setData(QString title, QString text);
    void initLayout();
};
}


#endif // MESSAGEBOX_H
