#***************************************************************************
# *   Copyright (C) 2003-2006 by A Lynch                                    *
# *   aalynch@users.sourceforge.net                                         *
# *                                                                         *
# *   This program is free software; you can redistribute it and/or modify  *
# *   it under the terms of the GNU General Public License version 2 as published by  *
# *   the Free Software Foundation;                                         *
# *                                                                         *
# *   This program is distributed in the hope that it will be useful,       *
# *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
# *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
# *   GNU General Public License for more details.                          *
# *                                                                         *
# *   You should have received a copy of the GNU General Public License     *
# *   along with this program; if not, write to the                         *
# *   Free Software Foundation, Inc.,                                       *
# *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
# ***************************************************************************/

from PyQt4 import QtGui, QtCore

import sys

import equation
import node as nodemodule
from pdf import pdffactory
from configuration import config

import logging
l = logging.getLogger(__name__)

class NotebookEquationLabel(QtGui.QLabel):
    def __init__(self, parent, index, node, mainGui):
        QtGui.QLabel.__init__(self, parent)
        self.index = index
        self.node = node
        self.mainGui = mainGui

        self.setContextMenuPolicy(QtCore.Qt.CustomContextMenu)
        self.connect(self,QtCore.SIGNAL("customContextMenuRequested ( const QPoint &)"), self.showPopupMenu)
        self.contextMenu = QtGui.QMenu(self)
        self.contextMenu.addAction( self.mainGui.ui.actionIntegrate )
        self.contextMenu.addAction( self.mainGui.ui.actionDifferentiate )
        self.contextMenu.addAction( self.mainGui.ui.actionPlot )

    def showPopupMenu(self, point):
        self.contextMenu.popup(QtGui.QCursor.pos())

    def mousePressEvent(self, e):
        self.mainGui.currentObjIndex = self.index                                               
        self.mainGui.eqCellClicked(self.index)

    def mouseDoubleClickEvent(self, e):
        self.mainGui.eqCellDoubleClicked(self.index)

    def paintEvent(self, e):
        QtGui.QLabel.paintEvent(self, e)
        #painter = QtGui.QPainter(self)
        #painter.drawRect(0,0,self.size().width()-1,self.size().height()-1)

class NotebookIdLabel(QtGui.QLabel):
    def __init__(self, parent, id):
        QtGui.QLabel.__init__(self, parent)
        self.id = id

class NotebookGraphLabel(QtGui.QLabel):
    def __init__(self, parent, index, node):
        QtGui.QLabel.__init__(self, parent)
        self.index = index
        self.node = node

class NotebookTextEdit(QtGui.QTextEdit):
    def __init__(self, parent, index, node, mainGui):
        QtGui.QTextEdit.__init__(self, parent)
        self.index = index
        self.node = node
        self.mainGui = mainGui

        self.setAlignment(QtCore.Qt.AlignHCenter)
        self.setFrameStyle(QtGui.QFrame.NoFrame | QtGui.QFrame.Plain)

        self.setContextMenuPolicy(QtCore.Qt.CustomContextMenu)
        self.connect(self,QtCore.SIGNAL("customContextMenuRequested ( const QPoint &)"), self.showPopupMenu)
        self.contextMenu = QtGui.QMenu(self)
        #self.contextMenu.addAction( self.mainGui.ui.actionIntegrate )

    def showPopupMenu(self, point):
        self.contextMenu.popup(QtGui.QCursor.pos())

    def mousePressEvent(self, e):
        self.mainGui.currentObjIndex = self.index                                               

    def mouseDoubleClickEvent(self, e):
        pass

class Notebook(QtGui.QWidget):
    def __init__(self, control, mainGui, parent):
        QtGui.QWidget.__init__(self, parent)
        self.control = control
        self.mainGui = mainGui

        self.palt = self.palette()
        self.palt.setColor(QtGui.QPalette.Window, QtCore.Qt.white)
        self.setPalette(self.palt)

        self.spacing = 10
        self.textSpacing = 10
        self.idWidth = 110
        self.nextWidgetLocation = self.spacing
        self.setMinimumSize(300,300)

        self.drawObjects = []

        from qt4gui import qt4factory
        self.fontfactory = qt4factory.FontFactory()

    def drawId(self, id, y):
        idLabel = NotebookIdLabel(self, id)
        # remove the initial % sign
        if id[0] == '%':
            id = id[1:]
        # make a pixmap of the id string with a rounded rectangle around it
        font = self.fontfactory.makeFont()
        font.setFamily(config["tablefont"])
        font.setPointSize(config["tablefontsize"])
        metrics = self.fontfactory.getFontMetrics(font)
        size = metrics.boundingRect(id)
        w = size.width()
        h = size.height()
        image = QtGui.QImage(QtCore.QSize(w+10, h+10),QtGui.QImage.Format_RGB32)
        from qt4gui import qt4factory
        painter = qt4factory.Painter(image)
        painter.setRenderHint(QtGui.QPainter.Antialiasing)
        pen = painter.pen()
        pen.setWidth(1)
        painter.setPen(pen)
        painter.eraseRect(0,0,w+10,h+10)
        painter.drawRoundRect(0,0,w+8,h+5,50,50)
        painter.setFont(font)
        painter.drawText(5,h,id)
        painter.end()
        idLabel.setPixmap(QtGui.QPixmap.fromImage(image))
        idLabel.move(self.idWidth/2.0 - image.width()/2.0, y)
        idLabel.show()
        self.drawObjects.append(idLabel)

    def addRow(self, index, id, io):
        l.debug("add notebook row %s" % index)
        # calculate the contents of this row and cache them as an image
        self.resize(self.parentWidget().width(), self.nextWidgetLocation)
        content = equation.DrawObject.drawobjects[index]
        content.io = io
        node = content.node
        image = None
        notepadWidth = self.width() - self.idWidth
        if id:
            self.drawId(id, self.nextWidgetLocation)
        if isinstance(content, equation.Equation):
            if content.textOnly == False:
                try:
                    image = self.getImage(node, notepadWidth)
                    content.notepadImage = image
                    equationLabel = NotebookEquationLabel(self, index, node, self.mainGui)
                    equationLabel.setPixmap(QtGui.QPixmap.fromImage(image))
                    equationLabel.resize(image.size())
                    x, y = notepadWidth/2.0 - equationLabel.size().width()/2.0 + self.idWidth, self.nextWidgetLocation
                    l.debug("equation size is %s %s" % (equationLabel.size().width(),equationLabel.size().height()))
                    content.notepadLocation = (x,y)
                    equationLabel.move(x, y)
                    equationLabel.show()
                    self.drawObjects.append(equationLabel)
                    self.nextWidgetLocation += self.spacing + equationLabel.size().height()
                    #l.debug("next widget location is %s" % self.nextWidgetLocation)
                    self.resize(self.parentWidget().width(), self.nextWidgetLocation+50)
                    #l.debug("new size is %s %s" % (self.size().width(), self.size().height()))
                except:
                    l.exception("adding notebook row")
            else:
                l.debug("text only equation")
        elif isinstance(content, equation.Text):
            l.debug("eq.Text")
            textEdit = NotebookTextEdit(self, index, node, self.mainGui)
            font = textEdit.font()
            font.setPointSize(config["tablefontsize"])
            textEdit.setCurrentFont(font)
            textEdit.insertPlainText(content.text)
            textEdit.resize(notepadWidth*0.8,50)
            x, y = notepadWidth/2.0 - textEdit.size().width()/2.0 + self.idWidth, self.nextWidgetLocation
            l.debug("text edit size is %s %s" % (textEdit.size().width(),textEdit.size().height()))
            content.notepadLocation = (x,y)
            textEdit.move(x, y)
            textEdit.show()
            self.drawObjects.append(textEdit)
            self.nextWidgetLocation += self.textSpacing + textEdit.size().height()
            self.resize(self.parentWidget().width(), self.nextWidgetLocation+50)
        elif isinstance(content, equation.Graph):
            l.debug("eq.Graph")
            graphLabel = NotebookGraphLabel(self, index, node)
            l.debug("pixthumb is " + repr(content.pixthumb))
            graphLabel.setPixmap(content.pixthumb)
            x, y = notepadWidth/2.0 - content.pixthumb.size().width()/2.0 + self.idWidth, self.nextWidgetLocation
            graphLabel.move(x,y)
            graphLabel.show()
            self.nextWidgetLocation += self.textSpacing + graphLabel.size().height()
            self.resize(self.parentWidget().width(), self.nextWidgetLocation+50)

    def getImage(self,node, width):
        from qt4gui import qt4factory
        try:
            nodes = node.layoutNode(0,0,width, config["tablefont"], config["tablefontsize"])
        except:
            l.exception("laying out node")
        verticalGap = 20
        h = 0
        w = 0
        for node in nodes:
            if node.w > w:
                w = node.w
            h += node.h + verticalGap
        w += 1
        h += 1

        l.debug("set pixmap size to %s %s" % (w,h))
        image = QtGui.QImage(QtCore.QSize(w, h),QtGui.QImage.Format_RGB32)
#        dpm = 5000
#        image.setDotsPerMeterX(dpm)
#        image.setDotsPerMeterY(dpm)
        painter = qt4factory.Painter(image)
        painter.eraseRect(0,0,w,h)
        painter.end()
        self.drawNodesToDevice(nodes, w, h, image, verticalGap)
        return image

    def drawNodesToDevice(self, nodes, w, h, device, verticalGap):
        from qt4gui import qt4factory
        try:
            y = 0
            for node in nodes:
                y += node.h - node.operatorcentreline
                painter = qt4factory.Painter(device)
                node.setTextPosition((w - node.w)/2.0,y)
                node.drawNode(painter)
                painter.end()
                y += node.operatorcentreline  + verticalGap
        except:
            l.exception("drawing node")
            return None

