/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.dom.html;

import java.util.Locale;
import org.jaxen.Navigator;
import org.jaxen.XPath;
import org.jaxen.dom.html.HTMLXPath;
import org.jaxen.saxpath.SAXPathException;
import org.w3c.dom.Node;

public class DocumentNavigator
extends org.jaxen.dom.DocumentNavigator {
    private static final DocumentNavigator LOWERCASE = new DocumentNavigator(true);
    private static final DocumentNavigator UPPERCASE = new DocumentNavigator(false);
    private final boolean toLowerCase;

    public DocumentNavigator() {
        this(true);
    }

    public DocumentNavigator(boolean toLowerCase) {
        this.toLowerCase = toLowerCase;
    }

    public boolean isToLowerCase() {
        return this.toLowerCase;
    }

    public static Navigator getInstance(boolean toLowerCase) {
        if (toLowerCase) {
            return LOWERCASE;
        }
        return UPPERCASE;
    }

    public XPath parseXPath(String xpath) throws SAXPathException {
        return new HTMLXPath(xpath);
    }

    protected String getHTMLNodeName(Node node, String name) {
        if (name != null && !this.isXMLNode(node)) {
            name = this.toLowerCase ? name.toLowerCase(Locale.ENGLISH) : name.toUpperCase(Locale.ENGLISH);
        }
        return name;
    }

    public String getElementName(Object object) {
        return this.getHTMLNodeName((Node)object, super.getElementName(object));
    }

    public String getElementQName(Object object) {
        return this.getHTMLNodeName((Node)object, super.getElementQName(object));
    }

    private boolean isXMLNode(Node node) {
        return node != null && node.getNamespaceURI() != null;
    }
}

