/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.validation;

import java.util.Collection;
import java.util.Locale;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import net.sourceforge.stripes.validation.ScopedLocalizableError;
import net.sourceforge.stripes.validation.TypeConverter;
import net.sourceforge.stripes.validation.ValidationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailTypeConverter
implements TypeConverter<String> {
    @Override
    public void setLocale(Locale locale) {
    }

    @Override
    public String convert(String input, Class<? extends String> targetType, Collection<ValidationError> errors) {
        String result = null;
        try {
            InternetAddress address = new InternetAddress(input);
            result = address.getAddress();
            if (!result.contains("@")) {
                result = null;
                throw new AddressException();
            }
        }
        catch (AddressException ae) {
            errors.add(new ScopedLocalizableError("converter.email", "invalidEmail", new Object[0]));
        }
        return result;
    }
}

