<?php

//    showlink.php
//    Shows the info regarding a link
//
//    Part of the ht://Check package
//
//    Copyright (c) 1999-2004 Comune di Prato - Prato - Italy
//    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
//
//    For copyright details, see the file COPYING in your distribution
//    or the GNU General Public License version 2 or later 
//    <http://www.gnu.org/copyleft/gpl.html>
//
//    $Id: showlink.php,v 1.26 2003/12/30 09:39:23 angusgb Exp $

///////
   //    Global settings
///////

include ("./include/global.inc.php");


if (!isset($dbname))
{
   // Error
   DisplayErrMsg($strErrorNoDBSelected);
   echo "<a href=\"index.php\">" . $strMainPage . "</A>";
   die;
}
else
{
   eval("\$strhome = \"$strDBHome \";");
   if (!isset($IDUrl) || !isset($TagPosition) || !isset($AttrPosition))
   {
      // Error
      DisplayErrMsg($strMissingInfo);
      echo "<a href=\"index.php?dbname=". $dbname . "\">". $strhome."</A>";
      die;
   }

   $strSQL = "Select Schedule.Url as DestUrl, SrcUrl.Url as SourceUrl," .
      " Schedule.Status, Link.IDUrlSrc, Link.IDUrlDest," .
      " Link.LinkType, LinkResult, LinkDomain, Link.Anchor, " .
      " Url.Url, Url.StatusCode, Url.ReasonPhrase, Url.ContentType," . 
      " HtmlStatement.Statement, HtmlStatement.Row," .
      " HtmlAttribute.Attribute, HtmlAttribute.Content" .
      " from Url AS SrcUrl, Schedule, Link, HtmlStatement, HtmlAttribute" .
      " LEFT JOIN Url ON Url.IDUrl=Link.IDUrlDest " .
      " WHERE Link.IDUrlSrc=" . $IDUrl . " AND " .
      " Link.TagPosition=" . $TagPosition . " AND " .
      " Link.AttrPosition=" . $AttrPosition . " AND " .
      " SrcUrl.IDUrl=Link.IDUrlSrc AND " .
      " HtmlStatement.IDUrl=" . $IDUrl . " AND " .
      " HtmlAttribute.IDUrl=" . $IDUrl . " AND " .
      " HtmlStatement.TagPosition=Link.TagPosition AND " .
      " HtmlAttribute.TagPosition=Link.TagPosition AND " .
      " HtmlAttribute.AttrPosition=Link.AttrPosition AND " .
      " Schedule.IDUrl=Link.IDUrlDest";

      $result=$MyDB->Query($dbname, $strSQL);
   
   if ($result)
   {
      DisplayErrMsg($MyDB->errmsg);
      die;
   }
   
   if (! $num=$MyDB->NumRows())
   {
      DisplayErrMsg($strNoOccurrencies);
      die;
   }

   // Information retrieved
   $link = $MyDB->FetchArray();
   $URLName = $link["SourceUrl"];
   $DestLink = $link["DestUrl"];
   $ShowURLName = GetURL($URLName);
   $ShowDestLink = GetURL($DestLink);

   if (strlen($link["Anchor"]))
   {
      $DestLink .= "#" . $link["Anchor"];
      $ShowDestLink .= "#" . $link["Anchor"];
   }

   $pagetitle = "Database: $dbname - " . $strShowLink . ": " . $URLName;
   $linkbar = "<a href=\"index.php?dbname=". $dbname . "\">". $strhome ."</A>";
   $linkbar = $linkbar . " | " .
      "<a href=\"javascript:history.go(-1)\">" . $strBack . "</A>";

      
?>
<?php include ("./include/header.inc.php"); ?>
<?php

   // A database and a URL have been selected

?>
<div class="header">
<h4><?php echo $strShowLink; ?>:</h4>
</div>

<div class="content">
 <strong><?php echo $strReferencingUrl; ?></strong>: <a href="showurl.php?dbname=<?php echo $dbname; ?>&IDUrl=<?php echo $link["IDUrlSrc"]; ?>"><?php echo $ShowURLName; ?></A><br>
 <strong><?php echo $strReferencedUrl; ?></strong>: <a href="showurl.php?dbname=<?php echo $dbname; ?>&IDUrl=<?php echo $link["IDUrlDest"]; ?>"><?php echo $ShowDestLink; ?></A><br>
<?php
  if ($link["Anchor"])
  {
?>
 <strong><?php echo $strAnchor; ?></strong>: <?php echo WriteHTML($link["Anchor"]); ?><br>
<?php  
  }
?>
 <strong><?php echo $strRetrievingFlag; ?></strong>: <?php echo WriteHTML($link["Status"]); ?><br>
 <strong><?php echo $strLinkType; ?></strong>: <?php echo GetTextString($link["LinkType"]) ; ?><br>
 <strong><?php echo $strLinkResult; ?></strong>: <?php
   echo GetTextString($link["LinkResult"]); // Show text anyway

   if ($ShowIcons)
   {
?>
<IMG src="img/<?php echo $link["LinkResult"]; ?>.png" alt="<?php
   echo GetTextString($link["LinkResult"]); ?>"
   width="40" height="35" border=1" bordercolor="black"
   align="middle" hspace="5">
<?php
   }

?><br>
 <strong><?php echo $strLinkDomain; ?></strong>: <?php echo GetTextString($link["LinkDomain"]) ; ?><br>
</div>

<div class="header">
<h4><?php echo $strRetrievingInfo; ?></h4>
</div>

<div class="content">
<?php
   if ($link["StatusCode"])
   {
?>
 <strong><?php echo $strStatusCode; ?></strong>: <?php echo WriteHTML($link["StatusCode"]); ?> -
 <strong><?php echo $strReasonPhrase; ?></strong>: <?php echo WriteHTML($link["ReasonPhrase"]); ?> - 
 <strong><?php echo $strContentType; ?></strong>: <?php echo WriteHTML($link["ContentType"]); ?><br>
<?php
   }
   else
   {
?>
<strong><?php echo $strNotRetrieved; ?></strong><br>
<?php
   }

   $MyDB->Free();

   $strSQL = "Select IDUrl from Url WHERE IDUrl=" . $link['IDUrlSrc'] . ' AND Contents IS NOT NULL';

   $result=$MyDB->Query($dbname, $strSQL);
   
   if ($result)
   {
      DisplayErrMsg($MyDB->errmsg);
      die;
   }
   
   if ($num=$MyDB->NumRows())
      $DisplaySource = true;
   else
      $DisplaySource = false;

   $MyDB->Free();

?>
</div>

<div class="header">
<h4><?php echo $strLinkIssued; ?></h4>
</div>

<div class="content">
<strong><?php echo $strHTMLStatement; ?></strong>: &lt;<?php echo WriteHTML($link["Statement"]); ?>&gt;<br>
<strong><?php echo $strHTMLStatementRow; ?></strong>: <?php echo WriteHTML($link["Row"]); ?><br>
<strong><?php echo $strHTMLAttribute; ?></strong>: <?php echo WriteHTML($link["Attribute"]); ?>="<?php echo WriteHTML($link["Content"]); ?>"<br>
</div>

<div class="header">
<h4><?php echo $strOperations; ?></h4>
</div>

<div class="content">
<ul>
<li><a href="<?php echo $URLName; ?>" target="_blank"><?php echo $strOpenReferencingUrl; ?></A> (<?php echo $ShowURLName; ?>)</li>
<li><a href="<?php echo $DestLink; ?>" target="_blank"><?php echo $strOpenReferencedUrl; ?></A> (<?php echo $ShowDestLink; ?>)</li>
<?php
if ($DisplaySource)
{
?>
<li><a href="showsource.php?dbname=<?php echo $dbname; ?>&IDUrl=<?php echo $link["IDUrlSrc"]; ?>&RowNumber=<?php echo $link['Row']; ?>#<?php echo $link['Row']; ?>" target="_urlsource"><?php echo $strShowThisUrlSource; ?></A></li>
<?php
} 
?>
</ul>
</div>

<?php      

}

?>

<br>

<?php include ("./include/footer.inc.php"); ?>
