% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dirichlet.R
\name{dirichlet}
\alias{dirichlet}
\alias{rdirichlet}
\alias{ddirichlet}
\title{Functions for the Dirichlet Distribution}
\usage{
ddirichlet(x, alpha)

rdirichlet(n, alpha)
}
\arguments{
\item{x}{A vector containing a single random deviate or matrix containing one
random deviate per row.}

\item{alpha}{Vector or (for \code{ddirichlet}) matrix containing shape
parameters.}

\item{n}{Number of random vectors to generate.}
}
\value{
\code{ddirichlet} returns a vector containing the Dirichlet density
for the corresponding rows of \code{x}.

\code{rdirichlet} returns a matrix with \code{n} rows, each containing a
single Dirichlet random deviate.
}
\description{
Functions to compute the density of or generate random deviates from the
Dirichlet distribution
}
\details{
The Dirichlet distribution is the multidimensional generalization of the
beta distribution.  It is the canonical Bayesian distribution for the
parameter estimates of a multinomial distribution.
}
\section{Functions}{
\itemize{
\item \code{ddirichlet}: Dirichlet distribution function.

\item \code{rdirichlet}: Generate dirichlet random deviates.
}}

\examples{


x <- rdirichlet(20, c(1, 1, 1))

ddirichlet(x, c(1, 1, 1))
}
\seealso{
\code{\link{dbeta}}, \code{\link{rbeta}}
}
\author{
Code original posted by Ben Bolker to R-News on Fri Dec 15 2000. See
\url{https://stat.ethz.ch/pipermail/r-help/2000-December/009561.html}.  Ben
attributed the code to Ian Wilson \email{i.wilson@maths.abdn.ac.uk}.
Subsequent modifications by Gregory R. Warnes \email{greg@warnes.net}.
}
\keyword{distribution}
