// Code generated by smithy-go-codegen DO NOT EDIT.

package chimesdkmediapipelines

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/chimesdkmediapipelines/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Starts a voice tone analysis task. For more information about voice tone
// analysis, see [Using Amazon Chime SDK voice analytics]in the Amazon Chime SDK Developer Guide.
//
// Before starting any voice tone analysis tasks, you must provide all notices and
// obtain all consents from the speaker as required under applicable privacy and
// biometrics laws, and as required under the [AWS service terms]for the Amazon Chime SDK.
//
// [Using Amazon Chime SDK voice analytics]: https://docs.aws.amazon.com/chime-sdk/latest/dg/voice-analytics.html
// [AWS service terms]: https://aws.amazon.com/service-terms/
func (c *Client) StartVoiceToneAnalysisTask(ctx context.Context, params *StartVoiceToneAnalysisTaskInput, optFns ...func(*Options)) (*StartVoiceToneAnalysisTaskOutput, error) {
	if params == nil {
		params = &StartVoiceToneAnalysisTaskInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartVoiceToneAnalysisTask", params, optFns, c.addOperationStartVoiceToneAnalysisTaskMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartVoiceToneAnalysisTaskOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartVoiceToneAnalysisTaskInput struct {

	// The unique identifier of the resource to be updated. Valid values include the
	// ID and ARN of the media insights pipeline.
	//
	// This member is required.
	Identifier *string

	// The language code.
	//
	// This member is required.
	LanguageCode types.VoiceAnalyticsLanguageCode

	// The unique identifier for the client request. Use a different token for
	// different voice tone analysis tasks.
	ClientRequestToken *string

	// The task configuration for the Kinesis video stream source of the media
	// insights pipeline.
	KinesisVideoStreamSourceTaskConfiguration *types.KinesisVideoStreamSourceTaskConfiguration

	noSmithyDocumentSerde
}

type StartVoiceToneAnalysisTaskOutput struct {

	// The details of the voice tone analysis task.
	VoiceToneAnalysisTask *types.VoiceToneAnalysisTask

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartVoiceToneAnalysisTaskMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartVoiceToneAnalysisTask{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartVoiceToneAnalysisTask{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartVoiceToneAnalysisTask"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opStartVoiceToneAnalysisTaskMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpStartVoiceToneAnalysisTaskValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartVoiceToneAnalysisTask(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpStartVoiceToneAnalysisTask struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpStartVoiceToneAnalysisTask) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpStartVoiceToneAnalysisTask) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*StartVoiceToneAnalysisTaskInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *StartVoiceToneAnalysisTaskInput ")
	}

	if input.ClientRequestToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientRequestToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opStartVoiceToneAnalysisTaskMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpStartVoiceToneAnalysisTask{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opStartVoiceToneAnalysisTask(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartVoiceToneAnalysisTask",
	}
}
