---
title: Announcing dep v0.4.1 (with docs!)
author: sam boyer
authorURL: http://twitter.com/sdboyer
---

v0.4.1 of dep has been released - and along with it, this site for documentation and announcements about dep! And, being that it's been nearly six months since [the last dep status update](https://sdboyer.io/dep-status/2017-08-17/) (which are now officially discontinued, in favor of this blog), and the roadmap hasn't been substantially updated in even longer, we'll use this release as an excuse to bring a bunch of things up to speed.

_Note: there was [a significant omission](https://github.com/golang/dep/issues/1561) in v0.4.0's new pruning behavior, so we immediately shipped [v0.4.1](https://github.com/golang/dep/releases/tag/v0.4.1) with a fix._

### A new dep release!

After three months of work, the next version of dep is stable and ready for public use. The big headline changes are:

* `dep prune` no longer exists as a separate command. It has been absorbed into `dep ensure`, and its behavior can now be more granularly controlled by [directives in `Gopkg.toml`](https://golang.github.io/dep/docs/Gopkg.toml.html#prune). Calls to `dep prune` will not fail now, but will in future versions, so update your scripts!
* Support for govendor and glock have been added; `dep init` can now read their metadata files and attempt to automatically convert projects managed by those tools.

Additional information is available in [the release notes](https://github.com/golang/dep/releases/tag/v0.4.1). The other major addition is this documentation site!

### Docs docs docs

Dep has had a documentation problem for a while. Having a single-command interface helped us get by with having only an FAQ, but as time wore on, it became increasingly clear that we needed a comprehensive set of documentation if people were to really feel comfortable with the tool.

This site, which is automatically generated from the [docs directory](https://github.com/golang/dep/tree/master/docs) within the dep repository by [docusaurus](http://docusaurus.io/), is now that comprehensive source of docs. More so than any individual bit of information, it provides some broader benefits:

* New user guides - reference documentation is not what folks need when starting with a new tool. Step-by-step instructions are. Now [we have that](https://golang.github.io/dep/docs/introduction.html), and it caters to users who are not only new to dep, but also to Go in general.
* Thematic organization of content - up until now, we were somewhat haphazardly flinging information into the FAQ. The body of documentation here is organized from the ground up, which will hopefully make it both more useful and easier to maintain.
* Versioning - docusaurus is capable of snapshotting doc versions on each release, and users will be able to select the version of the docs they want to view (though we've not enabled this just quite yet). Ideally, everyone should always be able to use the latest version, but this at least means you're not penalized if that's not feasible for you/your organization.
* A blog - you're reading it! This is great, as it provides us a canonical place to circulate information about what's happening with the project.

At the same time, the docs aren't quite comprehensive _yet_. There's more reference material and guides to be written. For example, we're still missing a guide for project maintainers on how to make releases that align well with dep's happy path.

Also, now that we have this whole docs apparatus, it would be particularly awesome if someone were to step up to help as a [docs maintainer](https://github.com/golang/dep/issues/629#issuecomment-359922251)! (Also also, the CSS on this site is terrible, [please halp](https://github.com/golang/dep/issues/1558)!)

### The future

Right now, there's two aspects to the future of dep. One is the roadmap of changes and features that make sense for dep as it exists today, in this standalone context. The other is the roadmap for moving dep into the toolchain.

For the former, we have a fair bit of work underway that, now that this release is out the door, we can move on quickly. That includes major performance improvements, solver improvements to pick a sane version more of the time with less manual intervention, allowing the `source` field to work the way [most people expect it to](https://github.com/golang/dep/issues/860), and others. The goal is also to move dep towards a more regular release schedule.

With respect to dep's movement towards the toolchain, discussions have already been ongoing between dep folks and the Go team for months. Movement into the toolchain is not a simple process. Some rules that dep, as a standalone tool, had to accept as law, become negotiable (for example, the semantics of vendor directories). There's also the question of how to best fit dep's commands themselves into the `go` tool. These present both interesting design opportunities and considerable risk. More information and opportunities for comment will be coming as we move into the Go 1.10 cycle. As has always been the plan, though, dep will continue to exist as a standalone tool until the toolchain has evolved sufficiently to supplant it.
