/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * gnome-scan
 * Copyright (C) Étienne Bersac 2007 <bersace03@laposte.net>
 * 
 * gnome-scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with gnome-scan.  If not, write to:
 * 	The Free Software Foundation, Inc.,
 * 	51 Franklin Street, Fifth Floor
 * 	Boston, MA  02110-1301, USA.
 */

#include "gnome-scan-string-widget.h"

#define GET_PRIVATE(o)  (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_TYPE_SCAN_STRING_WIDGET, GnomeScanStringWidgetPrivate))

typedef struct _GnomeScanStringWidgetPrivate GnomeScanStringWidgetPrivate;
struct _GnomeScanStringWidgetPrivate
{
	GtkWidget *entry;
};

/* entry*/
static void gssw_activate (GtkEntry *entry, GnomeScanParamWidget *gspw);

GS_DEFINE_PARAM_WIDGET (GnomeScanStringWidget, gnome_scan_string_widget);

static void
gnome_scan_string_widget_init (GnomeScanStringWidget *object)
{
	/* TODO: Add initialization code here */
}

static void
gnome_scan_string_widget_finalize (GObject *object)
{
	/* TODO: Add deinitalization code here */

	G_OBJECT_CLASS (gnome_scan_string_widget_parent_class)->finalize (object);
}

static void
gnome_scan_string_widget_build (GnomeScanParamWidget *gspw)
{
	GnomeScanStringWidgetPrivate *priv = GET_PRIVATE (gspw);
	priv->entry = gtk_entry_new ();
	gtk_box_pack_start (GTK_BOX (gspw), priv->entry, TRUE, TRUE, 0);
	g_signal_connect (priv->entry, "activate",
					  (GCallback) gssw_activate,
					  gspw);
}

static void
gnome_scan_string_widget_set (GnomeScanParamWidget *gspw, GValue *value)
{
	gtk_entry_set_text (GTK_ENTRY (GET_PRIVATE (gspw)->entry),
						g_value_get_string (value));
}


static void
gssw_activate (GtkEntry *entry, GnomeScanParamWidget *gspw)
{
	g_value_set_string (gspw->value,
						g_strdup(gtk_entry_get_text (entry)));
	gnome_scan_param_widget_changed (gspw);
}
