#!/bin/sh

# Install build deps
pacman -S --noconfirm --needed \
	help2man \
	meson ninja \
        mingw-w64-x86_64-SDL2 \
        mingw-w64-x86_64-adwaita-icon-theme \
        mingw-w64-x86_64-aom \
        mingw-w64-x86_64-asciidoc \
        mingw-w64-x86_64-binutils \
        mingw-w64-x86_64-boost \
        mingw-w64-x86_64-brotli \
        mingw-w64-x86_64-bzip2 \
        mingw-w64-x86_64-c-ares \
        mingw-w64-x86_64-ca-certificates \
        mingw-w64-x86_64-cairo \
        mingw-w64-x86_64-ceres-solver \
        mingw-w64-x86_64-cppunit \
        mingw-w64-x86_64-crt-git \
        mingw-w64-x86_64-curl \
	mingw-w64-x86_64-diffutils \
        mingw-w64-x86_64-dav1d \
        mingw-w64-x86_64-docbook-xml \
        mingw-w64-x86_64-docbook-xsl \
        mingw-w64-x86_64-eigen3 \
        mingw-w64-x86_64-expat \
        mingw-w64-x86_64-ffmpeg \
        mingw-w64-x86_64-ffms2 \
        mingw-w64-x86_64-fontconfig \
        mingw-w64-x86_64-freeglut \
        mingw-w64-x86_64-freeimage \
        mingw-w64-x86_64-freetype \
        mingw-w64-x86_64-frei0r-plugins \
        mingw-w64-x86_64-fribidi \
        mingw-w64-x86_64-gavl \
        mingw-w64-x86_64-gcab \
        mingw-w64-x86_64-gcc \
        mingw-w64-x86_64-gcc-ada \
        mingw-w64-x86_64-gcc-fortran \
        mingw-w64-x86_64-gcc-libgfortran \
        mingw-w64-x86_64-gcc-libs \
        mingw-w64-x86_64-gcc-objc \
        mingw-w64-x86_64-gdb \
        mingw-w64-x86_64-gdb-multiarch \
        mingw-w64-x86_64-gdk-pixbuf2 \
        mingw-w64-x86_64-gettext \
        mingw-w64-x86_64-gflags \
        mingw-w64-x86_64-giflib \
        mingw-w64-x86_64-glib2 \
        mingw-w64-x86_64-glog \
        mingw-w64-x86_64-glsl-optimizer-git \
        mingw-w64-x86_64-gmp \
        mingw-w64-x86_64-gnutls \
        mingw-w64-x86_64-graphene \
        mingw-w64-x86_64-graphite2 \
        mingw-w64-x86_64-gsl \
        mingw-w64-x86_64-gsm \
        mingw-w64-x86_64-gst-plugins-bad-libs \
        mingw-w64-x86_64-gst-plugins-base \
        mingw-w64-x86_64-gstreamer \
        mingw-w64-x86_64-gtk-update-icon-cache \
        mingw-w64-x86_64-gtk4 \
        mingw-w64-x86_64-harfbuzz \
        mingw-w64-x86_64-hdf5 \
        mingw-w64-x86_64-headers-git \
        mingw-w64-x86_64-hicolor-icon-theme \
        mingw-w64-x86_64-hlsl2glsl-git \
        mingw-w64-x86_64-icu \
        mingw-w64-x86_64-ilmbase \
        mingw-w64-x86_64-intel-tbb \
        mingw-w64-x86_64-isl \
        mingw-w64-x86_64-iso-codes \
        mingw-w64-x86_64-jansson \
        mingw-w64-x86_64-jasper \
        mingw-w64-x86_64-jbigkit \
        mingw-w64-x86_64-jemalloc \
        mingw-w64-x86_64-json-glib \
        mingw-w64-x86_64-jxrlib \
        mingw-w64-x86_64-l-smash \
        mingw-w64-x86_64-lame \
        mingw-w64-x86_64-lcms2 \
        mingw-w64-x86_64-leptonica \
        mingw-w64-x86_64-lerc \
        mingw-w64-x86_64-libadwaita \
        mingw-w64-x86_64-libaec \
        mingw-w64-x86_64-libarchive \
        mingw-w64-x86_64-libass \
        mingw-w64-x86_64-libb2 \
        mingw-w64-x86_64-libbluray \
        mingw-w64-x86_64-libcaca \
        mingw-w64-x86_64-libdatrie \
        mingw-w64-x86_64-libdeflate \
        mingw-w64-x86_64-libepoxy \
        mingw-w64-x86_64-libexif \
        mingw-w64-x86_64-libffi \
        mingw-w64-x86_64-libgccjit \
        mingw-w64-x86_64-libgcrypt \
        mingw-w64-x86_64-libgme \
        mingw-w64-x86_64-libgpg-error \
        mingw-w64-x86_64-libgusb \
        mingw-w64-x86_64-libiconv \
        mingw-w64-x86_64-libidn2 \
        mingw-w64-x86_64-libjpeg-turbo \
        mingw-w64-x86_64-libmangle-git \
        mingw-w64-x86_64-libmfx \
        mingw-w64-x86_64-libmodplug \
        mingw-w64-x86_64-libmysofa \
        mingw-w64-x86_64-libogg \
        mingw-w64-x86_64-libpng \
        mingw-w64-x86_64-libpsl \
        mingw-w64-x86_64-libraw \
        mingw-w64-x86_64-librsvg \
        mingw-w64-x86_64-libsass \
        mingw-w64-x86_64-libsoxr \
        mingw-w64-x86_64-libssh \
        mingw-w64-x86_64-libssh2 \
        mingw-w64-x86_64-libsystre \
        mingw-w64-x86_64-libtasn1 \
        mingw-w64-x86_64-libthai \
        mingw-w64-x86_64-libtheora \
        mingw-w64-x86_64-libtiff \
        mingw-w64-x86_64-libtre-git \
        mingw-w64-x86_64-libunistring \
        mingw-w64-x86_64-libunwind \
        mingw-w64-x86_64-libusb \
        mingw-w64-x86_64-libvorbis \
        mingw-w64-x86_64-libvpx \
        mingw-w64-x86_64-libwebp \
        mingw-w64-x86_64-libwinpthread-git \
        mingw-w64-x86_64-libxml2 \
        mingw-w64-x86_64-libxslt \
        mingw-w64-x86_64-lz4 \
        mingw-w64-x86_64-lzo2 \
        mingw-w64-x86_64-make \
        mingw-w64-x86_64-meson \
        mingw-w64-x86_64-metis \
        mingw-w64-x86_64-mpc \
        mingw-w64-x86_64-mpdecimal \
        mingw-w64-x86_64-mpfr \
        mingw-w64-x86_64-ncurses \
        mingw-w64-x86_64-nettle \
        mingw-w64-x86_64-nghttp2 \
        mingw-w64-x86_64-ninja \
        mingw-w64-x86_64-ogre3d \
        mingw-w64-x86_64-openal \
        mingw-w64-x86_64-openblas \
        mingw-w64-x86_64-opencore-amr \
        mingw-w64-x86_64-opencv \
        mingw-w64-x86_64-openexr \
        mingw-w64-x86_64-openjpeg2 \
        mingw-w64-x86_64-openssl \
        mingw-w64-x86_64-opus \
        mingw-w64-x86_64-orc \
        mingw-w64-x86_64-p11-kit \
        mingw-w64-x86_64-pango \
        mingw-w64-x86_64-pcre \
        mingw-w64-x86_64-pixman \
        mingw-w64-x86_64-pkg-config \
        mingw-w64-x86_64-protobuf \
        mingw-w64-x86_64-pugixml \
        mingw-w64-x86_64-python \
        mingw-w64-x86_64-rav1e \
        mingw-w64-x86_64-readline \
        mingw-w64-x86_64-rtmpdump-git \
        mingw-w64-x86_64-shared-mime-info \
        mingw-w64-x86_64-speex \
        mingw-w64-x86_64-speexdsp \
        mingw-w64-x86_64-sqlite3 \
        mingw-w64-x86_64-srt \
        mingw-w64-x86_64-suitesparse \
        mingw-w64-x86_64-svt-av1 \
        mingw-w64-x86_64-tcl \
        mingw-w64-x86_64-termcap \
        mingw-w64-x86_64-tesseract-ocr \
        mingw-w64-x86_64-tinyxml \
        mingw-w64-x86_64-tk \
        mingw-w64-x86_64-tools-git \
        mingw-w64-x86_64-tzdata \
        mingw-w64-x86_64-vid.stab \
        mingw-w64-x86_64-vulkan-headers \
        mingw-w64-x86_64-vulkan-loader \
        mingw-w64-x86_64-windows-default-manifest \
        mingw-w64-x86_64-wineditline \
        mingw-w64-x86_64-winpthreads-git \
        mingw-w64-x86_64-winstorecompat-git \
        mingw-w64-x86_64-x264 \
        mingw-w64-x86_64-x265 \
        mingw-w64-x86_64-xvidcore \
        mingw-w64-x86_64-xxhash \
        mingw-w64-x86_64-xz \
        mingw-w64-x86_64-zimg \
        mingw-w64-x86_64-zlib \
        mingw-w64-x86_64-zstd \
        mingw-w64-x86_64-zziplib

# see https://github.com/msys2/MINGW-packages/issues/5803
# issues with libjcat and libxmlb while building subprojected fwupd
export CFLAGS=-fstack-protector

rm -rf build
meson build \
        -Dlibxmlb:introspection=false \
        -Dlibxmlb:gtkdoc=false \
        -Dlibjcat:gpg=false \
        -Dlibjcat:tests=false \
        -Dlibjcat:introspection=false \
        -Dlibjcat:man=false \
        -Dgcab:introspection=false \
        -Dgcab:docs=false \
        -Dfwupd:docs=none \
        -Dfwupd:build=library \
        -Dlibadwaita:introspection=disabled \
        -Dlibadwaita:tests=false
ninja -C build
