import os
import cStringIO

import pygphoto_lowlevel as pglow
 
 
 
FILE_TYPE_PREVIEW = pglow.GP_FILE_TYPE_PREVIEW
FILE_TYPE_NORMAL = pglow.GP_FILE_TYPE_NORMAL
FILE_TYPE_RAW = pglow.GP_FILE_TYPE_RAW
FILE_TYPE_AUDIO = pglow.GP_FILE_TYPE_AUDIO
FILE_TYPE_EXIF = pglow.GP_FILE_TYPE_EXIF
FILE_TYPE_METADATA = pglow.GP_FILE_TYPE_METADATA

MIME_WAV  = "audio/wav"
MIME_RAW  = "image/x-raw"
MIME_PNG  = "image/png"
MIME_PGM  = "image/x-portable-graymap"
MIME_PPM  = "image/x-portable-pixmap"
MIME_PNM  = "image/x-portable-anymap"
MIME_JPEG = "image/jpeg"
MIME_TIFF = "image/tiff"
MIME_BMP  = "image/bmp"
MIME_QUICKTIME = "video/quicktime"
MIME_AVI  = "video/x-msvideo"
MIME_CRW  = "image/x-canon-raw"
MIME_UNKNOWN = "application/octet-stream"
MIME_EXIF = "application/x-exif"
MIME_MP3 = "audio/mpeg"
MIME_OGG = "application/ogg"
MIME_WMA = "audio/x-wma"
MIME_ASF = "audio/x-asf"
MIME_MPEG = "video/mpeg"

__currentCameras = []


def detect():
	
    global __currentCameras

    gplist = pglow.gp_detectcameras( )
    count = pglow.gp_list_count( gplist )
    detected = []
    while count > 0:
        count = count - 1
	detected.append( [pglow.gp_name(gplist, count),pglow.gp_value(gplist,count)] )
    # remove cameras which vanished
    #we only need new cams which are really new
    for oldCam in __currentCameras:
	for newCam in detected:
            if newCam[0] == oldCam.name and newCam[1] == oldCam.port:
	        detected.remove(newCam)
		break
        else: 
	    # "exit" camera to remove (just to be sure)
	    oldCam.exit()
	    __currentCameras.remove(oldCam)	
    # only insert new cameras
    for newCam in detected:
        __currentCameras.append(Camera(newCam[0],newCam[1])) 
    return __currentCameras



class Camera:

    def __init__(self, name, port):
        self.name = name
	self.port = port 
	self.__camera = pglow.gp_camera(name, port)
	self.ready = False
	
	
    def initialize(self, context = None):
        if not self.ready:
	    self.__camera = pglow.gp_camera(self.name, self.port)
	    pglow.gp_init(self.__camera, context)
	    self.ready = True
	
	
    def exit(self, context = None):
	self.ready = False
	return pglow.gp_exit(self.__camera, context)


    def listfolders(self, path, context = None, retry = True):
	try:
	    self.initialize(context)
            gFolders = pglow.gp_getsubfolders( self.__camera, path, context )
	except:
	    self.exit()
	    if retry:
	        return self.listfolders(path, context, False)
	    else:
		return None
	return self.__gList2pyList(gFolders)


    def listfiles(self, path, context = None, retry = True):
	try:
	    self.initialize(context)
	    gFiles = pglow.gp_getfiles( self.__camera, path, context )
	except:
	    self.exit()
	    if retry:
	        return self.listfiles(path, context, False)
	    else:
		return None       	
	return self.__gList2pyList(gFiles)


    def getfile(self, path, filetype = FILE_TYPE_NORMAL, context = None, retry = True):
        filename = os.path.basename(path)
        dirname  = os.path.dirname(path)	
	try:	
	    self.initialize(context)
	    cfile = pglow.gp_getfile( self.__camera, dirname, filename, filetype, context )
	except:
	    self.exit()
	    if retry:
	        return self.getfile(path, filetype, context, False)
	    else:
		return None
        string = pglow.gp_readfile( cfile )
        file = cStringIO.StringIO( string )
        return file
	
	
    def getmimetype(self, path, context = None, retry = True):
        filename = os.path.basename(path)
        dirname  = os.path.dirname(path)	
	try:	
	    self.initialize(context)
	    return pglow.gp_getmimetype( self.__camera, dirname, filename, context )
	except:
	    self.exit()
	    if retry:
	        return self.getmimetype(path, context, False)
	    else:
		return None


    def __gList2pyList(self, gList):
        '''Creates a proper python list from a gphoto list'''
        number = pglow.gp_list_count( gList )
        result = []
        for i in xrange(0, number):
            name = pglow.gp_name( gList, i )
            result.append(name)
        return result	
	
	
class Context:
    
    def progress_start(self, target, text):
        return None
	
    def progress_update(self, id, current):
	pass
    
    def progress_stop(self, id):
	pass





