/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.JFrame;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.DataReferenceImpl;
import visad.Display;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded3DSet;
import visad.Integer2DSet;
import visad.Integer3DSet;
import visad.MathType;
import visad.QuickSort;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.bom.Radar2DCoordinateSystem;
import visad.bom.Radar3DCoordinateSystem;
import visad.bom.RadarFile;
import visad.java3d.DisplayImplJ3D;

public class RadarAdapter {
    public RadarFile rf;
    private Vector pvector = new Vector();
    private PolarData pdata;
    public PolarData[] polar;
    public int numVectors;
    private static int objCount = 0;
    FlatField radar;

    public RadarAdapter(float centlat, float centlon, String radarSource, boolean d3d) throws IOException, VisADException {
        this(centlat, centlon, 0.0f, radarSource, d3d);
    }

    public RadarAdapter(float centlat, float centlon, float centalt, String radarSource, boolean d3d) throws IOException, VisADException {
        int k;
        RealType[] domain_components;
        int i;
        try {
            this.rf = new RadarFile(radarSource);
        }
        catch (IOException e) {
            throw new VisADException("Problem with Radar file: " + e);
        }
        System.out.println("Radar Adapter : dtTime = " + this.rf.dtTime);
        int naz = this.rf.pbdataArray.length;
        float[] azs = new float[naz];
        int nrad = 0;
        for (int i2 = 0; i2 < naz; ++i2) {
            int n = this.rf.pbdataArray[i2].bdata.length;
            if (n > nrad) {
                nrad = n;
            }
            azs[i2] = (float)this.rf.pbdataArray[i2].azimuth;
        }
        int[] sortToOld = QuickSort.sort(azs);
        float radlow = this.rf.startrng;
        float radres = this.rf.rngres;
        float azlow = azs[0];
        float azres = this.rf.azimuthres;
        int newnaz = 1 + (int)((azs[naz - 1] - azs[0]) / azres);
        int[] newToOld = new int[newnaz];
        for (i = 0; i < newnaz; ++i) {
            newToOld[i] = 0;
        }
        for (i = 0; i < naz; ++i) {
            int k2 = (int)((azs[i] - azs[0]) / azres);
            if (k2 < 0) {
                k2 = 0;
            }
            if (k2 > newnaz - 1) {
                k2 = newnaz - 1;
            }
            newToOld[k2] = sortToOld[i];
        }
        Object ref = null;
        Radar2DCoordinateSystem rcs2d = null;
        Radar3DCoordinateSystem rcs3d = null;
        float elevlow = 0.5f;
        float elevres = 0.1f;
        int nelev = 1;
        if (d3d) {
            rcs3d = new Radar3DCoordinateSystem(centlat, centlon, centalt, radlow, radres, azlow, azres, elevlow, elevres);
        } else {
            rcs2d = new Radar2DCoordinateSystem(centlat, centlon, radlow, radres, azlow, azres);
        }
        RealType azimuth = RealType.getRealType("azimuth", CommonUnit.degree, null);
        RealType range = RealType.getRealType("range", CommonUnit.meter, null);
        RealType elevation = RealType.getRealType("elevation", CommonUnit.degree, null);
        RealTupleType radaz = null;
        if (d3d) {
            domain_components = new RealType[]{range, azimuth, elevation};
            radaz = new RealTupleType(domain_components, (CoordinateSystem)rcs3d, null);
        } else {
            domain_components = new RealType[]{range, azimuth};
            radaz = new RealTupleType(domain_components, (CoordinateSystem)rcs2d, null);
        }
        RealType reflection = RealType.getRealType("reflection");
        FunctionType radar_image = new FunctionType(radaz, reflection);
        int bignaz = newnaz;
        if (newnaz == 360) {
            bignaz = 361;
        }
        float[][] values = new float[1][nrad * bignaz];
        int m = 0;
        for (int i3 = 0; i3 < newnaz; ++i3) {
            k = newToOld[i3];
            if (k >= 0) {
                byte[] bd = this.rf.pbdataArray[newToOld[i3]].bdata;
                for (int j = 0; j < nrad; ++j) {
                    values[0][m] = bd[j];
                    ++m;
                }
                continue;
            }
            for (int j = 0; j < nrad; ++j) {
                values[0][m] = Float.NaN;
                ++m;
            }
        }
        if (newnaz == 360) {
            int offset = nrad * newnaz;
            for (int j = 0; j < nrad; ++j) {
                values[0][offset + j] = values[0][j];
            }
        }
        if (d3d) {
            if (nelev == 1) {
                float[][] samples = new float[3][nrad * bignaz];
                k = 0;
                for (int j = 0; j < bignaz; ++j) {
                    for (int i4 = 0; i4 < nrad; ++i4) {
                        samples[0][k] = i4;
                        samples[1][k] = j;
                        samples[2][k] = 0.0f;
                        ++k;
                    }
                }
                Gridded3DSet set = new Gridded3DSet((MathType)radaz, samples, nrad, bignaz);
                this.radar = new FlatField(radar_image, set);
            } else {
                Integer3DSet set = new Integer3DSet((MathType)radaz, nrad, bignaz, nelev);
                this.radar = new FlatField(radar_image, set);
            }
        } else {
            Integer2DSet set = new Integer2DSet((MathType)radaz, nrad, bignaz);
            this.radar = new FlatField(radar_image, set);
        }
        this.radar.setSamples(values);
    }

    public FlatField getData() {
        return this.radar;
    }

    public static void main(String[] args) throws VisADException, RemoteException {
        String radarSource = "radar.dat";
        RadarAdapter ra = null;
        try {
            ra = new RadarAdapter(-34.9f, 138.5f, 4.0f, radarSource, false);
        }
        catch (Exception e) {
            System.err.println("Caught Exception for \"" + radarSource + "\": " + e);
            System.exit(1);
        }
        FlatField radar = ra.getData();
        FunctionType radar_image = (FunctionType)radar.getType();
        RealTupleType radaz = radar_image.getDomain();
        RealType reflection = (RealType)radar_image.getRange();
        RealType azimuth = (RealType)radaz.getComponent(1);
        RealType range = (RealType)radaz.getComponent(0);
        DisplayImplJ3D display = new DisplayImplJ3D("radar");
        ScalarMap lonmap = new ScalarMap(RealType.Longitude, Display.XAxis);
        display.addMap(lonmap);
        ScalarMap latmap = new ScalarMap(RealType.Latitude, Display.YAxis);
        display.addMap(latmap);
        display.addMap(new ScalarMap(RealType.Altitude, Display.ZAxis));
        ScalarMap rgbMap = new ScalarMap(reflection, Display.RGB);
        display.addMap(rgbMap);
        GraphicsModeControl mode = display.getGraphicsModeControl();
        mode.setScaleEnable(true);
        DataReferenceImpl ref = new DataReferenceImpl("radar_ref");
        ref.setData(radar);
        display.addReference(ref);
        JFrame frame = new JFrame("VisAD BOM radar image");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.getContentPane().add(display.getComponent());
        int WIDTH = 500;
        int HEIGHT = 600;
        frame.setSize(WIDTH, HEIGHT);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(screenSize.width / 2 - WIDTH / 2, screenSize.height / 2 - HEIGHT / 2);
        frame.setVisible(true);
    }

    public class PolarData {
        public double azimuth;
        public double range;
    }
}

