/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grid;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribGridRecord;
import ucar.grib.grib1.Grib1GridTableLookup;
import ucar.grib.grib2.Grib2GridTableLookup;
import ucar.grib.grib2.Grib2Tables;
import ucar.grid.GridParameter;
import ucar.grid.GridRecord;
import ucar.grid.GridTableLookup;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.gempak.GempakLookup;
import ucar.nc2.iosp.grib.GribGridServiceProvider;
import ucar.nc2.iosp.grid.GridCoordSys;
import ucar.nc2.iosp.grid.GridEnsembleCoord;
import ucar.nc2.iosp.grid.GridHorizCoordSys;
import ucar.nc2.iosp.grid.GridIndexToNC;
import ucar.nc2.iosp.grid.GridTimeCoord;
import ucar.nc2.iosp.grid.GridVertCoord;
import ucar.nc2.iosp.mcidas.McIDASLookup;
import ucar.nc2.units.DateFormatter;
import ucar.unidata.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridVariable {
    private static Logger log = LoggerFactory.getLogger(GridVariable.class);
    private String name;
    private String desc;
    private String vname;
    private GridRecord firstRecord;
    private GridTableLookup lookup;
    private GridHorizCoordSys hcs;
    private GridCoordSys vcs;
    private GridTimeCoord tcs;
    private GridEnsembleCoord ecs = null;
    private GridVertCoord vc;
    private List<GridRecord> records = new ArrayList<GridRecord>();
    private int nlevels;
    private int nEnsembles;
    private int ntimes;
    private GridRecord[] recordTracker;
    private boolean hasVert = false;
    private boolean showRecords = false;
    private boolean showGen = false;
    private volatile int hashCode = 0;

    GridVariable(String name, String desc, GridHorizCoordSys hcs, GridTableLookup lookup) {
        this.name = name;
        this.desc = desc;
        this.hcs = hcs;
        this.lookup = lookup;
    }

    void addProduct(GridRecord record) {
        this.records.add(record);
        if (this.firstRecord == null) {
            this.firstRecord = record;
        }
    }

    List<GridRecord> getRecords() {
        return this.records;
    }

    GridRecord getFirstRecord() {
        return this.records.get(0);
    }

    GridHorizCoordSys getHorizCoordSys() {
        return this.hcs;
    }

    GridCoordSys getVertCoordSys() {
        return this.vcs;
    }

    GridVertCoord getVertCoord() {
        return this.vc;
    }

    boolean hasVert() {
        return this.hasVert;
    }

    void setVarName(String vname) {
        this.vname = vname;
    }

    void setVertCoordSys(GridCoordSys vcs) {
        this.vcs = vcs;
    }

    void setVertCoord(GridVertCoord vc) {
        this.vc = vc;
    }

    void setTimeCoord(GridTimeCoord tcs) {
        this.tcs = tcs;
    }

    void setEnsembleCoord(GridEnsembleCoord ecs) {
        this.ecs = ecs;
    }

    public int getNEnsembles() {
        return this.ecs == null ? 1 : this.ecs.getNEnsembles();
    }

    public int getPDN() {
        return this.ecs == null ? -1 : this.ecs.getPDN();
    }

    public int[] getEnsTypes() {
        return this.ecs == null ? null : this.ecs.getEnsType();
    }

    int getEnsembleIndex(GridRecord record) {
        return this.ecs == null ? 1 : this.ecs.getIndex(record);
    }

    boolean hasEnsemble() {
        return this.ecs == null ? false : this.ecs.getNEnsembles() > 1;
    }

    String getEnsembleName() {
        return this.ecs.getName();
    }

    int getVertNlevels() {
        return this.vcs == null ? this.vc.getNLevels() : this.vcs.getNLevels();
    }

    String getVertName() {
        return this.vcs == null ? this.vc.getVariableName() : this.vcs.getVerticalName();
    }

    String getVertLevelName() {
        return this.vcs == null ? this.vc.getLevelName() : this.vcs.getVerticalName();
    }

    boolean getVertIsUsed() {
        return this.vcs == null ? !this.vc.dontUseVertical : !this.vcs.dontUseVertical;
    }

    int getVertIndex(GridRecord p) {
        return this.vcs == null ? this.vc.getIndex(p) : this.vcs.getIndex(p);
    }

    int getNTimes() {
        return this.tcs == null ? 1 : this.tcs.getNTimes();
    }

    Variable makeVariable(NetcdfFile ncfile, Group g, boolean useDesc) {
        int[] paramId;
        int icf;
        assert (this.records.size() > 0) : "no records for this variable";
        this.nlevels = this.getVertNlevels();
        this.nEnsembles = this.getNEnsembles();
        this.ntimes = this.tcs.getNTimes();
        if (this.vname == null) {
            this.vname = AbstractIOServiceProvider.createValidNetcdfObjectName(useDesc ? this.desc : this.name);
        }
        this.vname = StringUtil.replace(this.vname, ' ', "_");
        Variable v = new Variable(ncfile, g, null, this.vname);
        v.setDataType(DataType.FLOAT);
        String dims = this.tcs.getName();
        if (this.hasEnsemble()) {
            dims = dims + " " + this.getEnsembleName();
        }
        if (this.getVertIsUsed()) {
            dims = dims + " " + this.getVertName();
            this.hasVert = true;
        }
        dims = this.hcs.isLatLon() ? dims + " lat lon" : dims + " y x";
        v.setDimensions(dims);
        GridParameter param = this.lookup.getParameter(this.firstRecord);
        String unit = param.getUnit();
        if (unit == null) {
            unit = "";
        }
        v.addAttribute(new Attribute("long_name", this.makeLongName(this.firstRecord, this.lookup)));
        if (this.firstRecord instanceof GribGridRecord) {
            GribGridRecord ggr = (GribGridRecord)this.firstRecord;
            if (ggr.startOfInterval != -9999) {
                v.addAttribute(new Attribute("standard_name", "accumulated_" + this.vname));
                v.addAttribute(new Attribute("cell_methods", this.tcs.getName() + ": sum"));
            }
        }
        v.addAttribute(new Attribute("units", unit));
        v.addAttribute(new Attribute("missing_value", new Float(this.lookup.getFirstMissingValue())));
        if (!this.hcs.isLatLon()) {
            if (GribGridServiceProvider.addLatLon) {
                v.addAttribute(new Attribute("coordinates", "lat lon"));
            }
            v.addAttribute(new Attribute("grid_mapping", this.hcs.getGridName()));
        }
        String flag = (icf = this.hcs.getGds().getInt("VectorComponentFlag")) == 0 ? Grib2Tables.VectorComponentFlag.easterlyNortherlyRelative.toString() : Grib2Tables.VectorComponentFlag.gridRelative.toString();
        if (this.lookup instanceof Grib2GridTableLookup) {
            Grib2GridTableLookup g2lookup = (Grib2GridTableLookup)this.lookup;
            paramId = g2lookup.getParameterId(this.firstRecord);
            v.addAttribute(new Attribute("GRIB_param_discipline", this.lookup.getDisciplineName(this.firstRecord)));
            v.addAttribute(new Attribute("GRIB_param_category", this.lookup.getCategoryName(this.firstRecord)));
            v.addAttribute(new Attribute("GRIB_param_name", param.getName()));
            v.addAttribute(new Attribute("GRIB_param_id", Array.factory(Integer.TYPE, new int[]{paramId.length}, (Object)paramId)));
            v.addAttribute(new Attribute("GRIB_product_definition_type", g2lookup.getProductDefinitionName(this.firstRecord)));
            v.addAttribute(new Attribute("GRIB_level_type", new Integer(this.firstRecord.getLevelType1())));
            if (g2lookup.isEnsemble(this.firstRecord)) {
                v.addAttribute(new Attribute("GRIB_forecasts_in_ensemble", g2lookup.NumberOfForecastsInEnsemble(this.firstRecord)));
            }
            if (g2lookup.isProbability(this.firstRecord)) {
                v.addAttribute(new Attribute("GRIB_forecasts_in_probability", g2lookup.NumberOfForecastsInProbability(this.firstRecord)));
            }
            v.addAttribute(new Attribute("GRIB_VectorComponentFlag", flag));
        } else if (this.lookup instanceof Grib1GridTableLookup) {
            Grib1GridTableLookup g1lookup = (Grib1GridTableLookup)this.lookup;
            paramId = g1lookup.getParameterId(this.firstRecord);
            v.addAttribute(new Attribute("GRIB_param_name", param.getDescription()));
            v.addAttribute(new Attribute("GRIB_param_short_name", param.getName()));
            v.addAttribute(new Attribute("GRIB_center_id", new Integer(paramId[1])));
            v.addAttribute(new Attribute("GRIB_table_id", new Integer(paramId[2])));
            v.addAttribute(new Attribute("GRIB_param_number", new Integer(paramId[3])));
            v.addAttribute(new Attribute("GRIB_param_id", Array.factory(Integer.TYPE, new int[]{paramId.length}, (Object)paramId)));
            v.addAttribute(new Attribute("GRIB_product_definition_type", g1lookup.getProductDefinitionName(this.firstRecord)));
            v.addAttribute(new Attribute("GRIB_level_type", new Integer(this.firstRecord.getLevelType1())));
            v.addAttribute(new Attribute("GRIB_VectorComponentFlag", flag));
        } else {
            v.addAttribute(new Attribute("VectorComponentFlag", flag));
        }
        v.setSPobject(this);
        if (this.showRecords) {
            System.out.println("Variable " + this.getName());
        }
        this.recordTracker = new GridRecord[this.ntimes * this.nEnsembles * this.nlevels];
        for (GridRecord p : this.records) {
            int recno;
            if (this.showRecords) {
                System.out.println(" " + this.vc.getVariableName() + " (type=" + p.getLevelType1() + "," + p.getLevelType2() + ")  value=" + p.getLevelType1() + "," + p.getLevelType2());
            }
            int level = this.getVertIndex(p);
            if (!this.getVertIsUsed() && level > 0) {
                log.warn("inconsistent level encoding=" + level);
                level = 0;
            }
            int time = this.tcs.getIndex(p);
            if (level < 0) {
                log.warn("NOT FOUND record; level=" + level + " time= " + time + " for " + this.getName() + " file=" + ncfile.getLocation() + "\n" + "   " + this.getVertLevelName() + " (type=" + p.getLevelType1() + "," + p.getLevelType2() + ")  value=" + p.getLevel1() + "," + p.getLevel2() + "\n");
                this.getVertIndex(p);
                continue;
            }
            if (time < 0) {
                log.warn("NOT FOUND record; level=" + level + " time= " + time + " for " + this.getName() + " file=" + ncfile.getLocation() + "\n" + " forecastTime= " + p.getValidTimeOffset() + " date= " + this.tcs.getValidTime(p) + "\n");
                this.tcs.getIndex(p);
                continue;
            }
            if (this.hasEnsemble()) {
                int ens = this.getEnsembleIndex(p);
                recno = ens * (this.ntimes * this.nlevels) + time * this.nlevels + level;
            } else {
                recno = time * this.nlevels + level;
            }
            if (this.recordTracker[recno] == null) {
                this.recordTracker[recno] = p;
                continue;
            }
            GridRecord q = this.recordTracker[recno];
            this.recordTracker[recno] = p;
        }
        this.records.clear();
        return v;
    }

    void dumpMissing() {
        System.out.println("  " + this.name);
        for (int j = 0; j < this.nlevels; ++j) {
            System.out.print("   ");
            for (int i = 0; i < this.ntimes; ++i) {
                boolean missing = this.recordTracker[i * this.nlevels + j] == null;
                System.out.print(missing ? "-" : "X");
            }
            System.out.println();
        }
    }

    int dumpMissingSummary() {
        if (this.nlevels == 1) {
            return 0;
        }
        int count = 0;
        int total = this.nlevels * this.ntimes;
        for (int i = 0; i < total; ++i) {
            if (this.recordTracker[i] != null) continue;
            ++count;
        }
        System.out.println("  MISSING= " + count + "/" + total + " " + this.name);
        return count;
    }

    public GridRecord findRecord(int time, int ens, int level) {
        if (this.hasEnsemble()) {
            return this.recordTracker[ens * (this.ntimes * this.nlevels) + time * this.nlevels + level];
        }
        return this.recordTracker[time * this.nlevels + level];
    }

    public boolean equals(Object oo) {
        if (this == oo) {
            return true;
        }
        if (!(oo instanceof GridVariable)) {
            return false;
        }
        return this.hashCode() == oo.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public String getParamName() {
        return this.desc;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.name.hashCode();
            result += 37 * result + this.firstRecord.getLevelType1();
            result += 37 * result + this.hcs.getID().hashCode();
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public String dump() {
        DateFormatter formatter = new DateFormatter();
        StringBuilder sbuff = new StringBuilder();
        sbuff.append(this.name + " " + this.records.size() + "\n");
        for (GridRecord record : this.records) {
            sbuff.append(" level = " + record.getLevelType1() + " " + record.getLevel1());
            if (null != record.getValidTime()) {
                sbuff.append(" time = " + formatter.toDateTimeString(record.getValidTime()));
            }
            sbuff.append("\n");
        }
        return sbuff.toString();
    }

    private String makeLongName(GridRecord gr, GridTableLookup lookup) {
        GridParameter param = lookup.getParameter(gr);
        String levelName = lookup instanceof GempakLookup || lookup instanceof McIDASLookup ? lookup.getLevelDescription(gr) : GridIndexToNC.makeLevelName(gr, lookup);
        String ensembleName = GridIndexToNC.makeSuffixName(gr, lookup);
        String paramName = param.getDescription();
        paramName = ensembleName.length() == 0 ? paramName : paramName + "_" + ensembleName;
        paramName = levelName.length() == 0 ? paramName : paramName + " @ " + levelName;
        return paramName;
    }
}

