/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;
import ucar.unidata.geoloc.projection.Stereographic;

public class PolarStereographic
extends AbstractCoordTransBuilder {
    public String getTransformName() {
        return "polar_stereographic";
    }

    public TransformType getTransformType() {
        return TransformType.Projection;
    }

    public CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
        double lon0 = this.readAttributeDouble(ctv, "straight_vertical_longitude_from_pole", Double.NaN);
        if (Double.isNaN(lon0)) {
            lon0 = this.readAttributeDouble(ctv, "longitude_of_projection_origin", Double.NaN);
        }
        if (Double.isNaN(lon0)) {
            throw new IllegalArgumentException("No longitude parameter");
        }
        double lat0 = this.readAttributeDouble(ctv, "latitude_of_projection_origin", 90.0);
        double scale = this.readAttributeDouble(ctv, "scale_factor_at_projection_origin", Double.NaN);
        if (Double.isNaN(scale)) {
            double stdpar = this.readAttributeDouble(ctv, "standard_parallel", Double.NaN);
            if (!Double.isNaN(stdpar)) {
                double sin = Math.abs(Math.sin(Math.toRadians(stdpar)));
                scale = (1.0 + sin) / 2.0;
            } else {
                scale = 1.0;
            }
        }
        double false_easting = this.readAttributeDouble(ctv, "false_easting", 0.0);
        double false_northing = this.readAttributeDouble(ctv, "false_northing", 0.0);
        if (false_easting != 0.0 || false_northing != 0.0) {
            double scalef = PolarStereographic.getFalseEastingScaleFactor(ds, ctv);
            false_easting *= scalef;
            false_northing *= scalef;
        }
        Stereographic proj = new Stereographic(lat0, lon0, scale, false_easting, false_northing);
        return new ProjectionCT(ctv.getShortName(), "FGDC", proj);
    }

    public static void main(String[] arg) {
        double stdpar = 70.0;
        double sin = Math.abs(Math.sin(Math.toRadians(stdpar)));
        double scale = (1.0 + sin) / 2.0;
        System.out.printf("stdpar = %f has scale = %f %n", stdpar, scale);
    }
}

